/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.tests.AbstractProtocolTest;
import org.eclipse.net4j.tests.data.TinyData;
import org.eclipse.net4j.tests.signal.ArrayRequest;
import org.eclipse.net4j.tests.signal.AsyncRequest;
import org.eclipse.net4j.tests.signal.IntRequest;
import org.eclipse.net4j.tests.signal.StringRequest;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class SignalTest
extends AbstractProtocolTest {
    public void testInteger() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            protocol = new TestSignalProtocol(this.getConnector());
            int data = 10;
            int result = (Integer)new IntRequest(protocol, data).send();
            SignalTest.assertEquals((int)data, (int)result);
        }
    }

    public void testArray() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            protocol = new TestSignalProtocol(this.getConnector());
            byte[] data = TinyData.getBytes();
            byte[] result = (byte[])new ArrayRequest(protocol, data).send();
            SignalTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
        }
    }

    public void testAsync() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            OMPlatform.INSTANCE.setDebugging(false);
            protocol = new TestSignalProtocol(this.getConnector());
            String data = TinyData.getText();
            int i = 0;
            while (i < 1000) {
                SignalTest.msg("Loop " + i);
                new AsyncRequest(protocol, data).sendAsync();
                String result = (String)new StringRequest(protocol, data).send();
                SignalTest.assertEquals((String)data, (String)result);
                ++i;
            }
        }
    }

    public void testCloseSocketChannel() throws Exception {
        try (TestSignalProtocol protocol = null;){
            this.startTransport();
            TestSignalProtocol lifecycle = protocol = new TestSignalProtocol(this.getConnector());
            SignalTest.closeSocketChannel((TCPConnector)this.getAcceptor().getAcceptedConnectors()[0]);
            new AbstractOMTest.PollingTimeOuter((ILifecycle)lifecycle){
                private final /* synthetic */ ILifecycle val$lifecycle;
                {
                    this.val$lifecycle = iLifecycle;
                }

                @Override
                protected boolean successful() {
                    return !this.val$lifecycle.isActive();
                }
            }.assertNoTimeOut();
        }
    }

    private static void closeSocketChannel(TCPConnector connector) throws IOException {
        Field field = ReflectUtil.getField(TCPConnector.class, (String)"socketChannel");
        SocketChannel socketChannel = (SocketChannel)ReflectUtil.getValue((Field)field, (Object)connector);
        socketChannel.close();
    }

    public static final class SSL
    extends SignalTest {
        @Override
        protected boolean useJVMTransport() {
            return false;
        }

        @Override
        protected boolean useSSLTransport() {
            return true;
        }
    }

    public static final class TCP
    extends SignalTest {
        @Override
        protected boolean useJVMTransport() {
            return false;
        }

        @Override
        protected boolean useSSLTransport() {
            return false;
        }
    }
}

