/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp.ssl;

import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.internal.tcp.ssl.SSLAcceptor;
import org.eclipse.net4j.internal.tcp.ssl.SSLConnector;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.spi.net4j.InternalConnector;

public class SSLServerConnector
extends SSLConnector {
    private SSLAcceptor acceptor;

    public SSLServerConnector(SSLAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public SSLAcceptor getAcceptor() {
        return this.acceptor;
    }

    public ILocationAware.Location getLocation() {
        return ILocationAware.Location.SERVER;
    }

    @Override
    public String getHost() {
        try {
            return this.getSocketChannel().socket().getInetAddress().getHostAddress();
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    @Override
    public int getPort() {
        try {
            return this.getSocketChannel().socket().getPort();
        }
        catch (RuntimeException ex) {
            return 0;
        }
    }

    public String toString() {
        if (this.getUserID() == null) {
            return MessageFormat.format("SSLServerConnector[{0}:{1}]", this.getHost(), this.getPort());
        }
        return MessageFormat.format("SSLServerConnector[{2}@{0}:{1}]", this.getHost(), this.getPort(), this.getUserID());
    }

    @Override
    public void handleRegistration(ITCPSelector selector, SocketChannel socketChannel) {
        super.handleRegistration(selector, socketChannel);
        try {
            this.acceptor.addConnector((InternalConnector)this);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            this.deactivateAsync();
        }
    }
}

