/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.emf.editors.impl;

import java.util.Map;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.impl.DawnAbstractEditorSupport;
import org.eclipse.emf.cdo.dawn.emf.notifications.impl.DawnEMFHandler;
import org.eclipse.emf.cdo.dawn.emf.notifications.impl.DawnEMFLockingHandler;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;

public class DawnEMFEditorSupport
extends DawnAbstractEditorSupport {
    public DawnEMFEditorSupport(IDawnEditor editor) {
        super(editor);
    }

    public void close() {
        CDOView view = this.getView();
        if (view != null && !view.isClosed()) {
            view.close();
        }
    }

    protected BasicDawnListener getBasicHandler() {
        return new DawnEMFHandler(this.getEditor());
    }

    protected BasicDawnListener getLockingHandler() {
        return new DawnEMFLockingHandler(this.getEditor());
    }

    protected CDOTransactionHandlerBase getTransactionHandler() {
        return new DawnEMFHandler(this.getEditor());
    }

    public void rollback() {
        super.rollback();
        this.refresh();
    }

    public void refresh() {
        ((IViewerProvider)this.getEditor()).getViewer().refresh();
    }

    public void lockObject(Object objectToBeLocked) {
        if (objectToBeLocked instanceof EObject) {
            CDOUtil.getCDOObject((EObject)((EObject)objectToBeLocked)).cdoWriteLock().lock();
        }
        this.refresh();
    }

    public void unlockObject(Object objectToBeUnlocked) {
        CDOUtil.getCDOObject((EObject)((EObject)objectToBeUnlocked)).cdoWriteLock().unlock();
        this.refresh();
    }

    public void handleRemoteLockChanges(Map<Object, DawnState> changedObjects) {
        this.getEditor().getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DawnEMFEditorSupport.this.refresh();
            }
        });
    }
}

