/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionCacheAuditing;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;

public class CDORevisionCacheBranching
extends CDORevisionCacheAuditing {
    private Map<CDOID, TypeAndRefCounter> typeMap = CDOIDUtil.createMap();

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        return new CDORevisionCacheBranching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EClass getObjectType(CDOID id) {
        Map map = this.revisionLists;
        synchronized (map) {
            TypeAndRefCounter typeCounter = this.typeMap.get(id);
            if (typeCounter != null) {
                return typeCounter.getType();
            }
            return null;
        }
    }

    @Override
    protected void typeRefIncrease(CDOID id, EClass type) {
        TypeAndRefCounter typeCounter = this.typeMap.get(id);
        if (typeCounter == null) {
            typeCounter = new TypeAndRefCounter(type);
            this.typeMap.put(id, typeCounter);
        }
        typeCounter.increase();
    }

    @Override
    protected void typeRefDecrease(CDOID id) {
        TypeAndRefCounter typeCounter = this.typeMap.get(id);
        if (typeCounter != null && typeCounter.decreaseAndGet() == 0) {
            this.typeMap.remove(id);
        }
    }

    @Override
    protected void typeRefDispose() {
        this.typeMap.clear();
    }

    @Override
    protected boolean isKeyInBranch(Object key, CDOBranch branch) {
        return ((CDOIDAndBranch)key).getBranch() == branch;
    }

    @Override
    protected Object createKey(CDOID id, CDOBranch branch) {
        return CDOIDUtil.createIDAndBranch(id, branch);
    }

    private static final class TypeAndRefCounter {
        private EClass type;
        private int refCounter;

        public TypeAndRefCounter(EClass type) {
            this.type = type;
        }

        public EClass getType() {
            return this.type;
        }

        public void increase() {
            ++this.refCounter;
        }

        public int decreaseAndGet() {
            return --this.refCounter;
        }
    }
}

