/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.commit;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitHistory;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitHistoryImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitHistoryProviderImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitInfoImpl;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.net4j.util.ref.ReferenceValueMap2;

public class CDOCommitInfoManagerImpl
extends CDOCommitHistoryProviderImpl<CDOBranch, CDOCommitHistory>
implements InternalCDOCommitInfoManager {
    private final Map<Long, CDOCommitInfo> cache;
    private final Object cacheLock = new Object();
    private final Map<CDOBranch, BranchInfoCache> branches = new WeakHashMap<CDOBranch, BranchInfoCache>();
    private CDOCommonRepository repository;
    private InternalCDOCommitInfoManager.CommitInfoLoader loader;
    private List<CDOCommitInfoHandler> handlers = new ArrayList<CDOCommitInfoHandler>();
    private long lastCommit = 0L;

    public CDOCommitInfoManagerImpl(boolean caching) {
        this.cache = caching ? new ReferenceValueMap2.Soft() : null;
    }

    @Override
    public CDOCommonRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(CDOCommonRepository repository) {
        this.checkInactive();
        this.repository = repository;
    }

    @Override
    public InternalCDOCommitInfoManager.CommitInfoLoader getCommitInfoLoader() {
        return this.loader;
    }

    @Override
    public void setCommitInfoLoader(InternalCDOCommitInfoManager.CommitInfoLoader commitInfoLoader) {
        this.checkInactive();
        this.loader = commitInfoLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOCommitInfoHandler[] getCommitInfoHandlers() {
        List<CDOCommitInfoHandler> list = this.handlers;
        synchronized (list) {
            return this.handlers.toArray(new CDOCommitInfoHandler[this.handlers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommitInfoHandler(CDOCommitInfoHandler handler) {
        List<CDOCommitInfoHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommitInfoHandler(CDOCommitInfoHandler handler) {
        List<CDOCommitInfoHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.remove(handler);
        }
    }

    @Override
    public void notifyCommitInfoHandlers(CDOCommitInfo commitInfo) {
        CDOCommitInfoHandler[] cDOCommitInfoHandlerArray = this.getCommitInfoHandlers();
        int n = cDOCommitInfoHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCommitInfoHandler handler = cDOCommitInfoHandlerArray[n2];
            try {
                handler.handleCommitInfo(commitInfo);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public CDOCommitInfo createCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOCommitData commitData) {
        return this.createCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, null, commitData);
    }

    @Override
    public CDOCommitInfo createCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource, CDOCommitData commitData) {
        this.checkActive();
        CDOCommitInfoImpl commitInfo = new CDOCommitInfoImpl(this, branch, timeStamp, previousTimeStamp, userID, comment, mergeSource, commitData);
        return this.intern(commitInfo);
    }

    @Override
    public CDOCommitInfo getCommitInfo(long timeStamp) {
        return this.getCommitInfo(timeStamp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOCommitInfo getCommitInfo(long timeStamp, boolean loadOnDemand) {
        this.checkActive();
        if (this.cache != null) {
            Object object = this.cacheLock;
            synchronized (object) {
                CDOCommitInfo commitInfo = this.cache.get(timeStamp);
                if (commitInfo != null) {
                    return commitInfo;
                }
            }
        }
        final CDOCommitInfo[] result = new CDOCommitInfo[1];
        if (loadOnDemand) {
            this.getCommitInfos(null, timeStamp, timeStamp, new CDOCommitInfoHandler(){

                @Override
                public void handleCommitInfo(CDOCommitInfo commitInfo) {
                    result[0] = commitInfo;
                }
            });
        }
        return result[0];
    }

    @Override
    public CDOCommitInfo getCommitInfo(CDOBranch branch, long startTime, boolean up) {
        this.checkActive();
        int count = up ? 1 : -1;
        final CDOCommitInfo[] result = new CDOCommitInfo[1];
        this.getCommitInfos(branch, startTime, null, null, count, new CDOCommitInfoHandler(){

            @Override
            public void handleCommitInfo(CDOCommitInfo commitInfo) {
                result[0] = commitInfo;
            }
        });
        return result[0];
    }

    @Override
    public void getCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        this.checkActive();
        if (this.cache != null) {
            final CDOCommitInfoHandler delegate = handler;
            handler = new CDOCommitInfoHandler(){

                @Override
                public void handleCommitInfo(CDOCommitInfo commitInfo) {
                    delegate.handleCommitInfo(CDOCommitInfoManagerImpl.this.intern(commitInfo));
                }
            };
        }
        this.loader.loadCommitInfos(branch, startTime, endTime, handler);
    }

    @Override
    public void getCommitInfos(CDOBranch branch, long startTime, String reserved1, String reserved2, int count, CDOCommitInfoHandler handler) {
        if (reserved1 != null || reserved2 != null) {
            throw new IllegalArgumentException("The parameters reserved1 and reserved2 are not supported");
        }
        long endTime = CDOCommitInfoUtil.encodeCount(count);
        this.getCommitInfos(branch, startTime, endTime, handler);
    }

    @Override
    public CDOCommitInfo getBaseOfBranch(CDOBranch branch) {
        if (branch.isMainBranch()) {
            return null;
        }
        BranchInfoCache infoCache = this.getBranchInfoCache(branch, true);
        CDOCommitInfo base = infoCache.getBase();
        if (base == null) {
            base = this.loadBaseOfBranch(branch);
            infoCache.setBase(base);
        }
        return base;
    }

    @Override
    public CDOCommitInfo getFirstOfBranch(CDOBranch branch) {
        BranchInfoCache infoCache = this.getBranchInfoCache(branch, true);
        CDOCommitInfo first = infoCache.getFirst();
        if (first == null) {
            first = this.loadFirstOfBranch(branch);
            infoCache.setFirst(first);
        }
        return first;
    }

    @Override
    public CDOCommitInfo getLastOfBranch(CDOBranch branch) {
        BranchInfoCache infoCache = this.getBranchInfoCache(branch, true);
        CDOCommitInfo last = infoCache.getLast();
        if (last == null) {
            last = this.loadLastOfBranch(branch);
            infoCache.setLast(last);
        }
        return last;
    }

    @Override
    public long getLastCommitOfBranch(CDOBranch branch, boolean loadOnDemand) {
        if (branch == null) {
            return this.lastCommit;
        }
        BranchInfoCache infoCache = this.getBranchInfoCache(branch, loadOnDemand);
        if (infoCache != null) {
            long lastCommit = infoCache.getLastCommit();
            if (lastCommit == 0L && loadOnDemand) {
                CDOCommitInfo last = this.loadLastOfBranch(branch);
                infoCache.setLast(last);
                lastCommit = last.getTimeStamp();
            }
            return lastCommit;
        }
        return 0L;
    }

    @Override
    public void setLastCommitOfBranch(CDOBranch branch, long lastCommit) {
        if (branch != null) {
            BranchInfoCache infoCache = this.getBranchInfoCache(branch, true);
            infoCache.setLastCommit(lastCommit);
        }
        this.setLastCommit(lastCommit);
    }

    @Override
    public long getLastCommit() {
        return this.lastCommit;
    }

    public void setLastCommit(long lastCommit) {
        if (lastCommit > this.lastCommit) {
            this.lastCommit = lastCommit;
        }
    }

    public String toString() {
        return "CommitInfoManager";
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.loader, "commitInfoLoader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeactivate() throws Exception {
        if (this.cache != null) {
            Object object = this.cacheLock;
            synchronized (object) {
                this.cache.clear();
            }
        }
        super.doDeactivate();
    }

    @Override
    protected CDOCommitHistory createHistory(CDOBranch key) {
        return new CDOCommitHistoryImpl(this, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CDOCommitInfo intern(CDOCommitInfo commitInfo) {
        if (this.cache != null && commitInfo != null) {
            long timeStamp = commitInfo.getTimeStamp();
            Object object = this.cacheLock;
            synchronized (object) {
                CDOCommitInfo cachedCommitInfo = this.cache.get(timeStamp);
                if (cachedCommitInfo != null) {
                    return cachedCommitInfo;
                }
                this.cache.put(timeStamp, commitInfo);
            }
        }
        return commitInfo;
    }

    private BranchInfoCache getBranchInfoCache(CDOBranch branch, boolean createOnDemand) {
        BranchInfoCache infoCache = this.branches.get(branch);
        if (infoCache == null && createOnDemand) {
            infoCache = new BranchInfoCache();
            this.branches.put(branch, infoCache);
        }
        return infoCache;
    }

    private CDOCommitInfo loadBaseOfBranch(CDOBranch branch) {
        CDOBranch baseBranch;
        CDOBranchPoint base = branch.getBase();
        while ((baseBranch = base.getBranch()) != null) {
            long baseTime = base.getTimeStamp();
            CDOCommitInfo commitInfo = this.getCommitInfo(baseBranch, baseTime, false);
            if (commitInfo != null) {
                return commitInfo;
            }
            base = baseBranch.getBase();
        }
        return null;
    }

    private CDOCommitInfo loadFirstOfBranch(CDOBranch branch) {
        return this.getCommitInfo(branch, 1L, true);
    }

    private CDOCommitInfo loadLastOfBranch(CDOBranch branch) {
        return this.getCommitInfo(branch, Long.MAX_VALUE, false);
    }

    private static final class BranchInfoCache {
        private SoftReference<CDOCommitInfo> base;
        private SoftReference<CDOCommitInfo> first;
        private SoftReference<CDOCommitInfo> last;
        private long lastCommit = 0L;

        public CDOCommitInfo getBase() {
            return this.base != null ? this.base.get() : null;
        }

        public void setBase(CDOCommitInfo base) {
            this.base = new SoftReference<CDOCommitInfo>(base);
        }

        public CDOCommitInfo getFirst() {
            return this.first != null ? this.first.get() : null;
        }

        public void setFirst(CDOCommitInfo first) {
            this.first = new SoftReference<CDOCommitInfo>(first);
        }

        public CDOCommitInfo getLast() {
            return this.last != null ? this.last.get() : null;
        }

        public void setLast(CDOCommitInfo last) {
            this.last = new SoftReference<CDOCommitInfo>(last);
            long timeStamp = last.getTimeStamp();
            if (timeStamp > this.lastCommit) {
                this.lastCommit = timeStamp;
            }
        }

        public long getLastCommit() {
            return this.lastCommit;
        }

        public void setLastCommit(long lastCommit) {
            if (lastCommit > this.lastCommit) {
                this.lastCommit = lastCommit;
                CDOCommitInfo last = this.getLast();
                if (last != null && lastCommit > last.getTimeStamp()) {
                    Object var3_2 = null;
                }
            }
        }
    }
}

