/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalAstWalker;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ObjectExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BlockExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ComputeExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ForExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeIterateExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.VariableInitExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.utilities.Visitable;
import org.eclipse.ocl.utilities.Visitor;

class ASTElementContextEnv
extends QvtOperationalEnv {
    private StringBuilder fErrors = new StringBuilder();

    ASTElementContextEnv(QvtOperationalEnv parent, EObject astElement) {
        super(parent);
        this.initializeContextVariables(astElement);
    }

    StringBuilder getErrorTxtBuffer() {
        return this.fErrors;
    }

    public boolean hasErrors() {
        return this.fErrors.length() > 0;
    }

    public void reportError(String message, int startOffset, int endOffset) {
        this.fErrors.append(message).append('\n');
    }

    public void reportWarning(String message, int startOffset, int endOffset) {
    }

    private void initializeContextVariables(EObject astContext) {
        List<Variable> variables;
        EnvVariableCollector varCollector = new EnvVariableCollector(astContext);
        EOperation contextOperation = (EOperation)this.getContextOperation();
        if (contextOperation instanceof ImperativeOperation) {
            varCollector.visitImperativeOperation((ImperativeOperation)contextOperation);
        }
        if (!(variables = varCollector.getVariables()).isEmpty()) {
            for (Variable variable : variables) {
                String name = variable.getName();
                boolean isExplicit = !name.startsWith("$");
                this.addElement(name, (org.eclipse.ocl.expressions.Variable)variable, isExplicit);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EnvVariableCollector
    extends QvtOperationalAstWalker {
        private final EObject astContext;
        private final List<Variable> varStack;
        private final List<Variable> result;

        private EnvVariableCollector(EObject astContext) {
            super(new QvtOperationalAstWalker.NodeProcessor(){

                public void process(Visitable e, Visitable parent) {
                }
            });
            this.astContext = astContext;
            this.varStack = new ArrayList<Variable>();
            this.result = new ArrayList<Variable>();
        }

        List<Variable> getVariables() {
            return this.result;
        }

        protected void doProcess(Visitable e, Visitable parent) {
            if (e == this.astContext) {
                this.result.addAll(this.varStack);
            }
            if (!this.result.isEmpty()) {
                return;
            }
            if (e != null) {
                this.getNodeProcessor().process(e, parent);
                e.accept((Visitor)this);
            }
        }

        public Object visitVariableInitExp(VariableInitExp variableInitExp) {
            Variable var = variableInitExp.getReferredVariable();
            this.varStack.add(var);
            Object result = super.visitVariableInitExp(variableInitExp);
            return result;
        }

        public Object visitLetExp(LetExp<EClassifier, EParameter> letExp) {
            org.eclipse.ocl.expressions.Variable var = letExp.getVariable();
            this.varStack.add((Variable)var);
            Object result = super.visitLetExp(letExp);
            this.varStack.remove((Variable)var);
            return result;
        }

        public Object visitObjectExp(ObjectExp objectExp) {
            Variable var = objectExp.getReferredObject();
            this.varStack.add(var);
            Object result = super.visitObjectExp(objectExp);
            this.varStack.remove(var);
            return result;
        }

        public Object visitResolveExp(ResolveExp resolveExp) {
            Variable var = resolveExp.getTarget();
            if (var != null) {
                this.varStack.add(var);
            }
            Object result = super.visitResolveExp(resolveExp);
            if (var != null) {
                this.varStack.remove(var);
            }
            return result;
        }

        public Object visitIteratorExp(IteratorExp<EClassifier, EParameter> callExp) {
            this.addVars(this.varStack, (LoopExp<EClassifier, EParameter>)callExp);
            Object result = super.visitIteratorExp(callExp);
            this.removeVars(this.varStack, (LoopExp<EClassifier, EParameter>)callExp);
            return result;
        }

        public Object visitIterateExp(IterateExp<EClassifier, EParameter> callExp) {
            this.addVars(this.varStack, (LoopExp<EClassifier, EParameter>)callExp);
            Object result = super.visitIterateExp(callExp);
            this.removeVars(this.varStack, (LoopExp<EClassifier, EParameter>)callExp);
            return result;
        }

        public Object visitForExp(ForExp forExp) {
            this.addVars(this.varStack, (LoopExp<EClassifier, EParameter>)forExp);
            Object result = super.visitForExp(forExp);
            this.removeVars(this.varStack, (LoopExp<EClassifier, EParameter>)forExp);
            return result;
        }

        public Object visitImperativeIterateExp(ImperativeIterateExp imperativeIterateExp) {
            this.addVars(this.varStack, (LoopExp<EClassifier, EParameter>)imperativeIterateExp);
            Object result = super.visitImperativeIterateExp(imperativeIterateExp);
            this.removeVars(this.varStack, (LoopExp<EClassifier, EParameter>)imperativeIterateExp);
            return result;
        }

        public Object visitBlockExp(BlockExp blockExp) {
            ArrayList<Variable> saveVarStack = new ArrayList<Variable>(this.varStack);
            Object result = super.visitBlockExp(blockExp);
            this.varStack.clear();
            this.varStack.addAll(saveVarStack);
            return result;
        }

        public Object visitComputeExp(ComputeExp computeExp) {
            Variable var = computeExp.getReturnedElement();
            if (var != null) {
                this.varStack.add(var);
            }
            Object result = super.visitComputeExp(computeExp);
            if (var != null) {
                this.varStack.remove(var);
            }
            return result;
        }

        private void removeVars(List<Variable> varStack, LoopExp<EClassifier, EParameter> itExp) {
            for (org.eclipse.ocl.expressions.Variable iter : itExp.getIterator()) {
                varStack.remove((Variable)iter);
            }
        }

        private void addVars(List<Variable> varStack, LoopExp<EClassifier, EParameter> itExp) {
            for (org.eclipse.ocl.expressions.Variable iter : itExp.getIterator()) {
                varStack.add((Variable)iter);
            }
        }
    }
}

