/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.vm;

import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.VariableFinder;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationEnvironment;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelsManager;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class QVTiVariableFinder
extends VariableFinder {
    public QVTiVariableFinder(@NonNull VMEvaluationEnvironment vmEvaluationEnvironment, boolean isStoreValues) {
        super(vmEvaluationEnvironment, isStoreValues);
    }

    public void collectChildVars(Object valueObject, @NonNull String @NonNull [] parentPath, @Nullable String containerType, @NonNull List<@NonNull VMVariableData> result) {
        if (valueObject instanceof QVTiModelsManager.QVTiTransformationInstance) {
            String[] childPath = new String[parentPath.length + 1];
            System.arraycopy(parentPath, 0, childPath, 0, parentPath.length);
            QVTiModelsManager.QVTiTransformationInstance transformationInstance = (QVTiModelsManager.QVTiTransformationInstance)valueObject;
            ImperativeTransformation transformation = transformationInstance.getTransformation();
            for (TypedModel typedModel : QVTimperativeUtil.getModelParameters((Transformation)transformation)) {
                Parameter variable = typedModel.getOwnedContext();
                String varName = typedModel.getName();
                assert (varName != null);
                childPath[childPath.length - 1] = varName;
                VMVariableData elementVar = new VMVariableData(varName, QVTiVariableFinder.createURI((String[])childPath).toString());
                elementVar.kind = 4;
                QVTiModelsManager modelManager = transformationInstance.getModelManager();
                Resource model = modelManager.getModel(typedModel);
                this.setValueAndType(elementVar, model, "TypedModel");
                if (this.fIsStoreValues) {
                    elementVar.valueObject = variable;
                }
                result.add(elementVar);
            }
        } else if (valueObject instanceof QVTiModelsManager.QVTiTypedModelInstance) {
            QVTiModelsManager.QVTiTypedModelInstance typedModelInstance = (QVTiModelsManager.QVTiTypedModelInstance)valueObject;
            QVTiModelsManager modelManager = typedModelInstance.getModelManager();
            TypedModel typedModel = typedModelInstance.getTypedModel();
            Resource model = modelManager.getModel(typedModel);
            super.collectChildVars((Object)model, parentPath, containerType, result);
        } else {
            super.collectChildVars(valueObject, parentPath, containerType, result);
        }
    }

    protected Object findChildObject(Object parentObj, @Nullable String optParentDeclaredType, @NonNull String @NonNull [] varTreePath, int pathIndex) {
        Resource nextObject = null;
        String nextDeclaredType = null;
        if (!(parentObj instanceof QVTiModelsManager.QVTiTransformationInstance)) {
            if (parentObj instanceof QVTiModelsManager.QVTiTypedModelInstance) {
                QVTiModelsManager.QVTiTypedModelInstance typedModelInstance = (QVTiModelsManager.QVTiTypedModelInstance)parentObj;
                QVTiModelsManager modelManager = typedModelInstance.getModelManager();
                TypedModel typedModel = typedModelInstance.getTypedModel();
                Resource model = modelManager.getModel(typedModel);
                return super.findChildObject((Object)model, optParentDeclaredType, varTreePath, pathIndex);
            }
            return super.findChildObject(parentObj, optParentDeclaredType, varTreePath, pathIndex);
        }
        QVTiModelsManager.QVTiTransformationInstance transformationInstance = (QVTiModelsManager.QVTiTransformationInstance)parentObj;
        ImperativeTransformation transformation = transformationInstance.getTransformation();
        TypedModel typedModel = transformation.getModelParameter(varTreePath[pathIndex]);
        QVTiModelsManager modelManager = transformationInstance.getModelManager();
        nextObject = typedModel != null ? modelManager.getModel(typedModel) : null;
        nextDeclaredType = "Resource";
        int nextIndex = pathIndex + 1;
        if (nextIndex < varTreePath.length) {
            if (nextObject != null) {
                return this.findChildObject(nextObject, nextDeclaredType, varTreePath, nextIndex);
            }
            return null;
        }
        return nextObject;
    }

    protected String getDeclaredType(Object valueObject) {
        if (valueObject instanceof QVTiModelsManager.QVTiTransformationInstance) {
            return "qvtruntimelibrary::Transformation";
        }
        if (valueObject instanceof QVTiModelsManager.QVTiTypedModelInstance) {
            return "qvtruntimelibrary::Model";
        }
        return super.getDeclaredType(valueObject);
    }

    protected @Nullable VMVariableData getVariable(@NonNull TypedElement variable, @Nullable Object pcObject) {
        return super.getVariable(variable, pcObject);
    }

    public void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable String declaredTypeName) {
        if (value instanceof QVTiModelsManager.QVTiTransformationInstance) {
            super.setValueAndType(variable, (Object)((QVTiModelsManager.QVTiTransformationInstance)value).getTransformation(), declaredTypeName);
        } else if (value instanceof QVTiModelsManager.QVTiTypedModelInstance) {
            QVTiModelsManager.QVTiTypedModelInstance typedModelInstance = (QVTiModelsManager.QVTiTypedModelInstance)value;
            QVTiModelsManager modelManager = typedModelInstance.getModelManager();
            TypedModel typedModel = typedModelInstance.getTypedModel();
            Resource model = modelManager.getModel(typedModel);
            super.setValueAndType(variable, (Object)model, declaredTypeName);
        } else {
            super.setValueAndType(variable, value, declaredTypeName);
        }
    }
}

