/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtcore.environment;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.LookupException;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTCore.Area;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.DomainCS;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.PatternCS;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.IQVTcEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.IQVTcNodeEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcBottomPatternEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcGuardPatternEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcMappingEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcPatternEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QVTcAreaEnvironment<AST extends EModelElement>
extends QVTcEnvironment<IQVTcNodeEnvironment, QVTcMappingEnvironment<?>, AST, DomainCS>
implements IQVTcEnvironment {
    protected final String modelName;
    protected final TypedModel typedModel;
    private QVTcBottomPatternEnvironment bottomPatternEnvironment = null;
    private QVTcGuardPatternEnvironment guardPatternEnvironment = null;
    private Set<TypedModel> typedModelClosure = null;
    private Set<EPackage> usedPackageClosure = null;
    private Set<QVTcAreaEnvironment<?>> areaEnvironmentPartialClosure = null;
    private Set<QVTcPatternEnvironment<?>> bottomPatternEnvironmentClosure = null;
    private Set<QVTcPatternEnvironment<?>> guardPatternEnvironmentClosure = null;

    protected QVTcAreaEnvironment(QVTcMappingEnvironment<?> env, AST astNode, DomainCS domainCS, String modelName) {
        super(env, astNode, domainCS);
        this.modelName = modelName;
        if (!"".equals(modelName)) {
            Transformation transformation = this.getTransformation();
            TypedModel typedModel = transformation.getModelParameter(modelName);
            if (typedModel == null) {
                String message = "Domain identifier '" + this.formatString(modelName) + "' must refer to a direction";
                this.analyzerError(message, "DomainCS", domainCS.getIdentifier());
            }
            this.typedModel = typedModel;
        } else {
            this.typedModel = null;
        }
    }

    protected void addUsedPackages(TypedModel typedModel, Set<EPackage> usedPackageClosure, Set<TypedModel> dependsOnClosure) {
        if (typedModel != null) {
            usedPackageClosure.addAll((Collection<EPackage>)typedModel.getUsedPackage());
            if (dependsOnClosure.add(typedModel)) {
                for (TypedModel dependent : typedModel.getDependsOn()) {
                    this.addUsedPackages(dependent, usedPackageClosure, dependsOnClosure);
                }
            }
        }
    }

    protected abstract Set<QVTcAreaEnvironment<?>> computeAreaEnvironmentPartialClosure();

    protected Set<QVTcPatternEnvironment<?>> computeBottomPatternEnvironmentClosure() {
        HashSet closure = new HashSet();
        QVTcAreaEnvironment<?> contextEnvironment = this;
        while (contextEnvironment != null) {
            for (QVTcAreaEnvironment<?> areaEnvironment : contextEnvironment.getAreaEnvironmentPartialClosure()) {
                closure.add(areaEnvironment.getBottomPatternEnvironment());
                closure.add(areaEnvironment.getGuardPatternEnvironment());
            }
            contextEnvironment = contextEnvironment.getContextEnvironment();
        }
        return closure;
    }

    protected Set<QVTcPatternEnvironment<?>> computeGuardPatternEnvironmentClosure() {
        HashSet closure = new HashSet();
        for (QVTcAreaEnvironment<?> areaEnvironment : this.getAreaEnvironmentPartialClosure()) {
            closure.add(areaEnvironment.getGuardPatternEnvironment());
        }
        QVTcAreaEnvironment<?> contextEnvironment = this.getContextEnvironment();
        while (contextEnvironment != null) {
            for (QVTcAreaEnvironment<?> areaEnvironment : contextEnvironment.getAreaEnvironmentPartialClosure()) {
                closure.add(areaEnvironment.getBottomPatternEnvironment());
                closure.add(areaEnvironment.getGuardPatternEnvironment());
            }
            contextEnvironment = contextEnvironment.getContextEnvironment();
        }
        return closure;
    }

    protected Set<TypedModel> computeTypedModelClosure() {
        HashSet<TypedModel> closure = new HashSet<TypedModel>();
        this.computeTypedModelClosure(closure, this.typedModel);
        return closure;
    }

    protected void computeTypedModelClosure(Set<TypedModel> closure, TypedModel typedModel) {
        if (typedModel != null && closure.add(typedModel)) {
            for (TypedModel dependant : typedModel.getDependsOn()) {
                this.computeTypedModelClosure(closure, dependant);
            }
        }
    }

    protected Set<EPackage> computeUsedPackageClosure() {
        HashSet<EPackage> closure = new HashSet<EPackage>();
        Transformation transformation = this.getTransformation();
        closure.add((EPackage)transformation);
        for (TypedModel typedModel : this.getTypedModelClosure()) {
            closure.addAll((Collection<EPackage>)typedModel.getUsedPackage());
        }
        return closure;
    }

    public QVTcBottomPatternEnvironment createBottomPatternEnvironment(PatternCS patternCS) {
        assert (this.typedModelClosure == null) : "Must not createBottomPatternEnvironment after computeTypedModelClosure";
        assert (this.usedPackageClosure == null) : "Must not createBottomPatternEnvironment after computeUsedPackageClosure";
        if (this.bottomPatternEnvironment != null) {
            this.analyzerError("Repeated createBottomPatternEnvironment", "BottomPattern", patternCS);
        }
        this.bottomPatternEnvironment = new QVTcBottomPatternEnvironment(this, patternCS);
        return this.bottomPatternEnvironment;
    }

    public QVTcGuardPatternEnvironment createGuardPatternEnvironment(PatternCS patternCS) {
        assert (this.typedModelClosure == null) : "Must not createGuardPatternEnvironment after computeTypedModelClosure";
        assert (this.usedPackageClosure == null) : "Must not createGuardPatternEnvironment after computeUsedPackageClosure";
        if (this.guardPatternEnvironment != null) {
            this.analyzerError("Repeated createGuardPatternEnvironment", "BottomPattern", patternCS);
        }
        this.guardPatternEnvironment = new QVTcGuardPatternEnvironment(this, patternCS);
        return this.guardPatternEnvironment;
    }

    public abstract Area getArea();

    public Set<QVTcAreaEnvironment<?>> getAreaEnvironmentPartialClosure() {
        if (this.areaEnvironmentPartialClosure == null) {
            this.areaEnvironmentPartialClosure = this.computeAreaEnvironmentPartialClosure();
        }
        return this.areaEnvironmentPartialClosure;
    }

    public QVTcBottomPatternEnvironment getBottomPatternEnvironment() {
        return this.bottomPatternEnvironment;
    }

    public Set<QVTcPatternEnvironment<?>> getBottomPatternEnvironmentClosure() {
        if (this.bottomPatternEnvironmentClosure == null) {
            this.bottomPatternEnvironmentClosure = this.computeBottomPatternEnvironmentClosure();
        }
        return this.bottomPatternEnvironmentClosure;
    }

    public abstract QVTcAreaEnvironment<?> getContextEnvironment();

    public QVTcGuardPatternEnvironment getGuardPatternEnvironment() {
        return this.guardPatternEnvironment;
    }

    public Set<QVTcPatternEnvironment<?>> getGuardPatternEnvironmentClosure() {
        if (this.guardPatternEnvironmentClosure == null) {
            this.guardPatternEnvironmentClosure = this.computeGuardPatternEnvironmentClosure();
        }
        return this.guardPatternEnvironmentClosure;
    }

    public abstract QVTcMappingEnvironment<?> getMappingEnvironment();

    public String getModelName() {
        return this.modelName;
    }

    public TypedModel getTypedModel() {
        return this.typedModel;
    }

    protected Set<TypedModel> getTypedModelClosure() {
        if (this.typedModelClosure == null) {
            this.typedModelClosure = this.computeTypedModelClosure();
        }
        return this.typedModelClosure;
    }

    protected Set<EPackage> getUsedPackageClosure() {
        if (this.usedPackageClosure == null) {
            this.usedPackageClosure = this.computeUsedPackageClosure();
        }
        return this.usedPackageClosure;
    }

    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        EClassifier eClassifier = this.tryLookupClassifier(this.getUsedPackageClosure(), names);
        if (eClassifier != null) {
            return eClassifier;
        }
        return null;
    }

    public String toString() {
        String parentString = this.getInternalParent() != null ? String.valueOf(this.getInternalParent().toString()) + "." : "";
        return String.valueOf(parentString) + this.getModelName();
    }
}

