/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import lpg.runtime.IToken;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseResult;
import org.eclipse.qvt.declarative.parser.utils.CommonASTVisitor;

public class CommonSourcePositionLocator
implements ISourcePositionLocator {
    protected final BasicEnvironment environment;
    private int fStartOffset;
    private int fEndOffset;
    private ASTNodeVisitor<Notifier> astVisitor = new ASTNodeVisitor<Notifier>(Notifier.class);
    private ASTNodeVisitor<CSTNode> cstVisitor = new ASTNodeVisitor<CSTNode>(CSTNode.class);

    protected CommonSourcePositionLocator(BasicEnvironment environment) {
        this.environment = environment;
    }

    public Object findNode(Object node, int offset) {
        return this.findNode(node, offset, offset);
    }

    public Object findNode(Object node, int startOffset, int endOffset) {
        if (node instanceof ICommonParseResult) {
            node = ((ICommonParseResult)node).getCST();
        }
        if (node instanceof CSTNode) {
            return this.findCSTNode((CSTNode)node, startOffset, endOffset);
        }
        if (node instanceof Notifier) {
            return this.findASTNode((Notifier)node, startOffset, endOffset);
        }
        return null;
    }

    public Notifier findASTNode(Notifier ast, int startOffset, int endOffset) {
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
        Notifier astNode = (Notifier)this.astVisitor.enter(ast);
        if (QVTEditorPlugin.VISITOR_SELECTION.isActive()) {
            if (astNode == null) {
                QVTEditorPlugin.VISITOR_SELECTION.println("Selected node:  null");
            } else {
                CSTNode cstNode = this.environment.getASTMapping((Object)astNode);
                QVTEditorPlugin.VISITOR_SELECTION.println("Selected node: " + cstNode + " [" + cstNode.getStartOffset() + ".." + cstNode.getEndOffset() + "]");
            }
        }
        return astNode;
    }

    public CSTNode findCSTNode(CSTNode cst, int startOffset, int endOffset) {
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
        CSTNode cstNode = (CSTNode)this.cstVisitor.enter(cst);
        if (QVTEditorPlugin.VISITOR_SELECTION.isActive()) {
            if (cstNode == null) {
                QVTEditorPlugin.VISITOR_SELECTION.println("Selected node:  null");
            } else {
                QVTEditorPlugin.VISITOR_SELECTION.println("Selected node: " + cstNode + " [" + cstNode.getStartOffset() + ".." + cstNode.getEndOffset() + "]");
            }
        }
        return cstNode;
    }

    public int getEndOffset(Object node) {
        if (node instanceof ICommonParseResult) {
            node = ((ICommonParseResult)node).getCST();
        }
        if (node instanceof CSTNode) {
            CSTNode n = (CSTNode)node;
            return n.getEndOffset();
        }
        if (node instanceof Notifier) {
            CSTNode cstNode = this.environment.getASTMapping(node);
            return cstNode != null ? cstNode.getEndOffset() : 0;
        }
        if (node instanceof IToken) {
            IToken t = (IToken)node;
            return t.getEndOffset();
        }
        return 0;
    }

    public int getLength(Object node) {
        return this.getEndOffset(node) - this.getStartOffset(node);
    }

    public IPath getPath(Object node) {
        return new Path("");
    }

    public int getStartOffset(Object node) {
        if (node instanceof ICommonParseResult) {
            node = ((ICommonParseResult)node).getCST();
        }
        if (node instanceof CSTNode) {
            CSTNode n = (CSTNode)node;
            return n.getStartOffset();
        }
        if (node instanceof Notifier) {
            CSTNode cstNode = this.environment.getASTMapping(node);
            return cstNode != null ? cstNode.getStartOffset() : 0;
        }
        if (node instanceof IToken) {
            IToken t = (IToken)node;
            return t.getStartOffset();
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ASTNodeVisitor<N>
    extends CommonASTVisitor<CSTNode, N> {
        protected ASTNodeVisitor(Class<N> nodeClass) {
            super(nodeClass);
        }

        public boolean preVisit(N astNode) {
            CSTNode cstNode = CommonSourcePositionLocator.this.environment.getASTMapping(astNode);
            if (cstNode == null) {
                return true;
            }
            int nodeStartOffset = cstNode.getStartOffset();
            int nodeEndOffset = cstNode.getEndOffset();
            if (QVTEditorPlugin.VISITOR_TRACE.isActive()) {
                QVTEditorPlugin.VISITOR_TRACE.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".preVisit(ASTNode):  Examining " + astNode.getClass().getName() + " @ [" + nodeStartOffset + "->" + nodeEndOffset + ']');
            }
            if (nodeStartOffset <= CommonSourcePositionLocator.this.fStartOffset && CommonSourcePositionLocator.this.fEndOffset <= nodeEndOffset + 1) {
                if (QVTEditorPlugin.VISITOR_TRACE.isActive()) {
                    QVTEditorPlugin.VISITOR_TRACE.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".preVisit(ASTNode) SELECTED for offsets [" + CommonSourcePositionLocator.this.fStartOffset + ".." + CommonSourcePositionLocator.this.fEndOffset + "]");
                }
                this.result = cstNode;
                return true;
            }
            return false;
        }
    }
}

