/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.uml24atl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.m2m.atl.drivers.uml24atl.ASMUMLModel;
import org.eclipse.m2m.atl.drivers.uml24atl.Invocation;
import org.eclipse.m2m.atl.engine.vm.ClassNativeOperation;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBag;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSet;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMTuple;

public class ASMUMLModelElement
extends ASMModelElement {
    private EObject object;

    static {
        try {
            ASMUMLModel.getMOF().findModelElement("EClass");
            ASMUMLModelElement.registerMOFOperation("EClass", "allInstances", new Class[0]);
            ASMUMLModelElement.registerMOFOperation("EClass", "allInstancesFrom", new Class[]{ASMString.class});
            ASMUMLModelElement.registerMOFOperation("EClassifier", "newInstance", new Class[0]);
            ASMUMLModelElement.registerMOFOperation("EClassifier", "getInstanceById", new Class[]{ASMString.class, ASMString.class});
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public ASMBoolean conformsTo(ASMOclType other) {
        boolean ret = false;
        if (other instanceof ASMUMLModelElement) {
            EObject o = ((ASMUMLModelElement)other).object;
            EObject t = this.object;
            if (o instanceof EClass && t instanceof EClass) {
                try {
                    ret = o.equals(t) || ((EClass)o).isSuperTypeOf((EClass)t);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        return new ASMBoolean(ret);
    }

    public ASMModelElement getPropertyType(String name) {
        ASMModelElement ret = null;
        ASMModelElement p = this.getProperty(name);
        if (p != null) {
            ret = (ASMModelElement)p.get(null, "eType");
        }
        return ret;
    }

    public ASMModelElement getProperty(String name) {
        ASMModelElement ret = null;
        EObject t = this.object;
        if (t instanceof EClass) {
            try {
                ret = ((ASMUMLModel)this.getModel()).getASMModelElement((EObject)((EClass)t).getEStructuralFeature(name));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return ret;
    }

    public ASMOclAny refImmediateComposite() {
        Object ret = null;
        EObject ic = this.object.eContainer();
        ret = ic == null ? super.refImmediateComposite() : ((ASMUMLModel)this.getModel()).getASMModelElement(ic);
        return ret;
    }

    public ASMOclAny get(StackFrame frame, String name) {
        ASMOclAny ret = null;
        if (frame != null && this.isHelper(frame, name)) {
            ret = this.getHelper(frame, name);
        } else if ("__xmiID__".equals(name)) {
            String id = ((XMIResource)((ASMUMLModel)this.getModel()).getExtent()).getURIFragment(this.object);
            ret = this.emf2ASM(frame, id);
        } else {
            EStructuralFeature sf = this.object.eClass().getEStructuralFeature(name);
            if (sf == null) {
                frame.printStackTrace("feature " + name + " does not exist on " + this.getType());
            }
            ret = this.emf2ASM(frame, this.object.eGet(sf));
        }
        return ret;
    }

    public ASMOclAny emf2ASM(StackFrame frame, Object value) {
        ASMString ret = null;
        if (value instanceof String) {
            ret = new ASMString((String)value);
        } else if (value instanceof Boolean) {
            ret = new ASMBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            ret = new ASMReal(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            ret = new ASMReal(((Float)value).doubleValue());
        } else if (value instanceof Integer) {
            ret = new ASMInteger(((Integer)value).intValue());
        } else if (value instanceof Long) {
            ret = new ASMInteger(((Long)value).intValue());
        } else if (value instanceof Byte) {
            ret = new ASMInteger(((Byte)value).intValue());
        } else if (value instanceof Short) {
            ret = new ASMInteger(((Short)value).intValue());
        } else if (value instanceof Character) {
            ret = new ASMInteger((int)((Character)value).charValue());
        } else if (value instanceof Enumerator) {
            ret = new ASMEnumLiteral(((Enumerator)value).getName());
        } else if (value instanceof FeatureMap.Entry) {
            ret = new ASMTuple();
            ret.set(frame, "eStructuralFeature", this.emf2ASM(frame, ((FeatureMap.Entry)value).getEStructuralFeature()));
            ret.set(frame, "value", this.emf2ASM(frame, ((FeatureMap.Entry)value).getValue()));
        } else if (value instanceof EObject) {
            ret = this.eObjectToASM(frame, (EObject)value);
        } else if (value == null) {
            ret = new ASMOclUndefined();
        } else if (value instanceof Collection) {
            Object col = value instanceof List ? new ASMSequence() : (value instanceof Set ? new ASMSet() : new ASMBag());
            Iterator i = ((Collection)value).iterator();
            while (i.hasNext()) {
                col.add(this.emf2ASM(frame, i.next()));
            }
            ret = col;
        } else {
            frame.printStackTrace("ERROR: cannot convert " + value + " : " + value.getClass() + " from EMF.");
        }
        return ret;
    }

    private ASMOclAny eObjectToASM(StackFrame frame, EObject value) {
        ASMUMLModel model = (ASMUMLModel)this.getModel();
        Resource valueExtent = value.eResource();
        if (model.getExtent().equals(valueExtent)) {
            return model.getASMModelElement(value);
        }
        for (Object m : frame.getModels().values()) {
            if (!(m instanceof ASMUMLModel) || model.equals(m) || !((ASMUMLModel)((Object)m)).getExtent().equals(valueExtent)) continue;
            return ((ASMUMLModel)((Object)m)).getASMModelElement(value);
        }
        return model.getASMModelElement(value);
    }

    public void set(StackFrame frame, String name, ASMOclAny value) {
        block10: {
            Object val;
            EStructuralFeature feature;
            block9: {
                super.set(frame, name, value);
                feature = this.object.eClass().getEStructuralFeature(name);
                if (feature == null) {
                    frame.printStackTrace("feature " + name + " does not exist on " + this.getType());
                }
                if (!feature.isChangeable()) {
                    frame.printStackTrace("feature " + name + " is not changeable");
                }
                if (!feature.isMany()) break block9;
                EList l = (EList)this.object.eGet(feature);
                if (value instanceof ASMCollection) {
                    for (ASMOclAny sv : (ASMCollection)value) {
                        if (((ASMUMLModel)this.getModel()).isCheckSameModel() && sv instanceof ASMModelElement && ((ASMModelElement)sv).getModel() != this.getModel()) continue;
                        Object val2 = this.asm2EMF(frame, sv, name, feature);
                        try {
                            l.add(val2);
                            this.checkContainment(feature, val2);
                        }
                        catch (Exception exception) {
                            frame.printStackTrace("cannot set feature " + this.getType() + "." + name + " to value " + val2);
                        }
                    }
                } else {
                    Object val3 = this.asm2EMF(frame, value, name, feature);
                    l.add(val3);
                    this.checkContainment(feature, val3);
                }
                break block10;
            }
            if (((ASMUMLModel)this.getModel()).isCheckSameModel() && value instanceof ASMModelElement && ((ASMModelElement)value).getModel() != this.getModel() || (val = this.asm2EMF(frame, value, name, feature)) == null) break block10;
            try {
                this.object.eSet(feature, val);
                this.checkContainment(feature, val);
            }
            catch (Exception e) {
                frame.printStackTrace("cannot set feature " + this.getType() + "." + name + " to value " + val, e);
            }
        }
    }

    private void checkContainment(EStructuralFeature feature, Object val) {
        if (val != null && feature instanceof EReference) {
            ASMUMLModel model;
            EList toplevelElements;
            EReference ref = (EReference)feature;
            if (ref.isContainment()) {
                ASMUMLModel model2 = (ASMUMLModel)this.getModel();
                EList toplevelElements2 = model2.getExtent().getContents();
                if (toplevelElements2.contains(val)) {
                    toplevelElements2.remove(val);
                }
            } else if (ref.isContainer() && (toplevelElements = (model = (ASMUMLModel)this.getModel()).getExtent().getContents()).contains((Object)this.object)) {
                toplevelElements.remove((Object)this.object);
            }
        }
    }

    public Object asm2EMF(StackFrame frame, ASMOclAny value, String propName, EStructuralFeature feature) {
        Object ret = null;
        if (value instanceof ASMString) {
            ret = ((ASMString)value).getSymbol();
        } else if (value instanceof ASMBoolean) {
            ret = new Boolean(((ASMBoolean)value).getSymbol());
        } else if (value instanceof ASMReal) {
            ret = new Double(((ASMReal)value).getSymbol());
        } else if (value instanceof ASMInteger) {
            String targetType;
            int val = ((ASMInteger)value).getSymbol();
            ret = feature != null ? (Number)((targetType = feature.getEType().getInstanceClassName()).equals("java.lang.Double") || targetType.equals("java.lang.Float") ? (Number)new Double(val) : (Number)new Integer(val)) : (Number)new Integer(val);
        } else if (value instanceof ASMUMLModelElement) {
            ret = ((ASMUMLModelElement)value).object;
        } else if (value instanceof ASMOclUndefined) {
            ret = null;
        } else if (value instanceof ASMEnumLiteral) {
            String name = ((ASMEnumLiteral)value).getName();
            EClassifier type = ((EClass)((ASMUMLModelElement)this.getMetaobject()).object).getEStructuralFeature(propName).getEType();
            ret = ((EEnum)type).getEEnumLiteral(name).getInstance();
        } else if (value instanceof ASMTuple) {
            Object f = this.asm2EMF(frame, ((ASMTuple)value).get(frame, "eStructuralFeature"), propName, feature);
            if (f instanceof EStructuralFeature) {
                Object v = this.asm2EMF(frame, ((ASMTuple)value).get(frame, "value"), propName, feature);
                ret = FeatureMapUtil.createEntry((EStructuralFeature)((EStructuralFeature)f), (Object)v);
            } else {
                frame.printStackTrace("ERROR: cannot convert " + value + " : " + value.getClass() + " to EMF.");
            }
        } else if (value instanceof ASMCollection) {
            ret = new ArrayList();
            Iterator i = ((ASMCollection)value).iterator();
            while (i.hasNext()) {
                Object v = this.asm2EMF(frame, (ASMOclAny)i.next(), propName, feature);
                if (v == null) continue;
                ((List)ret).add(v);
            }
        } else {
            frame.printStackTrace("ERROR: cannot convert " + value + " : " + value.getClass() + " to EMF.");
        }
        return ret;
    }

    private static ASMModelElement getMetaobject(ASMModel model, EObject object) {
        ASMModelElement ret = null;
        EClass metaobject = object.eClass();
        if (metaobject != object) {
            ret = ((ASMUMLModel)model.getMetamodel()).getASMModelElement((EObject)metaobject);
        }
        return ret;
    }

    private static void registerMOFOperation(String modelelementName, String methodName, Class[] args) throws Exception {
        ArrayList<Class> realArgs = new ArrayList<Class>((Collection)Arrays.asList(args));
        realArgs.add(0, ASMUMLModelElement.class);
        realArgs.add(0, StackFrame.class);
        ClassNativeOperation no = new ClassNativeOperation(ASMUMLModelElement.class.getMethod(methodName, realArgs.toArray(args)));
        ASMModelElement amme = ASMUMLModel.getMOF().findModelElement(modelelementName);
        amme.registerVMOperation((Operation)no);
    }

    public static ASMOclAny getInstanceById(StackFrame frame, ASMUMLModelElement self, ASMString modelName, ASMString id) {
        EObject eo;
        ASMOclUndefined ret = null;
        ASMModel model = (ASMModel)frame.getModels().get(modelName.getSymbol());
        if (model instanceof ASMUMLModel && (eo = ((XMIResource)((ASMUMLModel)model).getExtent()).getEObject(id.getSymbol())) != null) {
            ret = ((ASMUMLModel)model).getASMModelElement(eo);
        }
        return ret == null ? new ASMOclUndefined() : ret;
    }

    public static ASMSet allInstances(StackFrame frame, ASMUMLModelElement self) {
        return ASMUMLModelElement.allInstancesFrom(frame, self, null);
    }

    public static ASMSet allInstancesFrom(StackFrame frame, ASMUMLModelElement self, ASMString sourceModelName) {
        HashSet ret = new HashSet();
        for (String mname : frame.getModels().keySet()) {
            ASMModel am;
            if (sourceModelName != null && !mname.equals(sourceModelName.getSymbol()) || !(am = (ASMModel)frame.getModels().get(mname)).getMetamodel().equals(self.getModel())) continue;
            Set elems = am.getElementsByType((ASMModelElement)self);
            ret.addAll(elems);
        }
        return new ASMSet(ret);
    }

    public static ASMModelElement newInstance(StackFrame frame, ASMUMLModelElement self) {
        ASMModelElement ret = null;
        if (self.object.eClass().getName().equals("EClass")) {
            for (ASMModel model : frame.getExecEnv().getModels().values()) {
                if (!model.getMetamodel().equals(self.getModel()) || !model.isTarget()) continue;
                ret = model.newModelElement((ASMModelElement)self);
                break;
            }
        }
        return ret;
    }

    protected ASMUMLModelElement(Map modelElements, ASMModel model, EObject object) {
        super(model, ASMUMLModelElement.getMetaobject(model, object));
        this.object = object;
        modelElements.put(object, this);
        EStructuralFeature sfName = object.eClass().getEStructuralFeature("name");
        if (sfName != null) {
            String name = (String)object.eGet(sfName);
            if (name == null) {
                name = "<notnamedyet>";
            }
            this.setName(name);
        } else {
            this.setName("<unnamed>");
        }
        if (this.getMetaobject() == null) {
            this.setMetaobject(this);
        }
        this.setType((ASMOclType)this.getMetaobject());
        if (object instanceof EClass) {
            this.addSupertype(ASMOclType.myType);
            EClass cl = (EClass)object;
            for (EClass s : cl.getESuperTypes()) {
                this.addSupertype((ASMOclType)((ASMUMLModel)model).getASMModelElement((EObject)s));
            }
        }
    }

    protected Method findMethod(Class cls, String name, Class[] argumentTypes) {
        Method ret = null;
        Method[] methods = cls.getDeclaredMethods();
        int i = 0;
        while (i < methods.length && ret == null) {
            Class<?>[] pts;
            Method method = methods[i];
            if (method.getName().equals(name) && (pts = method.getParameterTypes()).length == argumentTypes.length) {
                boolean ok = true;
                int j = 0;
                while (j < pts.length && ok) {
                    if (!(pts[j].isAssignableFrom(argumentTypes[j]) || pts[j] == Boolean.TYPE && argumentTypes[j] == Boolean.class || pts[j] == Integer.TYPE && argumentTypes[j] == Integer.class || pts[j] == Character.TYPE && argumentTypes[j] == Character.class || pts[j] == Long.TYPE && argumentTypes[j] == Long.class || pts[j] == Float.TYPE && argumentTypes[j] == Float.class || pts[j] == Double.TYPE && argumentTypes[j] == Double.class)) {
                        ok = false;
                    }
                    ++j;
                }
                if (ok) {
                    ret = method;
                }
            }
            ++i;
        }
        if (ret == null && cls.getSuperclass() != null) {
            ret = this.findMethod(cls.getSuperclass(), name, argumentTypes);
        }
        return ret;
    }

    public ASMOclAny invoke(StackFrame frame, String opName, List arguments) {
        if (opName.equals("applyProfile") || opName.equals("applyStereotype") || opName.equals("setValue") || opName.equals("applyAllRequiredStereotypes") || opName.equals("applyAllStereotypes") || opName.equals("unapplyAllStereotype") || opName.equals("unapplyAllNonApplicableStereotypes")) {
            ((ASMUMLModel)this.getModel()).addDelayedInvocation(new Invocation(frame, this, opName, arguments));
            return new ASMOclUndefined();
        }
        return this.realInvoke(frame, opName, arguments);
    }

    public ASMOclAny realInvoke(StackFrame frame, String opName, List arguments) {
        ASMOclAny ret = null;
        if (this.findOperation(frame, opName, arguments) != null) {
            ret = super.invoke(frame, opName, arguments);
        } else {
            Object[] args = new Object[arguments.size()];
            Class[] argumentTypes = new Class[arguments.size()];
            int k = 0;
            Iterator i = arguments.iterator();
            while (i.hasNext()) {
                args[k] = this.asm2EMF(frame, (ASMOclAny)i.next(), null, null);
                argumentTypes[k] = args[k].getClass();
                ++k;
            }
            Method method = this.findMethod(this.object.getClass(), opName, argumentTypes);
            try {
                if (method != null) {
                    ret = this.emf2ASM(frame, method.invoke((Object)this.object, args));
                } else {
                    frame.printStackTrace("ERROR: could not find operation " + opName + " on " + this.getType() + " having supertypes: " + this.getType().getSupertypes() + " (including Java operations)");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                frame.printStackTrace("ERROR: could not invoke operation " + opName + " on " + this.getType() + " having supertypes: " + this.getType().getSupertypes() + " (including Java operations)");
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Exception toReport = cause instanceof Exception ? (Exception)cause : e;
                frame.printStackTrace("ERROR: exception during invocation of operation " + opName + " on " + this.getType() + " (java method: " + method + ")", toReport);
            }
        }
        return ret;
    }

    public EObject getObject() {
        return this.object;
    }
}

