/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.internal.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;

public class SelectConnectionEditPartTracker
extends SelectEditPartTracker {
    private final int MODIFIER_NO_SNAPPING = SWT.getPlatform().equals("carbon") ? 262144 : 65536;
    private Request sourceRequest;
    private int index = -1;
    private String type;
    private boolean bSourceFeedback = false;
    private PrecisionRectangle sourceRectangle;
    private Point originalLocation = null;

    public SelectConnectionEditPartTracker(ConnectionEditPart owner) {
        super((EditPart)owner);
    }

    protected boolean handleButtonDown(int button) {
        if (!super.handleButtonDown(button)) {
            return false;
        }
        Point p = this.getLocation();
        this.getConnection().translateToRelative((Translatable)p);
        PointList points = this.getConnection().getPoints();
        Dimension size = new Dimension(7, 7);
        this.getConnection().translateToRelative((Translatable)size);
        int i = 1;
        while (i < points.size() - 1) {
            Point ptCenter = points.getPoint(i);
            Rectangle rect = new Rectangle(ptCenter.x - size.width / 2, ptCenter.y - size.height / 2, size.width, size.height);
            if (rect.contains(p)) {
                this.setType("move bendpoint");
                this.setIndex(i);
            }
            ++i;
        }
        if (this.getIndex() == -1) {
            this.setIndex(PointListUtilities.findNearestLineSegIndexOfPoint((PointList)this.getConnection().getPoints(), (Point)new Point(p.x, p.y)));
            this.setIndex(this.getIndex() - 1);
            this.setType("create bendpoint");
        }
        return true;
    }

    protected boolean shouldAllowDrag() {
        return this.getIndex() != -1;
    }

    protected boolean handleButtonUp(int button) {
        boolean bExecuteDrag = this.isInState(4) && this.shouldAllowDrag();
        boolean bRet = super.handleButtonUp(button);
        if (bExecuteDrag) {
            this.eraseSourceFeedback();
            this.setCurrentCommand(this.getCommand());
            this.executeCurrentCommand();
        }
        return bRet;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(4) && this.shouldAllowDrag()) {
            this.updateSourceRequest();
            this.showSourceFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected boolean handleDragStarted() {
        this.originalLocation = null;
        this.sourceRectangle = null;
        return this.stateTransition(2, 4);
    }

    protected Cursor calculateCursor() {
        if (this.getType() == "move bendpoint") {
            return Cursors.CURSOR_SEG_MOVE;
        }
        return this.getConnection().getCursor();
    }

    public void deactivate() {
        if (!this.isInState(0x40000000)) {
            this.eraseSourceFeedback();
        }
        this.sourceRequest = null;
        super.deactivate();
    }

    private boolean isShowingFeedback() {
        return this.bSourceFeedback;
    }

    private void setShowingFeedback(boolean bSet) {
        this.bSourceFeedback = bSet;
    }

    protected List createOperationSet() {
        ArrayList<ConnectionEditPart> list = new ArrayList<ConnectionEditPart>();
        list.add(this.getConnectionEditPart());
        return list;
    }

    private void showSourceFeedback() {
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.showSourceFeedback(this.getSourceRequest());
            ++i;
        }
        this.setShowingFeedback(true);
    }

    private void eraseSourceFeedback() {
        if (!this.isShowingFeedback()) {
            return;
        }
        this.setShowingFeedback(false);
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.eraseSourceFeedback(this.getSourceRequest());
            ++i;
        }
    }

    private Request getSourceRequest() {
        if (this.sourceRequest == null) {
            this.sourceRequest = this.createSourceRequest();
        }
        return this.sourceRequest;
    }

    protected Object getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected Request createSourceRequest() {
        BendpointRequest request = new BendpointRequest();
        request.setType(this.getType());
        request.setIndex(this.getIndex());
        request.setSource((ConnectionEditPart)this.getSourceEditPart());
        return request;
    }

    protected Command getCommand() {
        return this.getSourceEditPart().getCommand(this.getSourceRequest());
    }

    protected String getCommandName() {
        return this.getType().toString();
    }

    private Connection getConnection() {
        return (Connection)this.getConnectionEditPart().getFigure();
    }

    private ConnectionEditPart getConnectionEditPart() {
        return (ConnectionEditPart)this.getSourceEditPart();
    }

    protected String getDebugName() {
        return "Bendpoint Handle Tracker " + this.getCommandName();
    }

    protected int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    protected void updateSourceRequest() {
        BendpointRequest request = (BendpointRequest)this.getSourceRequest();
        if (this.originalLocation == null) {
            this.originalLocation = this.getStartLocation().getCopy();
        }
        Dimension delta = this.getDragMoveDelta();
        if (this.getCurrentInput().isShiftKeyDown()) {
            float ratio = 0.0f;
            if (delta.width != 0) {
                ratio = (float)delta.height / (float)delta.width;
            }
            if ((double)(ratio = Math.abs(ratio)) > 0.5 && (double)ratio < 1.5) {
                if (Math.abs(delta.height) > Math.abs(delta.width)) {
                    delta.height = delta.height > 0 ? Math.abs(delta.width) : -Math.abs(delta.width);
                } else {
                    delta.width = delta.width > 0 ? Math.abs(delta.height) : -Math.abs(delta.height);
                }
            } else if (Math.abs(delta.width) > Math.abs(delta.height)) {
                delta.height = 0;
            } else {
                delta.width = 0;
            }
        }
        Point moveDelta = new Point(delta.width, delta.height);
        SnapToHelper snapToHelper = (SnapToHelper)this.getConnectionEditPart().getAdapter(SnapToHelper.class);
        Rectangle rect = new Rectangle(this.originalLocation.x, this.originalLocation.y, 1, 1);
        if (this.sourceRectangle == null) {
            this.sourceRectangle = new PrecisionRectangle(rect);
        }
        if (snapToHelper != null && !this.getCurrentInput().isModKeyDown(this.MODIFIER_NO_SNAPPING)) {
            PrecisionRectangle baseRect = this.sourceRectangle.getPreciseCopy();
            baseRect.translate(moveDelta);
            PrecisionPoint preciseDelta = new PrecisionPoint(moveDelta);
            snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
            Point newLocation = this.originalLocation.getCopy().translate((Point)preciseDelta);
            request.setLocation(newLocation);
        } else {
            request.setLocation(this.getLocation());
        }
    }
}

