/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.merge;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class DocumentMerger {
    private static final String DIFF_RANGE_CATEGORY = "org.eclipse.compare.DIFF_RANGE_CATEGORY";
    private static final boolean USE_MERGING_TOKEN_DIFF = false;
    private static final boolean APPEND_CONFLICT = true;
    private ArrayList<Diff> fAllDiffs;
    private ArrayList<Diff> fChangeDiffs;
    private IDocumentMergerInput fInput;

    public DocumentMerger(IDocumentMergerInput input) {
        this.fInput = input;
    }

    public void doDiff() throws CoreException {
        this.fChangeDiffs = new ArrayList();
        IDocument lDoc = this.getDocument('L');
        IDocument rDoc = this.getDocument('R');
        if (lDoc == null || rDoc == null) {
            return;
        }
        Position lRegion = this.getRegion('L');
        Position rRegion = this.getRegion('R');
        IDocument aDoc = null;
        Position aRegion = null;
        if (this.isThreeWay() && !this.isIgnoreAncestor()) {
            aDoc = this.getDocument('A');
            aRegion = this.getRegion('A');
        }
        this.resetPositions(lDoc);
        this.resetPositions(rDoc);
        this.resetPositions(aDoc);
        boolean ignoreWhiteSpace = this.isIgnoreWhitespace();
        ICompareFilter[] compareFilters = this.getCompareFilters();
        DocLineComparator sright = new DocLineComparator(rDoc, DocumentMerger.toRegion(rRegion), ignoreWhiteSpace, compareFilters, 'R');
        DocLineComparator sleft = new DocLineComparator(lDoc, DocumentMerger.toRegion(lRegion), ignoreWhiteSpace, compareFilters, 'L');
        DocLineComparator sancestor = null;
        if (aDoc != null) {
            sancestor = new DocLineComparator(aDoc, DocumentMerger.toRegion(aRegion), ignoreWhiteSpace, compareFilters, 'A');
        }
        Object[] result = new Object[1];
        DocLineComparator sa = sancestor;
        DocLineComparator sl = sleft;
        DocLineComparator sr = sright;
        IRunnableWithProgress runnable = monitor -> {
            monitor.beginTask(CompareMessages.DocumentMerger_0, DocumentMerger.maxWork(sa, sl, sr));
            try {
                objectArray[0] = RangeDifferencer.findRanges((IProgressMonitor)monitor, (IRangeComparator)sa, (IRangeComparator)sl, (IRangeComparator)sr);
            }
            catch (OutOfMemoryError ex) {
                System.gc();
                throw new InvocationTargetException(ex);
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.done();
        };
        RangeDifference[] e = null;
        try {
            this.getCompareConfiguration().getContainer().run(true, true, runnable);
            e = (RangeDifference[])result[0];
        }
        catch (InvocationTargetException ex) {
            Diff diff = new Diff(null, 0, aDoc, aRegion, 0, aDoc != null ? aDoc.getLength() : 0, lDoc, lRegion, 0, lDoc.getLength(), rDoc, rRegion, 0, rDoc.getLength());
            this.fAllDiffs = new ArrayList();
            this.fAllDiffs.add(diff);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 0, CompareMessages.DocumentMerger_1, ex.getTargetException()));
        }
        catch (InterruptedException interruptedException) {
            Diff diff = new Diff(null, 0, aDoc, aRegion, 0, aDoc != null ? aDoc.getLength() : 0, lDoc, lRegion, 0, lDoc.getLength(), rDoc, rRegion, 0, rDoc.getLength());
            this.fAllDiffs = new ArrayList();
            this.fAllDiffs.add(diff);
            return;
        }
        if (this.isCapped(sa, sl, sr)) {
            this.fInput.getCompareConfiguration().setProperty("OPTIMIZED_ALGORITHM_USED", Boolean.TRUE);
        } else {
            this.fInput.getCompareConfiguration().setProperty("OPTIMIZED_ALGORITHM_USED", Boolean.FALSE);
        }
        ArrayList<Diff> newAllDiffs = new ArrayList<Diff>();
        RangeDifference[] rangeDifferenceArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference es = rangeDifferenceArray[n2];
            int ancestorStart = 0;
            int ancestorEnd = 0;
            if (sancestor != null) {
                ancestorStart = sancestor.getTokenStart(es.ancestorStart());
                ancestorEnd = DocumentMerger.getTokenEnd2(sancestor, es.ancestorStart(), es.ancestorLength());
            }
            int leftStart = sleft.getTokenStart(es.leftStart());
            int leftEnd = DocumentMerger.getTokenEnd2(sleft, es.leftStart(), es.leftLength());
            int rightStart = sright.getTokenStart(es.rightStart());
            int rightEnd = DocumentMerger.getTokenEnd2(sright, es.rightStart(), es.rightLength());
            Diff diff = new Diff(null, es.kind(), aDoc, aRegion, ancestorStart, ancestorEnd, lDoc, lRegion, leftStart, leftEnd, rDoc, rRegion, rightStart, rightEnd);
            newAllDiffs.add(diff);
            if (this.isPatchHunk()) {
                if (this.useChange(diff)) {
                    this.recordChangeDiff(diff);
                }
            } else if (ignoreWhiteSpace || this.useChange(es.kind())) {
                String a = null;
                if (sancestor != null) {
                    a = this.extract2(aDoc, sancestor, es.ancestorStart(), es.ancestorLength());
                }
                String s = this.extract2(lDoc, sleft, es.leftStart(), es.leftLength());
                String d = this.extract2(rDoc, sright, es.rightStart(), es.rightLength());
                if (ignoreWhiteSpace && (a == null || a.trim().length() == 0) && s.trim().length() == 0 && d.trim().length() == 0) {
                    diff.fIsWhitespace = true;
                }
                if (this.useChange(diff)) {
                    this.recordChangeDiff(diff);
                    if (s.length() > 0 && d.length() > 0) {
                        if (a == null && sancestor != null) {
                            a = this.extract2(aDoc, sancestor, es.ancestorStart(), es.ancestorLength());
                        }
                        this.simpleTokenDiff(diff, aDoc, a, rDoc, d, lDoc, s);
                    }
                }
            }
            ++n2;
        }
        this.fAllDiffs = newAllDiffs;
    }

    private boolean isCapped(DocLineComparator ancestor, DocLineComparator left, DocLineComparator right) {
        if (this.isCappingDisabled()) {
            return false;
        }
        int aLength = ancestor == null ? 0 : ancestor.getRangeCount();
        int lLength = left.getRangeCount();
        int rLength = right.getRangeCount();
        return (double)aLength * (double)lLength > 1.0E8 || (double)aLength * (double)rLength > 1.0E8 || (double)lLength * (double)rLength > 1.0E8;
    }

    public Diff findDiff(char type, int pos) throws CoreException {
        IDocument aDoc = null;
        IDocument lDoc = this.getDocument('L');
        IDocument rDoc = this.getDocument('R');
        if (lDoc == null || rDoc == null) {
            return null;
        }
        Position aRegion = null;
        Position lRegion = null;
        Position rRegion = null;
        boolean threeWay = this.isThreeWay();
        if (threeWay && !this.isIgnoreAncestor()) {
            aDoc = this.getDocument('A');
        }
        boolean ignoreWhiteSpace = this.isIgnoreWhitespace();
        ICompareFilter[] compareFilters = this.getCompareFilters();
        DocLineComparator sright = new DocLineComparator(rDoc, DocumentMerger.toRegion(rRegion), ignoreWhiteSpace, compareFilters, 'R');
        DocLineComparator sleft = new DocLineComparator(lDoc, DocumentMerger.toRegion(lRegion), ignoreWhiteSpace, compareFilters, 'L');
        DocLineComparator sancestor = null;
        if (aDoc != null) {
            sancestor = new DocLineComparator(aDoc, DocumentMerger.toRegion(aRegion), ignoreWhiteSpace, compareFilters, 'A');
        }
        Object[] result = new Object[1];
        DocLineComparator sa = sancestor;
        DocLineComparator sl = sleft;
        DocLineComparator sr = sright;
        IRunnableWithProgress runnable = monitor -> {
            monitor.beginTask(CompareMessages.DocumentMerger_2, DocumentMerger.maxWork(sa, sl, sr));
            try {
                objectArray[0] = RangeDifferencer.findRanges((IProgressMonitor)monitor, (IRangeComparator)sa, (IRangeComparator)sl, (IRangeComparator)sr);
            }
            catch (OutOfMemoryError ex) {
                System.gc();
                throw new InvocationTargetException(ex);
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.done();
        };
        RangeDifference[] e = null;
        try {
            Utilities.executeRunnable(runnable);
            e = (RangeDifference[])result[0];
        }
        catch (InvocationTargetException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 0, CompareMessages.DocumentMerger_3, ex.getTargetException()));
        }
        catch (InterruptedException interruptedException) {}
        if (e != null) {
            RangeDifference[] rangeDifferenceArray = e;
            int n = e.length;
            int n2 = 0;
            while (n2 < n) {
                int rightEnd;
                int rightStart;
                int leftEnd;
                int leftStart;
                Diff diff;
                RangeDifference es = rangeDifferenceArray[n2];
                int kind = es.kind();
                int ancestorStart = 0;
                int ancestorEnd = 0;
                if (sancestor != null) {
                    ancestorStart = sancestor.getTokenStart(es.ancestorStart());
                    ancestorEnd = DocumentMerger.getTokenEnd2(sancestor, es.ancestorStart(), es.ancestorLength());
                }
                if ((diff = new Diff(null, kind, aDoc, aRegion, ancestorStart, ancestorEnd, lDoc, lRegion, leftStart = sleft.getTokenStart(es.leftStart()), leftEnd = DocumentMerger.getTokenEnd2(sleft, es.leftStart(), es.leftLength()), rDoc, rRegion, rightStart = sright.getTokenStart(es.rightStart()), rightEnd = DocumentMerger.getTokenEnd2(sright, es.rightStart(), es.rightLength()))).isInRange(type, pos)) {
                    return diff;
                }
                ++n2;
            }
        }
        return null;
    }

    private void recordChangeDiff(Diff diff) {
        this.fChangeDiffs.add(diff);
    }

    private boolean isPatchHunk() {
        return this.fInput.isPatchHunk();
    }

    private boolean isIgnoreWhitespace() {
        return Utilities.getBoolean(this.getCompareConfiguration(), "IGNORE_WHITESPACE", false);
    }

    private ICompareFilter[] getCompareFilters() {
        return Utilities.getCompareFilters(this.getCompareConfiguration());
    }

    private boolean isCappingDisabled() {
        return CompareUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.compare.CappingDisable");
    }

    private IDocument getDocument(char contributor) {
        return this.fInput.getDocument(contributor);
    }

    private Position getRegion(char contributor) {
        return this.fInput.getRegion(contributor);
    }

    public boolean isIgnoreAncestor() {
        return this.fInput.isIgnoreAncestor();
    }

    public boolean isThreeWay() {
        return this.fInput.isThreeWay();
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.fInput.getCompareConfiguration();
    }

    public boolean useChange(Diff diff) {
        if (diff.fIsWhitespace) {
            return false;
        }
        int kind = diff.getKind();
        return this.useChange(kind);
    }

    private boolean useChange(int kind) {
        if (kind == 0) {
            return false;
        }
        if (this.fInput.getCompareConfiguration().isChangeIgnored(kind)) {
            return false;
        }
        if (kind == 4) {
            return this.fInput.isShowPseudoConflicts();
        }
        return true;
    }

    private int getTokenEnd(ITokenComparator tc, int start, int count) {
        if (count <= 0) {
            return tc.getTokenStart(start);
        }
        int index = start + count - 1;
        return tc.getTokenStart(index) + tc.getTokenLength(index);
    }

    private static int getTokenEnd2(ITokenComparator tc, int start, int length) {
        return tc.getTokenStart(start + length);
    }

    private String extract2(IDocument doc, ITokenComparator tc, int start, int length) {
        int count = tc.getRangeCount();
        if (length > 0 && count > 0) {
            int startPos = tc.getTokenStart(start);
            int endPos = length == 1 ? startPos + tc.getTokenLength(start) : tc.getTokenStart(start + length);
            try {
                return doc.get(startPos, endPos - startPos);
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    private static IRegion toRegion(Position position) {
        if (position != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    private void mergingTokenDiff(Diff baseDiff, IDocument ancestorDoc, String a, IDocument rightDoc, String d, IDocument leftDoc, String s) {
        ITokenComparator sa = null;
        int ancestorStart = 0;
        if (ancestorDoc != null) {
            sa = this.createTokenComparator(a);
            ancestorStart = baseDiff.fAncestorPos.getOffset();
        }
        int rightStart = baseDiff.fRightPos.getOffset();
        ITokenComparator sm = this.createTokenComparator(d);
        int leftStart = baseDiff.fLeftPos.getOffset();
        ITokenComparator sy = this.createTokenComparator(s);
        RangeDifference[] r = RangeDifferencer.findRanges((IRangeComparator)sa, (IRangeComparator)sy, (IRangeComparator)sm);
        int i = 0;
        while (i < r.length) {
            RangeDifference es = r[i];
            int start = i;
            int leftLine = -1;
            int rightLine = -1;
            try {
                leftLine = leftDoc.getLineOfOffset(leftStart + sy.getTokenStart(es.leftStart()));
                rightLine = rightDoc.getLineOfOffset(rightStart + sm.getTokenStart(es.rightStart()));
            }
            catch (BadLocationException badLocationException) {}
            ++i;
            while (i < r.length) {
                es = r[i];
                try {
                    if (leftLine != leftDoc.getLineOfOffset(leftStart + sy.getTokenStart(es.leftStart())) || rightLine != rightDoc.getLineOfOffset(rightStart + sm.getTokenStart(es.rightStart()))) {
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {}
                ++i;
            }
            int end = i;
            RangeDifference first = null;
            int ii = start;
            while (ii < end) {
                es = r[ii];
                if (this.useChange(es.kind())) {
                    first = es;
                    break;
                }
                ++ii;
            }
            RangeDifference last = null;
            int ii2 = end - 1;
            while (ii2 >= start) {
                es = r[ii2];
                if (this.useChange(es.kind())) {
                    last = es;
                    break;
                }
                --ii2;
            }
            if (first != null && last != null) {
                int ancestorStart2 = 0;
                int ancestorEnd2 = 0;
                if (ancestorDoc != null) {
                    ancestorStart2 = ancestorStart + sa.getTokenStart(first.ancestorStart());
                    ancestorEnd2 = ancestorStart + this.getTokenEnd(sa, last.ancestorStart(), last.ancestorLength());
                }
                int leftStart2 = leftStart + sy.getTokenStart(first.leftStart());
                int leftEnd2 = leftStart + this.getTokenEnd(sy, last.leftStart(), last.leftLength());
                int rightStart2 = rightStart + sm.getTokenStart(first.rightStart());
                int rightEnd2 = rightStart + this.getTokenEnd(sm, last.rightStart(), last.rightLength());
                Diff diff = new Diff(baseDiff, first.kind(), ancestorDoc, null, ancestorStart2, ancestorEnd2, leftDoc, null, leftStart2, leftEnd2, rightDoc, null, rightStart2, rightEnd2);
                diff.fIsToken = true;
                baseDiff.add(diff);
            }
            ++i;
        }
    }

    private void simpleTokenDiff(Diff baseDiff, IDocument ancestorDoc, String a, IDocument rightDoc, String d, IDocument leftDoc, String s) {
        RangeDifference[] e;
        int ancestorStart = 0;
        ITokenComparator sa = null;
        if (ancestorDoc != null) {
            ancestorStart = baseDiff.fAncestorPos.getOffset();
            sa = this.createTokenComparator(a);
        }
        int rightStart = baseDiff.fRightPos.getOffset();
        ITokenComparator sm = this.createTokenComparator(d);
        int leftStart = baseDiff.fLeftPos.getOffset();
        ITokenComparator sy = this.createTokenComparator(s);
        RangeDifference[] rangeDifferenceArray = e = RangeDifferencer.findRanges((IRangeComparator)sa, (IRangeComparator)sy, (IRangeComparator)sm);
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference es = rangeDifferenceArray[n2];
            int kind = es.kind();
            if (kind != 0) {
                int ancestorStart2 = ancestorStart;
                int ancestorEnd2 = ancestorStart;
                if (ancestorDoc != null) {
                    ancestorStart2 += sa.getTokenStart(es.ancestorStart());
                    ancestorEnd2 += this.getTokenEnd(sa, es.ancestorStart(), es.ancestorLength());
                }
                int leftStart2 = leftStart + sy.getTokenStart(es.leftStart());
                int leftEnd2 = leftStart + this.getTokenEnd(sy, es.leftStart(), es.leftLength());
                int rightStart2 = rightStart + sm.getTokenStart(es.rightStart());
                int rightEnd2 = rightStart + this.getTokenEnd(sm, es.rightStart(), es.rightLength());
                Diff diff = new Diff(baseDiff, kind, ancestorDoc, null, ancestorStart2, ancestorEnd2, leftDoc, null, leftStart2, leftEnd2, rightDoc, null, rightStart2, rightEnd2);
                int leftS = baseDiff.fLeftPos.offset;
                int leftE = baseDiff.fLeftPos.offset + baseDiff.fLeftPos.length;
                int rightS = baseDiff.fRightPos.offset;
                int rightE = baseDiff.fRightPos.offset + baseDiff.fRightPos.length;
                if (leftS != leftStart2 || leftE != leftEnd2 || rightS != rightStart2 || rightE != rightEnd2) {
                    diff.fIsToken = true;
                    baseDiff.add(diff);
                }
            }
            ++n2;
        }
    }

    private ITokenComparator createTokenComparator(String s) {
        return this.fInput.createTokenComparator(s);
    }

    private static int maxWork(IRangeComparator a, IRangeComparator l, IRangeComparator r) {
        int ln = l.getRangeCount();
        int rn = r.getRangeCount();
        if (a != null) {
            int an = a.getRangeCount();
            return 2 * Math.max(an, ln) + 2 * Math.max(an, rn);
        }
        return 2 * Math.max(ln, rn);
    }

    private void resetPositions(IDocument doc) {
        if (doc == null) {
            return;
        }
        try {
            doc.removePositionCategory(DIFF_RANGE_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        doc.addPositionCategory(DIFF_RANGE_CATEGORY);
    }

    protected Point getLineRange(IDocument doc, Position p, Point region) {
        if (p == null || doc == null) {
            region.x = 0;
            region.y = 0;
            return region;
        }
        int start = p.getOffset();
        int length = p.getLength();
        int startLine = 0;
        try {
            startLine = doc.getLineOfOffset(start);
        }
        catch (BadLocationException badLocationException) {}
        int lineCount = 0;
        if (length != 0) {
            int endLine = 0;
            try {
                endLine = doc.getLineOfOffset(start + length - 1);
            }
            catch (BadLocationException badLocationException) {}
            lineCount = endLine - startLine + 1;
        }
        region.x = startLine;
        region.y = lineCount;
        return region;
    }

    public Diff findDiff(Position p, boolean left) {
        for (Diff diff : this.fAllDiffs) {
            Position diffPos = left ? diff.fLeftPos : diff.fRightPos;
            if (diffPos.offset + diffPos.length >= p.offset && diff.fDirection != 0) {
                return diff;
            }
            if (diffPos.offset < p.offset) continue;
            return diff;
        }
        return null;
    }

    public void reset() {
        this.fChangeDiffs = null;
        this.fAllDiffs = null;
    }

    public int realToVirtualPosition(char contributor, int vpos) {
        if (this.fAllDiffs == null) {
            return vpos;
        }
        int viewPos = 0;
        int virtualPos = 0;
        Point region = new Point(0, 0);
        for (Diff diff : this.fAllDiffs) {
            Position pos = diff.getPosition(contributor);
            this.getLineRange(this.getDocument(contributor), pos, region);
            int realHeight = region.y;
            int virtualHeight = diff.getMaxDiffHeight();
            if (vpos <= viewPos + realHeight) {
                vpos -= viewPos;
                vpos = realHeight <= 0 ? 0 : vpos * virtualHeight / realHeight;
                return virtualPos + vpos;
            }
            viewPos += realHeight;
            virtualPos += virtualHeight;
        }
        return virtualPos;
    }

    public int virtualToRealPosition(char contributor, int v) {
        if (this.fAllDiffs == null) {
            return v;
        }
        int virtualPos = 0;
        int viewPos = 0;
        Point region = new Point(0, 0);
        for (Diff diff : this.fAllDiffs) {
            Position pos = diff.getPosition(contributor);
            int viewHeight = this.getLineRange((IDocument)this.getDocument((char)contributor), (Position)pos, (Point)region).y;
            int virtualHeight = diff.getMaxDiffHeight();
            if (v < virtualPos + virtualHeight) {
                v -= virtualPos;
                v = viewHeight <= 0 ? 0 : (int)((double)v * ((double)viewHeight / (double)virtualHeight));
                return viewPos + v;
            }
            virtualPos += virtualHeight;
            viewPos += viewHeight;
        }
        return viewPos;
    }

    public int getVirtualHeight() {
        int h = 1;
        if (this.fAllDiffs != null) {
            for (Diff diff : this.fAllDiffs) {
                h += diff.getMaxDiffHeight();
            }
        }
        return h;
    }

    public int getRightHeight() {
        int h = 1;
        if (this.fAllDiffs != null) {
            for (Diff diff : this.fAllDiffs) {
                h += diff.getRightHeight();
            }
        }
        return h;
    }

    public int findInsertionPoint(Diff diff, char type) {
        if (diff != null) {
            switch (type) {
                case 'A': {
                    if (diff.fAncestorPos == null) break;
                    return diff.fAncestorPos.offset;
                }
                case 'L': {
                    if (diff.fLeftPos == null) break;
                    return diff.fLeftPos.offset;
                }
                case 'R': {
                    if (diff.fRightPos == null) break;
                    return diff.fRightPos.offset;
                }
            }
        }
        return 0;
    }

    public Diff[] getChangeDiffs(char contributor, IRegion region) {
        if (this.fChangeDiffs == null) {
            return new Diff[0];
        }
        ArrayList intersectingDiffs = new ArrayList();
        for (Diff diff : this.fChangeDiffs) {
            Diff[] changeDiffs = diff.getChangeDiffs(contributor, region);
            Collections.addAll(intersectingDiffs, changeDiffs);
        }
        return intersectingDiffs.toArray(new Diff[intersectingDiffs.size()]);
    }

    public Diff findDiff(int viewportHeight, boolean synchronizedScrolling, Point size, int my) {
        int virtualHeight;
        int n = virtualHeight = synchronizedScrolling ? this.getVirtualHeight() : this.getRightHeight();
        if (virtualHeight < viewportHeight) {
            return null;
        }
        int y = 0;
        if (this.fAllDiffs != null) {
            for (Diff diff : this.fAllDiffs) {
                int h;
                int n2 = h = synchronizedScrolling ? diff.getMaxDiffHeight() : diff.getRightHeight();
                if (this.useChange(diff.getKind()) && !diff.fIsWhitespace) {
                    int yy = y * size.y / virtualHeight;
                    int hh = h * size.y / virtualHeight;
                    if (hh < 3) {
                        hh = 3;
                    }
                    if (my >= yy && my < yy + hh) {
                        return diff;
                    }
                }
                y += h;
            }
        }
        return null;
    }

    public boolean hasChanges() {
        return this.fChangeDiffs != null && !this.fChangeDiffs.isEmpty();
    }

    public Iterator<Diff> changesIterator() {
        if (this.fChangeDiffs == null) {
            return new ArrayList().iterator();
        }
        return this.fChangeDiffs.iterator();
    }

    public Iterator<Diff> rangesIterator() {
        if (this.fAllDiffs == null) {
            return new ArrayList().iterator();
        }
        return this.fAllDiffs.iterator();
    }

    public boolean isFirstChildDiff(char contributor, int childStart, Diff diff) {
        if (!diff.hasChildren()) {
            return false;
        }
        Diff d = diff.fDiffs.get(0);
        Position p = d.getPosition(contributor);
        return p.getOffset() >= childStart;
    }

    public Diff getWrappedDiff(Diff diff, boolean down) {
        if (this.fChangeDiffs != null && this.fChangeDiffs.size() > 0) {
            if (down) {
                return this.fChangeDiffs.get(0);
            }
            return this.fChangeDiffs.get(this.fChangeDiffs.size() - 1);
        }
        return null;
    }

    public boolean copy(Diff diff, boolean leftToRight) {
        if (diff != null) {
            Position fromPos = null;
            Position toPos = null;
            IDocument fromDoc = null;
            IDocument toDoc = null;
            if (leftToRight) {
                fromPos = diff.getPosition('L');
                toPos = diff.getPosition('R');
                fromDoc = this.getDocument('L');
                toDoc = this.getDocument('R');
            } else {
                fromPos = diff.getPosition('R');
                toPos = diff.getPosition('L');
                fromDoc = this.getDocument('R');
                toDoc = this.getDocument('L');
            }
            if (fromDoc != null) {
                int fromStart = fromPos.getOffset();
                int fromLen = fromPos.getLength();
                int toStart = toPos.getOffset();
                int toLen = toPos.getLength();
                try {
                    String s = null;
                    switch (diff.getKind()) {
                        case 2: 
                        case 3: {
                            s = fromDoc.get(fromStart, fromLen);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 1: {
                            s = toDoc.get(toStart, toLen);
                            String ls = TextUtilities.getDefaultLineDelimiter((IDocument)toDoc);
                            if (!s.endsWith(ls)) {
                                s = String.valueOf(s) + ls;
                            }
                            s = String.valueOf(s) + fromDoc.get(fromStart, fromLen);
                        }
                    }
                    if (s != null) {
                        toDoc.replace(toStart, toLen, s);
                        toPos.setOffset(toStart);
                        toPos.setLength(s.length());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            diff.setResolved(true);
            return true;
        }
        return false;
    }

    public int changesCount() {
        if (this.fChangeDiffs == null) {
            return 0;
        }
        return this.fChangeDiffs.size();
    }

    public Diff findDiff(char contributor, int rangeStart, int rangeEnd) {
        if (this.hasChanges()) {
            Iterator<Diff> iterator = this.changesIterator();
            while (iterator.hasNext()) {
                Diff diff = iterator.next();
                if (diff.isDeleted() || diff.getKind() == 0 || !diff.overlaps(contributor, rangeStart, rangeEnd, this.getDocument(contributor).getLength())) continue;
                return diff;
            }
        }
        return null;
    }

    public Diff findDiff(char contributor, Position range) {
        int start = range.getOffset();
        int end = start + range.getLength();
        return this.findDiff(contributor, start, end);
    }

    public Diff findNext(char contributor, int start, int end, boolean deep) {
        return this.findNext(contributor, this.fChangeDiffs, start, end, deep);
    }

    private Diff findNext(char contributor, List<Diff> v, int start, int end, boolean deep) {
        if (v == null) {
            return null;
        }
        for (Diff diff : v) {
            Position p = diff.getPosition(contributor);
            if (p == null) continue;
            int startOffset = p.getOffset();
            if (end < startOffset) {
                return diff;
            }
            if (!deep || !diff.hasChildren()) continue;
            Diff d = null;
            int endOffset = startOffset + p.getLength();
            if (start == startOffset && (end == endOffset || end == endOffset - 1)) {
                d = this.findNext(contributor, diff.fDiffs, start - 1, start - 1, deep);
            } else if (end < endOffset) {
                d = this.findNext(contributor, diff.fDiffs, start, end, deep);
            }
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public Diff findPrev(char contributor, int start, int end, boolean deep) {
        return this.findPrev(contributor, this.fChangeDiffs, start, end, deep);
    }

    private Diff findPrev(char contributor, List<Diff> v, int start, int end, boolean deep) {
        if (v == null) {
            return null;
        }
        int i = v.size() - 1;
        while (i >= 0) {
            Diff diff = v.get(i);
            Position p = diff.getPosition(contributor);
            if (p != null) {
                int startOffset = p.getOffset();
                int endOffset = startOffset + p.getLength();
                if (start > endOffset) {
                    if (deep && diff.hasChildren()) {
                        return this.findPrev(contributor, diff.fDiffs, end, end, deep);
                    }
                    return diff;
                }
                if (deep && diff.hasChildren()) {
                    Diff d = null;
                    if ((start != startOffset || end != endOffset) && start >= startOffset) {
                        if (this.isFirstChildDiff(contributor, start, diff)) {
                            return diff;
                        }
                        d = this.findPrev(contributor, diff.fDiffs, start, end, deep);
                    }
                    if (d != null) {
                        return d;
                    }
                }
            }
            --i;
        }
        return null;
    }

    public class Diff {
        Position fAncestorPos;
        Position fLeftPos;
        Position fRightPos;
        Diff fParent;
        boolean fResolved;
        int fDirection;
        boolean fIsToken = false;
        List<Diff> fDiffs;
        boolean fIsWhitespace = false;

        Diff(Diff parent, int dir, IDocument ancestorDoc, Position aRange, int ancestorStart, int ancestorEnd, IDocument leftDoc, Position lRange, int leftStart, int leftEnd, IDocument rightDoc, Position rRange, int rightStart, int rightEnd) {
            this.fParent = parent != null ? parent : this;
            this.fDirection = dir;
            this.fLeftPos = this.createPosition(leftDoc, lRange, leftStart, leftEnd);
            this.fRightPos = this.createPosition(rightDoc, rRange, rightStart, rightEnd);
            if (ancestorDoc != null) {
                this.fAncestorPos = this.createPosition(ancestorDoc, aRange, ancestorStart, ancestorEnd);
            }
        }

        public Position getPosition(char type) {
            switch (type) {
                case 'A': {
                    return this.fAncestorPos;
                }
                case 'L': {
                    return this.fLeftPos;
                }
                case 'R': {
                    return this.fRightPos;
                }
            }
            return null;
        }

        boolean isInRange(char type, int pos) {
            Position p = this.getPosition(type);
            return pos >= p.offset && pos < p.offset + p.length;
        }

        public String changeType() {
            boolean rightEmpty;
            boolean leftEmpty = this.fLeftPos.length == 0;
            boolean bl = rightEmpty = this.fRightPos.length == 0;
            if (this.fDirection == 3) {
                if (!leftEmpty && rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_addition;
                }
                if (leftEmpty && !rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_deletion;
                }
            } else {
                if (leftEmpty && !rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_addition;
                }
                if (!leftEmpty && rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_deletion;
                }
            }
            return CompareMessages.TextMergeViewer_changeType_change;
        }

        public Image getImage() {
            int code = 3;
            switch (this.fDirection) {
                case 2: {
                    code += DocumentMerger.this.getCompareConfiguration().isMirrored() ? 8 : 4;
                    break;
                }
                case 3: {
                    code += DocumentMerger.this.getCompareConfiguration().isMirrored() ? 4 : 8;
                    break;
                }
                case 1: 
                case 4: {
                    code += 12;
                }
            }
            if (code != 0) {
                return DocumentMerger.this.getCompareConfiguration().getImage(code);
            }
            return null;
        }

        Position createPosition(IDocument doc, Position range, int start, int end) {
            try {
                int dl;
                int l = end - start;
                if (range != null) {
                    dl = range.length;
                    if (l > dl) {
                        l = dl;
                    }
                } else {
                    dl = doc.getLength();
                    if (start + l > dl) {
                        l = dl - start;
                    }
                }
                Position p = null;
                try {
                    p = new Position(start, l);
                }
                catch (RuntimeException runtimeException) {
                    p = new Position(0, 0);
                }
                try {
                    doc.addPosition(DocumentMerger.DIFF_RANGE_CATEGORY, p);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                return p;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        void add(Diff d) {
            if (this.fDiffs == null) {
                this.fDiffs = new ArrayList<Diff>();
            }
            this.fDiffs.add(d);
        }

        public boolean isDeleted() {
            if (this.fAncestorPos != null && this.fAncestorPos.isDeleted()) {
                return true;
            }
            return this.fLeftPos.isDeleted() || this.fRightPos.isDeleted();
        }

        void setResolved(boolean r) {
            this.fResolved = r;
            if (r) {
                this.fDiffs = null;
            }
        }

        public boolean isResolved() {
            if (!this.fResolved && this.fDiffs != null) {
                for (Diff d : this.fDiffs) {
                    if (d.isResolved()) continue;
                    return false;
                }
                return true;
            }
            return this.fResolved;
        }

        Position getPosition(int contributor) {
            if (contributor == 76) {
                return this.fLeftPos;
            }
            if (contributor == 82) {
                return this.fRightPos;
            }
            if (contributor == 65) {
                return this.fAncestorPos;
            }
            return null;
        }

        public boolean overlaps(int contributor, int start, int end, int docLength) {
            Position h = this.getPosition(contributor);
            if (h != null) {
                int ds = h.getOffset();
                int de = ds + h.getLength();
                if (start < de && end >= ds) {
                    return true;
                }
                if (start == docLength && start <= de && end >= ds) {
                    return true;
                }
            }
            return false;
        }

        public int getMaxDiffHeight() {
            Point region = new Point(0, 0);
            int h = DocumentMerger.this.getLineRange((IDocument)DocumentMerger.this.getDocument((char)'L'), (Position)this.fLeftPos, (Point)region).y;
            if (DocumentMerger.this.isThreeWay()) {
                h = Math.max(h, DocumentMerger.this.getLineRange((IDocument)DocumentMerger.this.getDocument((char)'A'), (Position)this.fAncestorPos, (Point)region).y);
            }
            return Math.max(h, DocumentMerger.this.getLineRange((IDocument)DocumentMerger.this.getDocument((char)'R'), (Position)this.fRightPos, (Point)region).y);
        }

        public int getAncestorHeight() {
            Point region = new Point(0, 0);
            return DocumentMerger.this.getLineRange((IDocument)DocumentMerger.this.getDocument((char)'A'), (Position)this.fAncestorPos, (Point)region).y;
        }

        public int getLeftHeight() {
            Point region = new Point(0, 0);
            return DocumentMerger.this.getLineRange((IDocument)DocumentMerger.this.getDocument((char)'L'), (Position)this.fLeftPos, (Point)region).y;
        }

        public int getRightHeight() {
            Point region = new Point(0, 0);
            return DocumentMerger.this.getLineRange((IDocument)DocumentMerger.this.getDocument((char)'R'), (Position)this.fRightPos, (Point)region).y;
        }

        public Diff[] getChangeDiffs(int contributor, IRegion region) {
            if (this.fDiffs != null && this.intersectsRegion(contributor, region)) {
                ArrayList<Diff> result = new ArrayList<Diff>();
                for (Diff diff : this.fDiffs) {
                    if (!diff.intersectsRegion(contributor, region)) continue;
                    result.add(diff);
                }
                return result.toArray(new Diff[result.size()]);
            }
            return new Diff[0];
        }

        private boolean intersectsRegion(int contributor, IRegion region) {
            Position p = this.getPosition(contributor);
            if (p != null) {
                return p.overlapsWith(region.getOffset(), region.getLength());
            }
            return false;
        }

        public boolean hasChildren() {
            return this.fDiffs != null && !this.fDiffs.isEmpty();
        }

        public int getKind() {
            return this.fDirection;
        }

        public boolean isToken() {
            return this.fIsToken;
        }

        public Diff getParent() {
            return this.fParent;
        }

        public Iterator<Diff> childIterator() {
            if (this.fDiffs == null) {
                return new ArrayList().iterator();
            }
            return this.fDiffs.iterator();
        }
    }

    public static interface IDocumentMergerInput {
        public IDocument getDocument(char var1);

        public Position getRegion(char var1);

        public boolean isIgnoreAncestor();

        public boolean isThreeWay();

        public CompareConfiguration getCompareConfiguration();

        public ITokenComparator createTokenComparator(String var1);

        public boolean isHunkOnLeft();

        public int getHunkStart();

        public boolean isPatchHunk();

        public boolean isShowPseudoConflicts();

        public boolean isPatchHunkOk();
    }
}

