/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.commands.IRestartHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.actions.AddToFavoritesAction;
import org.eclipse.debug.internal.ui.actions.EditLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.commands.actions.DisconnectCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.DropToFrameCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.RestartCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.ResumeCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepIntoCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepOverCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepReturnCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.SuspendCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateAllAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateAndRelaunchAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateAndRemoveAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.ToggleStepFiltersAction;
import org.eclipse.debug.internal.ui.sourcelookup.EditSourceLookupPathAction;
import org.eclipse.debug.internal.ui.sourcelookup.LookupSourceAction;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.VirtualFindAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.internal.ui.views.ViewContextService;
import org.eclipse.debug.internal.ui.views.launch.BreadcrumbDropDownAutoExpandAction;
import org.eclipse.debug.internal.ui.views.launch.BreadcrumbWorkbenchPart;
import org.eclipse.debug.internal.ui.views.launch.DebugToolBarAction;
import org.eclipse.debug.internal.ui.views.launch.DebugViewModeAction;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewBreadcrumb;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewMessages;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.actions.DebugCommandAction;
import org.eclipse.debug.ui.contexts.AbstractDebugContextProvider;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

public class LaunchView
extends AbstractDebugView
implements ISelectionChangedListener,
IPerspectiveListener2,
IPageListener,
IShowInTarget,
IShowInSource,
IShowInTargetList,
IPartListener2,
IViewerUpdateListener,
IContextManagerListener,
IModelChangedListener {
    public static final String ID_CONTEXT_ACTIVITY_BINDINGS = "contextActivityBindings";
    private static final String TERMINATE = "terminate";
    private static final String DISCONNECT = "disconnect";
    private static final String SUSPEND = "suspend";
    private static final String RESUME = "resume";
    private static final String STEP_RETURN = "step_return";
    private static final String STEP_OVER = "step_over";
    private static final String DROP_TO_FRAME = "drop_to_frame";
    private static final String STEP_INTO = "step_into";
    public static final String TERMINATE_AND_REMOVE = "terminate_and_remove";
    public static final String TERMINATE_ALL = "terminate_all";
    public static final String TERMINATE_AND_RELAUNCH = "terminate_relaunch";
    private static final String TOGGLE_STEP_FILTERS = "toggle_step_filters";
    private static final String RESTART = "restart";
    private static final int BREADCRUMB_TRIGGER_HEIGHT_DEFAULT = 30;
    private static final int BREADCRUMB_TRIGGER_RANGE = 5;
    private static final int BREADCRUMB_STICKY_RANGE = 20;
    private boolean fIsActive = true;
    private IDebugModelPresentation fPresentation;
    private IPresentationContext fPresentationContext;
    private EditLaunchConfigurationAction fEditConfigAction;
    private AddToFavoritesAction fAddToFavoritesAction;
    private EditSourceLookupPathAction fEditSourceAction;
    private LookupSourceAction fLookupAction;
    private String fCurrentViewMode = "Debug_view.mode.auto";
    private DebugViewModeAction[] fDebugViewModeActions;
    private DebugToolBarAction fDebugToolBarAction;
    private BreadcrumbDropDownAutoExpandAction fBreadcrumbDropDownAutoExpandAction;
    private IContextService fContextService;
    private String PREF_STATE_MEMENTO = "pref_state_memento.";
    private static final String BREADCRUMB_DROPDOWN_AUTO_EXPAND = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".BREADCRUMB_DROPDOWN_AUTO_EXPAND";
    private boolean fBreadcrumbDropDownAutoExpand;
    private Map<String, IHandler2> fHandlers = new HashMap<String, IHandler2>();
    private boolean fDebugToolbarInView = true;
    private Set<String> fDebugToolbarPerspectives = new TreeSet<String>();
    private BreadcrumbPage fBreadcrumbPage;
    private TreeViewerContextProvider fTreeViewerDebugContextProvider;
    private PageBookView.PageRec fDefaultPageRec = null;
    private ISelectionChangedListener fTreeViewerSelectionChangedListener = event -> this.fTreeViewerDebugContextProvider.activate(event.getSelection());
    private ContextProviderProxy fContextProviderProxy;

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.debug_view_context";
    }

    @Override
    protected void createActions() {
        this.setAction("Properties", (IAction)new PropertyDialogAction((IShellProvider)this.getSite(), this.getSite().getSelectionProvider()));
        this.fEditConfigAction = new EditLaunchConfigurationAction();
        this.fAddToFavoritesAction = new AddToFavoritesAction();
        this.fEditSourceAction = new EditSourceLookupPathAction(this);
        this.fLookupAction = new LookupSourceAction(this);
        this.setAction(FIND_ACTION, (IAction)new VirtualFindAction((TreeModelViewer)this.getViewer()));
        this.addCapabilityAction(new TerminateCommandAction(), TERMINATE);
        this.addCapabilityAction(new DisconnectCommandAction(), DISCONNECT);
        this.addCapabilityAction(new SuspendCommandAction(), SUSPEND);
        this.addCapabilityAction(new ResumeCommandAction(), RESUME);
        this.addCapabilityAction(new StepReturnCommandAction(), STEP_RETURN);
        this.addCapabilityAction(new StepOverCommandAction(), STEP_OVER);
        this.addCapabilityAction(new StepIntoCommandAction(), STEP_INTO);
        this.addCapabilityAction(new DropToFrameCommandAction(), DROP_TO_FRAME);
        DebugCommandAction action = new TerminateAndRemoveAction();
        this.addCapabilityAction(action, TERMINATE_AND_REMOVE);
        this.setHandler(TERMINATE_AND_REMOVE, (IHandler2)new ActionHandler((IAction)action));
        action = new TerminateAndRelaunchAction();
        this.addCapabilityAction(action, TERMINATE_AND_RELAUNCH);
        this.setHandler(TERMINATE_AND_RELAUNCH, (IHandler2)new ActionHandler((IAction)action));
        this.addCapabilityAction(new RestartCommandAction(), RESTART);
        action = new TerminateAllAction();
        this.addCapabilityAction(action, TERMINATE_ALL);
        this.setHandler(TERMINATE_ALL, (IHandler2)new ActionHandler((IAction)action));
        this.addCapabilityAction(new ToggleStepFiltersAction(), TOGGLE_STEP_FILTERS);
    }

    private void setHandler(String id, IHandler2 handler) {
        this.fHandlers.put(id, handler);
    }

    public IHandler2 getHandler(String id) {
        return this.fHandlers.get(id);
    }

    private void addCapabilityAction(DebugCommandAction capability, String actionID) {
        capability.init((IWorkbenchPart)this);
        this.setAction(actionID, (IAction)capability);
    }

    private void disposeCommandAction(String actionID) {
        DebugCommandAction action = (DebugCommandAction)this.getAction(actionID);
        action.dispose();
    }

    @Override
    public void createPartControl(final Composite parent) {
        super.createPartControl(parent);
        this.setGlobalActionBarsToPage((IPageBookViewPage)this.getDefaultPage());
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        ((IPageBookViewPage)this.getDefaultPage()).getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.partActivated(new BreadcrumbWorkbenchPart(this.getSite()));
        this.fContextProviderProxy = new ContextProviderProxy(new IDebugContextProvider[]{this.fTreeViewerDebugContextProvider, this.fBreadcrumbPage.getContextProvider()});
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextProvider(this.fContextProviderProxy);
        this.createViewModeActions(parent);
        IPreferenceStore prefStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String mode = prefStore.getString("org.eclispe.debug.ui.Debug_view.mode");
        this.setViewMode(mode, parent);
        DebugViewModeAction[] debugViewModeActionArray = this.fDebugViewModeActions;
        int n = this.fDebugViewModeActions.length;
        int n2 = 0;
        while (n2 < n) {
            DebugViewModeAction action = debugViewModeActionArray[n2];
            action.setChecked(action.getMode().equals(mode));
            ++n2;
        }
        this.createDebugToolBarInViewActions(parent);
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (parent.isDisposed()) {
                    return;
                }
                if ("Debug_view.mode.auto".equals(LaunchView.this.fCurrentViewMode)) {
                    LaunchView.this.autoSelectViewPage(parent);
                }
            }
        });
        this.fContextService.addContextManagerListener((IContextManagerListener)this);
    }

    private void setGlobalActionBarsToPage(IPageBookViewPage page) {
        IActionBars pageActionBars = page.getSite().getActionBars();
        IActionBars bars = this.getViewSite().getActionBars();
        pageActionBars.setGlobalActionHandler(FIND_ACTION, bars.getGlobalActionHandler(FIND_ACTION));
        pageActionBars.setGlobalActionHandler(COPY_ACTION, bars.getGlobalActionHandler(COPY_ACTION));
    }

    @Override
    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof BreadcrumbWorkbenchPart) {
            this.fBreadcrumbPage = new BreadcrumbPage();
            this.fBreadcrumbPage.createControl((Composite)this.getPageBook());
            this.initPage((IPageBookViewPage)this.fBreadcrumbPage);
            this.setGlobalActionBarsToPage((IPageBookViewPage)this.fBreadcrumbPage);
            return new PageBookView.PageRec(part, (IPage)this.fBreadcrumbPage);
        }
        return null;
    }

    @Override
    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof BreadcrumbWorkbenchPart;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        if (pageRec.page == this.getDefaultPage()) {
            this.fDefaultPageRec = pageRec;
        }
        super.showPageRec(pageRec);
    }

    private void createViewModeActions(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fDebugViewModeActions = new DebugViewModeAction[3];
        this.fDebugViewModeActions[0] = new DebugViewModeAction(this, "Debug_view.mode.auto", parent);
        this.fDebugViewModeActions[1] = new DebugViewModeAction(this, "Debug_view.mode.full", parent);
        this.fDebugViewModeActions[2] = new DebugViewModeAction(this, "Debug_view.mode.compact", parent);
        this.fBreadcrumbDropDownAutoExpandAction = new BreadcrumbDropDownAutoExpandAction(this);
        viewMenu.add((IContributionItem)new Separator());
        MenuManager modeSubmenu = new MenuManager(LaunchViewMessages.LaunchView_ViewModeMenu_label);
        modeSubmenu.setRemoveAllWhenShown(true);
        modeSubmenu.add((IAction)this.fDebugViewModeActions[0]);
        modeSubmenu.add((IAction)this.fDebugViewModeActions[1]);
        modeSubmenu.add((IAction)this.fDebugViewModeActions[2]);
        modeSubmenu.add((IContributionItem)new Separator());
        modeSubmenu.add((IAction)this.fBreadcrumbDropDownAutoExpandAction);
        viewMenu.add((IContributionItem)modeSubmenu);
        modeSubmenu.addMenuListener(manager -> {
            modeSubmenu.add((IAction)this.fDebugViewModeActions[0]);
            modeSubmenu.add((IAction)this.fDebugViewModeActions[1]);
            modeSubmenu.add((IAction)this.fDebugViewModeActions[2]);
            modeSubmenu.add((IContributionItem)new Separator());
            modeSubmenu.add((IAction)this.fBreadcrumbDropDownAutoExpandAction);
        });
    }

    private void createDebugToolBarInViewActions(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fDebugToolBarAction = new DebugToolBarAction(this);
        viewMenu.add((IAction)this.fDebugToolBarAction);
        this.updateCheckedDebugToolBarAction();
    }

    void setViewMode(String mode, Composite parent) {
        if (this.fCurrentViewMode.equals(mode)) {
            return;
        }
        this.fCurrentViewMode = mode;
        if ("Debug_view.mode.compact".equals(mode)) {
            this.showBreadcrumbPage();
        } else if ("Debug_view.mode.full".equals(mode)) {
            this.showTreeViewerPage();
        } else {
            this.autoSelectViewPage(parent);
        }
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclispe.debug.ui.Debug_view.mode", mode);
    }

    private void autoSelectViewPage(Composite parent) {
        int breadcrumbHeight = this.fBreadcrumbPage.getHeight();
        if (breadcrumbHeight == 0) {
            breadcrumbHeight = 30;
        }
        if (parent.getClientArea().height < breadcrumbHeight + 5) {
            this.showBreadcrumbPage();
        } else if (parent.getClientArea().height > breadcrumbHeight + 20) {
            this.showTreeViewerPage();
        }
    }

    void showTreeViewerPage() {
        if (this.fDefaultPageRec != null && !this.getDefaultPage().equals(this.getCurrentPage())) {
            this.showPageRec(this.fDefaultPageRec);
            this.fContextProviderProxy.setActiveProvider(this.fTreeViewerDebugContextProvider);
            this.fBreadcrumbPage.fCrumb.clearSelection();
        }
    }

    void showBreadcrumbPage() {
        PageBookView.PageRec rec = this.getPageRec((IPage)this.fBreadcrumbPage);
        if (rec != null && !((Object)((Object)this.fBreadcrumbPage)).equals(this.getCurrentPage())) {
            ISelection activeContext;
            this.showPageRec(rec);
            if (this.getSite().getPage().getActivePart() == this) {
                this.setFocus();
            }
            if ((activeContext = this.fTreeViewerDebugContextProvider.getActiveContext()) == null) {
                activeContext = StructuredSelection.EMPTY;
            }
            this.fBreadcrumbPage.fCrumb.debugContextChanged(new DebugContextEvent(this.fTreeViewerDebugContextProvider, activeContext, 1));
            this.fContextProviderProxy.setActiveProvider(this.fBreadcrumbPage.getContextProvider());
        }
    }

    @Override
    protected Viewer createViewer(Composite parent) {
        this.fPresentation = new DelegatingModelPresentation();
        this.fPresentationContext = new DebugModelPresentationContext("org.eclipse.debug.ui.DebugView", (IWorkbenchPart)this, this.fPresentation);
        TreeModelViewer viewer = new TreeModelViewer(parent, 268436226, this.fPresentationContext);
        viewer.addSelectionChangedListener(this.fTreeViewerSelectionChangedListener);
        viewer.addViewerUpdateListener(this);
        viewer.addModelChangedListener(this);
        viewer.setInput(DebugPlugin.getDefault().getLaunchManager());
        this.fTreeViewerDebugContextProvider = new TreeViewerContextProvider(viewer);
        return viewer;
    }

    private void commonInit(IViewSite site) {
        site.getPage().addPartListener((IPartListener2)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void preferenceInit(IViewSite site) {
        String preference;
        Boolean auto;
        IMemento mem;
        block19: {
            this.PREF_STATE_MEMENTO = String.valueOf(this.PREF_STATE_MEMENTO) + site.getId();
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String string = store.getString(this.PREF_STATE_MEMENTO);
            if (string.length() > 0) {
                try {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try {
                        ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes());
                        try {
                            try (InputStreamReader reader = new InputStreamReader(bin);){
                                XMLMemento stateMemento = XMLMemento.createReadRoot((Reader)reader);
                                this.setMemento((IMemento)stateMemento);
                            }
                            if (bin == null) break block19;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (bin == null) throw throwable;
                            bin.close();
                            throw throwable;
                        }
                        bin.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (WorkbenchException workbenchException) {
                }
                catch (IOException iOException) {}
            }
        }
        if ((mem = this.getMemento()) != null && (auto = mem.getBoolean(BREADCRUMB_DROPDOWN_AUTO_EXPAND)) != null) {
            this.setBreadcrumbDropDownAutoExpand(auto);
        }
        if ((preference = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclispe.debug.ui.Debug_view.debug_toolbar_hidden_perspectives")) != null) {
            this.fDebugToolbarPerspectives = ViewContextService.parseList(preference);
        }
        IPerspectiveDescriptor perspective = this.getSite().getPage().getPerspective();
        this.fDebugToolbarInView = this.isDebugToolbarShownInPerspective(perspective);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.commonInit(site);
        this.preferenceInit(site);
        this.fContextService = (IContextService)site.getService(IContextService.class);
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.commonInit(site);
        this.preferenceInit(site);
        this.fContextService = (IContextService)site.getService(IContextService.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void partDeactivated(IWorkbenchPart part) {
        block18: {
            String id = part.getSite().getId();
            if (id.equals(this.getSite().getId())) {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        try {
                            try (OutputStreamWriter writer = new OutputStreamWriter(bout);){
                                XMLMemento memento = XMLMemento.createWriteRoot((String)"DebugViewMemento");
                                this.saveViewerState((IMemento)memento);
                                memento.save((Writer)writer);
                                IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
                                String xmlString = bout.toString();
                                store.putValue(this.PREF_STATE_MEMENTO, xmlString);
                            }
                            if (bout == null) break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (bout == null) throw throwable;
                            bout.close();
                            throw throwable;
                        }
                        bout.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        StringBuilder buffer = new StringBuilder();
        Iterator<String> iterator = this.fDebugToolbarPerspectives.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.getPreferenceStore().setValue("org.eclispe.debug.ui.Debug_view.debug_toolbar_hidden_perspectives", buffer.toString());
                super.partDeactivated(part);
                return;
            }
            String perspectiveId = iterator.next();
            buffer.append(perspectiveId).append(',');
        }
    }

    public void saveViewerState(IMemento memento) {
        memento.putBoolean(BREADCRUMB_DROPDOWN_AUTO_EXPAND, this.getBreadcrumbDropDownAutoExpand());
    }

    @Override
    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("threadGroup"));
        tbm.add((IContributionItem)new Separator("stepGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepOverGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        tbm.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        if (this.fDebugToolbarInView) {
            this.addDebugToolbarActions(tbm);
        }
    }

    protected void addDebugToolbarActions(IToolBarManager tbm) {
        tbm.appendToGroup("threadGroup", this.getAction(RESUME));
        tbm.appendToGroup("threadGroup", this.getAction(SUSPEND));
        tbm.appendToGroup("threadGroup", this.getAction(TERMINATE));
        tbm.appendToGroup("threadGroup", this.getAction(DISCONNECT));
        tbm.appendToGroup("stepIntoGroup", this.getAction(STEP_INTO));
        tbm.appendToGroup("stepOverGroup", this.getAction(STEP_OVER));
        tbm.appendToGroup("stepReturnGroup", this.getAction(STEP_RETURN));
        tbm.appendToGroup("emptyStepGroup", this.getAction(DROP_TO_FRAME));
        tbm.appendToGroup("renderGroup", this.getAction(TOGGLE_STEP_FILTERS));
    }

    protected void removeDebugToolbarActions(IToolBarManager tbm) {
        tbm.remove((IContributionItem)new ActionContributionItem(this.getAction(RESUME)));
        tbm.remove((IContributionItem)new ActionContributionItem(this.getAction(SUSPEND)));
        tbm.remove((IContributionItem)new ActionContributionItem(this.getAction(TERMINATE)));
        tbm.remove((IContributionItem)new ActionContributionItem(this.getAction(DISCONNECT)));
        tbm.remove((IContributionItem)new ActionContributionItem(this.getAction(STEP_INTO)));
        tbm.remove((IContributionItem)new ActionContributionItem(this.getAction(STEP_OVER)));
        tbm.remove((IContributionItem)new ActionContributionItem(this.getAction(STEP_RETURN)));
        tbm.remove((IContributionItem)new ActionContributionItem(this.getAction(DROP_TO_FRAME)));
        tbm.remove((IContributionItem)new ActionContributionItem(this.getAction(TOGGLE_STEP_FILTERS)));
    }

    public boolean isDebugToolbarInView() {
        return this.fDebugToolbarInView;
    }

    public boolean isDebugToolbarShownInPerspective(IPerspectiveDescriptor perspective) {
        return perspective == null || this.fDebugToolbarPerspectives.contains(perspective.getId());
    }

    public void setDebugToolbarInView(boolean show) {
        if (show == this.isDebugToolbarInView()) {
            return;
        }
        this.fDebugToolbarInView = show;
        IPerspectiveDescriptor perspective = this.getSite().getPage().getPerspective();
        if (perspective != null) {
            if (show) {
                this.fDebugToolbarPerspectives.add(perspective.getId());
            } else {
                this.fDebugToolbarPerspectives.remove(perspective.getId());
            }
        }
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        if (show) {
            this.addDebugToolbarActions(tbm);
        } else {
            this.removeDebugToolbarActions(tbm);
        }
        this.getViewSite().getActionBars().updateActionBars();
        if (!Boolean.toString(show).equals(System.getProperty("org.eclipse.debug.ui.debugViewToolbarVisible"))) {
            try {
                System.setProperty("org.eclipse.debug.ui.debugViewToolbarVisible", Boolean.toString(show));
            }
            catch (SecurityException securityException) {}
        }
    }

    @Override
    public void dispose() {
        this.fContextService.removeContextManagerListener((IContextManagerListener)this);
        this.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextProvider(this.fContextProviderProxy);
        this.fContextProviderProxy.dispose();
        this.fTreeViewerDebugContextProvider.dispose();
        this.disposeActions();
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.removeSelectionChangedListener(this.fTreeViewerSelectionChangedListener);
            ((TreeModelViewer)viewer).removeViewerUpdateListener(this);
            ((TreeModelViewer)viewer).removeModelChangedListener(this);
        }
        if (this.fPresentationContext != null) {
            this.fPresentationContext.dispose();
        }
        IWorkbenchPage page = this.getSite().getPage();
        page.removePartListener((IPartListener2)this);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.removePerspectiveListener((IPerspectiveListener)this);
        window.removePageListener((IPageListener)this);
        for (IHandler2 handler : this.fHandlers.values()) {
            handler.dispose();
        }
        this.fHandlers.clear();
        if (this.fBreadcrumbPage != null) {
            this.fBreadcrumbPage.dispose();
            this.fBreadcrumbPage = null;
        }
        super.dispose();
    }

    private void disposeActions() {
        PropertyDialogAction properties = (PropertyDialogAction)this.getAction("Properties");
        properties.dispose();
        this.disposeCommandAction(TERMINATE);
        this.disposeCommandAction(DISCONNECT);
        this.disposeCommandAction(SUSPEND);
        this.disposeCommandAction(RESUME);
        this.disposeCommandAction(STEP_RETURN);
        this.disposeCommandAction(STEP_OVER);
        this.disposeCommandAction(STEP_INTO);
        this.disposeCommandAction(DROP_TO_FRAME);
        this.disposeCommandAction(TERMINATE_AND_REMOVE);
        this.disposeCommandAction(TERMINATE_AND_RELAUNCH);
        this.disposeCommandAction(RESTART);
        this.disposeCommandAction(TERMINATE_ALL);
        this.disposeCommandAction(TOGGLE_STEP_FILTERS);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateObjects();
    }

    @Override
    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object o = ss.getFirstElement();
        if (o == null || o instanceof IStackFrame) {
            return;
        }
        StructuredViewer viewer = (StructuredViewer)this.getViewer();
        viewer.refresh(o);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.setActive(page.findView(this.getSite().getId()) != null);
        this.updateObjects();
        this.setDebugToolbarInView(this.isDebugToolbarShownInPerspective(this.getSite().getPage().getPerspective()));
        this.updateCheckedDebugToolBarAction();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.setActive(page.findView(this.getSite().getId()) != null);
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void pageActivated(IWorkbenchPage page) {
        if (this.getSite().getPage().equals(page)) {
            this.setActive(true);
            this.updateObjects();
        }
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    @Override
    public IDebugModelPresentation getPresentation(String id) {
        return ((DelegatingModelPresentation)this.fPresentation).getPresentation(id);
    }

    @Override
    protected void fillContextMenu(IMenuManager menu) {
        TreeSelection sel = (TreeSelection)this.fTreeViewerDebugContextProvider.getActiveContext();
        Object element = sel != null && sel.size() > 0 ? sel.getFirstElement() : null;
        menu.add((IContributionItem)new Separator("emptyEditGroup"));
        menu.add((IContributionItem)new Separator("editGroup"));
        menu.add(this.getAction(FIND_ACTION));
        menu.add((IContributionItem)new Separator("emptyStepGroup"));
        menu.add((IContributionItem)new Separator("stepGroup"));
        menu.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        menu.add((IContributionItem)new GroupMarker("stepOverGroup"));
        menu.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("emptyThreadGroup"));
        menu.add((IContributionItem)new Separator("threadGroup"));
        menu.add((IContributionItem)new Separator("emptyLaunchGroup"));
        menu.add((IContributionItem)new Separator("launchGroup"));
        IStructuredSelection selection = (IStructuredSelection)this.getSite().getSelectionProvider().getSelection();
        this.updateAndAdd(menu, this.fEditConfigAction, selection);
        this.updateAndAdd(menu, this.fAddToFavoritesAction, selection);
        this.updateAndAdd(menu, this.fEditSourceAction, selection);
        this.updateAndAdd(menu, this.fLookupAction, selection);
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("propertyGroup"));
        PropertyDialogAction action = (PropertyDialogAction)this.getAction("Properties");
        action.setEnabled(action.isApplicableForSelection() && !(element instanceof ILaunch));
        menu.add((IAction)action);
        menu.add((IContributionItem)new Separator("additions"));
        menu.appendToGroup("launchGroup", this.getAction(TERMINATE_AND_REMOVE));
        menu.appendToGroup("launchGroup", this.getAction(TERMINATE_ALL));
        menu.appendToGroup("threadGroup", this.getAction(RESUME));
        menu.appendToGroup("threadGroup", this.getAction(SUSPEND));
        menu.appendToGroup("threadGroup", this.getAction(TERMINATE));
        menu.appendToGroup("threadGroup", this.getAction(TERMINATE_AND_RELAUNCH));
        if (element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IRestartHandler.class) != null) {
            menu.appendToGroup("threadGroup", this.getAction(RESTART));
        }
        menu.appendToGroup("threadGroup", this.getAction(DISCONNECT));
        menu.appendToGroup("stepIntoGroup", this.getAction(STEP_INTO));
        menu.appendToGroup("stepOverGroup", this.getAction(STEP_OVER));
        menu.appendToGroup("stepReturnGroup", this.getAction(STEP_RETURN));
        menu.appendToGroup("emptyStepGroup", this.getAction(DROP_TO_FRAME));
        menu.appendToGroup("renderGroup", this.getAction(TOGGLE_STEP_FILTERS));
    }

    public void contextManagerChanged(ContextManagerEvent event) {
        if (event.isActiveContextsChanged()) {
            Set oldContexts = event.getPreviouslyActiveContextIds();
            Set newContexts = event.getContextManager().getActiveContextIds();
            if (oldContexts.contains("org.eclipse.debug.ui.debugToolbarActionSet") != newContexts.contains("org.eclipse.debug.ui.debugToolbarActionSet")) {
                this.updateCheckedDebugToolBarAction();
            }
        }
    }

    private void updateCheckedDebugToolBarAction() {
        this.fDebugToolBarAction.setChecked(this.isDebugToolbarInView());
    }

    private void updateAndAdd(IMenuManager menu, SelectionListenerAction action, IStructuredSelection selection) {
        action.selectionChanged(selection);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
    }

    protected void setActive(boolean active) {
        this.fIsActive = active;
    }

    protected boolean isActive() {
        return this.fIsActive && this.getViewer() != null;
    }

    public boolean show(ShowInContext context) {
        Object obj;
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ((obj = ss.getFirstElement()) instanceof IDebugTarget || obj instanceof IProcess)) {
            Viewer viewer = this.getViewer();
            if (viewer instanceof InternalTreeModelViewer) {
                InternalTreeModelViewer tv = (InternalTreeModelViewer)viewer;
                tv.setSelection(selection, true, true);
            } else {
                viewer.setSelection(selection, true);
            }
            return true;
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        IAdaptable adaptable;
        IShowInSource show;
        Object object;
        IStructuredSelection selection;
        if (this.isActive() && (selection = (IStructuredSelection)this.getViewer().getSelection()).size() == 1 && (object = selection.getFirstElement()) instanceof IAdaptable && (show = (IShowInSource)(adaptable = (IAdaptable)object).getAdapter(IShowInSource.class)) != null) {
            return show.getShowInContext();
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        IAdaptable adaptable;
        IShowInTargetList show;
        Object object;
        IStructuredSelection selection;
        if (this.isActive() && (selection = (IStructuredSelection)this.getViewer().getSelection()).size() == 1 && (object = selection.getFirstElement()) instanceof IAdaptable && (show = (IShowInTargetList)(adaptable = (IAdaptable)object).getAdapter(IShowInTargetList.class)) != null) {
            return show.getShowInTargetIds();
        }
        return new String[0];
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == this) {
            this.setActive(true);
            this.getSite().getPage().showActionSet("org.eclipse.debug.ui.debugActionSet");
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        String debugToolBarShown = Boolean.toString(this.isDebugToolbarShownInPerspective(this.getSite().getPage().getPerspective()));
        if (!debugToolBarShown.equals(System.getProperty("org.eclipse.debug.ui.debugViewToolbarVisible"))) {
            try {
                System.setProperty("org.eclipse.debug.ui.debugViewToolbarVisible", debugToolBarShown);
            }
            catch (SecurityException securityException) {}
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    @Override
    protected void becomesVisible() {
        super.becomesVisible();
        this.getViewer().refresh();
    }

    @Override
    public void updateComplete(IViewerUpdate update) {
        if (!update.isCanceled() && TreePath.EMPTY.equals((Object)update.getElementPath())) {
            this.updateFindAction();
        }
    }

    @Override
    public void updateStarted(IViewerUpdate update) {
    }

    @Override
    public synchronized void viewerUpdatesBegin() {
        IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progressService != null) {
            progressService.incrementBusy();
        }
    }

    @Override
    public synchronized void viewerUpdatesComplete() {
        IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progressService != null) {
            progressService.decrementBusy();
        }
    }

    @Override
    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
        this.updateFindAction();
    }

    private void updateFindAction() {
        IAction action = this.getAction(FIND_ACTION);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    boolean isBreadcrumbVisible() {
        return ((Object)((Object)this.fBreadcrumbPage)).equals(this.getCurrentPage());
    }

    boolean getBreadcrumbDropDownAutoExpand() {
        return this.fBreadcrumbDropDownAutoExpand;
    }

    void setBreadcrumbDropDownAutoExpand(boolean expand) {
        this.fBreadcrumbDropDownAutoExpand = expand;
    }

    private class BreadcrumbPage
    extends Page {
        LaunchViewBreadcrumb fCrumb;
        Control fControl;

        private BreadcrumbPage() {
        }

        public void createControl(Composite parent) {
            this.fCrumb = new LaunchViewBreadcrumb(LaunchView.this, (TreeModelViewer)LaunchView.this.getViewer(), LaunchView.this.fTreeViewerDebugContextProvider);
            this.fControl = this.fCrumb.createContent(parent);
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            pageSite.setSelectionProvider(this.fCrumb.getSelectionProvider());
        }

        public Control getControl() {
            return this.fControl;
        }

        public void setFocus() {
            this.fCrumb.activate();
        }

        IDebugContextProvider getContextProvider() {
            return this.fCrumb.getContextProvider();
        }

        int getHeight() {
            return this.fCrumb.getHeight();
        }

        public void dispose() {
            this.fCrumb.dispose();
        }
    }

    private class ContextProviderProxy
    extends AbstractDebugContextProvider
    implements IDebugContextListener {
        private IDebugContextProvider fActiveProvider;
        private IDebugContextProvider[] fProviders;

        ContextProviderProxy(IDebugContextProvider[] providers) {
            super((IWorkbenchPart)LaunchView.this);
            this.fProviders = providers;
            this.fActiveProvider = providers[0];
            IDebugContextProvider[] iDebugContextProviderArray = this.fProviders;
            int n = this.fProviders.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugContextProvider provider = iDebugContextProviderArray[n2];
                provider.addDebugContextListener(this);
                ++n2;
            }
        }

        void setActiveProvider(IDebugContextProvider provider) {
            if (!provider.equals(this.fActiveProvider)) {
                ISelection activeContext = this.getActiveContext();
                this.fActiveProvider = provider;
                ISelection newActiveContext = this.getActiveContext();
                if (!activeContext.equals(newActiveContext)) {
                    this.fire(new DebugContextEvent(this, this.getActiveContext(), 1));
                }
            }
        }

        @Override
        public ISelection getActiveContext() {
            ISelection activeContext = this.fActiveProvider.getActiveContext();
            if (activeContext != null) {
                return activeContext;
            }
            return TreeSelection.EMPTY;
        }

        @Override
        public void debugContextChanged(DebugContextEvent event) {
            if (event.getSource().equals(this.fActiveProvider)) {
                this.fire(new DebugContextEvent(this, event.getContext(), event.getFlags()));
            }
        }

        void dispose() {
            IDebugContextProvider[] iDebugContextProviderArray = this.fProviders;
            int n = this.fProviders.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugContextProvider provider = iDebugContextProviderArray[n2];
                provider.removeDebugContextListener(this);
                ++n2;
            }
            this.fProviders = null;
            this.fActiveProvider = null;
        }
    }

    class TreeViewerContextProvider
    extends AbstractDebugContextProvider
    implements IModelChangedListener {
        private ISelection fContext;
        private TreeModelViewer fViewer;
        private Visitor fVisitor;

        private TreePath getViewerTreePath(IModelDelta node) {
            ArrayList<Object> list = new ArrayList<Object>();
            IModelDelta parentDelta = node.getParentDelta();
            while (parentDelta != null) {
                list.add(0, node.getElement());
                node = parentDelta;
                parentDelta = node.getParentDelta();
            }
            return new TreePath(list.toArray());
        }

        public TreeViewerContextProvider(TreeModelViewer viewer) {
            super((IWorkbenchPart)LaunchView.this);
            this.fContext = null;
            this.fViewer = null;
            this.fVisitor = new Visitor();
            this.fViewer = viewer;
            this.fViewer.addModelChangedListener(this);
        }

        protected void dispose() {
            this.fContext = null;
            this.fViewer.removeModelChangedListener(this);
        }

        @Override
        public synchronized ISelection getActiveContext() {
            return this.fContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(ISelection selection) {
            TreeViewerContextProvider treeViewerContextProvider = this;
            synchronized (treeViewerContextProvider) {
                this.fContext = selection;
            }
            this.fire(new DebugContextEvent(this, selection, 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void possibleChange(TreePath element, int type) {
            DebugContextEvent event = null;
            TreeViewerContextProvider treeViewerContextProvider = this;
            synchronized (treeViewerContextProvider) {
                if (this.fContext instanceof ITreeSelection) {
                    ITreeSelection ss = (ITreeSelection)this.fContext;
                    TreePath[] treePathArray = ss.getPaths();
                    int n = treePathArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreePath path = treePathArray[n2];
                        if (path.startsWith(element, null)) {
                            event = path.getSegmentCount() == element.getSegmentCount() ? new DebugContextEvent(this, this.fContext, type) : new DebugContextEvent(this, this.fContext, 16);
                        }
                        ++n2;
                    }
                }
            }
            if (event == null) {
                return;
            }
            if (LaunchView.this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                this.fire(event);
            } else {
                final DebugContextEvent finalEvent = event;
                UIJob job = new UIJob("context change"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TreeViewerContextProvider treeViewerContextProvider = TreeViewerContextProvider.this;
                        synchronized (treeViewerContextProvider) {
                            if (TreeViewerContextProvider.this.fContext instanceof IStructuredSelection) {
                                IStructuredSelection ss = (IStructuredSelection)TreeViewerContextProvider.this.fContext;
                                Object changed = ((IStructuredSelection)finalEvent.getContext()).getFirstElement();
                                if (ss.size() != 1 || !ss.getFirstElement().equals(changed)) {
                                    return Status.OK_STATUS;
                                }
                            }
                        }
                        TreeViewerContextProvider.this.fire(finalEvent);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }

        @Override
        public void modelChanged(IModelDelta delta, IModelProxy proxy) {
            delta.accept(this.fVisitor);
        }

        class Visitor
        implements IModelDeltaVisitor {
            Visitor() {
            }

            @Override
            public boolean visit(IModelDelta delta, int depth) {
                if ((delta.getFlags() & 0xC00) > 0 && (delta.getFlags() & 0x200000) == 0) {
                    if ((delta.getFlags() & 0x400) > 0) {
                        TreeViewerContextProvider.this.possibleChange(TreeViewerContextProvider.this.getViewerTreePath(delta), 1);
                    } else if ((delta.getFlags() & 0x800) > 0) {
                        TreeViewerContextProvider.this.possibleChange(TreeViewerContextProvider.this.getViewerTreePath(delta), 16);
                    }
                }
                return true;
            }
        }
    }
}

