/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.view.factories;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.internal.view.factories.AbstractDesignerEdgeFactory;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;

public class DEdgeViewFactory
extends AbstractDesignerEdgeFactory {
    protected List<?> createStyles(View view) {
        ArrayList styles = Lists.newArrayList();
        styles.add(NotationFactory.eINSTANCE.createConnectorStyle());
        styles.add(NotationFactory.eINSTANCE.createFontStyle());
        return styles;
    }

    @Override
    protected void decorateView(View containerView, View view, IAdaptable semanticAdapter, String semanticHint, int index, boolean persisted) {
        if (semanticHint == null) {
            semanticHint = SiriusVisualIDRegistry.getType(4001);
            view.setType(semanticHint);
        }
        super.decorateView(containerView, view, semanticAdapter, semanticHint, index, persisted);
        EObjectAdapter eObjectAdapter = null;
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            eObjectAdapter = new EObjectAdapter(eObject);
        }
        DEdgeViewFactory.getViewService().createNode((IAdaptable)eObjectAdapter, view, SiriusVisualIDRegistry.getType(6001), -1, true, this.getPreferencesHint());
        DEdgeViewFactory.getViewService().createNode((IAdaptable)eObjectAdapter, view, SiriusVisualIDRegistry.getType(6002), -1, true, this.getPreferencesHint());
        DEdgeViewFactory.getViewService().createNode((IAdaptable)eObjectAdapter, view, SiriusVisualIDRegistry.getType(6003), -1, true, this.getPreferencesHint());
        if (eObject != null && ((EdgeStyle)((DEdge)eObject).getStyle()).getRoutingStyle().equals((Object)EdgeRouting.MANHATTAN_LITERAL)) {
            DEdgeViewFactory.setManahattanRoutingStyle(view);
        }
        if (eObject != null && ((EdgeStyle)((DEdge)eObject).getStyle()).getRoutingStyle().equals((Object)EdgeRouting.TREE_LITERAL)) {
            DEdgeViewFactory.setTreeRoutingStyle(view);
        }
    }

    private static void setManahattanRoutingStyle(View view) {
        RoutingStyle rstyle = (RoutingStyle)view.getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        rstyle.setJumpLinkType(JumpLinkType.get((int)0));
        rstyle.setJumpLinkStatus(JumpLinkStatus.get((int)0));
        rstyle.setRouting(Routing.RECTILINEAR_LITERAL);
    }

    private static void setTreeRoutingStyle(View view) {
        RoutingStyle rstyle = (RoutingStyle)view.getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        rstyle.setJumpLinkType(JumpLinkType.get((int)0));
        rstyle.setJumpLinkStatus(JumpLinkStatus.get((int)0));
        rstyle.setRouting(Routing.TREE_LITERAL);
    }
}

