/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterUtil {
    public static String createIndentString(int indentationUnits, IJavaProject project) {
        Hashtable options = project != null ? project.getOptions(true) : JavaCore.getOptions();
        return ToolFactory.createCodeFormatter((Map)options).createIndentationString(indentationUnits);
    }

    public static String createIndentString(int indentationUnits, ICompilationUnit cu) {
        Hashtable options = cu != null ? cu.getOptions(true) : JavaCore.getOptions();
        return ToolFactory.createCodeFormatter((Map)options).createIndentationString(indentationUnits);
    }

    public static int getTabWidth(IJavaProject project) {
        String key = "space".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    public static int getTabWidth(ICompilationUnit cu) {
        String key = "space".equals(CodeFormatterUtil.getCoreOption(cu, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(cu, key, 4);
    }

    public static int getIndentWidth(IJavaProject project) {
        String key = "mixed".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    public static int getIndentWidth(ICompilationUnit cu) {
        String key = "mixed".equals(CodeFormatterUtil.getCoreOption(cu, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(cu, key, 4);
    }

    private static String getCoreOption(IJavaProject project, String key) {
        if (project == null) {
            return JavaCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private static int getCoreOption(IJavaProject project, String key, int def) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(project, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    private static String getCoreOption(ICompilationUnit cu, String key) {
        if (cu == null) {
            return JavaCore.getOption((String)key);
        }
        return (String)cu.getOptions(true).get(key);
    }

    private static int getCoreOption(ICompilationUnit cu, String key, int def) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(cu, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static String format(int kind, String source, int indentationLevel, String lineSeparator, IJavaProject project) {
        Map options = project != null ? project.getOptions(true) : null;
        return CodeFormatterUtil.format(kind, source, indentationLevel, lineSeparator, options);
    }

    public static String format(int kind, String source, int indentationLevel, String lineSeparator, Map<String, String> options) {
        TextEdit edit = CodeFormatterUtil.format2(kind, source, indentationLevel, lineSeparator, options);
        if (edit == null) {
            return source;
        }
        Document document = new Document(source);
        try {
            edit.apply((IDocument)document, 0);
        }
        catch (BadLocationException e) {
            JavaManipulationPlugin.log(e);
            Assert.isTrue((boolean)false, (String)("Formatter created edits with wrong positions: " + e.getMessage()));
        }
        return document.get();
    }

    public static TextEdit format2(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator, Map<String, String> options) {
        if (offset < 0 || length < 0 || offset + length > source.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + source.length());
        }
        return ToolFactory.createCodeFormatter(options).format(kind, source, offset, length, indentationLevel, lineSeparator);
    }

    public static TextEdit format2(int kind, String source, int indentationLevel, String lineSeparator, Map<String, String> options) {
        return CodeFormatterUtil.format2(kind, source, 0, source.length(), indentationLevel, lineSeparator, options);
    }

    public static TextEdit reformat(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator, Map<String, String> options) {
        if (offset < 0 || length < 0 || offset + length > source.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + source.length());
        }
        return ToolFactory.createCodeFormatter(options, (int)ToolFactory.M_FORMAT_EXISTING).format(kind, source, offset, length, indentationLevel, lineSeparator);
    }

    public static TextEdit reformat(int kind, String source, IRegion[] regions, int indentationLevel, String lineSeparator, Map<String, String> options) {
        return ToolFactory.createCodeFormatter(options, (int)ToolFactory.M_FORMAT_EXISTING).format(kind, source, regions, indentationLevel, lineSeparator);
    }

    public static TextEdit reformat(int kind, String source, int indentationLevel, String lineSeparator, Map<String, String> options) {
        return CodeFormatterUtil.reformat(kind, source, 0, source.length(), indentationLevel, lineSeparator, options);
    }

    public static TextEdit format2(ASTNode node, String source, int indentationLevel, String lineSeparator, Map<String, String> options) {
        String concatStr;
        TextEdit edit;
        int code;
        String prefix = "";
        String suffix = "";
        if (node instanceof Statement) {
            code = 2;
            if (node.getNodeType() == 49) {
                prefix = "switch(1) {";
                suffix = "}";
                code = 2;
            }
        } else if (node instanceof Expression && node.getNodeType() != 58) {
            code = 1;
        } else if (node instanceof BodyDeclaration) {
            code = 4;
        } else {
            switch (node.getNodeType()) {
                case 5: 
                case 39: 
                case 43: 
                case 74: 
                case 75: {
                    suffix = " x;";
                    code = 4;
                    break;
                }
                case 76: {
                    prefix = "A<";
                    suffix = "> x;";
                    code = 4;
                    break;
                }
                case 15: {
                    code = 8;
                    break;
                }
                case 93: {
                    code = 128;
                    break;
                }
                case 44: 
                case 58: {
                    suffix = ";";
                    code = 2;
                    break;
                }
                case 59: {
                    prefix = "A ";
                    suffix = ";";
                    code = 2;
                    break;
                }
                case 26: 
                case 35: {
                    suffix = "\nclass A {}";
                    code = 8;
                    break;
                }
                case 29: {
                    suffix = "void foo();";
                    code = 4;
                    break;
                }
                case 12: {
                    prefix = "try {}";
                    code = 2;
                    break;
                }
                case 1: {
                    prefix = "new A()";
                    suffix = ";";
                    code = 2;
                    break;
                }
                case 80: {
                    prefix = "@Author(";
                    suffix = ") class x {}";
                    code = 8;
                    break;
                }
                case 83: {
                    suffix = " class x {}";
                    code = 8;
                    break;
                }
                case 73: {
                    prefix = "class X<";
                    suffix = "> {}";
                    code = 8;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: {
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        if ((edit = CodeFormatterUtil.format2(code, concatStr = String.valueOf(prefix) + source + suffix, prefix.length(), source.length(), indentationLevel, lineSeparator, options)) != null && prefix.length() > 0) {
            edit.moveTree(-prefix.length());
        }
        return edit;
    }

    private CodeFormatterUtil() {
    }
}

