/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data;

import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.AbstractLostElementDataWithTarget;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.ILostElementDataWithMapping;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.ISimilarLostElementData;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataState;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class LostElementDataWithMapping
extends AbstractLostElementDataWithTarget
implements ISimilarLostElementData,
ILostElementDataWithMapping {
    private RepresentationElementMapping mapping;

    @Override
    public void setMapping(RepresentationElementMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public RepresentationElementMapping getMapping() {
        return this.mapping;
    }

    public final LostElementDataState reCreateLostElement(DSemanticDiagram designerDiagram) {
        DDiagramElement foundDesignerDiagramElement = LostElementDataUtil.findDesignerDiagramElement(designerDiagram, this);
        LostElementDataState result = foundDesignerDiagramElement == null ? this.doRecreateNonExistingLostElement(designerDiagram) : LostElementDataState.EXISTING;
        return result;
    }

    protected LostElementDataState doRecreateNonExistingLostElement(DSemanticDiagram designerDiagram) {
        return LostElementDataState.NOT_CREATED;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " |--| " + "Mapping name: " + this.mapping.getName();
    }

    @Override
    public final boolean isSimilarTo(DSemanticDecorator semanticDecorator) {
        boolean result;
        if (semanticDecorator instanceof DDiagramElement) {
            DDiagramElement diagramElement = (DDiagramElement)semanticDecorator;
            Option<? extends RepresentationElementMapping> extractedMapping = new DDiagramElementQuery(diagramElement).getMapping();
            result = extractedMapping != null && extractedMapping.some();
            result = result && this.doIsSimilarTo(diagramElement, (RepresentationElementMapping)extractedMapping.get());
        } else {
            result = false;
        }
        return result;
    }

    protected boolean doIsSimilarTo(DDiagramElement diagramElement, RepresentationElementMapping extractedMapping) {
        return this.getTarget() == diagramElement.getTarget() && this.mapping.getName().equals(extractedMapping.getName());
    }
}

