/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefSpecPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class FetchWizard
extends Wizard {
    private final Repository localDb;
    private final RepositorySelectionPage repoPage;
    private final RefSpecPage refSpecPage;

    public FetchWizard(Repository localDb) throws URISyntaxException {
        this.localDb = localDb;
        List remotes = RemoteConfig.getAllRemoteConfigs((Config)localDb.getConfig());
        this.repoPage = new RepositorySelectionPage(true, remotes, null);
        this.refSpecPage = new RefSpecPage(localDb, false){

            public void setVisible(boolean visible) {
                if (visible) {
                    this.setSelection(FetchWizard.this.repoPage.getSelection());
                    this.setCredentials(FetchWizard.this.repoPage.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_FETCH);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.repoPage);
        this.addPage((IWizardPage)this.refSpecPage);
    }

    public boolean canFinish() {
        RepositorySelection sel;
        if (this.getContainer().getCurrentPage() == this.repoPage && (sel = this.repoPage.getSelection()).isConfigSelected()) {
            RemoteConfig config = sel.getConfig();
            return !config.getURIs().isEmpty() && !config.getFetchRefSpecs().isEmpty();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        boolean calledFromRepoPage = false;
        if (this.getContainer().getCurrentPage() == this.repoPage) {
            calledFromRepoPage = true;
        }
        if (this.repoPage.getSelection().isConfigSelected() && this.refSpecPage.isSaveRequested()) {
            this.saveConfig();
        }
        if (this.repoPage.getStoreInSecureStore() && !SecureStoreUtils.storeCredentials(this.repoPage.getCredentials(), this.repoPage.getSelection().getURI())) {
            return false;
        }
        RepositorySelection repoSelection = this.repoPage.getSelection();
        FetchOperationUI op = calledFromRepoPage ? new FetchOperationUI(this.localDb, repoSelection.getConfig(), false) : (repoSelection.isConfigSelected() ? new FetchOperationUI(this.localDb, (URIish)repoSelection.getConfig().getURIs().get(0), this.refSpecPage.getRefSpecs(), false) : new FetchOperationUI(this.localDb, repoSelection.getURI(false), this.refSpecPage.getRefSpecs(), false));
        UserPasswordCredentials credentials = this.repoPage.getCredentials();
        if (credentials != null) {
            op.setCredentialsProvider(new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword()));
        }
        if (!calledFromRepoPage) {
            op.setTagOpt(this.refSpecPage.getTagOpt());
        }
        op.start();
        this.repoPage.saveUriInPrefs();
        return true;
    }

    public String getWindowTitle() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.repoPage || currentPage == null) {
            return UIText.FetchWizard_windowTitleDefault;
        }
        return NLS.bind((String)UIText.FetchWizard_windowTitleWithSource, (Object)this.getSourceString());
    }

    private void saveConfig() {
        RemoteConfig rc = this.repoPage.getSelection().getConfig();
        rc.setFetchRefSpecs(this.refSpecPage.getRefSpecs());
        rc.setTagOpt(this.refSpecPage.getTagOpt());
        StoredConfig config = this.localDb.getConfig();
        rc.update((Config)config);
        try {
            config.save();
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.FetchWizard_cantSaveTitle, (String)UIText.FetchWizard_cantSaveMessage, (IStatus)new Status(2, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    private String getSourceString() {
        RepositorySelection repoSelection = this.repoPage.getSelection();
        if (repoSelection.isConfigSelected()) {
            return repoSelection.getConfigName();
        }
        return repoSelection.getURI(false).toString();
    }
}

