/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.AbstractMap;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.der.DERWriter;

public class SignatureECDSA
extends AbstractSignature {
    protected SignatureECDSA(String algo) {
        super(algo);
    }

    @Override
    public byte[] sign(SessionContext session) throws Exception {
        byte[] sig = super.sign(session);
        try (DERParser parser = new DERParser(sig);){
            int type = parser.read();
            if (type != 48) {
                throw new StreamCorruptedException("Invalid signature format - not a DER SEQUENCE: 0x" + Integer.toHexString(type));
            }
            int remainLen = parser.readLength();
            if (remainLen < 6) {
                throw new StreamCorruptedException("Invalid signature format - not enough encoded data length: " + remainLen);
            }
            BigInteger r = parser.readBigInteger();
            BigInteger s = parser.readBigInteger();
            ByteArrayBuffer rsBuf = new ByteArrayBuffer();
            rsBuf.putMPInt(r);
            rsBuf.putMPInt(s);
            byte[] byArray = rsBuf.getCompactData();
            return byArray;
        }
    }

    @Override
    public boolean verify(SessionContext session, byte[] sig) throws Exception {
        byte[] encoded;
        byte[] sEncoding;
        byte[] rEncoding;
        byte[] data = sig;
        AbstractMap.SimpleImmutableEntry<String, byte[]> encoding = this.extractEncodedSignature(data);
        if (encoding != null) {
            String keyType = (String)encoding.getKey();
            ECCurves curve = ECCurves.fromKeyType(keyType);
            ValidateUtils.checkNotNull(curve, "Unknown curve type: %s", (Object)keyType);
            data = (byte[])encoding.getValue();
        }
        ByteArrayBuffer rsBuf = new ByteArrayBuffer(data);
        byte[] rArray = rsBuf.getMPIntAsBytes();
        try (DERWriter w = new DERWriter(rArray.length + 4);){
            w.writeBigInteger(rArray);
            rEncoding = w.toByteArray();
        }
        byte[] sArray = rsBuf.getMPIntAsBytes();
        try (DERWriter w = new DERWriter(sArray.length + 4);){
            w.writeBigInteger(sArray);
            sEncoding = w.toByteArray();
        }
        int remaining = rsBuf.available();
        if (remaining != 0) {
            throw new StreamCorruptedException("Signature had padding - remaining=" + remaining);
        }
        int length = rEncoding.length + sEncoding.length;
        try (DERWriter w = new DERWriter(1 + length + 4);){
            w.write(48);
            w.writeLength(length);
            w.write(rEncoding);
            w.write(sEncoding);
            encoded = w.toByteArray();
        }
        return this.doVerify(encoded);
    }

    public static class SignatureECDSA256
    extends SignatureECDSA {
        public static final String DEFAULT_ALGORITHM = "SHA256withECDSA";

        public SignatureECDSA256() {
            super(DEFAULT_ALGORITHM);
        }
    }

    public static class SignatureECDSA384
    extends SignatureECDSA {
        public static final String DEFAULT_ALGORITHM = "SHA384withECDSA";

        public SignatureECDSA384() {
            super(DEFAULT_ALGORITHM);
        }
    }

    public static class SignatureECDSA521
    extends SignatureECDSA {
        public static final String DEFAULT_ALGORITHM = "SHA512withECDSA";

        public SignatureECDSA521() {
            super(DEFAULT_ALGORITHM);
        }
    }
}

