/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sirius.common.ui.tools.api.util.IObjectActionDelegateWrapper;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DNodeLabelItemProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.AbstractExtendedContentOutlinePage;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePageListener;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.IDiagramOutlinePage;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;

public class DiagramOutlinePage
extends AbstractExtendedContentOutlinePage {
    protected static final int ID_OUTLINE = 0;
    protected static final int ID_OVERVIEW = 1;
    private static final String SIRIUS_DIAGRAM_OUTLINE_SHOW_OUTLINE = "sirius.diagram.outline.show.outline";
    private static final String SIRIUS_DIAGRAM_OUTLINE_SHOW_OVERVIEW = "sirius.diagram.outline.show.overview";
    protected IDiagramWorkbenchPart diagramWorkbenchPart;
    protected TreeViewer outlineViewer;
    protected ITreeContentProvider contentProvider;
    private IAction showOutlineAction;
    private IAction showOverviewAction;
    private int defaultMode = 1;
    private PageBook pageBook;
    private Control outline;
    private IBaseLabelProvider labelProvider;
    private ViewerComparator viewerComparator;
    private Object input;
    private Canvas overview;
    private Thumbnail thumbnail;
    private DisposeListener disposeListener;
    private boolean overviewInitialized;
    private GraphicalViewer graphicalViewer;
    private final Collection<IObjectActionDelegateWrapper> menuContributions = Lists.newArrayList();
    private final Collection<DiagramOutlinePageListener> listeners = Lists.newArrayList();

    public DiagramOutlinePage(Object input, IBaseLabelProvider labelProvider, ITreeContentProvider contentProvider, ViewerComparator comparator, GraphicalViewer viewer, IObjectActionDelegateWrapper[] menuContributions) {
        this.input = input;
        this.graphicalViewer = viewer;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.viewerComparator = comparator;
        if (menuContributions != null) {
            Collections.addAll(this.menuContributions, menuContributions);
        }
    }

    public void addListener(DiagramOutlinePageListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DiagramOutlinePageListener listener) {
        this.listeners.remove(listener);
    }

    public void setDiagramWorkbenchPart(IDiagramWorkbenchPart diagramWorkbenchPart) {
        this.diagramWorkbenchPart = diagramWorkbenchPart;
    }

    @Override
    public Control getControl() {
        return this.pageBook;
    }

    protected EditPartViewer getViewer() {
        return this.graphicalViewer;
    }

    @Override
    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IActionBars bars = pageSite.getActionBars();
        bars.getToolBarManager().markDirty();
    }

    private Control createOutline(Composite parent) {
        return this.createFilteredTreeControl(parent);
    }

    protected Control createFilteredTreeControl(Composite parent) {
        super.createControl(parent);
        return super.getControl();
    }

    @Override
    public void createControl(Composite parent) {
        this.pageBook = SWTUtil.createPageBook((Composite)parent);
        this.createControls(this.pageBook);
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.configureControls(tbm);
        this.showPage(this.defaultMode);
    }

    protected void configureControls(IToolBarManager tbm) {
        this.configureOutline(tbm);
        this.initializeOutline();
        this.configureOverview(tbm);
        this.initializeOverview();
    }

    protected void createControls(PageBook pb) {
        this.outline = this.createOutline((Composite)pb);
        this.outlineViewer = super.getTreeViewer();
        final MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                menuManager.removeAll();
                for (IObjectActionDelegateWrapper menuContribution : DiagramOutlinePage.this.menuContributions) {
                    if (!menuContribution.isEnabled()) continue;
                    menuManager.add((IAction)menuContribution);
                }
            }
        });
        this.outlineViewer.getTree().setMenu(menuManager.createContextMenu((Control)this.outlineViewer.getTree()));
        this.overview = new Canvas((Composite)pb, 0);
        if (this.contentProvider instanceof DiagramOutlinePageListener) {
            this.addListener((DiagramOutlinePageListener)this.contentProvider);
        }
    }

    @Override
    public void dispose() {
        if (this.disposeListener != null) {
            if (this.getEditor() != null && !this.getEditor().isDisposed()) {
                this.getEditor().removeDisposeListener(this.disposeListener);
            }
            this.disposeListener = null;
        }
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        if (this.showOutlineAction != null) {
            tbm.remove(SIRIUS_DIAGRAM_OUTLINE_SHOW_OUTLINE);
            this.showOutlineAction = null;
        }
        if (this.showOverviewAction != null) {
            tbm.remove(SIRIUS_DIAGRAM_OUTLINE_SHOW_OVERVIEW);
            this.showOverviewAction = null;
        }
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
            this.thumbnail = null;
        }
        if (this.overview != null) {
            this.overview.dispose();
            this.overview = null;
        }
        this.overviewInitialized = false;
        this.pageBook.dispose();
        this.pageBook = null;
        this.contentProvider.dispose();
        this.contentProvider = null;
        this.labelProvider.dispose();
        this.labelProvider = null;
        this.viewerComparator = null;
        this.outlineViewer.getTree().dispose();
        this.outlineViewer = null;
        this.outline.dispose();
        this.outline = null;
        this.listeners.clear();
        this.menuContributions.clear();
        this.diagramWorkbenchPart = null;
        this.graphicalViewer = null;
        this.input = null;
        super.dispose();
    }

    @Override
    protected IStructuredSelection createStructuredSelectionWrapper(IStructuredSelection originalSelection) {
        ArrayList<AbstractDDiagramElementLabelItemProvider> elements = new ArrayList<AbstractDDiagramElementLabelItemProvider>(originalSelection.toList().size());
        for (Object obj : originalSelection.toList()) {
            if (obj instanceof EditPart) {
                EObject element;
                EditPart editPart = (EditPart)obj;
                if (editPart instanceof LabelEditPart && editPart.getModel() instanceof View) {
                    if (((View)editPart.getModel()).getElement() instanceof DNode) {
                        DNode parentDNode = null;
                        parentDNode = (DNode)((View)editPart.getModel()).getElement();
                        if (!(this.contentProvider instanceof OutlineContentProvider)) continue;
                        elements.add(new DNodeLabelItemProvider(((OutlineContentProvider)this.contentProvider).getAdapterFactory(), parentDNode));
                        continue;
                    }
                    if (!(((View)editPart.getModel()).getElement() instanceof DEdge)) continue;
                    DEdge parentDEdge = null;
                    parentDEdge = (DEdge)((View)editPart.getModel()).getElement();
                    if (!(this.contentProvider instanceof OutlineContentProvider)) continue;
                    elements.add(new DEdgeLabelItemProvider(((OutlineContentProvider)this.contentProvider).getAdapterFactory(), parentDEdge));
                    continue;
                }
                if (!(editPart.getModel() instanceof View) || (element = ((View)editPart.getModel()).getElement()) == null) continue;
                elements.add((AbstractDDiagramElementLabelItemProvider)element);
                continue;
            }
            elements.add((AbstractDDiagramElementLabelItemProvider)((Object)obj));
        }
        return new StructuredSelection(elements);
    }

    protected void configureOutline(IToolBarManager tbm) {
        this.showOutlineAction = new Action(){

            public void run() {
                DiagramOutlinePage.this.showPage(0);
            }
        };
        this.showOutlineAction.setImageDescriptor(IDiagramOutlinePage.DESC_OUTLINE);
        this.showOutlineAction.setToolTipText(IDiagramOutlinePage.OUTLINE_VIEW_OUTLINE_TIP_TEXT);
        this.showOutlineAction.setId(SIRIUS_DIAGRAM_OUTLINE_SHOW_OUTLINE);
        tbm.add(this.showOutlineAction);
    }

    protected void configureOverview(IToolBarManager tbm) {
        this.showOverviewAction = new Action(){

            public void run() {
                DiagramOutlinePage.this.showPage(1);
            }
        };
        this.showOverviewAction.setImageDescriptor(IDiagramOutlinePage.DESC_OVERVIEW);
        this.showOverviewAction.setToolTipText(IDiagramOutlinePage.OUTLINE_VIEW_OVERVIEW_TIP_TEXT);
        this.showOverviewAction.setId(SIRIUS_DIAGRAM_OUTLINE_SHOW_OVERVIEW);
        tbm.add(this.showOverviewAction);
    }

    protected void initializeOutline() {
        this.outlineViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.outlineViewer.setLabelProvider(this.labelProvider);
        this.outlineViewer.setComparator(this.viewerComparator);
        this.outlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.outlineViewer.setInput(this.input);
    }

    protected void initializeOverview() {
        LightweightSystem lws = new LightweightSystem(this.overview);
        RootEditPart rep = this.graphicalViewer.getRootEditPart();
        if (rep instanceof DiagramRootEditPart) {
            DiagramRootEditPart root = (DiagramRootEditPart)rep;
            this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            this.thumbnail.setSource(root.getLayer((Object)"Scalable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DiagramOutlinePage.this.thumbnail != null) {
                        DiagramOutlinePage.this.thumbnail.deactivate();
                        DiagramOutlinePage.this.thumbnail = null;
                    }
                }
            };
            this.getEditor().addDisposeListener(this.disposeListener);
            this.overviewInitialized = true;
        }
    }

    protected void uncheckProvidedActions() {
        Diagram diagram;
        EObject element;
        this.showOutlineAction.setChecked(false);
        this.showOverviewAction.setChecked(false);
        if (this.thumbnail != null) {
            this.thumbnail.setVisible(false);
        }
        if (this.input instanceof Diagram && (element = (diagram = (Diagram)this.input).getElement()) != null) {
            for (DiagramOutlinePageListener listener : this.listeners) {
                listener.deactivate(0);
                listener.deactivate(1);
            }
        }
    }

    protected void showPage(Control control) {
        this.pageBook.showPage(control);
    }

    protected void showPage(int id) {
        switch (id) {
            case 0: {
                Diagram diagram;
                EObject element;
                this.showOutlineAction.setChecked(true);
                this.showOverviewAction.setChecked(false);
                this.showPage(this.outline);
                if (this.thumbnail != null) {
                    this.thumbnail.setVisible(false);
                }
                if (!(this.input instanceof Diagram) || (element = (diagram = (Diagram)this.input).getElement()) == null) break;
                for (DiagramOutlinePageListener listener : this.listeners) {
                    listener.activate(0);
                    listener.deactivate(1);
                }
                break;
            }
            case 1: {
                Diagram diagram;
                EObject element;
                if (!this.overviewInitialized) {
                    this.initializeOverview();
                }
                this.showOutlineAction.setChecked(false);
                this.showOverviewAction.setChecked(true);
                this.showPage((Control)this.overview);
                if (this.thumbnail != null) {
                    this.thumbnail.setVisible(true);
                }
                if (!(this.input instanceof Diagram) || (element = (diagram = (Diagram)this.input).getElement()) == null) break;
                for (DiagramOutlinePageListener listener : this.listeners) {
                    listener.deactivate(0);
                    listener.activate(1);
                }
                break;
            }
        }
    }

    public Control getEditor() {
        return this.graphicalViewer.getControl();
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        for (IObjectActionDelegateWrapper action : this.menuContributions) {
            action.getWrappedAction().selectionChanged(null, (ISelection)new TreeSelectionWrapper((IStructuredSelection)event.getSelection(), this.graphicalViewer));
            action.selectionChanged((ISelection)new TreeSelectionWrapper((IStructuredSelection)event.getSelection(), this.graphicalViewer));
        }
    }

    public static class TreeSelectionWrapper
    implements IStructuredSelection {
        private GraphicalViewer viewer;
        private IStructuredSelection selection;

        public TreeSelectionWrapper(IStructuredSelection selection, GraphicalViewer viewer) {
            this.selection = selection;
            this.viewer = viewer;
        }

        public GraphicalViewer getViewer() {
            return this.viewer;
        }

        public RootEditPart getRoot() {
            return this.viewer.getRootEditPart();
        }

        public boolean isEmpty() {
            return this.selection.isEmpty();
        }

        public Object getFirstElement() {
            return this.selection.getFirstElement();
        }

        public Iterator<?> iterator() {
            return this.selection.iterator();
        }

        public int size() {
            return this.selection.size();
        }

        public Object[] toArray() {
            return this.selection.toArray();
        }

        public List<?> toList() {
            return this.selection.toList();
        }
    }
}

