/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.decoration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.AbstractSiriusDecorationDescriptorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.DecorationDescriptor;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.SiriusDecorationDescriptorProvider;
import org.eclipse.sirius.viewpoint.description.DecorationDistributionDirection;
import org.eclipse.sirius.viewpoint.description.Position;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ValidationDecorationDescriptorProvider
extends AbstractSiriusDecorationDescriptorProvider
implements SiriusDecorationDescriptorProvider {
    private static final String NAME = "validationStatus";
    private static final String MARKER_TYPE = "org.eclipse.sirius.diagram.ui.diagnostic";
    private static MarkerObserver fileObserver;
    private static Map<String, IDecorator> viewIdToDecorator;
    private static Map<GraphicalEditPart, String> editPartToViewId;

    static {
        viewIdToDecorator = new HashMap<String, IDecorator>();
        editPartToViewId = new HashMap<GraphicalEditPart, String>();
    }

    @Override
    public boolean provides(IDiagramElementEditPart editPart) {
        EditDomain ed;
        View view;
        Object model;
        boolean provides = false;
        if ((editPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) && (model = editPart.getModel()) instanceof View && ((view = (View)model) instanceof Edge || view.isSetElement()) && view.eResource() != null && (ed = editPart.getViewer().getEditDomain()) instanceof DiagramEditDomain) {
            provides = "Sirius".equals(SiriusVisualIDRegistry.getModelID(view));
        }
        return provides;
    }

    @Override
    public List<DecorationDescriptor> createDecorationDescriptors(IDiagramElementEditPart editPart, Session session) {
        Resource markedResource;
        IFile resource;
        View view = (View)editPart.getModel();
        String elementId = SiriusGMFHelper.getViewId(view);
        if (elementId != null && (resource = WorkspaceSynchronizer.getFile((Resource)(markedResource = session == null ? null : session.getSessionResource()))) != null && resource.exists()) {
            IMarker[] markers = null;
            try {
                markers = resource.findMarkers(MARKER_TYPE, true, 2);
            }
            catch (CoreException e) {
                DiagramPlugin.getDefault().logError(Messages.StatusDecorator_validationMarkersFailureMsg, (Throwable)e);
            }
            if (markers != null && markers.length > 0) {
                return this.doCreateDecorationDescriptors(markers, elementId);
            }
        }
        return new ArrayList<DecorationDescriptor>();
    }

    private List<DecorationDescriptor> doCreateDecorationDescriptors(IMarker[] markers, String elementId) {
        int severity = 0;
        IMarker foundMarker = null;
        Label toolTip = null;
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            String attribute = marker.getAttribute("elementId", "");
            if (attribute.equals(elementId)) {
                int nextSeverity = marker.getAttribute("severity", 0);
                Image nextImage = this.getImage(nextSeverity);
                if (foundMarker == null) {
                    foundMarker = marker;
                    toolTip = new Label(marker.getAttribute("message", ""), nextImage);
                } else {
                    if (toolTip.getChildren().isEmpty()) {
                        Label comositeLabel = new Label();
                        FlowLayout fl = new FlowLayout(false);
                        fl.setMinorSpacing(0);
                        comositeLabel.setLayoutManager((LayoutManager)fl);
                        comositeLabel.add((IFigure)toolTip);
                        toolTip = comositeLabel;
                    }
                    toolTip.add((IFigure)new Label(marker.getAttribute("message", ""), nextImage));
                }
                severity = nextSeverity > severity ? nextSeverity : severity;
            }
            ++i;
        }
        if (foundMarker == null) {
            return new ArrayList<DecorationDescriptor>();
        }
        DecorationDescriptor decoDesc = new DecorationDescriptor();
        decoDesc.setName(NAME);
        decoDesc.setPosition(Position.NORTH_EAST_LITERAL);
        decoDesc.setDistributionDirection(DecorationDistributionDirection.HORIZONTAL);
        decoDesc.setDisplayPriority(DecorationDescriptor.DisplayPriority.HIGH_PRIORITY.getValue());
        decoDesc.setDecorationAsImage(this.getImage(severity));
        decoDesc.setTooltipAsFigure((IFigure)toolTip);
        return Arrays.asList(decoDesc);
    }

    private Image getImage(int severity) {
        String imageName = "IMG_OBJS_ERROR_TSK";
        switch (severity) {
            case 2: {
                imageName = "IMG_OBJS_ERROR_TSK";
                break;
            }
            case 1: {
                imageName = "IMG_OBJS_WARN_TSK";
                break;
            }
            default: {
                imageName = "IMG_OBJS_INFO_TSK";
            }
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
    }

    @Override
    public void activate(IDecoratorTarget decoratorTarget, IDecorator decorator, GraphicalEditPart editPart) {
        String viewId;
        View view = (View)decoratorTarget.getAdapter(View.class);
        if (view != null && (viewId = this.getViewId(view)) != null) {
            editPartToViewId.put(editPart, viewId);
            viewIdToDecorator.put(viewId, decorator);
            Diagram diagramView = view.getDiagram();
            if (diagramView == null) {
                return;
            }
            if (fileObserver == null) {
                fileObserver = new MarkerObserver(diagramView);
                FileChangeManager.getInstance().addFileObserver((IFileObserver)fileObserver);
            }
        }
    }

    @Override
    public void deactivate(IDecorator decorator, GraphicalEditPart editPart) {
        String viewId = editPartToViewId.get(editPart);
        editPartToViewId.remove(editPart);
        if (viewId != null) {
            viewIdToDecorator.remove(viewId);
            if (fileObserver != null && viewIdToDecorator.isEmpty()) {
                FileChangeManager.getInstance().removeFileObserver((IFileObserver)fileObserver);
                fileObserver = null;
            }
        }
    }

    private String getViewId(final View view) {
        final ArrayList listString = new ArrayList();
        try {
            TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)view);
            if (ted == null) {
                listString.add(null);
            } else {
                ted.runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        listString.add(view != null ? SiriusGMFHelper.getViewId(view) : null);
                    }
                });
            }
        }
        catch (InterruptedException e) {
            DiagramPlugin.getDefault().logError(Messages.StatusDecorator_viewIdAccessFailureMsg, (Throwable)e);
        }
        return (String)listString.get(0);
    }

    static final class MarkerObserver
    implements IFileObserver {
        private Diagram diagram;

        private MarkerObserver(Diagram diagram) {
            this.diagram = diagram;
        }

        public void handleFileRenamed(IFile oldFile, IFile file) {
        }

        public void handleFileMoved(IFile oldFile, IFile file) {
        }

        public void handleFileDeleted(IFile file) {
        }

        public void handleFileChanged(IFile file) {
        }

        public void handleMarkerAdded(IMarker marker) {
            if (marker.getAttribute("elementId", null) != null) {
                this.handleMarkerChanged(marker);
            }
        }

        public void handleMarkerDeleted(IMarker marker, Map attributes) {
            if (attributes != null) {
                String viewId = (String)attributes.get("elementId");
                MarkerObserver.refreshDecorators(viewId, this.diagram);
            }
        }

        public void handleMarkerChanged(IMarker marker) {
            if (!ValidationDecorationDescriptorProvider.MARKER_TYPE.equals(this.getType(marker))) {
                return;
            }
            String viewId = marker.getAttribute("elementId", "");
            MarkerObserver.refreshDecorators(viewId, this.diagram);
        }

        private String getType(IMarker marker) {
            try {
                return marker.getType();
            }
            catch (CoreException e) {
                DiagramPlugin.getDefault().logError(Messages.MarkerObserver_validationMarkerFailureMsg, (Throwable)e);
                return "";
            }
        }

        private static void refreshDecorators(String viewId, Diagram diagram) {
            IDecorator decorator;
            IDecorator iDecorator = decorator = viewId != null ? (IDecorator)viewIdToDecorator.get(viewId) : null;
            if (decorator == null || diagram == null) {
                return;
            }
            final Diagram fdiagram = diagram;
            EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        TransactionUtil.getEditingDomain((EObject)fdiagram).runExclusive(new Runnable(){

                            @Override
                            public void run() {
                                decorator.refresh();
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        DiagramPlugin.getDefault().logError(Messages.SiriusValidationDecoratorProvider_refreshFailureMsg, (Throwable)e);
                    }
                }
            });
        }
    }
}

