/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.sirius.editor.properties.sections.common.ModelViewBinding;
import org.eclipse.sirius.editor.utils.TextWithContentAssistChangeHelper;
import org.eclipse.sirius.ext.swt.TextChangeListener;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractTextWithButtonPropertySection
extends AbstractViewpointPropertySection
implements ModelViewBinding {
    private final String RETURN_TYPE = "http://www.eclipse.org/sirius/interpreted/expression/returnType";
    private final String VARIABLES = "http://www.eclipse.org/sirius/interpreted/expression/variables";
    protected Text text;
    protected CLabel nameLabel;
    protected Composite composite;
    protected TextChangeListener listener;
    protected Button button;
    private boolean handleModifications;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        if (tabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)tabbedPropertySheetPage);
        } else {
            super.createControls(parent, tabbedPropertySheetPage);
        }
        boolean hasButton = this.getFeature().getEType() != DescriptionPackage.Literals.INTERPRETED_EXPRESSION;
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.text = this.getWidgetFactory().createText(this.composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = hasButton ? new FormAttachment(95, 0) : new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.text.setLayoutData((Object)data);
        if (hasButton) {
            this.button = this.getWidgetFactory().createButton(this.composite, "...", 8);
            data = new FormData();
            data.left = new FormAttachment(95, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.text, 0, 0x1000000);
            this.button.setLayoutData((Object)data);
        }
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.text, -25);
        data.top = new FormAttachment((Control)this.text, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        if (hasButton) {
            this.button.addSelectionListener(this.createButtonListener());
        }
        this.listener = new TextWithContentAssistChangeHelper(){

            @Override
            public void textChanged(Text control) {
                AbstractTextWithButtonPropertySection.this.handleTextModified();
            }
        };
        this.listener.startListeningTo(this.text);
        this.listener.startListeningForEnter(this.text);
        this.enableModelUpdating();
    }

    protected abstract SelectionListener createButtonListener();

    public void aboutToBeShown() {
        super.aboutToBeShown();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.sirius." + this.eObject.eClass().getName());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
    }

    public TextChangeListener getListener() {
        return this.listener;
    }

    protected void handleTextModified() {
        String newText;
        boolean equals;
        if (this.isActive() && !(equals = this.isEqual(newText = this.text.getText()))) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            Object value = this.getFeatureValue(newText);
            if (value instanceof String && StringUtil.isEmpty((String)((String)value))) {
                value = this.getFeature() != null && !StringUtil.isEmpty((String)this.getFeature().getDefaultValueLiteral()) ? "" : null;
            }
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    @Override
    public void disableModelUpdating() {
        this.handleModifications = false;
    }

    @Override
    public void enableModelUpdating() {
        this.handleModifications = true;
    }

    protected boolean isActive() {
        return this.handleModifications;
    }

    public void refresh() {
        String tooltip;
        String value = this.getFeatureAsText();
        if (!StringUtil.equals((CharSequence)value, (CharSequence)this.text.getText())) {
            this.text.setText(value);
        }
        if ((tooltip = this.getToolTipText()) != null) {
            this.text.setToolTipText(this.getToolTipText());
        }
    }

    protected abstract boolean isEqual(String var1);

    public abstract EAttribute getFeature();

    protected abstract String getPropertyDescription();

    protected String getToolTipText() {
        EAttribute exp = this.getFeature();
        if (!DescriptionPackage.eINSTANCE.getInterpretedExpression().equals(exp.getEAttributeType())) {
            return this.getPropertyDescription();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPropertyDescription());
        this.addNewLine(sb);
        this.appendReturnTypeDetails(exp, sb);
        this.appendVariablesDetails(exp, sb);
        return sb.toString();
    }

    protected void appendReturnTypeDetails(EAttribute exp, StringBuilder sb) {
        EAnnotation returnTypes = exp.getEAnnotation("http://www.eclipse.org/sirius/interpreted/expression/returnType");
        if (returnTypes != null && !returnTypes.getDetails().isEmpty()) {
            this.addNewLine(sb);
            sb.append("Expected return type: ");
            sb.append((String)((Map.Entry)returnTypes.getDetails().iterator().next()).getValue());
            sb.append("\n");
        }
    }

    protected void appendVariablesDetails(EAttribute exp, StringBuilder sb) {
        EAnnotation overrideAnnotation = this.eObject.eClass().getEAnnotation("http://www.eclipse.org/sirius/interpreted/expression/variables_" + exp.getName());
        EAnnotation variables = overrideAnnotation == null || overrideAnnotation.getDetails().isEmpty() ? exp.getEAnnotation("http://www.eclipse.org/sirius/interpreted/expression/variables") : overrideAnnotation;
        if (variables != null && !variables.getDetails().isEmpty()) {
            this.addNewLine(sb);
            sb.append("Available variables:");
            for (Map.Entry variable : variables.getDetails().entrySet()) {
                sb.append("\n . ");
                sb.append((String)variable.getKey());
                sb.append(": ");
                sb.append((String)variable.getValue());
            }
        }
    }

    private void addNewLine(StringBuilder sb) {
        if (!StringUtil.isEmpty((String)sb.toString())) {
            sb.append("\n");
        }
    }

    protected String getDefaultFeatureAsText() {
        String value = new String();
        if (this.eObject.eGet((EStructuralFeature)this.getFeature()) != null) {
            value = this.eObject.eGet((EStructuralFeature)this.getFeature()).toString();
        }
        return value;
    }

    protected String getFeatureAsText() {
        EAttribute eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor((EStructuralFeature)eFeature);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getLabelProvider((Object)this.eObject).getText(this.eObject.eGet((EStructuralFeature)eFeature));
        }
        return this.getDefaultFeatureAsText();
    }

    protected abstract Object getFeatureValue(String var1);

    protected abstract String getDefaultLabelText();

    protected String getLabelText() {
        EAttribute eFeature;
        IItemPropertyDescriptor propertyDescriptor;
        if (this.eObject != null && (propertyDescriptor = this.getPropertyDescriptor((EStructuralFeature)(eFeature = this.getFeature()))) != null) {
            return propertyDescriptor.getDisplayName((Object)this.eObject);
        }
        return this.getDefaultLabelText();
    }

    @Override
    protected void makeReadonly() {
        this.text.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.text.setEnabled(true);
    }
}

