/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class LostMessageEnd
extends AbstractSequenceNode {
    public static final int VISUAL_ID = 2001;

    LostMessageEnd(Node node) {
        super(node);
        Preconditions.checkArgument((boolean)LostMessageEnd.notationPredicate().apply((Object)node), (Object)Messages.LostMessage_nonLostMessageEndNode);
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 2001, LostMessageEnd.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    public Option<Message> getMessage() {
        Message msg = null;
        Node node = this.getNotationNode();
        Iterable srcEdges = Iterables.filter((Iterable)node.getSourceEdges(), Edge.class);
        Iterable tgtEdges = Iterables.filter((Iterable)node.getTargetEdges(), Edge.class);
        for (Edge edge : Iterables.concat((Iterable)srcEdges, (Iterable)tgtEdges)) {
            Option<Message> message = ISequenceElementAccessor.getMessage((View)edge);
            if (!message.some()) continue;
            msg = (Message)message.get();
            break;
        }
        return Options.newSome(msg);
    }

    @Override
    public Option<Lifeline> getLifeline() {
        return Options.newNone();
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        if (this.getNotationNode().getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)this.getNotationNode().getLayoutConstraint();
            return new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        }
        throw new RuntimeException();
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            boolean result = AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getNodeMapping());
            if (input instanceof EdgeTarget) {
                EdgeTarget et = (EdgeTarget)input;
                result = result && Iterables.any((Iterable)Iterables.concat((Iterable)et.getIncomingEdges(), (Iterable)et.getOutgoingEdges()), Message.viewpointElementPredicate());
            }
            ArrayList potentialMessageTarget = Lists.newArrayList();
            potentialMessageTarget.add(EndOfLife.viewpointElementPredicate());
            potentialMessageTarget.add(AbstractNodeEvent.viewpointElementPredicate());
            potentialMessageTarget.add(Lifeline.viewpointElementPredicate());
            potentialMessageTarget.add(InstanceRole.viewpointElementPredicate());
            result = result && !Predicates.or((Iterable)potentialMessageTarget).apply((Object)input);
            return result;
        }
    }
}

