/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StringMatcher;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceListSelectionDialog
extends SelectionDialog {
    private static final String DIALOG_SETTINGS_SECTION = "ResourceListSelectionDialogSettings";
    Text pattern;
    Table resourceNames;
    Table folderNames;
    String patternString;
    IContainer container;
    int typeMask;
    private static Collator collator = Collator.getInstance();
    boolean gatherResourcesDynamically = true;
    StringMatcher stringMatcher;
    UpdateFilterThread updateFilterThread;
    UpdateGatherThread updateGatherThread;
    ResourceDescriptor[] descriptors;
    int descriptorsSize;
    WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
    boolean okEnabled = false;
    private boolean showDerived = false;
    private Button showDerivedButton;
    private boolean allowUserToToggleDerived;

    public ResourceListSelectionDialog(Shell parentShell, IResource[] resources) {
        super(parentShell);
        this.gatherResourcesDynamically = false;
        this.initDescriptors(resources);
    }

    public ResourceListSelectionDialog(Shell parentShell, IContainer container, int typeMask) {
        super(parentShell);
        this.container = container;
        this.typeMask = typeMask;
    }

    protected String adjustPattern() {
        String text = this.pattern.getText().trim();
        if (text.endsWith("<")) {
            return text.substring(0, text.length() - 1);
        }
        if (!text.equals("") && !text.endsWith("*")) {
            return String.valueOf(text) + "*";
        }
        return text;
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    public boolean close() {
        boolean result = super.close();
        this.labelProvider.dispose();
        return result;
    }

    public void create() {
        super.create();
        this.pattern.setFocus();
        this.getButton(0).setEnabled(this.okEnabled);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label l = new Label(dialogArea, 0);
        l.setText(IDEWorkbenchMessages.ResourceSelectionDialog_label);
        GridData data = new GridData(768);
        l.setLayoutData((Object)data);
        this.pattern = new Text(dialogArea, 2052);
        this.pattern.setLayoutData((Object)new GridData(768));
        l = new Label(dialogArea, 0);
        l.setText(IDEWorkbenchMessages.ResourceSelectionDialog_matching);
        data = new GridData(768);
        l.setLayoutData((Object)data);
        this.resourceNames = new Table(dialogArea, 2564);
        data = new GridData(1808);
        data.heightHint = 12 * this.resourceNames.getItemHeight();
        this.resourceNames.setLayoutData((Object)data);
        l = new Label(dialogArea, 0);
        l.setText(IDEWorkbenchMessages.ResourceSelectionDialog_folders);
        data = new GridData(768);
        l.setLayoutData((Object)data);
        this.folderNames = new Table(dialogArea, 2820);
        data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 4 * this.folderNames.getItemHeight();
        this.folderNames.setLayoutData((Object)data);
        if (this.gatherResourcesDynamically) {
            this.updateGatherThread = new UpdateGatherThread();
        } else {
            this.updateFilterThread = new UpdateFilterThread();
        }
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ResourceListSelectionDialog.this.resourceNames.setFocus();
                }
            }
        });
        this.pattern.addModifyListener(e -> this.refresh(false));
        this.resourceNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceListSelectionDialog.this.updateFolders((ResourceDescriptor)e.item.getData());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourceListSelectionDialog.this.okPressed();
            }
        });
        this.folderNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourceListSelectionDialog.this.okPressed();
            }
        });
        if (this.getAllowUserToToggleDerived()) {
            this.showDerivedButton = new Button(dialogArea, 32);
            this.showDerivedButton.setText(IDEWorkbenchMessages.ResourceSelectionDialog_showDerived);
            this.showDerivedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceListSelectionDialog.this.setShowDerived(ResourceListSelectionDialog.this.showDerivedButton.getSelection());
                    ResourceListSelectionDialog.this.refresh(true);
                }
            });
            this.showDerivedButton.setSelection(this.getShowDerived());
        }
        ResourceListSelectionDialog.applyDialogFont((Control)dialogArea);
        return dialogArea;
    }

    public boolean getAllowUserToToggleDerived() {
        return this.allowUserToToggleDerived;
    }

    public void setAllowUserToToggleDerived(boolean allow) {
        this.allowUserToToggleDerived = allow;
    }

    private void filterResources(boolean force) {
        int matchLength;
        String oldPattern = force ? null : this.patternString;
        this.patternString = this.adjustPattern();
        if (!force && this.patternString.equals(oldPattern)) {
            return;
        }
        this.updateFilterThread.stop = true;
        this.stringMatcher = new StringMatcher(this.patternString, true, false);
        UpdateFilterThread oldThread = this.updateFilterThread;
        this.updateFilterThread = new UpdateFilterThread();
        if (this.patternString.equals("")) {
            this.updateFilterThread.firstMatch = 0;
            this.updateFilterThread.lastMatch = -1;
            this.updateFilterThread.start();
            return;
        }
        if (oldPattern != null && oldPattern.length() != 0 && oldPattern.endsWith("*") && this.patternString.endsWith("*") && this.patternString.regionMatches(0, oldPattern, 0, matchLength = oldPattern.length() - 1)) {
            this.updateFilterThread.firstMatch = oldThread.firstMatch;
            this.updateFilterThread.lastMatch = oldThread.lastMatch;
            this.updateFilterThread.start();
            return;
        }
        this.updateFilterThread.firstMatch = 0;
        this.updateFilterThread.lastMatch = this.descriptorsSize - 1;
        this.updateFilterThread.start();
    }

    private int getFirstMatch() {
        int high = this.descriptorsSize;
        int low = -1;
        boolean match = false;
        ResourceDescriptor desc = new ResourceDescriptor();
        desc.label = this.patternString.substring(0, this.patternString.length() - 1);
        while (high - low > 1) {
            int index = (high + low) / 2;
            String label = this.descriptors[index].label;
            if (this.match(label)) {
                high = index;
                match = true;
                continue;
            }
            int compare = this.descriptors[index].compareTo(desc);
            if (compare == -1) {
                low = index;
                continue;
            }
            high = index;
        }
        if (match) {
            return high;
        }
        return -1;
    }

    private void gatherResources(boolean force) {
        int matchLength;
        String oldPattern = force ? null : this.patternString;
        this.patternString = this.adjustPattern();
        if (!force && this.patternString.equals(oldPattern)) {
            return;
        }
        this.updateGatherThread.stop = true;
        this.updateGatherThread = new UpdateGatherThread();
        if (this.patternString.equals("")) {
            this.updateGatherThread.start();
            return;
        }
        this.stringMatcher = new StringMatcher(this.patternString, true, false);
        if (oldPattern != null && oldPattern.length() != 0 && oldPattern.endsWith("*") && this.patternString.endsWith("*") && this.patternString.regionMatches(0, oldPattern, 0, matchLength = oldPattern.length() - 1)) {
            this.updateGatherThread.refilter = true;
            this.updateGatherThread.firstMatch = 0;
            this.updateGatherThread.lastMatch = this.descriptorsSize - 1;
            this.updateGatherThread.start();
            return;
        }
        ArrayList resources = new ArrayList();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            this.getMatchingResources(resources);
            IResource[] resourcesArray = new IResource[resources.size()];
            resources.toArray(resourcesArray);
            this.initDescriptors(resourcesArray);
        });
        this.updateGatherThread.firstMatch = 0;
        this.updateGatherThread.lastMatch = this.descriptorsSize - 1;
        this.updateGatherThread.start();
    }

    private Image getImage(ResourceDescriptor desc) {
        IResource r = (IResource)desc.resources.get(0);
        return this.labelProvider.getImage((Object)r);
    }

    private int getLastMatch() {
        int high = this.descriptorsSize;
        int low = -1;
        boolean match = false;
        ResourceDescriptor desc = new ResourceDescriptor();
        desc.label = this.patternString.substring(0, this.patternString.length() - 1);
        while (high - low > 1) {
            int index = (high + low) / 2;
            String label = this.descriptors[index].label;
            if (this.match(label)) {
                low = index;
                match = true;
                continue;
            }
            int compare = this.descriptors[index].compareTo(desc);
            if (compare == -1) {
                low = index;
                continue;
            }
            high = index;
        }
        if (match) {
            return low;
        }
        return -1;
    }

    private void getMatchingResources(ArrayList resources) {
        try {
            this.container.accept(proxy -> {
                if (!this.getShowDerived() && proxy.isDerived()) {
                    return false;
                }
                int type = proxy.getType();
                if ((this.typeMask & type) != 0 && this.match(proxy.getName())) {
                    IResource res = proxy.requestResource();
                    if (this.select(res)) {
                        resources.add(res);
                        return true;
                    }
                    return false;
                }
                return type != 1;
            }, 0);
        }
        catch (CoreException coreException) {}
    }

    private Image getParentImage(IResource resource) {
        IContainer parent = resource.getParent();
        return this.labelProvider.getImage((Object)parent);
    }

    private String getParentLabel(IResource resource) {
        IContainer parent = resource.getParent();
        String text = parent.getType() == 8 ? this.labelProvider.getText((Object)parent) : parent.getFullPath().makeRelative().toString();
        if (text == null) {
            return "";
        }
        return text;
    }

    protected boolean getShowDerived() {
        return this.showDerived;
    }

    protected void setShowDerived(boolean show) {
        this.showDerived = show;
    }

    private void initDescriptors(IResource[] resources) {
        BusyIndicator.showWhile(null, () -> {
            this.descriptors = new ResourceDescriptor[resources.length];
            int i1 = 0;
            while (i1 < resources.length) {
                IResource r = resources[i1];
                ResourceDescriptor d = new ResourceDescriptor();
                d.label = r.getName();
                d.resources.add(r);
                this.descriptors[i1] = d;
                ++i1;
            }
            Arrays.sort(this.descriptors);
            this.descriptorsSize = this.descriptors.length;
            int index = 0;
            if (this.descriptorsSize < 2) {
                return;
            }
            ResourceDescriptor current = this.descriptors[index];
            IResource currentResource = (IResource)current.resources.get(0);
            int i2 = 1;
            while (i2 < this.descriptorsSize) {
                ResourceDescriptor next = this.descriptors[i2];
                IResource nextResource = (IResource)next.resources.get(0);
                if (nextResource.getType() == currentResource.getType() && next.label.equals(current.label)) {
                    current.resources.add(nextResource);
                    current.resourcesSorted = false;
                } else {
                    if (current.resources.size() > 1) {
                        current.resourcesSorted = false;
                    }
                    this.descriptors[index + 1] = this.descriptors[i2];
                    current = this.descriptors[++index];
                    currentResource = (IResource)current.resources.get(0);
                }
                ++i2;
            }
            this.descriptorsSize = index + 1;
        });
    }

    private boolean match(String label) {
        if (this.patternString == null || this.patternString.equals("") || this.patternString.equals("*")) {
            return true;
        }
        return this.stringMatcher.match(label);
    }

    protected void okPressed() {
        TableItem[] items = this.folderNames.getSelection();
        if (items.length == 1) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(items[0].getData());
            this.setResult(result);
        }
        super.okPressed();
    }

    protected boolean select(IResource resource) {
        return true;
    }

    protected void refresh(boolean force) {
        if (this.gatherResourcesDynamically) {
            this.gatherResources(force);
        } else {
            this.filterResources(force);
        }
    }

    private void updateFolders(ResourceDescriptor desc) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            if (!resourceDescriptor.resourcesSorted) {
                Collections.sort(resourceDescriptor.resources, (o1, o2) -> {
                    String s1 = this.getParentLabel((IResource)o1);
                    String s2 = this.getParentLabel((IResource)o2);
                    return collator.compare(s1, s2);
                });
                resourceDescriptor.resourcesSorted = true;
            }
            this.folderNames.removeAll();
            int i = 0;
            while (i < resourceDescriptor.resources.size()) {
                TableItem newItem = new TableItem(this.folderNames, 0);
                IResource r = (IResource)resourceDescriptor.resources.get(i);
                newItem.setText(this.getParentLabel(r));
                newItem.setImage(this.getParentImage(r));
                newItem.setData((Object)r);
                ++i;
            }
            this.folderNames.setSelection(0);
        });
    }

    private void updateItem(int index, int itemPos, int itemCount) {
        ResourceDescriptor desc = this.descriptors[index];
        if (itemPos < itemCount) {
            TableItem item = this.resourceNames.getItem(itemPos);
            if (item.getData() != desc) {
                item.setText(desc.label);
                item.setData((Object)desc);
                item.setImage(this.getImage(desc));
                if (itemPos == 0) {
                    this.resourceNames.setSelection(0);
                    this.updateFolders(desc);
                }
            }
        } else {
            TableItem item = new TableItem(this.resourceNames, 0);
            item.setText(desc.label);
            item.setData((Object)desc);
            item.setImage(this.getImage(desc));
            if (itemPos == 0) {
                this.resourceNames.setSelection(0);
                this.updateFolders(desc);
            }
        }
        this.updateOKState(true);
    }

    protected void updateOKState(boolean state) {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed() && state != this.okEnabled) {
            okButton.setEnabled(state);
            this.okEnabled = state;
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    static class ResourceDescriptor
    implements Comparable {
        String label;
        ArrayList resources = new ArrayList();
        boolean resourcesSorted = true;

        ResourceDescriptor() {
        }

        public int compareTo(Object o) {
            return collator.compare(this.label, ((ResourceDescriptor)o).label);
        }
    }

    class UpdateFilterThread
    extends Thread {
        boolean stop = false;
        int firstMatch = 0;
        int lastMatch;

        UpdateFilterThread() {
            this.lastMatch = ResourceListSelectionDialog.this.descriptorsSize - 1;
        }

        @Override
        public void run() {
            int last;
            Display display = ResourceListSelectionDialog.this.resourceNames.getDisplay();
            int[] itemIndex = new int[1];
            int[] itemCount = new int[1];
            boolean[] disposed = new boolean[1];
            display.syncExec(() -> {
                if (ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                    blArray[0] = true;
                    return;
                }
                nArray[0] = ResourceListSelectionDialog.this.resourceNames.getItemCount();
            });
            if (disposed[0]) {
                return;
            }
            if (ResourceListSelectionDialog.this.patternString.indexOf(63) == -1 && ResourceListSelectionDialog.this.patternString.endsWith("*") && ResourceListSelectionDialog.this.patternString.indexOf(42) == ResourceListSelectionDialog.this.patternString.length() - 1) {
                this.firstMatch = ResourceListSelectionDialog.this.getFirstMatch();
                if (this.firstMatch == -1) {
                    this.firstMatch = 0;
                    this.lastMatch = -1;
                } else {
                    this.lastMatch = ResourceListSelectionDialog.this.getLastMatch();
                }
                last = this.lastMatch;
                int i = this.firstMatch;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i++;
                    display.syncExec(() -> {
                        if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                            return;
                        }
                        ResourceListSelectionDialog.this.updateItem(index, itemIndex[0], itemCount[0]);
                        nArray[0] = itemIndex[0] + 1;
                    });
                }
            } else {
                last = this.lastMatch;
                boolean setFirstMatch = true;
                int i = this.firstMatch;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i;
                    if (ResourceListSelectionDialog.this.match(ResourceListSelectionDialog.this.descriptors[index].label)) {
                        if (setFirstMatch) {
                            setFirstMatch = false;
                            this.firstMatch = index;
                        }
                        last = index;
                        display.syncExec(() -> {
                            if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                                return;
                            }
                            ResourceListSelectionDialog.this.updateItem(index, itemIndex[0], itemCount[0]);
                            nArray[0] = itemIndex[0] + 1;
                        });
                    }
                    ++i;
                }
            }
            if (disposed[0]) {
                return;
            }
            this.lastMatch = last;
            display.syncExec(() -> {
                if (ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                    return;
                }
                nArray[0] = ResourceListSelectionDialog.this.resourceNames.getItemCount();
                if (itemIndex[0] < itemCount[0]) {
                    ResourceListSelectionDialog.this.resourceNames.setRedraw(false);
                    ResourceListSelectionDialog.this.resourceNames.remove(itemIndex[0], itemCount[0] - 1);
                    ResourceListSelectionDialog.this.resourceNames.setRedraw(true);
                }
                if (ResourceListSelectionDialog.this.resourceNames.getItemCount() == 0) {
                    ResourceListSelectionDialog.this.folderNames.removeAll();
                    ResourceListSelectionDialog.this.updateOKState(false);
                }
            });
        }
    }

    class UpdateGatherThread
    extends Thread {
        boolean stop = false;
        int lastMatch = -1;
        int firstMatch = 0;
        boolean refilter = false;

        UpdateGatherThread() {
        }

        @Override
        public void run() {
            Display display = ResourceListSelectionDialog.this.resourceNames.getDisplay();
            int[] itemIndex = new int[1];
            int[] itemCount = new int[1];
            boolean[] disposed = new boolean[1];
            display.syncExec(() -> {
                if (ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                    blArray[0] = true;
                    return;
                }
                nArray[0] = ResourceListSelectionDialog.this.resourceNames.getItemCount();
            });
            if (disposed[0]) {
                return;
            }
            if (!this.refilter) {
                int i = 0;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i++;
                    display.syncExec(() -> {
                        if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                            return;
                        }
                        ResourceListSelectionDialog.this.updateItem(index, itemIndex[0], itemCount[0]);
                        nArray[0] = itemIndex[0] + 1;
                    });
                }
            } else {
                int i = this.firstMatch;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i;
                    if (ResourceListSelectionDialog.this.match(ResourceListSelectionDialog.this.descriptors[index].label)) {
                        display.syncExec(() -> {
                            if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                                return;
                            }
                            ResourceListSelectionDialog.this.updateItem(index, itemIndex[0], itemCount[0]);
                            nArray[0] = itemIndex[0] + 1;
                        });
                    }
                    ++i;
                }
            }
            if (disposed[0]) {
                return;
            }
            display.syncExec(() -> {
                if (ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                    return;
                }
                nArray[0] = ResourceListSelectionDialog.this.resourceNames.getItemCount();
                if (itemIndex[0] < itemCount[0]) {
                    ResourceListSelectionDialog.this.resourceNames.setRedraw(false);
                    ResourceListSelectionDialog.this.resourceNames.remove(itemIndex[0], itemCount[0] - 1);
                    ResourceListSelectionDialog.this.resourceNames.setRedraw(true);
                }
                if (ResourceListSelectionDialog.this.resourceNames.getItemCount() == 0) {
                    ResourceListSelectionDialog.this.folderNames.removeAll();
                    ResourceListSelectionDialog.this.updateOKState(false);
                }
            });
        }
    }
}

