/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.relations.Relation;

public class VSMResolver {
    private final ViewpointRegistry registry;

    public VSMResolver(ViewpointRegistry regsitry) {
        this.registry = (ViewpointRegistry)Preconditions.checkNotNull((Object)regsitry);
    }

    public Set<URI> resolve(Set<URI> logicalURIs) throws IllegalArgumentException {
        Preconditions.checkNotNull(logicalURIs);
        Set<URI> allLogical = this.computeAllLogicalRequirements(logicalURIs);
        final HashSet missing = Sets.newHashSet();
        Iterable allPhysical = Iterables.transform(allLogical, (Function)new Function<URI, URI>(){

            public URI apply(URI from) {
                Option<URI> provider = VSMResolver.this.registry.getProvider(from);
                if (provider.some()) {
                    return (URI)provider.get();
                }
                missing.add(from);
                return null;
            }
        });
        if (!missing.isEmpty()) {
            String msg = MessageFormat.format("Some of the required logical Sirius URIs could not be resolved to physical resources: {0}.", Joiner.on((String)", ").join((Iterable)missing));
            throw new IllegalArgumentException(msg);
        }
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)allPhysical, (Predicate)Predicates.notNull()));
    }

    private Set<URI> computeAllLogicalRequirements(Set<URI> logicalURIs) {
        HashSet allLogical = Sets.newHashSet();
        Relation<URI> requires = this.registry.getRelations().getTransitiveRequires();
        for (URI uri : logicalURIs) {
            allLogical.add(uri);
            allLogical.addAll(requires.apply((Object)uri));
        }
        return allLogical;
    }
}

