/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.components.BranchNameNormalizer;
import org.eclipse.egit.ui.internal.dialogs.BranchEditDialog;
import org.eclipse.egit.ui.internal.dialogs.NonBlockingWizardDialog;
import org.eclipse.egit.ui.internal.fetch.FetchHeadChangedEvent;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.egit.ui.internal.gerrit.GerritDialogSettings;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.WorkbenchJob;

public class FetchGerritChangePage
extends WizardPage {
    private static final String GERRIT_CHANGE_REF_PREFIX = "refs/changes/";
    private static final Pattern GERRIT_FETCH_PATTERN = Pattern.compile("git fetch (\\w+:\\S+) (refs/changes/\\d+/\\d+/\\d+) && git (\\w+) FETCH_HEAD");
    private static final Pattern GERRIT_URL_PATTERN = Pattern.compile("(?:https?://\\S+?/|/)?([1-9][0-9]*)(?:/([1-9][0-9]*)(?:/([1-9][0-9]*)(?:\\.\\.\\d+)?)?)?(?:/\\S*)?");
    private static final Pattern GERRIT_CHANGE_REF_PATTERN = Pattern.compile("refs/changes/(\\d\\d)/([1-9][0-9]*)(?:/([1-9][0-9]*)?)?");
    private static final SimpleDateFormat SIMPLE_TIMESTAMP = new SimpleDateFormat("yyyyMMddHHmmss");
    private final Repository repository;
    private final IDialogSettings settings;
    private final String lastUriKey;
    private Combo uriCombo;
    private Map<String, ChangeList> changeRefs = new HashMap<String, ChangeList>();
    private Text refText;
    private Button createBranch;
    private Button createTag;
    private Button checkoutFetchHead;
    private Button updateFetchHead;
    private Label tagTextlabel;
    private Text tagText;
    private Label branchTextlabel;
    private Text branchText;
    private String refName;
    private Composite warningAdditionalRefNotActive;
    private Button activateAdditionalRefs;
    private IInputValidator branchValidator;
    private IInputValidator tagValidator;
    private Button branchEditButton;
    private Button branchCheckoutButton;
    private ExplicitContentProposalAdapter contentProposer;
    private boolean branchTextEdited;
    private boolean tagTextEdited;
    private boolean fetching;
    private boolean doAutoFill = true;

    public FetchGerritChangePage(Repository repository, String refName) {
        super(FetchGerritChangePage.class.getName());
        this.repository = repository;
        this.refName = refName;
        this.setTitle(NLS.bind((String)UIText.FetchGerritChangePage_PageTitle, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(repository)));
        this.setMessage(UIText.FetchGerritChangePage_PageMessage);
        this.settings = this.getDialogSettings();
        this.lastUriKey = repository + ".lastUri";
        this.branchValidator = ValidationUtils.getRefNameInputValidator(repository, "refs/heads/", true);
        this.tagValidator = ValidationUtils.getRefNameInputValidator(repository, "refs/tags/", true);
    }

    protected IDialogSettings getDialogSettings() {
        return GerritDialogSettings.getSection(GerritDialogSettings.FETCH_FROM_GERRIT_SECTION);
    }

    public void createControl(Composite parent) {
        IWizardContainer container;
        parent.addDisposeListener(event -> {
            for (ChangeList l : this.changeRefs.values()) {
                l.cancel(ChangeList.CancelMode.INTERRUPT);
            }
            this.changeRefs.clear();
        });
        Clipboard clipboard = new Clipboard(parent.getDisplay());
        String clipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        clipboard.dispose();
        String defaultUri = null;
        String defaultCommand = null;
        String defaultChange = null;
        Change candidateChange = null;
        if (clipText != null) {
            Matcher matcher = GERRIT_FETCH_PATTERN.matcher(clipText);
            if (matcher.matches()) {
                defaultUri = matcher.group(1);
                defaultChange = matcher.group(2);
                defaultCommand = matcher.group(3);
            } else {
                candidateChange = FetchGerritChangePage.determineChangeFromString(clipText.trim());
            }
        }
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        new Label(main, 0).setText(UIText.FetchGerritChangePage_UriLabel);
        this.uriCombo = new Combo(main, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.uriCombo);
        this.uriCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String uriText = FetchGerritChangePage.this.uriCombo.getText();
                ChangeList list = (ChangeList)FetchGerritChangePage.this.changeRefs.get(uriText);
                if (list != null) {
                    list.cancel(ChangeList.CancelMode.INTERRUPT);
                }
                list = new ChangeList(FetchGerritChangePage.this.repository, uriText);
                FetchGerritChangePage.this.changeRefs.put(uriText, list);
                FetchGerritChangePage.this.preFetch(list);
            }
        });
        new Label(main, 0).setText(UIText.FetchGerritChangePage_ChangeLabel);
        this.refText = new Text(main, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.refText);
        this.contentProposer = this.addRefContentProposalToText(this.refText);
        this.refText.addVerifyListener(event -> {
            event.text = event.text.replaceAll("\\v", " ").trim();
        });
        final Group checkoutGroup = new Group(main, 16);
        checkoutGroup.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)checkoutGroup);
        checkoutGroup.setText(UIText.FetchGerritChangePage_AfterFetchGroup);
        this.createBranch = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.createBranch);
        this.createBranch.setText(UIText.FetchGerritChangePage_LocalBranchRadio);
        this.createBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        this.branchCheckoutButton = new Button((Composite)checkoutGroup, 32);
        GridDataFactory.fillDefaults().span(2, 1).align(0x1000008, 0x1000000).applyTo((Control)this.branchCheckoutButton);
        this.branchCheckoutButton.setFont(JFaceResources.getDialogFont());
        this.branchCheckoutButton.setText(UIText.FetchGerritChangePage_LocalBranchCheckout);
        this.branchCheckoutButton.setSelection(true);
        this.branchTextlabel = new Label((Composite)checkoutGroup, 0);
        GridDataFactory.defaultsFor((Control)this.branchTextlabel).exclude(false).applyTo((Control)this.branchTextlabel);
        this.branchTextlabel.setText(UIText.FetchGerritChangePage_BranchNameText);
        this.branchText = new Text((Composite)checkoutGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.branchText);
        this.branchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                FetchGerritChangePage.this.branchTextEdited = true;
            }
        });
        this.branchText.addVerifyListener(event -> {
            if (event.text.isEmpty()) {
                this.branchTextEdited = false;
            }
        });
        this.branchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        BranchNameNormalizer normalizer = new BranchNameNormalizer(this.branchText);
        normalizer.setVisible(false);
        this.branchEditButton = new Button((Composite)checkoutGroup, 8);
        this.branchEditButton.setFont(JFaceResources.getDialogFont());
        this.branchEditButton.setText(UIText.FetchGerritChangePage_BranchEditButton);
        this.branchEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String txt = FetchGerritChangePage.this.branchText.getText();
                String refToMark = "".equals(txt) ? null : "refs/heads/" + txt;
                BranchEditDialog dlg = new BranchEditDialog(checkoutGroup.getShell(), FetchGerritChangePage.this.repository, refToMark);
                if (dlg.open() == 0) {
                    FetchGerritChangePage.this.branchText.setText(Repository.shortenRefName((String)dlg.getRefName()));
                    FetchGerritChangePage.this.branchTextEdited = true;
                } else {
                    FetchGerritChangePage.this.branchText.setText(FetchGerritChangePage.this.branchText.getText());
                }
            }
        });
        GridDataFactory.defaultsFor((Control)this.branchEditButton).exclude(false).applyTo((Control)this.branchEditButton);
        this.createTag = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.createTag);
        this.createTag.setText(UIText.FetchGerritChangePage_TagRadio);
        this.createTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        this.tagTextlabel = new Label((Composite)checkoutGroup, 0);
        GridDataFactory.defaultsFor((Control)this.tagTextlabel).exclude(true).applyTo((Control)this.tagTextlabel);
        this.tagTextlabel.setText(UIText.FetchGerritChangePage_TagNameText);
        this.tagText = new Text((Composite)checkoutGroup, 2052);
        GridDataFactory.fillDefaults().exclude(true).grab(true, false).applyTo((Control)this.tagText);
        this.tagText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                FetchGerritChangePage.this.tagTextEdited = true;
            }
        });
        this.tagText.addVerifyListener(event -> {
            if (event.text.isEmpty()) {
                this.tagTextEdited = false;
            }
        });
        this.tagText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        BranchNameNormalizer tagNormalizer = new BranchNameNormalizer(this.tagText, UIText.BranchNameNormalizer_TooltipForTag);
        tagNormalizer.setVisible(false);
        this.checkoutFetchHead = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.checkoutFetchHead);
        this.checkoutFetchHead.setText(UIText.FetchGerritChangePage_CheckoutRadio);
        this.checkoutFetchHead.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        this.updateFetchHead = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.updateFetchHead);
        this.updateFetchHead.setText(UIText.FetchGerritChangePage_UpdateRadio);
        this.updateFetchHead.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FetchGerritChangePage.this.checkPage();
            }
        });
        if ("checkout".equals(defaultCommand)) {
            this.checkoutFetchHead.setSelection(true);
        } else {
            this.createBranch.setSelection(true);
        }
        this.warningAdditionalRefNotActive = new Composite(main, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).exclude(true).applyTo((Control)this.warningAdditionalRefNotActive);
        this.warningAdditionalRefNotActive.setLayout((Layout)new GridLayout(2, false));
        this.warningAdditionalRefNotActive.setVisible(false);
        this.activateAdditionalRefs = new Button(this.warningAdditionalRefNotActive, 32);
        this.activateAdditionalRefs.setText(UIText.FetchGerritChangePage_ActivateAdditionalRefsButton);
        this.activateAdditionalRefs.setToolTipText(UIText.FetchGerritChangePage_ActivateAdditionalRefsTooltip);
        ActionUtils.setGlobalActions((Control)this.refText, ActionUtils.createGlobalAction(ActionFactory.PASTE, () -> this.doPaste(this.refText)));
        this.refText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Change change = FetchGerritChangePage.determineChangeFromString(FetchGerritChangePage.this.refText.getText());
                String suggestion = "";
                if (change != null) {
                    Object ps = change.getPatchSetNumber();
                    if (ps == null) {
                        ps = SIMPLE_TIMESTAMP.format(new Date());
                    }
                    suggestion = NLS.bind((String)UIText.FetchGerritChangePage_SuggestedRefNamePattern, (Object)change.getChangeNumber(), (Object)ps);
                }
                if (!FetchGerritChangePage.this.branchTextEdited) {
                    FetchGerritChangePage.this.branchText.setText(suggestion);
                }
                if (!FetchGerritChangePage.this.tagTextEdited) {
                    FetchGerritChangePage.this.tagText.setText(suggestion);
                }
                FetchGerritChangePage.this.checkPage();
            }
        });
        if (defaultChange != null) {
            this.refText.setText(defaultChange);
        } else if (candidateChange != null) {
            String ref = candidateChange.getRefName();
            if (ref != null) {
                this.refText.setText(ref);
            } else {
                this.refText.setText(candidateChange.getChangeNumber().toString());
            }
        }
        TreeSet<String> uris = new TreeSet<String>();
        try {
            for (RemoteConfig rc : RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig())) {
                if (!GerritUtil.isGerritFetch((RemoteConfig)rc)) continue;
                if (rc.getURIs().size() > 0) {
                    uris.add(((URIish)rc.getURIs().get(0)).toPrivateString());
                }
                for (URIish u : rc.getPushURIs()) {
                    uris.add(u.toPrivateString());
                }
            }
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, false);
            this.setErrorMessage(e.getMessage());
        }
        for (String aUri : uris) {
            this.uriCombo.add(aUri);
            this.changeRefs.put(aUri, new ChangeList(this.repository, aUri));
        }
        if (defaultUri != null) {
            this.uriCombo.setText(defaultUri);
        } else {
            this.selectLastUsedUri();
        }
        String currentUri = this.uriCombo.getText();
        ChangeList list = this.changeRefs.get(currentUri);
        if (list == null) {
            list = new ChangeList(this.repository, currentUri);
            this.changeRefs.put(currentUri, list);
        }
        this.preFetch(list);
        this.refText.setFocus();
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
        if (candidateChange != null && (container = this.getContainer()) instanceof IPageChangeProvider) {
            ((IPageChangeProvider)container).addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (event.getSelectedPage() == FetchGerritChangePage.this) {
                        event.getPageChangeProvider().removePageChangedListener((IPageChangedListener)this);
                        FetchGerritChangePage.this.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Control control = FetchGerritChangePage.this.getControl();
                                if (control != null && !control.isDisposed()) {
                                    FetchGerritChangePage.this.contentProposer.openProposalPopup();
                                }
                            }
                        });
                    }
                }
            });
        }
        this.checkPage();
    }

    private void preFetch(ChangeList list) {
        try {
            list.fetch();
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getLocalizedMessage(), e.getCause(), true);
        }
    }

    protected static Change determineChangeFromString(String input) {
        if (input == null) {
            return null;
        }
        try {
            Matcher matcher = GERRIT_URL_PATTERN.matcher(input);
            if (matcher.matches()) {
                String first = matcher.group(1);
                String second = matcher.group(2);
                String third = matcher.group(3);
                if (second != null && !second.isEmpty()) {
                    int secondNum;
                    if (third != null && !third.isEmpty()) {
                        return Change.create(Integer.parseInt(second), Integer.parseInt(third));
                    }
                    if (input.startsWith("http")) {
                        return Change.create(Integer.parseInt(first), Integer.parseInt(second));
                    }
                    int firstNum = Integer.parseInt(first);
                    if (firstNum > (secondNum = Integer.parseInt(second))) {
                        return Change.create(firstNum, secondNum);
                    }
                    return Change.create(secondNum);
                }
                return Change.create(Integer.parseInt(first));
            }
            matcher = GERRIT_CHANGE_REF_PATTERN.matcher(input);
            if (matcher.matches()) {
                int firstNum = Integer.parseInt(matcher.group(2));
                String second = matcher.group(3);
                if (second != null) {
                    return Change.create(firstNum, Integer.parseInt(second));
                }
                return Change.create(firstNum);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private void doPaste(Text text) {
        block7: {
            Clipboard clipboard = new Clipboard(text.getDisplay());
            try {
                String clipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (clipText == null) break block7;
                Change input = FetchGerritChangePage.determineChangeFromString(clipText.trim());
                if (input != null) {
                    String toInsert = input.getChangeNumber().toString();
                    if (input.getPatchSetNumber() != null) {
                        toInsert = text.getText().trim().isEmpty() || text.getSelectionText().equals(text.getText()) ? input.getRefName() : String.valueOf(toInsert) + '/' + input.getPatchSetNumber();
                    }
                    clipboard.setContents(new Object[]{toInsert}, new Transfer[]{TextTransfer.getInstance()});
                    try {
                        text.paste();
                    }
                    catch (Throwable throwable) {
                        clipboard.setContents(new Object[]{clipText}, new Transfer[]{TextTransfer.getInstance()});
                        throw throwable;
                    }
                    clipboard.setContents(new Object[]{clipText}, new Transfer[]{TextTransfer.getInstance()});
                    break block7;
                }
                text.paste();
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private void storeLastUsedUri(String uri) {
        this.settings.put(this.lastUriKey, uri.trim());
    }

    private void selectLastUsedUri() {
        int i;
        String lastUri = this.settings.get(this.lastUriKey);
        if (lastUri != null && (i = this.uriCombo.indexOf(lastUri)) != -1) {
            this.uriCombo.select(i);
            return;
        }
        this.uriCombo.select(0);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.refName != null) {
            this.refText.setText(this.refName);
        }
    }

    private void checkPage() {
        boolean createTagSelected;
        boolean createBranchSelected;
        block11: {
            block9: {
                ChangeList list;
                Change change;
                block12: {
                    block10: {
                        createBranchSelected = this.createBranch.getSelection();
                        this.branchText.setEnabled(createBranchSelected);
                        this.branchText.setVisible(createBranchSelected);
                        this.branchTextlabel.setVisible(createBranchSelected);
                        this.branchEditButton.setVisible(createBranchSelected);
                        this.branchCheckoutButton.setVisible(createBranchSelected);
                        GridData gd = (GridData)this.branchText.getLayoutData();
                        gd.exclude = !createBranchSelected;
                        gd = (GridData)this.branchTextlabel.getLayoutData();
                        gd.exclude = !createBranchSelected;
                        gd = (GridData)this.branchEditButton.getLayoutData();
                        gd.exclude = !createBranchSelected;
                        gd = (GridData)this.branchCheckoutButton.getLayoutData();
                        gd.exclude = !createBranchSelected;
                        createTagSelected = this.createTag.getSelection();
                        this.tagText.setEnabled(createTagSelected);
                        this.tagText.setVisible(createTagSelected);
                        this.tagTextlabel.setVisible(createTagSelected);
                        gd = (GridData)this.tagText.getLayoutData();
                        gd.exclude = !createTagSelected;
                        gd = (GridData)this.tagTextlabel.getLayoutData();
                        gd.exclude = !createTagSelected;
                        this.branchText.getParent().layout(true);
                        boolean showActivateAdditionalRefs = false;
                        showActivateAdditionalRefs = (this.checkoutFetchHead.getSelection() || this.updateFetchHead.getSelection()) && !Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_show_additionalrefs");
                        gd = (GridData)this.warningAdditionalRefNotActive.getLayoutData();
                        gd.exclude = !showActivateAdditionalRefs;
                        this.warningAdditionalRefNotActive.setVisible(showActivateAdditionalRefs);
                        this.warningAdditionalRefNotActive.getParent().layout(true);
                        this.setErrorMessage(null);
                        try {
                            if (this.refText.getText().length() <= 0) break block9;
                            change = Change.fromRef(this.refText.getText());
                            if (change != null || (change = FetchGerritChangePage.determineChangeFromString(this.refText.getText())) != null) break block10;
                            this.setErrorMessage(UIText.FetchGerritChangePage_MissingChangeMessage);
                        }
                        catch (Throwable throwable) {
                            this.setPageComplete(this.getErrorMessage() == null);
                            throw throwable;
                        }
                        this.setPageComplete(this.getErrorMessage() == null);
                        return;
                    }
                    list = this.changeRefs.get(this.uriCombo.getText());
                    if (list == null || !list.isDone()) break block11;
                    if (change.getPatchSetNumber() == null) break block12;
                    if (list.getResult().contains(change)) break block11;
                    this.setErrorMessage(UIText.FetchGerritChangePage_UnknownChangeRefMessage);
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                Change fromGerrit = this.findHighestPatchSet(list.getResult(), change.getChangeNumber());
                if (fromGerrit != null) break block11;
                this.setErrorMessage(NLS.bind((String)UIText.FetchGerritChangePage_NoSuchChangeMessage, (Object)change.getChangeNumber()));
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            this.setErrorMessage(UIText.FetchGerritChangePage_MissingChangeMessage);
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (createBranchSelected) {
            this.setErrorMessage(this.branchValidator.isValid(this.branchText.getText()));
        } else if (createTagSelected) {
            this.setErrorMessage(this.tagValidator.isValid(this.tagText.getText()));
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private Collection<Change> getRefsForContentAssist(final String originalRefText) throws InvocationTargetException, InterruptedException {
        ChangeList list;
        final String uriText = this.uriCombo.getText();
        if (!this.changeRefs.containsKey(uriText)) {
            this.changeRefs.put(uriText, new ChangeList(this.repository, uriText));
        }
        if (!(list = this.changeRefs.get(uriText)).isFinished()) {
            final IWizardContainer container = this.getContainer();
            IRunnableWithProgress operation = monitor -> {
                monitor.beginTask(MessageFormat.format(UIText.FetchGerritChangePage_FetchingRemoteRefsMessage, uriText), -1);
                final Collection<Change> result = list.get();
                if (monitor.isCanceled()) {
                    return;
                }
                if (result == null || result.isEmpty() || this.fetching) {
                    return;
                }
                WorkbenchJob showProposals = new WorkbenchJob(UIText.FetchGerritChangePage_ShowingProposalsJobName){

                    public boolean shouldRun() {
                        return super.shouldRun() && !FetchGerritChangePage.this.fetching;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public IStatus runInUIThread(IProgressMonitor uiMonitor) {
                        try {
                            if (!(container instanceof NonBlockingWizardDialog)) ** GOTO lbl18
                            if (FetchGerritChangePage.access$15(FetchGerritChangePage.this)) {
                                var4_2 = Status.CANCEL_STATUS;
                                return var4_2;
                            }
                            uriNow = FetchGerritChangePage.access$1(FetchGerritChangePage.this).getText();
                            if (!uriNow.equals(uriText)) {
                                var4_3 = Status.CANCEL_STATUS;
                                return var4_3;
                            }
                            if (FetchGerritChangePage.access$9(FetchGerritChangePage.this) != FetchGerritChangePage.access$9(FetchGerritChangePage.this).getDisplay().getFocusControl()) {
                                FetchGerritChangePage.access$17(FetchGerritChangePage.this, result, null);
                                var4_4 = Status.CANCEL_STATUS;
                                return var4_4;
                            }
                            try {
                                block12: {
                                    FetchGerritChangePage.access$17(FetchGerritChangePage.this, result, originalRefText);
                                    FetchGerritChangePage.access$16(FetchGerritChangePage.this, false);
                                    break block12;
lbl18:
                                    // 1 sources

                                    FetchGerritChangePage.access$17(FetchGerritChangePage.this, result, null);
                                    FetchGerritChangePage.access$16(FetchGerritChangePage.this, false);
                                }
                                FetchGerritChangePage.access$14(FetchGerritChangePage.this).openProposalPopup();
                            }
                            catch (SWTException e) {
                                var4_5 = Status.CANCEL_STATUS;
                                return var4_5;
                            }
                        }
                        finally {
                            FetchGerritChangePage.access$16(FetchGerritChangePage.this, true);
                            uiMonitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                showProposals.schedule();
            };
            if (container instanceof NonBlockingWizardDialog) {
                NonBlockingWizardDialog dialog = (NonBlockingWizardDialog)container;
                dialog.run(operation, () -> {
                    if (!this.fetching) {
                        list.cancel(ChangeList.CancelMode.ABANDON);
                    }
                });
            } else {
                container.run(true, true, operation);
            }
            return null;
        }
        Collection<Change> changes = list.get();
        if (this.doAutoFill) {
            this.fillInPatchSet(changes, originalRefText);
        }
        return changes;
    }

    private void fillInPatchSet(Collection<Change> changes, String originalText) {
        Change fromGerrit;
        String currentText = this.refText.getText();
        if (this.contentProposer.isProposalPopupOpen() || originalText != null && !originalText.equals(currentText)) {
            return;
        }
        Change change = FetchGerritChangePage.determineChangeFromString(currentText);
        if (change != null && change.getPatchSetNumber() == null && (fromGerrit = this.findHighestPatchSet(changes, change.getChangeNumber())) != null) {
            String fullRef = fromGerrit.getRefName();
            this.refText.setText(fullRef);
            this.refText.setSelection(fullRef.length());
        }
    }

    private Change findHighestPatchSet(Collection<Change> changes, int changeNumber) {
        for (Change fromGerrit : changes) {
            int num = fromGerrit.getChangeNumber();
            if (num < changeNumber) {
                return null;
            }
            if (changeNumber != num) continue;
            return fromGerrit;
        }
        return null;
    }

    boolean doFetch() {
        CheckoutMode mode;
        ChangeList changeList;
        this.fetching = true;
        final Change change = FetchGerritChangePage.determineChangeFromString(this.refText.getText());
        final String uri = this.uriCombo.getText();
        ChangeList changeList2 = changeList = change.getPatchSetNumber() == null ? this.changeRefs.remove(uri) : null;
        if (changeList != null) {
            changeList.cancel(ChangeList.CancelMode.ABANDON);
        }
        final boolean doCheckoutNewBranch = (mode = this.getCheckoutMode()) == CheckoutMode.CREATE_BRANCH && this.branchCheckoutButton.getSelection();
        final boolean doActivateAdditionalRefs = this.showAdditionalRefs();
        final String textForTag = this.tagText.getText();
        final String textForBranch = this.branchText.getText();
        Job job = new Job(UIText.FetchGerritChangePage_GetChangeTaskName){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    final int steps = this.getTotalWork(mode);
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)UIText.FetchGerritChangePage_GetChangeTaskName, (int)(steps + 1));
                    Change finalChange = this.completeChange(change, (IProgressMonitor)progress.newChild(1));
                    if (finalChange == null) {
                        Activator.showError(NLS.bind((String)UIText.FetchGerritChangePage_NoSuchChangeMessage, (Object)change.getChangeNumber()), null);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    final RefSpec spec = new RefSpec().setSource(finalChange.getRefName()).setDestination("FETCH_HEAD");
                    if (progress.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        final RevCommit commit = FetchGerritChangePage.this.fetchChange(uri, spec, (IProgressMonitor)progress.newChild(1));
                        if (mode != CheckoutMode.NOCHECKOUT) {
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                                public void run(IProgressMonitor innerMonitor) throws CoreException {
                                    SubMonitor innerProgress = SubMonitor.convert((IProgressMonitor)innerMonitor, (int)steps);
                                    switch (mode) {
                                        case CHECKOUT_FETCH_HEAD: {
                                            FetchGerritChangePage.this.checkout(commit.name(), (IProgressMonitor)innerProgress.newChild(1));
                                            break;
                                        }
                                        case CREATE_TAG: {
                                            FetchGerritChangePage.this.createTag(spec, textForTag, commit, (IProgressMonitor)innerProgress.newChild(1));
                                            FetchGerritChangePage.this.checkout(commit.name(), (IProgressMonitor)innerProgress.newChild(1));
                                            break;
                                        }
                                        case CREATE_BRANCH: {
                                            FetchGerritChangePage.this.createBranch(textForBranch, doCheckoutNewBranch, commit, (IProgressMonitor)innerProgress.newChild(1));
                                            break;
                                        }
                                    }
                                }
                            };
                            workspace.run(operation, null, 1, (IProgressMonitor)progress.newChild(steps));
                        }
                        if (doActivateAdditionalRefs) {
                            FetchGerritChangePage.this.activateAdditionalRefs();
                        }
                        if (mode == CheckoutMode.NOCHECKOUT) {
                            FetchGerritChangePage.this.repository.fireEvent((RepositoryEvent)new FetchHeadChangedEvent());
                        }
                        FetchGerritChangePage.this.storeLastUsedUri(uri);
                    }
                    catch (OperationCanceledException oe) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (CoreException ce) {
                        IStatus iStatus = ce.getStatus();
                        return iStatus;
                    }
                    catch (Exception e) {
                        IStatus iStatus = Activator.createErrorStatus(e.getLocalizedMessage(), e);
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                super.canceling();
                if (changeList != null) {
                    changeList.cancel(ChangeList.CancelMode.INTERRUPT);
                }
            }

            private Change completeChange(Change originalChange, IProgressMonitor monitor) throws OperationCanceledException {
                if (changeList != null) {
                    Collection<Change> changes;
                    monitor.subTask(NLS.bind((String)UIText.FetchGerritChangePage_FetchingRemoteRefsMessage, (Object)uri));
                    try {
                        changes = changeList.get();
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        throw new OperationCanceledException();
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    return FetchGerritChangePage.this.findHighestPatchSet(changes, originalChange.getChangeNumber());
                }
                return originalChange;
            }

            private int getTotalWork(CheckoutMode m) {
                switch (m) {
                    case CREATE_BRANCH: 
                    case CHECKOUT_FETCH_HEAD: {
                        return 2;
                    }
                    case CREATE_TAG: {
                        return 3;
                    }
                }
                return 1;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.FETCH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    private boolean showAdditionalRefs() {
        return (this.checkoutFetchHead.getSelection() || this.updateFetchHead.getSelection()) && this.activateAdditionalRefs.getSelection();
    }

    private CheckoutMode getCheckoutMode() {
        if (this.createBranch.getSelection()) {
            return CheckoutMode.CREATE_BRANCH;
        }
        if (this.createTag.getSelection()) {
            return CheckoutMode.CREATE_TAG;
        }
        if (this.checkoutFetchHead.getSelection()) {
            return CheckoutMode.CHECKOUT_FETCH_HEAD;
        }
        return CheckoutMode.NOCHECKOUT;
    }

    private RevCommit fetchChange(String uri, RefSpec spec, IProgressMonitor monitor) throws CoreException, URISyntaxException, IOException {
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>(1);
        specs.add(spec);
        String taskName = NLS.bind((String)UIText.FetchGerritChangePage_FetchingTaskName, (Object)spec.getSource());
        monitor.subTask(taskName);
        FetchResult fetchRes = new FetchOperationUI(this.repository, new URIish(uri), specs, timeout, false).execute(monitor);
        monitor.worked(1);
        Throwable throwable = null;
        Object var9_10 = null;
        try (RevWalk rw = new RevWalk(this.repository);){
            return rw.parseCommit((AnyObjectId)fetchRes.getAdvertisedRef(spec.getSource()).getObjectId());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createTag(RefSpec spec, String textForTag, RevCommit commit, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(UIText.FetchGerritChangePage_CreatingTagTaskName);
        TagBuilder tag = new TagBuilder();
        PersonIdent personIdent = new PersonIdent(this.repository);
        tag.setTag(textForTag);
        tag.setTagger(personIdent);
        tag.setMessage(NLS.bind((String)UIText.FetchGerritChangePage_GeneratedTagMessage, (Object)spec.getSource()));
        tag.setObjectId((RevObject)commit);
        new TagOperation(this.repository, tag, false).execute(monitor);
        monitor.worked(1);
    }

    private void createBranch(String textForBranch, boolean doCheckout, RevCommit commit, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(doCheckout ? 10 : 2));
        progress.subTask(UIText.FetchGerritChangePage_CreatingBranchTaskName);
        CreateLocalBranchOperation bop = new CreateLocalBranchOperation(this.repository, textForBranch, commit);
        bop.execute((IProgressMonitor)progress.newChild(2));
        if (doCheckout) {
            this.checkout(textForBranch, (IProgressMonitor)progress.newChild(8));
        }
    }

    private void checkout(String targetName, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(UIText.FetchGerritChangePage_CheckingOutTaskName);
        BranchOperationUI.checkout(this.repository, targetName).run(monitor);
        monitor.worked(1);
    }

    private void activateAdditionalRefs() {
        Activator.getDefault().getPreferenceStore().setValue("resourcehistory_show_additionalrefs", true);
    }

    private ExplicitContentProposalAdapter addRefContentProposalToText(Text textField) {
        KeyStroke stroke = UIUtils.getKeystrokeOfBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (stroke != null) {
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.FetchGerritChangePage_ContentAssistTooltip, (Object)stroke.format()));
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                Collection proposals;
                try {
                    proposals = FetchGerritChangePage.this.getRefsForContentAssist(contents);
                }
                catch (InvocationTargetException e) {
                    Activator.handleError(e.getMessage(), e, true);
                    return null;
                }
                catch (InterruptedException e) {
                    return null;
                }
                if (proposals == null) {
                    return null;
                }
                ArrayList<ChangeContentProposal> resultList = new ArrayList<ChangeContentProposal>();
                String input = contents;
                Matcher matcher = GERRIT_CHANGE_REF_PATTERN.matcher(contents);
                if (matcher.find()) {
                    input = matcher.group(2);
                }
                Pattern pattern = UIUtils.createProposalPattern(input);
                for (Change ref : proposals) {
                    if (pattern != null && !pattern.matcher(ref.getChangeNumber().toString()).matches()) continue;
                    resultList.add(new ChangeContentProposal(ref));
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        };
        ExplicitContentProposalAdapter adapter = new ExplicitContentProposalAdapter((Control)textField, cp, stroke);
        adapter.setProposalAcceptanceStyle(2);
        return adapter;
    }

    static /* synthetic */ void access$16(FetchGerritChangePage fetchGerritChangePage, boolean bl) {
        fetchGerritChangePage.doAutoFill = bl;
    }

    static /* synthetic */ void access$17(FetchGerritChangePage fetchGerritChangePage, Collection collection, String string) {
        fetchGerritChangePage.fillInPatchSet(collection, string);
    }

    static final class Change
    implements Comparable<Change> {
        private final String refName;
        private final Integer changeNumber;
        private final Integer patchSetNumber;

        static Change fromRef(String refName) {
            Integer changeNumber;
            Matcher m;
            block8: {
                block7: {
                    block6: {
                        if (refName != null) break block6;
                        return null;
                    }
                    m = GERRIT_CHANGE_REF_PATTERN.matcher(refName);
                    if (m.matches() && m.group(3) != null) break block7;
                    return null;
                }
                Integer subdir = Integer.valueOf(m.group(1));
                changeNumber = Integer.valueOf(m.group(2));
                if (subdir == changeNumber % 100) break block8;
                return null;
            }
            try {
                Integer patchSetNumber = Integer.valueOf(m.group(3));
                return new Change(refName, changeNumber, patchSetNumber);
            }
            catch (NumberFormatException e) {
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }

        static Change create(int changeNumber) {
            return new Change(null, changeNumber, null);
        }

        static Change create(int changeNumber, int patchSetNumber) {
            int subDir = changeNumber % 100;
            return new Change(FetchGerritChangePage.GERRIT_CHANGE_REF_PREFIX + String.format("%02d", subDir) + '/' + changeNumber + '/' + patchSetNumber, changeNumber, patchSetNumber);
        }

        private Change(String refName, Integer changeNumber, Integer patchSetNumber) {
            this.refName = refName;
            this.changeNumber = changeNumber;
            this.patchSetNumber = patchSetNumber;
        }

        public String getRefName() {
            return this.refName;
        }

        public Integer getChangeNumber() {
            return this.changeNumber;
        }

        public Integer getPatchSetNumber() {
            return this.patchSetNumber;
        }

        public String toString() {
            return this.refName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Change)) {
                return false;
            }
            return this.compareTo((Change)obj) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.changeNumber, this.patchSetNumber);
        }

        @Override
        public int compareTo(Change o) {
            int changeDiff = this.changeNumber.compareTo(o.getChangeNumber());
            if (changeDiff == 0) {
                if (this.patchSetNumber == null) {
                    return o.getPatchSetNumber() != null ? -1 : 0;
                }
                if (o.getPatchSetNumber() == null) {
                    return 1;
                }
                changeDiff = this.patchSetNumber.compareTo(o.getPatchSetNumber());
            }
            return changeDiff;
        }
    }

    private static final class ChangeContentProposal
    implements IContentProposal {
        private final Change myChange;

        ChangeContentProposal(Change change) {
            this.myChange = change;
        }

        public String getContent() {
            return this.myChange.getRefName();
        }

        public int getCursorPosition() {
            return 0;
        }

        public String getDescription() {
            return NLS.bind((String)UIText.FetchGerritChangePage_ContentAssistDescription, (Object)this.myChange.getPatchSetNumber(), (Object)this.myChange.getChangeNumber());
        }

        public String getLabel() {
            return NLS.bind((String)"{0} - {1}", (Object)this.myChange.getChangeNumber(), (Object)this.myChange.getPatchSetNumber());
        }

        public String toString() {
            return this.getContent();
        }
    }

    private static class ChangeList {
        private final Repository repository;
        private final String uriText;
        private State state = State.PRISTINE;
        private Set<Change> result;
        private InterruptibleJob job;

        public ChangeList(Repository repository, String uriText) {
            this.repository = repository;
            this.uriText = uriText;
        }

        public synchronized boolean cancel(CancelMode cancellation) {
            CancelMode mode = cancellation == null ? CancelMode.CANCEL : cancellation;
            switch (this.state) {
                case PRISTINE: {
                    this.finish(false);
                    return true;
                }
                case SCHEDULED: {
                    this.state = State.CANCELING;
                    boolean canceled = this.job.cancel();
                    if (canceled) {
                        this.state = State.CANCELED;
                    } else if (mode == CancelMode.INTERRUPT) {
                        this.interrupt();
                    } else if (mode == CancelMode.ABANDON) {
                        this.notifyAll();
                    }
                    return canceled;
                }
                case CANCELING: {
                    if (mode == CancelMode.INTERRUPT) {
                        this.interrupt();
                    } else if (mode == CancelMode.ABANDON) {
                        this.notifyAll();
                    }
                    return false;
                }
                case INTERRUPT: {
                    if (mode != CancelMode.CANCEL) {
                        this.notifyAll();
                    }
                    return false;
                }
                case CANCELED: {
                    return true;
                }
            }
            return false;
        }

        public synchronized boolean isFinished() {
            return this.state == State.CANCELED || this.state == State.DONE;
        }

        public synchronized boolean isDone() {
            return this.state == State.DONE;
        }

        public synchronized Collection<Change> get() throws InterruptedException, InvocationTargetException {
            switch (this.state) {
                case CANCELED: 
                case DONE: {
                    return this.result;
                }
                case PRISTINE: {
                    this.fetch();
                    return this.get();
                }
            }
            this.wait();
            if (this.state == State.CANCELING || this.state == State.INTERRUPT) {
                throw new InterruptedException();
            }
            return this.get();
        }

        public synchronized Collection<Change> getResult() {
            if (this.isFinished()) {
                return this.result;
            }
            throw new IllegalStateException("Fetching change list is not finished");
        }

        private synchronized void finish(boolean done) {
            this.state = done ? State.DONE : State.CANCELED;
            this.job = null;
            this.notifyAll();
        }

        private synchronized void interrupt() {
            this.state = State.INTERRUPT;
            this.job.interrupt();
            this.notifyAll();
        }

        public synchronized void fetch() throws InvocationTargetException {
            ListRemoteOperation listOp;
            if (this.job != null || this.state != State.PRISTINE) {
                return;
            }
            try {
                listOp = new ListRemoteOperation(this.repository, new URIish(this.uriText), Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"));
            }
            catch (URISyntaxException e) {
                this.finish(false);
                throw new InvocationTargetException(e);
            }
            this.job = new InterruptibleJob(MessageFormat.format(UIText.FetchGerritChangePage_FetchingRemoteRefsMessage, this.uriText)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        listOp.run(monitor);
                    }
                    catch (InterruptedException e) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (InvocationTargetException e) {
                        ChangeList changeList = this;
                        synchronized (changeList) {
                            if (state == State.CANCELING || state == State.INTERRUPT) {
                                return Status.CANCEL_STATUS;
                            }
                        }
                        return Activator.createErrorStatus(e.getLocalizedMessage(), e);
                    }
                    ArrayList<Change> changes = new ArrayList<Change>();
                    for (Ref ref : listOp.getRemoteRefs()) {
                        Change change = Change.fromRef(ref.getName());
                        if (change == null) continue;
                        changes.add(change);
                    }
                    Collections.sort(changes, Collections.reverseOrder());
                    result = new LinkedHashSet(changes);
                    return Status.OK_STATUS;
                }
            };
            this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IStatus status = event.getResult();
                    this.finish(status != null && status.isOK());
                }
            });
            this.job.setUser(false);
            this.job.setSystem(true);
            this.state = State.SCHEDULED;
            this.job.schedule();
        }

        public static enum CancelMode {
            CANCEL,
            ABANDON,
            INTERRUPT;

        }

        private static abstract class InterruptibleJob
        extends Job {
            public InterruptibleJob(String name) {
                super(name);
            }

            public void interrupt() {
                Thread thread = this.getThread();
                if (thread != null) {
                    thread.interrupt();
                }
            }
        }

        private static enum State {
            PRISTINE,
            SCHEDULED,
            CANCELING,
            INTERRUPT,
            CANCELED,
            DONE;

        }
    }

    private static enum CheckoutMode {
        CREATE_BRANCH,
        CREATE_TAG,
        CHECKOUT_FETCH_HEAD,
        NOCHECKOUT;

    }

    private static class ExplicitContentProposalAdapter
    extends ContentProposalAdapter {
        public ExplicitContentProposalAdapter(Control control, IContentProposalProvider proposalProvider, KeyStroke keyStroke) {
            super(control, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, keyStroke, null);
        }

        public void openProposalPopup() {
            super.openProposalPopup();
        }
    }
}

