/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.quickaccess.QuickAccessDialog;
import org.eclipse.ui.internal.quickaccess.SearchField;

public class QuickAccessHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) {
        Control control;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow(executionEvent);
        if (window == null) {
            return null;
        }
        MWindow mWindow = ((WorkbenchWindow)window).getModel();
        EModelService modelService = (EModelService)mWindow.getContext().get(EModelService.class);
        MToolControl searchField = (MToolControl)modelService.find("SearchField", (MUIElement)mWindow);
        if (searchField != null && searchField.isVisible() && (control = (Control)searchField.getWidget()) != null && control.isVisible()) {
            Control previousFocusControl = control.getDisplay().getFocusControl();
            control.setFocus();
            SearchField field = (SearchField)searchField.getObject();
            field.activate(previousFocusControl);
            return null;
        }
        QuickAccessHandler.displayQuickAccessDialog(window, executionEvent.getCommand());
        return null;
    }

    private static void displayQuickAccessDialog(IWorkbenchWindow window, Command command) {
        QuickAccessDialog popupDialog = new QuickAccessDialog(window, command);
        popupDialog.open();
    }
}

