/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store.internals.query;

import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.eclipse.lyo.store.internals.query.JenaQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlQueryExecutorImpl
implements JenaQueryExecutor {
    private final Logger log = LoggerFactory.getLogger(SparqlQueryExecutorImpl.class);
    private final String queryEndpoint;
    private final String updateEndpoint;

    public SparqlQueryExecutorImpl(String sparqlEndpoint, String updateEndpoint) {
        this.queryEndpoint = sparqlEndpoint;
        this.updateEndpoint = updateEndpoint;
    }

    @Override
    public QueryExecution prepareSparqlQuery(String query) {
        return QueryExecutionFactory.sparqlService((String)this.queryEndpoint, (String)query);
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(UpdateRequest updateRequest) {
        return UpdateExecutionFactory.createRemote((UpdateRequest)updateRequest, (String)this.updateEndpoint);
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(Update update) {
        return this.prepareSparqlUpdate(new UpdateRequest(update));
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(String query) {
        return this.prepareSparqlUpdate(UpdateFactory.create((String)query));
    }

    @Override
    public void release() {
        this.log.trace("NOP, there is nothing to release");
    }

    @Override
    public void beginWrite() {
    }

    @Override
    public void beginRead() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void end() {
    }
}

