/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store;

import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.jena.query.Dataset;
import org.apache.jena.tdb.TDBFactory;
import org.eclipse.lyo.store.Store;
import org.eclipse.lyo.store.StoreFactory;
import org.eclipse.lyo.store.internals.SparqlStoreImpl;
import org.eclipse.lyo.store.internals.query.DatasetQueryExecutorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorePool {
    public static final URI DEFAULT_GRAPH_JENA = URI.create("urn:x-arq:DefaultGraph");
    private URI defaultNamedGraphUri;
    private BlockingQueue<Store> storePool;
    private static final Logger log = LoggerFactory.getLogger(StorePool.class);

    public StorePool(int poolSize, URI defaultNamedGraphUri, URI sparqlQueryEndpoint, URI sparqlUpdateEndpoint, String userName, String password) {
        this.defaultNamedGraphUri = defaultNamedGraphUri;
        this.storePool = new ArrayBlockingQueue<Store>(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            Store s = null;
            s = userName != null && password != null ? StoreFactory.sparql(sparqlQueryEndpoint.toString(), sparqlUpdateEndpoint.toString(), userName, password) : StoreFactory.sparql(sparqlQueryEndpoint.toString(), sparqlUpdateEndpoint.toString());
            this.storePool.add(s);
        }
    }

    public StorePool(int poolSize, URI defaultNamedGraphUri) {
        this.defaultNamedGraphUri = defaultNamedGraphUri;
        this.storePool = new ArrayBlockingQueue<Store>(poolSize);
        Dataset dataset = TDBFactory.createDataset();
        DatasetQueryExecutorImpl queryExecutor = new DatasetQueryExecutorImpl(dataset);
        for (int i = 0; i < poolSize; ++i) {
            this.storePool.add(new SparqlStoreImpl(queryExecutor));
        }
    }

    public URI getDefaultNamedGraphUri() {
        return this.defaultNamedGraphUri;
    }

    public Store getStore() {
        try {
            return this.storePool.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Failed to get a store from the pool", (Throwable)e);
            return null;
        }
    }

    public void releaseStore(Store store) {
        try {
            this.storePool.put(store);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Failed to get a store from the pool", (Throwable)e);
        }
    }
}

