/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.http;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.http.HttpClient;
import com.apicatalog.jsonld.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.Optional;

public final class DefaultHttpClient
implements HttpClient {
    private static final java.net.http.HttpClient CLIENT = java.net.http.HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
    private static final DefaultHttpClient INSTANCE = new DefaultHttpClient(CLIENT);
    private final java.net.http.HttpClient httpClient;

    public DefaultHttpClient(java.net.http.HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public HttpResponse send(URI targetUri, String requestProfile) throws JsonLdError {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(targetUri).header("Accept", requestProfile).build();
        try {
            return new HttpResponseImpl(this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
        }
    }

    public static final HttpClient defaultInstance() {
        return INSTANCE;
    }

    public static class HttpResponseImpl
    implements HttpResponse {
        private final java.net.http.HttpResponse<InputStream> response;

        HttpResponseImpl(java.net.http.HttpResponse<InputStream> response) {
            this.response = response;
        }

        @Override
        public int statusCode() {
            return this.response.statusCode();
        }

        @Override
        public InputStream body() {
            return this.response.body();
        }

        @Override
        public Collection<String> links() {
            return this.response.headers().map().get("link");
        }

        @Override
        public Optional<String> contentType() {
            return this.response.headers().firstValue("content-type");
        }

        @Override
        public Optional<String> location() {
            return this.response.headers().firstValue("location");
        }

        @Override
        public void close() {
        }
    }
}

