/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.RangeExpressionException;

public class RangeExpression {
    private final Edge from;
    private final Edge to;
    private final String errorMessage;

    public RangeExpression(Edge from, Edge to) {
        this.from = from;
        this.to = to;
        this.errorMessage = RangeExpression.createErrorMessage(from, to);
    }

    private static String createErrorMessage(Edge from, Edge to) {
        StringBuilder message = new StringBuilder("The value `{0}`' must be ");
        if (to == null) {
            message.append("greater than ");
            if (from.inclusive) {
                message.append("or equal to ");
            }
            message.append("`");
            message.append(from.valueAsString);
            message.append("`.");
        } else {
            message.append("between ");
            message.append("`");
            message.append(from.valueAsString);
            message.append("`");
            if (from.inclusive) {
                message.append(" (inclusive)");
            } else {
                message.append(" (exclusive)");
            }
            message.append(" and ");
            message.append("`");
            message.append(to.valueAsString);
            message.append("`");
            if (to.inclusive) {
                message.append(" (inclusive)");
            } else {
                message.append(" (exclusive)");
            }
            message.append(".");
        }
        return message.toString();
    }

    public String validate(double value) {
        if (!this.from.validate(value) || this.to != null && !this.to.validate(value)) {
            return MessageFormat.format(this.errorMessage, value);
        }
        return null;
    }

    public static RangeExpression parse(String expression) throws RangeExpressionException {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            throw new RangeExpressionException("No expression");
        }
        Edge from = null;
        Edge to = null;
        boolean inclusive = true;
        StringBuilder valueAsString = new StringBuilder();
        int i = 0;
        while (i < expression.length()) {
            char c = expression.charAt(i);
            switch (c) {
                case ' ': {
                    break;
                }
                case '[': {
                    if (from != null && valueAsString.length() > 0) {
                        RangeExpression.unexpectedToken(c, i, expression);
                    }
                    inclusive = true;
                    break;
                }
                case '(': {
                    if (from != null && valueAsString.length() > 0) {
                        RangeExpression.unexpectedToken(c, i, expression);
                    }
                    inclusive = false;
                    break;
                }
                case ']': {
                    if (from == null) {
                        RangeExpression.unexpectedToken(c, i, expression);
                    }
                    inclusive = true;
                    break;
                }
                case ')': {
                    if (from == null) {
                        RangeExpression.unexpectedToken(c, i, expression);
                    }
                    inclusive = false;
                    break;
                }
                case ',': {
                    if (valueAsString.length() == 0) {
                        RangeExpression.unexpectedToken(c, i, expression);
                    }
                    from = RangeExpression.createEdge(inclusive, true, valueAsString.toString());
                    valueAsString.setLength(0);
                    inclusive = true;
                    break;
                }
                case '.': {
                    if (valueAsString.length() == 0 || valueAsString.toString().contains("" + c)) {
                        RangeExpression.unexpectedToken(c, i, expression);
                    }
                    valueAsString.append(c);
                    break;
                }
                case '-': {
                    if (valueAsString.length() == 0) {
                        valueAsString.append(c);
                        break;
                    }
                    RangeExpression.unexpectedToken(c, i, expression);
                    break;
                }
                default: {
                    if (Character.isDigit(c)) {
                        valueAsString.append(c);
                        break;
                    }
                    RangeExpression.unexpectedToken(c, i, expression);
                }
            }
            ++i;
        }
        if (valueAsString.length() > 0) {
            if (from == null) {
                from = RangeExpression.createEdge(inclusive, true, valueAsString.toString());
            } else {
                to = RangeExpression.createEdge(inclusive, false, valueAsString.toString());
            }
        }
        if (from == null) {
            throw new RangeExpressionException("No range");
        }
        return new RangeExpression(from, to);
    }

    private static Edge createEdge(boolean inclusive, boolean superior, String valueAsString) throws RangeExpressionException {
        if (valueAsString.length() == 0) {
            throw new RangeExpressionException("No value");
        }
        return new Edge(valueAsString, superior, inclusive);
    }

    private static void unexpectedToken(char c, int i, String expression) throws RangeExpressionException {
        throw new RangeExpressionException("Unexpected character " + c + " at " + i + " for expression " + expression);
    }

    private static class Edge {
        private final double value;
        private final String valueAsString;
        private final boolean superior;
        private final boolean inclusive;

        public Edge(String valueAsString, boolean superior, boolean inclusive) {
            this.valueAsString = valueAsString;
            this.value = Double.parseDouble(valueAsString);
            this.superior = superior;
            this.inclusive = inclusive;
        }

        public boolean validate(double value) {
            if (this.inclusive && value == this.value) {
                return true;
            }
            return this.superior ? value > this.value : value < this.value;
        }
    }
}

