/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.di;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.test.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.test.core.JakartaForJavaAssert;
import org.junit.Test;

public class InjectionPointBeanValidationTests
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void abstractClassConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/AbstractInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 52, 54, "The parameter should not contain the abstract modifier. If it contains the abstract modifier, the class should be annotated with @Decorator.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidAbstractClassBean");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1);
    }

    @Test
    public void abstractClassDecoratorConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/AbstractDecoratorInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, new Diagnostic[0]);
    }

    @Test
    public void innerClassConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/InnerClassInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 48, 55, "The parameter should not be an inner class.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidInnerClassBean");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1);
    }

    @Test
    public void extensionServiceConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/ExtensionInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 61, 64, "The parameter should not implement the jakarta.enterprise.inject.spi.Extension interface either directly or through a superclass or through super interface.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidExtensionProviderBean");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1);
    }

    @Test
    public void superClassExtensionServiceConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/SuperClassExtensionInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 98, 105, "The parameter should not implement the jakarta.enterprise.inject.spi.Extension interface either directly or through a superclass or through super interface.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidExtensionProviderBean");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1);
    }

    @Test
    public void superInterfaceExtensionServiceConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/SuperInterfaceExtensionInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 97, 103, "The parameter should not implement the jakarta.enterprise.inject.spi.Extension interface either directly or through a superclass or through super interface.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidExtensionProviderBean");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1);
    }

    @Test
    public void primitiveConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/PrimitiveParamConstructorInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(21, 61, 62, "The parameter should not be a primitive type.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidPrimitiveBean");
        Diagnostic d2 = JakartaForJavaAssert.d(21, 68, 69, "The parameter should not be a primitive type.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidPrimitiveBean");
        Diagnostic d3 = JakartaForJavaAssert.d(21, 76, 78, "The parameter should not be a primitive type.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidPrimitiveBean");
        Diagnostic d4 = JakartaForJavaAssert.d(21, 86, 87, "The parameter should not be a primitive type.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidPrimitiveBean");
        Diagnostic d5 = JakartaForJavaAssert.d(21, 96, 98, "The parameter should not be a primitive type.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidPrimitiveBean");
        Diagnostic d6 = JakartaForJavaAssert.d(21, 105, 106, "The parameter should not be a primitive type.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidPrimitiveBean");
        Diagnostic d7 = JakartaForJavaAssert.d(21, 113, 115, "The parameter should not be a primitive type.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidPrimitiveBean");
        Diagnostic d8 = JakartaForJavaAssert.d(21, 125, 126, "The parameter should not be a primitive type.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidPrimitiveBean");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2, d3, d4, d5, d6, d7, d8);
    }

    @Test
    public void vetoedConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/VetoedInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 48, 50, "The parameter should not be annotated with @Vetoed either directly or through the package-info metadata.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidVetoedClassBean");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1);
    }

    @Test
    public void vetoedPackageConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/VetoedPackageInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 62, 65, "The parameter should not be annotated with @Vetoed either directly or through the package-info metadata.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidVetoedClassBean");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1);
    }

    @Test
    public void invalidConstructorParam() throws Exception {
        IJavaProject javaProject = InjectionPointBeanValidationTests.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/InvalidConstructorInjectionPointUser.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 72, 75, "The parameter should define a constructor with no parameters or a constructor annotated with @Inject.", DiagnosticSeverity.Warning, "jakarta-di", "InjectionPointInvalidConstructorBean");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1);
    }
}

