/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.persistence;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.persistence.Constants;
import org.eclipse.lsp4jakarta.jdt.internal.persistence.ErrorCode;

public class PersistenceMapKeyDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    private static final Logger LOGGER = Logger.getLogger(PersistenceMapKeyDiagnosticsParticipant.class.getName());
    final String MAP_INTERFACE_FQDN = "java.util.Map";

    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] alltypes;
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] iTypeArray = alltypes = unit.getAllTypes();
        int n = alltypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IMethod[] methods = type.getMethods();
            this.collectMemberDiagnostics((IMember[])methods, type, unit, diagnostics, context);
            IField[] fields = type.getFields();
            this.collectMemberDiagnostics((IMember[])fields, type, unit, diagnostics, context);
            ++n2;
        }
        return diagnostics;
    }

    private void validateMapKeyJoinColumnAnnotations(JavaDiagnosticsContext context, String uri, List<IAnnotation> annotations, IMember element, ICompilationUnit unit, List<Diagnostic> diagnostics) throws CoreException {
        annotations.forEach(annotation -> {
            try {
                Range range = null;
                String message = null;
                ErrorCode errorCode = null;
                if (element instanceof IMethod) {
                    range = PositionUtils.toNameRange((IMethod)element, context.getUtils());
                    errorCode = ErrorCode.InvalidMethodWithMultipleMPJCAnnotations;
                    message = Messages.getMessage("MultipleMapKeyJoinColumnMethod", new Object[0]);
                } else {
                    range = PositionUtils.toNameRange((IField)element, context.getUtils());
                    errorCode = ErrorCode.InvalidFieldWithMultipleMPJCAnnotations;
                    message = Messages.getMessage("MultipleMapKeyJoinColumnField", new Object[0]);
                }
                List<IMemberValuePair> memberValues = Arrays.asList(annotation.getMemberValuePairs());
                boolean allNamesSpecified = memberValues.stream().anyMatch(mv -> mv.getMemberName().equals("name"));
                boolean allReferencedColumnNameSpecified = memberValues.stream().anyMatch(mv -> mv.getMemberName().equals("referencedColumnName"));
                if (!allNamesSpecified || !allReferencedColumnNameSpecified) {
                    diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-persistence", null, errorCode, DiagnosticSeverity.Error));
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Error while retrieving member values of @MapKeyJoinColumn Annotation", e);
            }
        });
    }

    private void collectMemberDiagnostics(IMember[] members, IType type, ICompilationUnit unit, List<Diagnostic> diagnostics, JavaDiagnosticsContext context) throws CoreException {
        ArrayList<IAnnotation> mapKeyJoinCols = null;
        boolean hasMapKeyAnnotation = false;
        boolean hasMapKeyClassAnnotation = false;
        boolean hasTypeDiagnostics = false;
        IAnnotation[] allAnnotations = null;
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            mapKeyJoinCols = new ArrayList<IAnnotation>();
            hasMapKeyAnnotation = false;
            hasMapKeyClassAnnotation = false;
            allAnnotations = null;
            if (member instanceof IMethod) {
                allAnnotations = ((IMethod)member).getAnnotations();
            } else if (member instanceof IField) {
                allAnnotations = ((IField)member).getAnnotations();
            }
            IAnnotation[] iAnnotationArray = allAnnotations;
            int n3 = allAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                String matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), Constants.SET_OF_PERSISTENCE_ANNOTATIONS);
                if (matchedAnnotation != null) {
                    if ("jakarta.persistence.MapKey".equals(matchedAnnotation)) {
                        hasMapKeyAnnotation = true;
                    } else if ("jakarta.persistence.MapKeyClass".equals(matchedAnnotation)) {
                        hasMapKeyClassAnnotation = true;
                    } else if ("jakarta.persistence.MapKeyJoinColumn".equals(matchedAnnotation)) {
                        mapKeyJoinCols.add(annotation);
                    }
                }
                ++n4;
            }
            if (hasMapKeyAnnotation) {
                hasTypeDiagnostics = this.collectTypeDiagnostics(member, "@MapKey", context, diagnostics);
                this.collectAccessorDiagnostics(member, type, context, diagnostics);
            }
            if (hasMapKeyClassAnnotation) {
                hasTypeDiagnostics = this.collectTypeDiagnostics(member, "@MapKeyClass", context, diagnostics);
                this.collectAccessorDiagnostics(member, type, context, diagnostics);
            }
            if (!hasTypeDiagnostics && hasMapKeyAnnotation && hasMapKeyClassAnnotation) {
                this.collectMapKeyAnnotationsDiagnostics(member, context, diagnostics);
            }
            if (mapKeyJoinCols.size() > 1) {
                this.validateMapKeyJoinColumnAnnotations(context, context.getUri(), mapKeyJoinCols, member, unit, diagnostics);
            }
            ++n2;
        }
    }

    private boolean collectTypeDiagnostics(IMember member, String attribute, JavaDiagnosticsContext context, List<Diagnostic> diagnostics) throws CoreException {
        boolean hasTypeDiagnostics = false;
        Range range = null;
        String messageKey = null;
        String fqName = null;
        ErrorCode errorCode = null;
        boolean isMap = false;
        IType declaringType = member.getDeclaringType();
        IJavaProject javaProject = declaringType.getJavaProject();
        if (member instanceof IMethod) {
            fqName = JDTTypeUtils.getResolvedResultTypeName((IMethod)member);
        } else if (member instanceof IField) {
            fqName = JDTTypeUtils.getResolvedTypeName((IField)member);
        }
        if (fqName != null) {
            if ("java.util.Map".equals(fqName)) {
                isMap = true;
            } else {
                IType[] interfaces;
                IType returnType = javaProject.findType(fqName);
                ITypeHierarchy hierarchy = returnType.newTypeHierarchy(null);
                IType[] iTypeArray = interfaces = hierarchy.getAllSuperInterfaces(returnType);
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    IType superInterface = iTypeArray[n2];
                    if ("java.util.Map".equals(superInterface.getFullyQualifiedName())) {
                        isMap = true;
                    }
                    ++n2;
                }
            }
        }
        if (!isMap) {
            if (member instanceof IMethod) {
                range = PositionUtils.toNameRange((IMethod)member, context.getUtils());
                messageKey = "MapKeyAnnotationsReturnTypeOfMethod";
                errorCode = ErrorCode.InvalidReturnTypeOfMethod;
            } else if (member instanceof IField) {
                range = PositionUtils.toNameRange((IField)member, context.getUtils());
                messageKey = "MapKeyAnnotationsTypeOfField";
                errorCode = ErrorCode.InvalidTypeOfField;
            }
        }
        if (messageKey != null) {
            hasTypeDiagnostics = true;
            diagnostics.add(context.createDiagnostic(context.getUri(), Messages.getMessage(messageKey, attribute), range, "jakarta-persistence", null, errorCode, DiagnosticSeverity.Error));
        }
        return hasTypeDiagnostics;
    }

    private void collectMapKeyAnnotationsDiagnostics(IMember member, JavaDiagnosticsContext context, List<Diagnostic> diagnostics) throws CoreException {
        Range range = null;
        String messageKey = null;
        ErrorCode errorCode = null;
        if (member instanceof IMethod) {
            range = PositionUtils.toNameRange((IMethod)member, context.getUtils());
            messageKey = "MapKeyAnnotationsNotOnSameMethod";
            errorCode = ErrorCode.InvalidMapKeyAnnotationsOnSameMethod;
        } else if (member instanceof IField) {
            range = PositionUtils.toNameRange((IField)member, context.getUtils());
            messageKey = "MapKeyAnnotationsNotOnSameField";
            errorCode = ErrorCode.InvalidMapKeyAnnotationsOnSameField;
        }
        if (messageKey != null) {
            diagnostics.add(context.createDiagnostic(context.getUri(), Messages.getMessage(messageKey, new Object[0]), range, "jakarta-persistence", null, errorCode, DiagnosticSeverity.Error));
        }
    }

    private void collectAccessorDiagnostics(IMember member, IType type, JavaDiagnosticsContext context, List<Diagnostic> diagnostics) throws CoreException {
        Range range = null;
        String messageKey = null;
        ErrorCode errorCode = null;
        if (member instanceof IMethod) {
            String methodName = member.getElementName();
            int flag = member.getFlags();
            boolean isPublic = Flags.isPublic((int)flag);
            boolean isStartsWithGet = methodName.startsWith("get");
            boolean isPropertyExist = false;
            if (isStartsWithGet) {
                isPropertyExist = this.hasField((IMethod)member, type);
            }
            if (!isPublic) {
                messageKey = "MapKeyAnnotationsInvalidMethodAccessSpecifier";
                errorCode = ErrorCode.InvalidMethodAccessSpecifier;
            } else if (!isStartsWithGet) {
                messageKey = "MapKeyAnnotationsOnInvalidMethod";
                errorCode = ErrorCode.InvalidMethodName;
            } else if (!isPropertyExist) {
                messageKey = "MapKeyAnnotationsFieldNotFound";
                errorCode = ErrorCode.InvalidMapKeyAnnotationsFieldNotFound;
            }
            if (messageKey != null) {
                range = PositionUtils.toNameRange((IMethod)member, context.getUtils());
                diagnostics.add(context.createDiagnostic(context.getUri(), Messages.getMessage(messageKey, new Object[0]), range, "jakarta-persistence", null, errorCode, DiagnosticSeverity.Warning));
            }
        }
    }

    private boolean hasField(IMethod method, IType type) throws JavaModelException {
        IField expectedfield;
        String methodName = method.getElementName();
        String expectedFieldName = methodName.startsWith("get") && methodName.length() > 3 ? Introspector.decapitalize(methodName.substring(3)) : null;
        IField iField = expectedfield = StringUtils.isNotBlank(expectedFieldName) ? type.getField(expectedFieldName) : null;
        return expectedfield != null && expectedfield.exists();
    }
}

