/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.servlet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.ICodeActionId;
import org.eclipse.lsp4jakarta.commons.codeaction.JakartaCodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.InsertAnnotationMissingQuickFix;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ModifyAnnotationProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.servlet.ErrorCode;

public class CompleteFilterAnnotationQuickFix
extends InsertAnnotationMissingQuickFix {
    public CompleteFilterAnnotationQuickFix() {
        super("jakarta.servlet.annotation.WebFilter");
    }

    @Override
    public String getParticipantId() {
        return CompleteFilterAnnotationQuickFix.class.getName();
    }

    @Override
    protected ICodeActionId getCodeActionId() {
        return JakartaCodeActionId.ServletCompleteWebFilterAnnotation;
    }

    @Override
    protected void insertAnnotations(Diagnostic diagnostic, JavaCodeActionContext context, List<CodeAction> codeActions) throws CoreException {
        String[] annotations;
        String[] stringArray = annotations = this.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String annotation = stringArray[n2];
            this.insertAndReplaceAnnotation(diagnostic, context, codeActions, annotation);
            ++n2;
        }
    }

    private void insertAndReplaceAnnotation(Diagnostic diagnostic, JavaCodeActionContext context, List<CodeAction> codeActions, String annotation) throws CoreException {
        CodeAction codeAction;
        ModifyAnnotationProposal proposal;
        String name;
        String attribute;
        int i;
        ArrayList<String> attributes;
        ASTNode node = context.getCoveringNode();
        IBinding parentType = this.getBinding(node);
        if (((String)diagnostic.getCode().getLeft()).equals(ErrorCode.WebFilterAnnotationMissingAttributes.getCode())) {
            attributes = new ArrayList<String>();
            attributes.add("value");
            attributes.add("urlPatterns");
            attributes.add("servletNames");
            i = 0;
            while (i < attributes.size()) {
                attribute = (String)attributes.get(i);
                ArrayList<String> attributesToAdd = new ArrayList<String>();
                attributesToAdd.add(attribute);
                name = CompleteFilterAnnotationQuickFix.getLabel(annotation, attribute, "Add");
                proposal = new ModifyAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, annotation, attributesToAdd);
                codeAction = context.convertToCodeAction(proposal, diagnostic);
                codeAction.setTitle(name);
                if (codeAction != null) {
                    codeActions.add(codeAction);
                }
                ++i;
            }
        }
        if (((String)diagnostic.getCode().getLeft()).equals(ErrorCode.WebFilterAnnotationAttributeConflict.getCode())) {
            attributes = new ArrayList();
            attributes.add("value");
            attributes.add("urlPatterns");
            i = 0;
            while (i < attributes.size()) {
                attribute = (String)attributes.get(i);
                ArrayList<String> attributesToRemove = new ArrayList<String>();
                attributesToRemove.add(attribute);
                name = CompleteFilterAnnotationQuickFix.getLabel(annotation, attribute, "Remove");
                proposal = new ModifyAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, annotation, new ArrayList<String>(), attributesToRemove);
                codeAction = context.convertToCodeAction(proposal, diagnostic);
                codeAction.setTitle(name);
                if (codeAction != null) {
                    codeActions.add(codeAction);
                }
                ++i;
            }
        }
    }

    private static String getLabel(String annotation, String attribute, String labelType) {
        String annotationName = annotation.substring(annotation.lastIndexOf(46) + 1, annotation.length());
        annotationName = "@" + annotationName;
        if (labelType.equals("Remove")) {
            return Messages.getMessage("RemoveTheAttriubuteFrom", attribute, annotationName);
        }
        return Messages.getMessage("AddTheAttributeTo", attribute, annotationName);
    }
}

