/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.jsonb;

import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.JakartaCodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.RemoveAnnotationConflictQuickFix;

public class RemoveAllButJsonbTransientAnnotationQuickFix
extends RemoveAnnotationConflictQuickFix {
    public RemoveAllButJsonbTransientAnnotationQuickFix() {
        super(new String[0]);
    }

    @Override
    public String getParticipantId() {
        return RemoveAllButJsonbTransientAnnotationQuickFix.class.getName();
    }

    @Override
    protected JakartaCodeActionId getCodeActionId() {
        return JakartaCodeActionId.JSONBRemoveAllButJsonbTransientAnnotation;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        if (parentType != null) {
            JsonArray diagnosticData = (JsonArray)diagnostic.getData();
            List<String> annotations = IntStream.range(0, diagnosticData.size()).mapToObj(idx -> diagnosticData.get(idx).getAsString()).collect(Collectors.toList());
            annotations.remove("JsonbTransient");
            if (annotations.size() > 0) {
                this.createCodeAction(diagnostic, context, parentType, codeActions, annotations.toArray(new String[0]));
            }
        }
        return codeActions;
    }
}

