/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.operations.rename;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.rename.LSPMoveParticipant;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockWorkspaceService;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LSPMoveParticipantTest
extends AbstractTestWithProject {
    LSPMoveParticipantTest() {
    }

    @BeforeEach
    void setupCaps() {
        MockLanguageServer.reset(() -> {
            ServerCapabilities caps = MockLanguageServer.defaultServerCapabilities();
            WorkspaceServerCapabilities ws = new WorkspaceServerCapabilities();
            FileOperationsServerCapabilities fileOps = new FileOperationsServerCapabilities();
            fileOps.setWillRename(new FileOperationOptions());
            ws.setFileOperations(fileOps);
            caps.setWorkspace(ws);
            return caps;
        });
    }

    @Test
    void computesNewUriFromDestinationResource() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(file);
        Assertions.assertTrue((boolean)LanguageServers.forProject((IProject)this.project).anyMatching());
        IFolder dest = this.project.getFolder("dest");
        if (!dest.exists()) {
            dest.create(true, true, null);
        }
        URI oldUri = LSPEclipseUtils.toUri((IResource)file);
        Assertions.assertNotNull((Object)oldUri);
        URI expectedNewUri = LSPEclipseUtils.toUri((IPath)(dest.getRawLocation() != null ? dest.getRawLocation().append(file.getName()) : dest.getLocation().append(file.getName())));
        TestableMoveParticipant participant = new TestableMoveParticipant();
        participant.setArgs(new MoveArguments((Object)dest, false));
        Assertions.assertTrue((boolean)participant.initialize(file));
        participant.createPreChange((IProgressMonitor)new NullProgressMonitor());
        MockWorkspaceService ws = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws.getLastWillRename());
        Assertions.assertEquals((int)1, (int)ws.getLastWillRename().getFiles().size());
        Assertions.assertEquals((Object)oldUri.toString(), (Object)((FileRename)ws.getLastWillRename().getFiles().get(0)).getOldUri());
        Assertions.assertEquals((Object)expectedNewUri.toString(), (Object)((FileRename)ws.getLastWillRename().getFiles().get(0)).getNewUri());
    }

    @Test
    void computesNewUriFromDestinationPath() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(file);
        Assertions.assertTrue((boolean)LanguageServers.forProject((IProject)this.project).anyMatching());
        IFolder dest = this.project.getFolder("destPath");
        if (!dest.exists()) {
            dest.create(true, true, null);
        }
        URI oldUri = LSPEclipseUtils.toUri((IResource)file);
        Assertions.assertNotNull((Object)oldUri);
        IPath destPath = dest.getRawLocation() != null ? dest.getRawLocation() : dest.getLocation();
        Assertions.assertNotNull((Object)destPath);
        URI expectedNewUri = LSPEclipseUtils.toUri((IPath)destPath.append(file.getName()));
        TestableMoveParticipant participant = new TestableMoveParticipant();
        participant.setArgs(new MoveArguments((Object)destPath, false));
        Assertions.assertTrue((boolean)participant.initialize(file));
        participant.createPreChange((IProgressMonitor)new NullProgressMonitor());
        MockWorkspaceService ws = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws.getLastWillRename());
        Assertions.assertEquals((int)1, (int)ws.getLastWillRename().getFiles().size());
        Assertions.assertEquals((Object)oldUri.toString(), (Object)((FileRename)ws.getLastWillRename().getFiles().get(0)).getOldUri());
        Assertions.assertEquals((Object)expectedNewUri.toString(), (Object)((FileRename)ws.getLastWillRename().getFiles().get(0)).getNewUri());
    }

    static class TestableMoveParticipant
    extends LSPMoveParticipant {
        private MoveArguments args;

        TestableMoveParticipant() {
        }

        void setArgs(MoveArguments args) {
            this.args = args;
        }

        public boolean initialize(Object element) {
            return super.initialize(element);
        }

        public MoveArguments getArguments() {
            return this.args;
        }
    }
}

