/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.linkedediting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LinkedEditingTest
extends AbstractTestWithProject {
    @Test
    public void testLinkedEditing() throws CoreException {
        Annotation annotation;
        ISourceViewer sourceViewer = this.setupSimpleHtmlPageViewer();
        sourceViewer.getTextWidget().setSelection(11);
        HashMap<org.eclipse.jface.text.Position, Annotation> annotations = new HashMap<org.eclipse.jface.text.Position, Annotation>();
        this.waitForAnnotationsPresent(sourceViewer);
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            annotation = (Annotation)iterator.next();
            annotations.put(model.getPosition(annotation), annotation);
        }
        annotation = (Annotation)annotations.get(new LinkedPosition(sourceViewer.getDocument(), 10, 4, 0));
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertTrue((boolean)annotation.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link"));
    }

    @Test
    public void testLinkedEditingExitPolicy() throws CoreException {
        ISourceViewer sourceViewer = this.setupSimpleHtmlPageViewer();
        sourceViewer.getTextWidget().setCaretOffset(14);
        sourceViewer.getTextWidget().setSelection(14);
        this.waitForAnnotationsPresent(sourceViewer);
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        List<Annotation> annotations = this.findAnnotations(sourceViewer, 14).stream().filter(a -> a.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link")).toList();
        Assertions.assertEquals((int)1, (int)annotations.size(), (String)("Exepected only 1 link annotation here, got " + String.valueOf(annotations)));
        Annotation masterAnnotation = this.findAnnotation(sourceViewer, "org.eclipse.ui.internal.workbench.texteditor.link.master");
        Assertions.assertNotNull((Object)masterAnnotation);
        Assertions.assertTrue((boolean)annotations.contains(masterAnnotation));
        org.eclipse.jface.text.Position masterPosition = model.getPosition(masterAnnotation);
        Assertions.assertNotNull((Object)masterPosition);
        Annotation slaveAnnotation = this.findAnnotation(sourceViewer, "org.eclipse.ui.internal.workbench.texteditor.link.slave");
        Assertions.assertNotNull((Object)slaveAnnotation);
        org.eclipse.jface.text.Position slavePosition = model.getPosition(slaveAnnotation);
        Assertions.assertNotNull((Object)slavePosition);
        Assertions.assertEquals((Object)sourceViewer.getTextWidget().getTextRange(masterPosition.getOffset(), masterPosition.getLength()), (Object)sourceViewer.getTextWidget().getTextRange(slavePosition.getOffset(), slavePosition.getLength()));
        sourceViewer.getTextWidget().setCaretOffset(15);
        sourceViewer.getTextWidget().setSelection(15);
        this.waitForAnnotationsPresent(sourceViewer);
        model = sourceViewer.getAnnotationModel();
        Assertions.assertFalse((boolean)this.findAnnotations(sourceViewer, 15).stream().anyMatch(a -> a.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link")));
    }

    @Test
    public void testSelectionChange() throws CoreException {
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(new Position(0, 0), new Position(0, 5)));
        ranges.add(new Range(new Position(0, 6), new Position(0, 12)));
        LinkedEditingRanges linkedEditingRanges = new LinkedEditingRanges(ranges, "[:A-Z_a-z]*\\b");
        MockLanguageServer.INSTANCE.setLinkedEditingRanges(linkedEditingRanges);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "first second");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        if (!(viewer instanceof ISourceViewer)) {
            Assertions.fail();
        }
        ISourceViewer sourceViewer = (ISourceViewer)viewer;
        sourceViewer.getTextWidget().setSelection(9, 3);
        TestUtils.waitForAndAssertCondition(3000, () -> this.findAnnotations(sourceViewer, 1).size() != 0);
        Assertions.assertEquals((int)3, (int)sourceViewer.getTextWidget().getCaretOffset());
    }

    private void waitForAnnotationsPresent(ISourceViewer sourceViewer) {
        TestUtils.waitForAndAssertCondition(3000, () -> {
            Iterator iterator = sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!annotation.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link")) continue;
                return true;
            }
            return false;
        });
    }

    private ISourceViewer setupSimpleHtmlPageViewer() throws CoreException {
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(new Position(1, 3), new Position(1, 7)));
        ranges.add(new Range(new Position(3, 4), new Position(3, 8)));
        LinkedEditingRanges linkkedEditingRanges = new LinkedEditingRanges(ranges, "[:A-Z_a-z]*\\Z");
        MockLanguageServer.INSTANCE.setLinkedEditingRanges(linkkedEditingRanges);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "<html>\n  <body class=\"test\">\n    a body text\n  </body>\n</html>");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        if (!(viewer instanceof ISourceViewer)) {
            Assertions.fail();
        }
        return (ISourceViewer)viewer;
    }

    private List<Annotation> findAnnotations(ISourceViewer sourceViewer, int offset) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            org.eclipse.jface.text.Position position = model.getPosition(annotation);
            if (position == null || !position.includes(offset)) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    private Annotation findAnnotation(ISourceViewer sourceViewer, String type) {
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (annotation.getType() == null || !annotation.getType().equals(type)) continue;
            return annotation;
        }
        return null;
    }
}

