/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockConnectionProviderMultiRootFolders;
import org.eclipse.ui.IEditorPart;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LanguageServerWrapperTest
extends AbstractTestWithProject {
    private IProject project2;

    @Before
    public void setUp() throws Exception {
        this.project2 = TestUtils.createProject("LanguageServerWrapperTestProject2" + System.currentTimeMillis());
    }

    @Test
    public void testConnect() throws Exception {
        IFile testFile1 = TestUtils.createFile(this.project, "shouldUseExtension.lsptWithMultiRoot", "");
        IFile testFile2 = TestUtils.createFile(this.project2, "shouldUseExtension.lsptWithMultiRoot", "");
        IEditorPart editor1 = TestUtils.openEditor(testFile1);
        IEditorPart editor2 = TestUtils.openEditor(testFile2);
        @NonNull List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, request -> true);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        TestUtils.waitForAndAssertCondition(2000, () -> ((LanguageServerWrapper)wrapper).isActive());
        MatcherAssert.assertThat((Object)wrapper.toString(), (Matcher)Matchers.matchesPattern((String)"LanguageServerWrapper@[0-9a-f]+ \\[serverId=org.eclipse.lsp4e.test.server-with-multi-root-support, initialPath=null, initialProject=P\\/LanguageServerWrapperTest_testConnect_[0-9]+, isActive=true, pid=(null|[0-9])+\\]"));
        Assert.assertTrue((boolean)wrapper.isConnectedTo(testFile1.getLocationURI()));
        Assert.assertTrue((boolean)wrapper.isConnectedTo(testFile2.getLocationURI()));
        TestUtils.closeEditor(editor1, false);
        TestUtils.closeEditor(editor2, false);
    }

    @Test
    public void testStartStopAndActive() throws CoreException, AssertionError {
        int testCount = 100;
        MockConnectionProviderMultiRootFolders.resetCounts();
        IFile testFile1 = TestUtils.createFile(this.project, "shouldUseExtension.lsptWithMultiRoot", "");
        IEditorPart editor1 = TestUtils.openEditor(testFile1);
        @NonNull List wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, request -> true);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        int startingActiveThreads = ForkJoinPool.commonPool().getActiveThreadCount();
        CompletableFuture<Void> startStop = CompletableFuture.runAsync(() -> {
            int i = 0;
            while (i < 99) {
                wrapper.stop();
                wrapper.start();
                ++i;
            }
            wrapper.stop();
        });
        CompletableFuture<Void> testActive = CompletableFuture.runAsync(() -> {
            while (!startStop.isDone()) {
                wrapper.isActive();
            }
        });
        try {
            try {
                startStop.get(30L, TimeUnit.SECONDS);
                try {
                    testActive.get(1L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)"testActive terminated with exception");
                }
            }
            catch (Exception e) {
                throw new AssertionError((Object)"test job terminated with exception");
            }
        }
        finally {
            TestUtils.closeEditor(editor1, false);
        }
        long timeOut = System.currentTimeMillis() + 60000L;
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (ForkJoinPool.commonPool().getActiveThreadCount() > startingActiveThreads && System.currentTimeMillis() < timeOut);
        if (ForkJoinPool.commonPool().getActiveThreadCount() > startingActiveThreads) {
            throw new AssertionError((Object)"timeout waiting for ForkJoinPool.commonPool to go quiet");
        }
        Integer cpStartCount = MockConnectionProviderMultiRootFolders.getStartCount();
        Integer cpStopCount = MockConnectionProviderMultiRootFolders.getStopCount();
        Assert.assertEquals((String)"startCount == stopCount", (Object)cpStartCount, (Object)cpStopCount);
    }
}

