/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.signal.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.trace4cps.analysis.stl.impl.STLUtil;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.Shape;
import org.eclipse.trace4cps.core.impl.Claim;
import org.eclipse.trace4cps.core.impl.Interval;
import org.eclipse.trace4cps.core.impl.Psop;
import org.eclipse.trace4cps.core.impl.PsopFragment;
import org.eclipse.trace4cps.core.impl.Resource;

public class PsopHelper {
    private PsopHelper() {
    }

    public static int size(IPsop p) {
        return p.getFragments().size();
    }

    public static IPsop translate(IPsop p, double delta) {
        Psop p2 = new Psop();
        for (Map.Entry<String, String> e : p.getAttributes().entrySet()) {
            p2.setAttribute(e.getKey(), e.getValue());
        }
        for (IPsopFragment f : p.getFragments()) {
            double ub;
            double lb = BigDecimal.valueOf(f.dom().lb().doubleValue()).add(BigDecimal.valueOf(delta)).doubleValue();
            if (!(lb < (ub = BigDecimal.valueOf(f.dom().ub().doubleValue()).add(BigDecimal.valueOf(delta)).doubleValue()))) continue;
            Interval i2 = new Interval(lb, f.dom().isOpenLb(), ub, f.dom().isOpenUb());
            p2.add(new PsopFragment(f.getC(), f.getB(), f.getA(), i2));
        }
        return p2;
    }

    public static IPsop max(IPsop p1, IPsop p2) {
        return PsopHelper.minMax(p1, p2, true);
    }

    public static IPsop min(IPsop p1, IPsop p2) {
        return PsopHelper.minMax(p1, p2, false);
    }

    private static IPsop minMax(IPsop p1, IPsop p2, boolean isMax) {
        Psop f1 = PsopHelper.copy(p1);
        Psop f2 = PsopHelper.copy(p2);
        Interval d = Interval.intersect(PsopHelper.dom(f1), PsopHelper.dom(f2));
        if (d.isEmpty()) {
            return new Psop();
        }
        PsopHelper.projectTo(f1, d);
        PsopHelper.projectTo(f2, d);
        if (isMax) {
            return STLUtil.signalOr(f1, f2);
        }
        return STLUtil.signalAnd(f1, f2);
    }

    public static IPsop add(IPsop p, double cnst) {
        Psop r = new Psop();
        for (IPsopFragment f : p.getFragments()) {
            double c = BigDecimal.valueOf(f.getC().doubleValue()).add(BigDecimal.valueOf(cnst)).doubleValue();
            r.add(new PsopFragment(c, f.getB(), f.getA(), f.dom()));
        }
        return r;
    }

    public static IPsop add(IPsop p1, IPsop p2) {
        return PsopHelper.addSub(p1, p2, true);
    }

    public static IPsop sub(IPsop p1, IPsop p2) {
        return PsopHelper.addSub(p1, p2, false);
    }

    private static IPsop addSub(IPsop p1, IPsop p2, boolean isAdd) {
        Psop r = new Psop();
        Psop g1 = PsopHelper.copy(p1);
        PsopHelper.alignWith(g1, p2);
        Psop g2 = PsopHelper.copy(p2);
        PsopHelper.alignWith(g2, p1);
        int i = 0;
        while (i < g1.getFragments().size()) {
            IPsopFragment f1 = g1.getFragments().get(i);
            IPsopFragment f2 = g2.getFragments().get(i);
            if (isAdd) {
                c = BigDecimal.valueOf(f1.getC().doubleValue()).add(BigDecimal.valueOf(f2.getC().doubleValue())).doubleValue();
                b = BigDecimal.valueOf(f1.getB().doubleValue()).add(BigDecimal.valueOf(f2.getB().doubleValue())).doubleValue();
                a = BigDecimal.valueOf(f1.getA().doubleValue()).add(BigDecimal.valueOf(f2.getA().doubleValue())).doubleValue();
                r.add(new PsopFragment(c, b, a, f1.dom()));
            } else {
                c = BigDecimal.valueOf(f1.getC().doubleValue()).subtract(BigDecimal.valueOf(f2.getC().doubleValue())).doubleValue();
                b = BigDecimal.valueOf(f1.getB().doubleValue()).subtract(BigDecimal.valueOf(f2.getB().doubleValue())).doubleValue();
                a = BigDecimal.valueOf(f1.getA().doubleValue()).subtract(BigDecimal.valueOf(f2.getA().doubleValue())).doubleValue();
                r.add(new PsopFragment(c, b, a, f1.dom()));
            }
            ++i;
        }
        return r;
    }

    public static IPsop mult(IPsop p, double cnst) {
        Psop r = new Psop();
        for (IPsopFragment f : p.getFragments()) {
            double c = BigDecimal.valueOf(f.getC().doubleValue()).multiply(BigDecimal.valueOf(cnst)).doubleValue();
            double b = BigDecimal.valueOf(f.getB().doubleValue()).multiply(BigDecimal.valueOf(cnst)).doubleValue();
            double a = BigDecimal.valueOf(f.getA().doubleValue()).multiply(BigDecimal.valueOf(cnst)).doubleValue();
            r.add(new PsopFragment(c, b, a, f.dom()));
        }
        return r;
    }

    public static Interval dom(IPsop p) {
        if (p.getFragments().isEmpty()) {
            throw new IllegalStateException("empty function has no domain");
        }
        Number lb = p.getFragments().get(0).dom().lb();
        Number ub = p.getFragments().get(p.getFragments().size() - 1).dom().ub();
        return new Interval(lb, false, ub, true);
    }

    public static IPsop createDerivativeOf(IPsop p) {
        Psop der = new Psop();
        der.setAttributes(p.getAttributes());
        for (IPsopFragment f : p.getFragments()) {
            PsopFragment fn = new PsopFragment(f.getB(), 2.0 * f.getA().doubleValue(), 0.0, f.dom());
            der.add(fn);
        }
        return der;
    }

    public static Number valueAt(IPsop p, Number t) {
        int i = 0;
        while (i < p.getFragments().size()) {
            IPsopFragment f = p.getFragments().get(i);
            if (f.dom().contains(t) || i == PsopHelper.size(p) - 1 && t.doubleValue() == f.dom().ub().doubleValue()) {
                return PsopHelper.valueAt(f, t);
            }
            ++i;
        }
        throw new IllegalArgumentException(String.valueOf(t) + " not in domain");
    }

    public static PsopFragment copy(IPsopFragment f) {
        return new PsopFragment(f.getC(), f.getB(), f.getA(), f.dom());
    }

    public static Psop copy(IPsop p) {
        Psop f = new Psop();
        f.setAttributes(p.getAttributes());
        for (IPsopFragment frag : p.getFragments()) {
            f.addAtEnd(PsopHelper.copy(frag));
        }
        return f;
    }

    public static Number getDomainLowerBound(IPsop p) {
        if (PsopHelper.size(p) == 0) {
            throw new IllegalStateException("function is empty");
        }
        return p.getFragments().get(0).dom().lb();
    }

    public static Number getDomainUpperBound(IPsop p) {
        if (PsopHelper.size(p) == 0) {
            throw new IllegalStateException("function is empty");
        }
        return p.getFragments().get(p.getFragments().size() - 1).dom().ub();
    }

    public static Number getStartValue(IPsop p) {
        if (PsopHelper.size(p) == 0) {
            throw new IllegalStateException("function is empty");
        }
        return p.getFragments().get(0).getC();
    }

    public static Number getMinValue(IPsop p) {
        if (PsopHelper.size(p) == 0) {
            throw new IllegalStateException("function is empty");
        }
        MinMaxResult r = new MinMaxResult();
        for (IPsopFragment f : p.getFragments()) {
            r.combineWith(PsopHelper.computeMinMax(f));
        }
        return r.getMin();
    }

    public static Number getMaxValue(IPsop p) {
        if (PsopHelper.size(p) == 0) {
            throw new IllegalStateException("function is empty");
        }
        MinMaxResult r = new MinMaxResult();
        for (IPsopFragment f : p.getFragments()) {
            r.combineWith(PsopHelper.computeMinMax(f));
        }
        return r.getMax();
    }

    public static List<ShapeSegment> createMonotonicSegmentation(IPsop p) {
        int startIndex = 0;
        int endIndex = -1;
        int size = PsopHelper.size(p);
        Shape previous = Shape.CONSTANT;
        ArrayList<ShapeSegment> res = new ArrayList<ShapeSegment>();
        int i = 0;
        while (i < size) {
            double tZeroSlope;
            IPsopFragment frag = p.getFragments().get(i);
            Shape shape = frag.getShape();
            if (i > 0 && PsopHelper.nonContinuous(p.getFragments().get(i - 1), frag)) {
                res.add(new ShapeSegment(startIndex, endIndex, previous));
                if (shape == Shape.PARABOLA_CAP || shape == Shape.PARABOLA_CUP) {
                    tZeroSlope = PsopHelper.argZeroSlope(frag).doubleValue();
                    PsopHelper.splitFragment(p.getFragments(), i, frag, tZeroSlope, PsopHelper.valueAt(frag, (Number)tZeroSlope), 0.0);
                    ++size;
                    frag = p.getFragments().get(i);
                    shape = frag.getShape();
                }
                previous = shape;
                startIndex = ++endIndex;
                ++i;
                continue;
            }
            if (shape == Shape.CONSTANT) {
                ++endIndex;
                ++i;
                continue;
            }
            if (shape == Shape.INCREASING) {
                if (previous == Shape.CONSTANT || previous == Shape.INCREASING) {
                    previous = Shape.INCREASING;
                    ++endIndex;
                } else if (previous == Shape.DECREASING) {
                    res.add(new ShapeSegment(startIndex, endIndex, previous));
                    previous = Shape.INCREASING;
                    startIndex = ++endIndex;
                }
                ++i;
                continue;
            }
            if (shape == Shape.DECREASING) {
                if (previous == Shape.CONSTANT || previous == Shape.DECREASING) {
                    previous = Shape.DECREASING;
                    ++endIndex;
                } else if (previous == Shape.INCREASING) {
                    res.add(new ShapeSegment(startIndex, endIndex, previous));
                    previous = Shape.DECREASING;
                    startIndex = ++endIndex;
                }
                ++i;
                continue;
            }
            if (shape != Shape.PARABOLA_CAP && shape != Shape.PARABOLA_CUP) continue;
            tZeroSlope = PsopHelper.argZeroSlope(frag).doubleValue();
            PsopHelper.splitFragment(p.getFragments(), i, frag, tZeroSlope, PsopHelper.valueAt(frag, (Number)tZeroSlope), 0.0);
            ++size;
        }
        res.add(new ShapeSegment(startIndex, endIndex, previous));
        return res;
    }

    private static boolean nonContinuous(IPsopFragment prev, IPsopFragment frag) {
        return Math.abs(frag.getC().doubleValue() - PsopHelper.valueAt(prev, prev.dom().ub()).doubleValue()) > 1.0E-9;
    }

    private static void splitFragment(List<IPsopFragment> fragments, int fragIndex, IPsopFragment frag, Number xSplit) {
        Number c = PsopHelper.valueAt(frag, xSplit);
        Number b = PsopHelper.valueDerivativeAt(frag, xSplit);
        PsopHelper.splitFragment(fragments, fragIndex, frag, xSplit, c, b);
    }

    private static void splitFragment(List<IPsopFragment> fragments, int fragIndex, IPsopFragment frag, Number xSplit, Number c, Number b) {
        if (xSplit.doubleValue() == frag.dom().lb().doubleValue() || xSplit.doubleValue() == frag.dom().ub().doubleValue()) {
            return;
        }
        Number lb = frag.dom().lb();
        Number ub = frag.dom().ub();
        Interval d1 = new Interval(lb, false, xSplit, true);
        Interval d2 = new Interval(xSplit, false, ub, true);
        fragments.remove(fragIndex);
        fragments.add(fragIndex, new PsopFragment(c, b, frag.getA(), d2));
        fragments.add(fragIndex, new PsopFragment(frag.getC(), frag.getB(), frag.getA(), d1));
    }

    public static void projectTo(IPsop p, IInterval d) {
        if (PsopHelper.size(p) == 0) {
            return;
        }
        if (p.getFragments().get(0).dom().lb().doubleValue() >= d.ub().doubleValue()) {
            p.getFragments().clear();
        } else if (p.getFragments().get(PsopHelper.size(p) - 1).dom().ub().doubleValue() <= d.lb().doubleValue()) {
            p.getFragments().clear();
        } else {
            PsopHelper.handleLowerBound(p, d);
            PsopHelper.handleUpperBound(p, d);
        }
    }

    private static void handleLowerBound(IPsop p, IInterval d) {
        if (p.getFragments().get(0).dom().lb().doubleValue() >= d.lb().doubleValue()) {
            return;
        }
        int removeUpTo = -1;
        int i = 0;
        while (i < p.getFragments().size()) {
            IPsopFragment frag = p.getFragments().get(i);
            if (frag.dom().contains(d.lb())) {
                if (frag.dom().lb().doubleValue() == d.lb().doubleValue()) break;
                Number c = PsopHelper.valueAt(frag, d.lb());
                Number b = PsopHelper.valueDerivativeAt(frag, d.lb());
                p.getFragments().remove(i);
                p.getFragments().add(i, new PsopFragment(c, b, frag.getA(), new Interval(d.lb(), false, frag.dom().ub(), true)));
                break;
            }
            ++removeUpTo;
            ++i;
        }
        i = 0;
        while (i <= removeUpTo) {
            p.getFragments().remove(0);
            ++i;
        }
    }

    private static void handleUpperBound(IPsop p, IInterval d) {
        if (p.getFragments().get(PsopHelper.size(p) - 1).dom().ub().doubleValue() <= d.ub().doubleValue()) {
            return;
        }
        int removeFrom = PsopHelper.size(p);
        int i = 0;
        while (i < PsopHelper.size(p)) {
            IPsopFragment frag = p.getFragments().get(i);
            if (frag.dom().contains(d.ub())) {
                if (frag.dom().lb().doubleValue() != d.ub().doubleValue()) {
                    p.getFragments().remove(i);
                    p.getFragments().add(i, new PsopFragment(frag.getC(), frag.getB(), frag.getA(), new Interval(frag.dom().lb(), false, d.ub(), true)));
                    removeFrom = i + 1;
                    break;
                }
                removeFrom = i;
                break;
            }
            ++i;
        }
        int numToRemove = PsopHelper.size(p) - removeFrom;
        int i2 = 0;
        while (i2 < numToRemove) {
            p.getFragments().remove(removeFrom);
            ++i2;
        }
    }

    public static void alignWith(IPsop p, IPsop g) {
        PsopHelper.projectTo(p, PsopHelper.dom(g));
        Interval dom = PsopHelper.dom(p);
        int index = 0;
        int i = 0;
        while (i < PsopHelper.size(g) - 1) {
            double tSplit = g.getFragments().get(i).dom().ub().doubleValue();
            if (tSplit > dom.lb().doubleValue() && tSplit < dom.ub().doubleValue()) {
                IPsopFragment frag = p.getFragments().get(index);
                while (!frag.dom().contains(tSplit)) {
                    frag = p.getFragments().get(++index);
                }
                PsopHelper.splitFragment(p.getFragments(), index, frag, tSplit);
            } else if (tSplit > dom.ub().doubleValue()) break;
            ++i;
        }
    }

    public static Number valueAt(IPsopFragment f, Number x) {
        if (!f.dom().contains(x) && x.doubleValue() != f.dom().ub().doubleValue()) {
            throw new IllegalArgumentException(String.valueOf(x) + " not in domain of this fragment");
        }
        if (f.dom().lb().doubleValue() == Double.NEGATIVE_INFINITY) {
            if (f.getA().doubleValue() != 0.0 || f.getB().doubleValue() != 0.0) {
                throw new IllegalStateException();
            }
            return f.getC();
        }
        double dt = x.doubleValue() - f.dom().lb().doubleValue();
        return f.getC().doubleValue() + f.getB().doubleValue() * dt + f.getA().doubleValue() * dt * dt;
    }

    public static Number valueDerivativeAt(IPsopFragment f, Number t) {
        double a = f.getA().doubleValue();
        double b = f.getB().doubleValue();
        if (!f.dom().contains(t) && t.doubleValue() != f.dom().ub().doubleValue()) {
            throw new IllegalArgumentException(String.valueOf(t) + " not in domain of this fragment");
        }
        if (f.dom().lb().doubleValue() == Double.NEGATIVE_INFINITY) {
            if (a != 0.0 || b != 0.0) {
                throw new IllegalStateException();
            }
            return 0.0;
        }
        double dx = t.doubleValue() - f.dom().lb().doubleValue();
        return b + 2.0 * a * dx;
    }

    public static Number argZeroSlope(IPsopFragment f) {
        if (f.getShape() != Shape.PARABOLA_CAP && f.getShape() != Shape.PARABOLA_CUP) {
            throw new IllegalArgumentException("not a parabola shape");
        }
        double a = f.getA().doubleValue();
        double b = f.getB().doubleValue();
        double lb = f.dom().lb().doubleValue();
        return lb + -b / (2.0 * a);
    }

    public static MinMaxResult computeMinMax(IPsopFragment f) {
        double a = f.getA().doubleValue();
        double b = f.getB().doubleValue();
        double c = f.getC().doubleValue();
        double size = f.dom().ub().doubleValue() - f.dom().lb().doubleValue();
        double v1 = c;
        double v2 = a * size * size + b * size + c;
        if (f.getOrder() == 0) {
            return new MinMaxResult(v1);
        }
        if (f.getOrder() == 1) {
            return new MinMaxResult(v1, v2);
        }
        double tTop = -b / (2.0 * a);
        if (0.0 <= tTop && tTop <= size) {
            double v3 = a * tTop * tTop + b * tTop + c;
            return new MinMaxResult(v1, v2, v3);
        }
        return new MinMaxResult(v1, v2);
    }

    public static List<Double> computeIntersections(IPsopFragment f1, IPsopFragment f2) {
        if (!f1.dom().equals(f2.dom())) {
            throw new IllegalArgumentException("fragments should have equal time domains");
        }
        double a = f1.getA().doubleValue() - f2.getA().doubleValue();
        double b = f1.getB().doubleValue() - f2.getB().doubleValue();
        double c = f1.getC().doubleValue() - f2.getC().doubleValue();
        if (a == 0.0 && b == 0.0) {
            return Collections.emptyList();
        }
        if (a == 0.0) {
            double tSol = f1.dom().lb().doubleValue() + -c / b;
            if (f1.dom().contains(tSol)) {
                return Collections.singletonList(tSol);
            }
            return Collections.emptyList();
        }
        double t1 = f1.dom().lb().doubleValue() + (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        double t2 = f1.dom().lb().doubleValue() + (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        if (t2 < t1) {
            double tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        ArrayList<Double> r = new ArrayList<Double>();
        if (f1.dom().contains(t1)) {
            r.add(t1);
        }
        if (f1.dom().contains(t2) && !r.contains(t2)) {
            r.add(t2);
        }
        return r;
    }

    public static List<IClaim> createClaimRepresentationOfSatisfaction(IPsop signal, String claimName) {
        ArrayList<IClaim> claims = new ArrayList<IClaim>();
        Resource r = new Resource(100, false);
        r.setAttribute("name", "STL dummy");
        double t0 = PsopHelper.getDomainLowerBound(signal).doubleValue();
        boolean sat = PsopHelper.getStartValue(signal).doubleValue() >= 0.0;
        block5: for (ShapeSegment seg : PsopHelper.createMonotonicSegmentation(signal)) {
            block0 : switch (seg.getShape()) {
                case CONSTANT: {
                    double startT = signal.getFragments().get(seg.getBeginFragment()).dom().lb().doubleValue();
                    double value = signal.getFragments().get(seg.getBeginFragment()).getC().doubleValue();
                    if (!(sat && value < 0.0) && (sat || !(value >= 0.0))) continue block5;
                    PsopHelper.createClaim(claims, claimName, r, t0, startT, sat);
                    t0 = startT;
                    sat = !sat;
                    break;
                }
                case INCREASING: {
                    double t1;
                    double v1;
                    IPsopFragment frag;
                    if (sat) continue block5;
                    int i = seg.getBeginFragment();
                    while (i <= seg.getEndFragment()) {
                        frag = signal.getFragments().get(i);
                        v1 = PsopHelper.valueAt(frag, frag.dom().ub()).doubleValue();
                        if (v1 >= 0.0) {
                            t1 = PsopHelper.argZeroValue(frag).doubleValue();
                            PsopHelper.createClaim(claims, claimName, r, t0, t1, sat);
                            t0 = t1;
                            sat = !sat;
                            break block0;
                        }
                        ++i;
                    }
                    continue block5;
                }
                case DECREASING: {
                    double t1;
                    double v1;
                    IPsopFragment frag;
                    if (!sat) continue block5;
                    int i = seg.getBeginFragment();
                    while (i <= seg.getEndFragment()) {
                        frag = signal.getFragments().get(i);
                        v1 = PsopHelper.valueAt(frag, frag.dom().ub()).doubleValue();
                        if (v1 < 0.0) {
                            t1 = PsopHelper.argZeroValue(frag).doubleValue();
                            PsopHelper.createClaim(claims, claimName, r, t0, t1, sat);
                            t0 = t1;
                            sat = !sat;
                            break block0;
                        }
                        ++i;
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        double t1 = PsopHelper.getDomainUpperBound(signal).doubleValue();
        PsopHelper.createClaim(claims, claimName, r, t0, t1, sat);
        return claims;
    }

    private static Number argZeroValue(IPsopFragment f) {
        if (f.getShape() == Shape.CONSTANT) {
            if (f.getC().doubleValue() == 0.0) {
                return f.dom().lb();
            }
            throw new IllegalArgumentException("not an increasing or decreasing shape");
        }
        if (f.getShape() != Shape.INCREASING && f.getShape() != Shape.DECREASING) {
            throw new IllegalArgumentException("not an increasing or decreasing shape");
        }
        double lb = f.dom().lb().doubleValue();
        double a = f.getA().doubleValue();
        double b = f.getB().doubleValue();
        double c = f.getC().doubleValue();
        if (f.getOrder() == 1) {
            return lb + -f.getC().doubleValue() / f.getB().doubleValue();
        }
        double d = Math.sqrt(b * b - 4.0 * a * c);
        double x1 = lb + (-b + d) / (2.0 * a);
        double x2 = lb + (-b - d) / (2.0 * a);
        if (f.dom().contains(x1)) {
            return x1;
        }
        if (f.dom().contains(x2)) {
            return x2;
        }
        return Double.NaN;
    }

    private static void createClaim(List<IClaim> claims, String name, Resource r, double t0, double t1, boolean sat) {
        Claim c = new Claim(t0, t1, r, 1);
        c.setAttribute("phi", name);
        c.setAttribute("type", "STL");
        c.setAttribute("color", sat ? "dark_green" : "dark_red");
        c.setAttribute("sat", Boolean.toString(sat));
        claims.add(c);
    }

    public static final class MinMaxResult {
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;

        public MinMaxResult() {
        }

        private MinMaxResult(double x) {
            this.addToMin(x);
            this.addToMax(x);
        }

        private MinMaxResult(double x1, double x2) {
            this.addToMin(x1);
            this.addToMin(x2);
            this.addToMax(x1);
            this.addToMax(x2);
        }

        private MinMaxResult(double x1, double x2, double x3) {
            this.addToMin(x1);
            this.addToMin(x2);
            this.addToMin(x3);
            this.addToMax(x1);
            this.addToMax(x2);
            this.addToMax(x3);
        }

        private void addToMin(double x) {
            this.min = Math.min(this.min, x);
        }

        private void addToMax(double x) {
            this.max = Math.max(this.max, x);
        }

        public void combineWith(MinMaxResult r) {
            this.addToMin(r.min);
            this.addToMax(r.max);
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }

    public static final class ShapeSegment {
        private final int beginFragment;
        private final int endFragment;
        private final Shape shape;

        public ShapeSegment(int start, int end, Shape shape) {
            this.beginFragment = start;
            this.endFragment = end;
            this.shape = shape;
            if (shape == Shape.PARABOLA_CAP || shape == Shape.PARABOLA_CUP) {
                throw new IllegalArgumentException("only monotonic shapes can be used");
            }
        }

        public int getBeginFragment() {
            return this.beginFragment;
        }

        public int getEndFragment() {
            return this.endFragment;
        }

        public Shape getShape() {
            return this.shape;
        }

        public String toString() {
            return "ShapeSegment[" + this.beginFragment + "->" + this.endFragment + " : " + String.valueOf((Object)this.shape) + "]";
        }
    }
}

