/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfigurationInfo;
import org.eclipse.debug.internal.core.LaunchConfigurationType;
import org.eclipse.debug.internal.core.LaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LaunchConfiguration
extends PlatformObject
implements ILaunchConfiguration {
    public static final String ATTR_MAPPED_RESOURCE_PATHS = DebugPlugin.getUniqueIdentifier() + ".MAPPED_RESOURCE_PATHS";
    public static final String ATTR_MAPPED_RESOURCE_TYPES = DebugPlugin.getUniqueIdentifier() + ".MAPPED_RESOURCE_TYPES";
    public static final String ATTR_LAUNCH_MODES = DebugPlugin.getUniqueIdentifier() + ".LAUNCH_MODES";
    public static final String ATTR_PREFERRED_LAUNCHERS = DebugPlugin.getUniqueIdentifier() + ".preferred_launchers";
    public static final String ATTR_PROTOTYPE = DebugPlugin.getUniqueIdentifier() + ".ATTR_PROTOTYPE";
    public static final String IS_PROTOTYPE = DebugPlugin.getUniqueIdentifier() + ".IS_PROTOTYPE";
    protected static final IStatus promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    protected static final IStatus delegateNotAvailable = new Status(1, "org.eclipse.debug.core", 226, "", null);
    protected static final IStatus duplicateDelegates = new Status(1, "org.eclipse.debug.core", 227, "", null);
    private String fName;
    private IContainer fContainer;
    private boolean fIsPrototype;

    protected LaunchConfiguration(String name, IContainer container) {
        this(name, container, false);
    }

    protected LaunchConfiguration(String name, IContainer container, boolean prototype) {
        this.initialize();
        this.setName(name);
        this.setContainer(container);
        this.fIsPrototype = prototype;
    }

    protected void initialize() {
    }

    protected LaunchConfiguration(IFile file) {
        this(LaunchConfiguration.getSimpleName(file.getName()), file.getParent(), LaunchConfiguration.isPrototype(file));
    }

    protected static String getSimpleName(String fileName) {
        IPath path = IPath.fromOSString((String)fileName);
        if ("launch".equals(path.getFileExtension())) {
            return path.removeFileExtension().toString();
        }
        if ("prototype".equals(path.getFileExtension())) {
            return path.removeFileExtension().toString();
        }
        return fileName;
    }

    protected LaunchConfiguration(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
            parser.setErrorHandler(new DefaultHandler());
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String localString = root.getAttribute("local");
            String path = root.getAttribute("path");
            String message = null;
            if (path == null || "".equals(path)) {
                message = DebugCoreMessages.LaunchConfiguration_18;
            } else if (localString == null || "".equals(localString)) {
                message = DebugCoreMessages.LaunchConfiguration_19;
            }
            if (message != null) {
                throw new CoreException(this.newStatus(message, 5013, null));
            }
            boolean local = Boolean.parseBoolean(localString);
            IPath iPath = IPath.fromOSString((String)path);
            String name = LaunchConfiguration.getSimpleName(iPath.lastSegment());
            IContainer container = null;
            if (!local) {
                container = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath).getParent();
            }
            this.setName(name);
            this.setContainer(container);
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        IStatus s = this.newStatus(DebugCoreMessages.LaunchConfiguration_17, 5013, ex);
        throw new CoreException(s);
    }

    @Override
    public boolean contentsEqual(ILaunchConfiguration object) {
        try {
            if (object instanceof LaunchConfiguration) {
                LaunchConfiguration otherConfig = (LaunchConfiguration)object;
                return this.getName().equals(otherConfig.getName()) && this.getType().equals(otherConfig.getType()) && this.equalOrNull(this.getContainer(), otherConfig.getContainer()) && this.getInfo().equals(otherConfig.getInfo());
            }
            return false;
        }
        catch (CoreException ce) {
            return false;
        }
    }

    @Override
    public ILaunchConfigurationWorkingCopy copy(String name) throws CoreException {
        LaunchConfigurationWorkingCopy copy = new LaunchConfigurationWorkingCopy(this, name);
        return copy;
    }

    @Override
    public void delete() throws CoreException {
        if (this.exists()) {
            IFile file = this.getFile();
            if (file == null) {
                IFileStore store = this.getFileStore();
                if (store != null) {
                    store.delete(0, null);
                    if (store.fetchInfo().exists()) {
                        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchConfiguration_Failed_to_delete_launch_configuration__1, null));
                    }
                }
            } else {
                IStatus status;
                if (file.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).isOK()) {
                    throw new CoreException(status);
                }
                file.delete(true, null);
            }
            this.getLaunchManager().launchConfigurationDeleted(this);
        }
    }

    @Override
    public void delete(int flag) throws CoreException {
        if (flag == 1 && this.isPrototype()) {
            Collection<ILaunchConfiguration> children = this.getPrototypeChildren();
            for (ILaunchConfiguration child : children) {
                ILaunchConfigurationWorkingCopy childWC = child.getWorkingCopy();
                childWC.setPrototype(null, false);
                childWC.doSave();
            }
        }
        this.delete();
    }

    public boolean equals(Object object) {
        if (object instanceof ILaunchConfiguration) {
            if (this.isWorkingCopy()) {
                return this == object;
            }
            LaunchConfiguration config = (LaunchConfiguration)object;
            if (!config.isWorkingCopy()) {
                return this.getName().equals(config.getName()) && this.equalOrNull(this.getContainer(), config.getContainer());
            }
        }
        return false;
    }

    protected boolean equalOrNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    @Override
    public boolean exists() {
        IFile file = this.getFile();
        if (file != null) {
            return file.exists();
        }
        try {
            IFileStore store = this.getFileStore();
            if (store != null) {
                return store.fetchInfo().exists();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean getAttribute(String attributeName, boolean defaultValue) throws CoreException {
        return this.getInfo().getBooleanAttribute(attributeName, defaultValue);
    }

    @Override
    public int getAttribute(String attributeName, int defaultValue) throws CoreException {
        return this.getInfo().getIntAttribute(attributeName, defaultValue);
    }

    @Override
    public List<String> getAttribute(String attributeName, List<String> defaultValue) throws CoreException {
        return this.getInfo().getListAttribute(attributeName, defaultValue);
    }

    @Override
    public Set<String> getAttribute(String attributeName, Set<String> defaultValue) throws CoreException {
        return this.getInfo().getSetAttribute(attributeName, defaultValue);
    }

    @Override
    public Map<String, String> getAttribute(String attributeName, Map<String, String> defaultValue) throws CoreException {
        return this.getInfo().getMapAttribute(attributeName, defaultValue);
    }

    @Override
    public String getAttribute(String attributeName, String defaultValue) throws CoreException {
        return this.getInfo().getStringAttribute(attributeName, defaultValue);
    }

    @Override
    public Map<String, Object> getAttributes() throws CoreException {
        LaunchConfigurationInfo info = this.getInfo();
        return info.getAttributes();
    }

    @Override
    public String getCategory() throws CoreException {
        return this.getType().getCategory();
    }

    @Override
    public IFile getFile() {
        IContainer container = this.getContainer();
        if (container != null) {
            return container.getFile(IPath.fromOSString((String)this.getFileName()));
        }
        return null;
    }

    protected String getFileName() {
        StringBuilder buf = new StringBuilder(this.getName());
        buf.append('.');
        if (this.isPrototype()) {
            buf.append("prototype");
        } else {
            buf.append("launch");
        }
        return buf.toString();
    }

    protected LaunchConfigurationInfo getInfo() throws CoreException {
        return this.getLaunchManager().getInfo(this);
    }

    protected LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    @Override
    public IPath getLocation() {
        try {
            File localFile;
            IFileStore store = this.getFileStore();
            if (store != null && (localFile = store.toLocalFile(0, null)) != null) {
                return IPath.fromOSString((String)localFile.getAbsolutePath());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public IFileStore getFileStore() throws CoreException {
        if (this.isLocal()) {
            return EFS.getLocalFileSystem().fromLocalFile(LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH.append(this.getFileName()).toFile());
        }
        URI uri = this.getFile().getLocationURI();
        if (uri != null) {
            return EFS.getStore((URI)uri);
        }
        return null;
    }

    @Override
    public IResource[] getMappedResources() throws CoreException {
        List<String> paths = this.getAttribute(ATTR_MAPPED_RESOURCE_PATHS, (List<String>)null);
        if (paths == null || paths.isEmpty()) {
            return null;
        }
        List<String> types = this.getAttribute(ATTR_MAPPED_RESOURCE_TYPES, (List<String>)null);
        if (types == null || types.size() != paths.size()) {
            throw new CoreException(this.newStatus(DebugCoreMessages.LaunchConfiguration_0, 125, null));
        }
        ArrayList<IWorkspaceRoot> list = new ArrayList<IWorkspaceRoot>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < paths.size()) {
            String pathStr = paths.get(i);
            String typeStr = types.get(i);
            int type = -1;
            try {
                type = Integer.decode(typeStr);
            }
            catch (NumberFormatException e) {
                throw new CoreException(this.newStatus(DebugCoreMessages.LaunchConfiguration_0, 125, e));
            }
            IPath path = IPath.fromPortableString((String)pathStr);
            IWorkspaceRoot res = null;
            switch (type) {
                case 1: {
                    res = root.getFile(path);
                    break;
                }
                case 4: {
                    pathStr = path.makeRelative().toPortableString();
                    if (!IPath.ROOT.isValidSegment(pathStr)) break;
                    res = root.getProject(pathStr);
                    break;
                }
                case 2: {
                    res = root.getFolder(path);
                    break;
                }
                case 8: {
                    res = root;
                    break;
                }
                default: {
                    throw new CoreException(this.newStatus(DebugCoreMessages.LaunchConfiguration_0, 125, null));
                }
            }
            if (res != null) {
                list.add(res);
            }
            ++i;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new IResource[list.size()]);
    }

    @Override
    public String getMemento() throws CoreException {
        IPath relativePath = null;
        IFile file = this.getFile();
        String lineDelimeter = this.getLineSeparator();
        boolean local = true;
        if (file == null) {
            relativePath = IPath.fromOSString((String)this.getName());
        } else {
            local = false;
            relativePath = file.getFullPath();
        }
        Exception e = null;
        try {
            Document doc = LaunchManager.getDocument();
            Element node = doc.createElement("launchConfiguration");
            doc.appendChild(node);
            node.setAttribute("local", Boolean.toString(local));
            node.setAttribute("path", relativePath.toString());
            return LaunchManager.serializeDocument(doc, lineDelimeter);
        }
        catch (IOException ioe) {
            e = ioe;
        }
        catch (ParserConfigurationException pce) {
            e = pce;
        }
        catch (TransformerException te) {
            e = te;
        }
        IStatus status = this.newStatus(DebugCoreMessages.LaunchConfiguration_16, 5013, e);
        throw new CoreException(status);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    protected IContainer getContainer() {
        return this.fContainer;
    }

    @Override
    public Set<String> getModes() throws CoreException {
        Set<String> options = this.getAttribute(ATTR_LAUNCH_MODES, (Set<String>)null);
        return options != null ? new HashSet<String>(options) : new HashSet(0);
    }

    @Override
    public ILaunchConfigurationType getType() throws CoreException {
        return this.getInfo().getType();
    }

    @Override
    public ILaunchConfigurationWorkingCopy getWorkingCopy() throws CoreException {
        return new LaunchConfigurationWorkingCopy(this);
    }

    public int hashCode() {
        IContainer container = this.getContainer();
        if (container == null) {
            return this.getName().hashCode();
        }
        return this.getName().hashCode() + container.hashCode();
    }

    @Override
    public boolean hasAttribute(String attributeName) throws CoreException {
        return this.getInfo().hasAttribute(attributeName);
    }

    protected void initializeSourceLocator(ILaunch launch) throws CoreException {
        if (launch.getSourceLocator() == null) {
            String type = this.getAttribute(ATTR_SOURCE_LOCATOR_ID, (String)null);
            if (type == null) {
                type = this.getType().getSourceLocatorId();
            }
            if (type != null) {
                IPersistableSourceLocator locator = this.getLaunchManager().newSourceLocator(type);
                String memento = this.getAttribute(ATTR_SOURCE_LOCATOR_MEMENTO, (String)null);
                if (memento == null) {
                    locator.initializeDefaults(this);
                } else if (locator instanceof IPersistableSourceLocator2) {
                    ((IPersistableSourceLocator2)locator).initializeFromMemento(memento, this);
                } else {
                    locator.initializeFromMemento(memento);
                }
                launch.setSourceLocator(locator);
            }
        }
    }

    @Override
    public boolean isLocal() {
        return this.getContainer() == null;
    }

    @Override
    public boolean isMigrationCandidate() throws CoreException {
        return ((LaunchConfigurationType)this.getType()).isMigrationCandidate(this);
    }

    @Override
    public boolean isWorkingCopy() {
        return false;
    }

    @Override
    public ILaunch launch(String mode, IProgressMonitor monitor) throws CoreException {
        return this.launch(mode, monitor, false);
    }

    @Override
    public ILaunch launch(String mode, IProgressMonitor monitor, boolean build) throws CoreException {
        return this.launch(mode, monitor, build, true);
    }

    @Override
    public ILaunch launch(String mode, IProgressMonitor monitor, boolean build, boolean register) throws CoreException {
        SubMonitor lmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)DebugCoreMessages.LaunchConfiguration_9, (int)23);
        try {
            ILaunch launch;
            ILaunchConfigurationDelegate2 delegate2;
            ILaunchConfigurationDelegate delegate;
            block25: {
                delegate = this.getPreferredLaunchDelegate(mode);
                delegate2 = null;
                if (delegate instanceof ILaunchConfigurationDelegate2) {
                    delegate2 = (ILaunchConfigurationDelegate2)delegate;
                }
                launch = null;
                if (delegate2 != null) {
                    launch = delegate2.getLaunch(this, mode);
                }
                if (launch == null) {
                    launch = new Launch(this, mode, null);
                } else if (!mode.equals(launch.getLaunchMode())) {
                    Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, MessageFormat.format(DebugCoreMessages.LaunchConfiguration_14, mode, launch.getLaunchMode()), null);
                    throw new CoreException((IStatus)status);
                }
                launch.setAttribute("org.eclipse.debug.core.launch.timestamp", Long.toString(System.currentTimeMillis()));
                boolean captureOutput = this.getAttribute("org.eclipse.debug.core.capture_output", true);
                if (!captureOutput) {
                    launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
                } else {
                    launch.setAttribute("org.eclipse.debug.core.capture_output", null);
                }
                if (!this.getAttribute("org.eclipse.debug.core.ATTR_FORCE_SYSTEM_CONSOLE_ENCODING", false)) {
                    launch.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", this.getLaunchManager().getEncoding(this));
                }
                if (register) {
                    this.getLaunchManager().addLaunch(launch);
                }
                lmonitor.subTask(DebugCoreMessages.LaunchConfiguration_8);
                if (delegate2 == null || delegate2.preLaunchCheck(this, mode, (IProgressMonitor)lmonitor.split(1))) break block25;
                this.getLaunchManager().removeLaunch(launch);
                ILaunch iLaunch = launch;
                return iLaunch;
            }
            lmonitor.setWorkRemaining(22);
            if (build) {
                lmonitor.subTask(DebugCoreMessages.LaunchConfiguration_7 + DebugCoreMessages.LaunchConfiguration_6);
                boolean tempbuild = build;
                if (delegate2 != null) {
                    tempbuild = delegate2.buildForLaunch(this, mode, (IProgressMonitor)lmonitor.split(7));
                }
                if (tempbuild) {
                    lmonitor.subTask(DebugCoreMessages.LaunchConfiguration_7 + DebugCoreMessages.LaunchConfiguration_5);
                    ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)lmonitor.split(3));
                }
            }
            lmonitor.setWorkRemaining(12);
            lmonitor.subTask(DebugCoreMessages.LaunchConfiguration_4);
            if (delegate2 != null && !delegate2.finalLaunchCheck(this, mode, (IProgressMonitor)lmonitor.split(1))) {
                this.getLaunchManager().removeLaunch(launch);
                ILaunch iLaunch = launch;
                return iLaunch;
            }
            try {
                lmonitor.setWorkRemaining(11);
                lmonitor.subTask(DebugCoreMessages.LaunchConfiguration_3);
                this.initializeSourceLocator(launch);
                lmonitor.worked(1);
                lmonitor.subTask(DebugCoreMessages.LaunchConfiguration_2);
                delegate.launch(this, mode, launch, (IProgressMonitor)lmonitor.split(10));
            }
            catch (CoreException e) {
                if (launch != null && !launch.hasChildren()) {
                    this.getLaunchManager().removeLaunch(launch);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (launch != null && !launch.hasChildren()) {
                    this.getLaunchManager().removeLaunch(launch);
                }
                throw e;
            }
            if (lmonitor.isCanceled()) {
                this.getLaunchManager().removeLaunch(launch);
            }
            ILaunch iLaunch = launch;
            return iLaunch;
        }
        finally {
            lmonitor.done();
        }
    }

    @Override
    public void migrate() throws CoreException {
        ((LaunchConfigurationType)this.getType()).migrate(this);
    }

    protected IStatus newStatus(String message, int code, Throwable e) {
        return new Status(4, DebugPlugin.getUniqueIdentifier(), code, message, e);
    }

    protected void setName(String name) {
        this.fName = name;
    }

    protected void setContainer(IContainer container) {
        this.fContainer = container;
    }

    @Override
    public boolean supportsMode(String mode) throws CoreException {
        return this.getType().supportsMode(mode);
    }

    @Override
    public boolean isReadOnly() {
        try {
            IFileStore fileStore = this.getFileStore();
            if (fileStore != null) {
                return fileStore.fetchInfo().getAttribute(2);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public ILaunchDelegate getPreferredDelegate(Set<String> modes) throws CoreException {
        String id;
        Map<String, String> delegates = this.getAttribute(ATTR_PREFERRED_LAUNCHERS, (Map<String, String>)null);
        if (delegates != null && (id = delegates.get(modes.toString())) != null) {
            return this.getLaunchManager().getLaunchDelegate(id);
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ILaunchConfiguration getPrototype() throws CoreException {
        String memento = this.getAttribute(ATTR_PROTOTYPE, (String)null);
        if (memento != null) {
            LaunchConfiguration prototype = new LaunchConfiguration(memento);
            prototype.setIsPrototype(true);
            return prototype;
        }
        return null;
    }

    @Override
    public Collection<ILaunchConfiguration> getPrototypeChildren() throws CoreException {
        ILaunchConfiguration[] configurations = this.getLaunchManager().getLaunchConfigurations(this.getType());
        ArrayList<ILaunchConfiguration> proteges = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (this.equals(config.getPrototype())) {
                proteges.add(config);
            }
            ++n2;
        }
        return proteges;
    }

    @Override
    public boolean isPrototype() {
        return this.fIsPrototype;
    }

    protected void setIsPrototype(boolean isPrototype) {
        this.fIsPrototype = isPrototype;
    }

    protected static boolean isPrototype(IFile file) {
        return "prototype".equals(file.getFileExtension());
    }

    @Override
    public int getKind() throws CoreException {
        if (this.fIsPrototype) {
            return 2;
        }
        return 1;
    }

    @Override
    public boolean isAttributeModified(String attribute) throws CoreException {
        ILaunchConfiguration prototype = this.getPrototype();
        if (prototype != null) {
            Object attributeValue;
            Object prototypeValue = prototype.getAttributes().get(attribute);
            return !LaunchConfigurationInfo.compareAttribute(attribute, prototypeValue, attributeValue = this.getAttributes().get(attribute));
        }
        return false;
    }

    @Override
    public Set<String> getPrototypeVisibleAttributes() throws CoreException {
        return this.getInfo().getVisibleAttributes();
    }

    @Override
    public void setPrototypeAttributeVisibility(String attribute, boolean visible) throws CoreException {
        this.getInfo().setAttributeVisibility(attribute, visible);
    }

    public ILaunchConfigurationDelegate getPreferredLaunchDelegate(String mode) throws CoreException {
        Set<String> modes = this.getModes();
        modes.add(mode);
        ILaunchDelegate[] delegates = this.getType().getDelegates(modes);
        ILaunchConfigurationDelegate delegate = null;
        switch (delegates.length) {
            case 1: {
                delegate = delegates[0].getDelegate();
                break;
            }
            case 0: {
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                if (handler != null) {
                    handler.handleStatus(delegateNotAvailable, new Object[]{this, mode});
                }
                Status status = new Status(8, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.LaunchConfiguration_11, null);
                throw new CoreException((IStatus)status);
            }
            default: {
                ILaunchDelegate del = this.getPreferredDelegate(modes);
                if (del == null) {
                    del = this.getType().getPreferredDelegate(modes);
                }
                if (del == null) {
                    IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                    Status status = null;
                    if (handler != null) {
                        status = (IStatus)handler.handleStatus(duplicateDelegates, new Object[]{this, mode});
                    }
                    if (status != null && status.isOK()) {
                        del = this.getPreferredDelegate(modes);
                        if (del == null) {
                            del = this.getType().getPreferredDelegate(modes);
                        }
                        if (del != null) {
                            delegate = del.getDelegate();
                            break;
                        }
                        status = new Status(8, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.LaunchConfiguration_13, null);
                        throw new CoreException((IStatus)status);
                    }
                    status = new Status(8, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.LaunchConfiguration_13, null);
                    throw new CoreException((IStatus)status);
                }
                delegate = del.getDelegate();
            }
        }
        return delegate;
    }

    protected String getLineSeparator() throws CoreException {
        IFile file = this.getFile();
        if (file != null) {
            return file.getLineSeparator(true);
        }
        return System.lineSeparator();
    }
}

