/**
 */
package org.eclipse.lsat.common.scheduler.graph;

import org.eclipse.lsat.common.graph.directed.DirectedGraphPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.lsat.common.scheduler.graph.GraphFactory
 * @model kind="package"
 * @generated
 */
public interface GraphPackage extends EPackage {
	/**
     * The package name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNAME = "graph";

	/**
     * The package namespace URI.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_URI = "http://www.eclipse.org/lsat/scheduler/graph";

	/**
     * The package namespace name.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String eNS_PREFIX = "graph";

	/**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	GraphPackage eINSTANCE = org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl.init();

	/**
     * The meta object id for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.TaskDependencyGraphImpl <em>Task Dependency Graph</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see org.eclipse.lsat.common.scheduler.graph.impl.TaskDependencyGraphImpl
     * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getTaskDependencyGraph()
     * @generated
     */
	int TASK_DEPENDENCY_GRAPH = 0;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH__NAME = DirectedGraphPackage.DIRECTED_GRAPH__NAME;

	/**
     * The feature id for the '<em><b>Sub Graphs</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH__SUB_GRAPHS = DirectedGraphPackage.DIRECTED_GRAPH__SUB_GRAPHS;

	/**
     * The feature id for the '<em><b>Parent Graph</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH__PARENT_GRAPH = DirectedGraphPackage.DIRECTED_GRAPH__PARENT_GRAPH;

	/**
     * The feature id for the '<em><b>Edges</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH__EDGES = DirectedGraphPackage.DIRECTED_GRAPH__EDGES;

	/**
     * The feature id for the '<em><b>Nodes</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH__NODES = DirectedGraphPackage.DIRECTED_GRAPH__NODES;

	/**
     * The feature id for the '<em><b>Aspects</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH__ASPECTS = DirectedGraphPackage.DIRECTED_GRAPH__ASPECTS;

	/**
     * The feature id for the '<em><b>Resource Model</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH__RESOURCE_MODEL = DirectedGraphPackage.DIRECTED_GRAPH_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Constraints</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TASK_DEPENDENCY_GRAPH__CONSTRAINTS = DirectedGraphPackage.DIRECTED_GRAPH_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Task Dependency Graph</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH_FEATURE_COUNT = DirectedGraphPackage.DIRECTED_GRAPH_FEATURE_COUNT + 2;

	/**
     * The operation id for the '<em>All Nodes In Topological Order</em>' operation.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH___ALL_NODES_IN_TOPOLOGICAL_ORDER = DirectedGraphPackage.DIRECTED_GRAPH___ALL_NODES_IN_TOPOLOGICAL_ORDER;

	/**
     * The number of operations of the '<em>Task Dependency Graph</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_DEPENDENCY_GRAPH_OPERATION_COUNT = DirectedGraphPackage.DIRECTED_GRAPH_OPERATION_COUNT + 0;

	/**
     * The meta object id for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.TaskImpl <em>Task</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see org.eclipse.lsat.common.scheduler.graph.impl.TaskImpl
     * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getTask()
     * @generated
     */
	int TASK = 1;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__NAME = DirectedGraphPackage.NODE__NAME;

	/**
     * The feature id for the '<em><b>Outgoing Edges</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__OUTGOING_EDGES = DirectedGraphPackage.NODE__OUTGOING_EDGES;

	/**
     * The feature id for the '<em><b>Incoming Edges</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__INCOMING_EDGES = DirectedGraphPackage.NODE__INCOMING_EDGES;

	/**
     * The feature id for the '<em><b>Graph</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__GRAPH = DirectedGraphPackage.NODE__GRAPH;

	/**
     * The feature id for the '<em><b>Aspects</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__ASPECTS = DirectedGraphPackage.NODE__ASPECTS;

	/**
     * The feature id for the '<em><b>Properties</b></em>' map.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TASK__PROPERTIES = DirectedGraphPackage.NODE__PROPERTIES;

    /**
     * The feature id for the '<em><b>Execution Time</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__EXECUTION_TIME = DirectedGraphPackage.NODE_FEATURE_COUNT + 0;

	/**
     * The feature id for the '<em><b>Execution Data</b></em>' map.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TASK__EXECUTION_DATA = DirectedGraphPackage.NODE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Execution Data Parameters</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TASK__EXECUTION_DATA_PARAMETERS = DirectedGraphPackage.NODE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Resources</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK__RESOURCES = DirectedGraphPackage.NODE_FEATURE_COUNT + 3;

	/**
     * The number of structural features of the '<em>Task</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_FEATURE_COUNT = DirectedGraphPackage.NODE_FEATURE_COUNT + 4;

	/**
     * The operation id for the '<em>Add Execution Data</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TASK___ADD_EXECUTION_DATA__STRING_ELIST = DirectedGraphPackage.NODE_OPERATION_COUNT + 0;

    /**
     * The number of operations of the '<em>Task</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TASK_OPERATION_COUNT = DirectedGraphPackage.NODE_OPERATION_COUNT + 1;

	/**
     * The meta object id for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.DependencyImpl <em>Dependency</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see org.eclipse.lsat.common.scheduler.graph.impl.DependencyImpl
     * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getDependency()
     * @generated
     */
	int DEPENDENCY = 2;

	/**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPENDENCY__NAME = DirectedGraphPackage.EDGE__NAME;

	/**
     * The feature id for the '<em><b>Source Node</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPENDENCY__SOURCE_NODE = DirectedGraphPackage.EDGE__SOURCE_NODE;

	/**
     * The feature id for the '<em><b>Target Node</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPENDENCY__TARGET_NODE = DirectedGraphPackage.EDGE__TARGET_NODE;

	/**
     * The feature id for the '<em><b>Graph</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPENDENCY__GRAPH = DirectedGraphPackage.EDGE__GRAPH;

	/**
     * The feature id for the '<em><b>Aspects</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPENDENCY__ASPECTS = DirectedGraphPackage.EDGE__ASPECTS;

	/**
     * The number of structural features of the '<em>Dependency</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPENDENCY_FEATURE_COUNT = DirectedGraphPackage.EDGE_FEATURE_COUNT + 0;

	/**
     * The number of operations of the '<em>Dependency</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DEPENDENCY_OPERATION_COUNT = DirectedGraphPackage.EDGE_OPERATION_COUNT + 0;


	/**
     * The meta object id for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.ExecutionDataEntryImpl <em>Execution Data Entry</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.lsat.common.scheduler.graph.impl.ExecutionDataEntryImpl
     * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getExecutionDataEntry()
     * @generated
     */
    int EXECUTION_DATA_ENTRY = 3;

    /**
     * The feature id for the '<em><b>Key</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXECUTION_DATA_ENTRY__KEY = 0;

    /**
     * The feature id for the '<em><b>Value</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXECUTION_DATA_ENTRY__VALUE = 1;

    /**
     * The number of structural features of the '<em>Execution Data Entry</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXECUTION_DATA_ENTRY_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Execution Data Entry</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXECUTION_DATA_ENTRY_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.TimeStepDataImpl <em>Time Step Data</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.lsat.common.scheduler.graph.impl.TimeStepDataImpl
     * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getTimeStepData()
     * @generated
     */
    int TIME_STEP_DATA = 4;

    /**
     * The feature id for the '<em><b>Values</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_STEP_DATA__VALUES = 0;

    /**
     * The number of structural features of the '<em>Time Step Data</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_STEP_DATA_FEATURE_COUNT = 1;

    /**
     * The operation id for the '<em>Time Value</em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_STEP_DATA___TIME_VALUE = 0;

    /**
     * The number of operations of the '<em>Time Step Data</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_STEP_DATA_OPERATION_COUNT = 1;

    /**
     * The meta object id for the '{@link org.eclipse.lsat.common.scheduler.graph.Constraint <em>Constraint</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.lsat.common.scheduler.graph.Constraint
     * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getConstraint()
     * @generated
     */
    int CONSTRAINT = 5;

    /**
     * The feature id for the '<em><b>Source</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONSTRAINT__SOURCE = 0;

    /**
     * The feature id for the '<em><b>Target</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONSTRAINT__TARGET = 1;

    /**
     * The number of structural features of the '<em>Constraint</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONSTRAINT_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Constraint</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONSTRAINT_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.JitConstraintImpl <em>Jit Constraint</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.lsat.common.scheduler.graph.impl.JitConstraintImpl
     * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getJitConstraint()
     * @generated
     */
    int JIT_CONSTRAINT = 6;

    /**
     * The feature id for the '<em><b>Source</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int JIT_CONSTRAINT__SOURCE = CONSTRAINT__SOURCE;

    /**
     * The feature id for the '<em><b>Target</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int JIT_CONSTRAINT__TARGET = CONSTRAINT__TARGET;

    /**
     * The number of structural features of the '<em>Jit Constraint</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int JIT_CONSTRAINT_FEATURE_COUNT = CONSTRAINT_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Jit Constraint</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int JIT_CONSTRAINT_OPERATION_COUNT = CONSTRAINT_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.TimeConstraintImpl <em>Time Constraint</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.lsat.common.scheduler.graph.impl.TimeConstraintImpl
     * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getTimeConstraint()
     * @generated
     */
    int TIME_CONSTRAINT = 7;

    /**
     * The feature id for the '<em><b>Source</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_CONSTRAINT__SOURCE = CONSTRAINT__SOURCE;

    /**
     * The feature id for the '<em><b>Target</b></em>' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_CONSTRAINT__TARGET = CONSTRAINT__TARGET;

    /**
     * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_CONSTRAINT__LOWER_BOUND = CONSTRAINT_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_CONSTRAINT__UPPER_BOUND = CONSTRAINT_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Time Constraint</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_CONSTRAINT_FEATURE_COUNT = CONSTRAINT_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Time Constraint</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int TIME_CONSTRAINT_OPERATION_COUNT = CONSTRAINT_OPERATION_COUNT + 0;


    /**
     * Returns the meta object for class '{@link org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph <em>Task Dependency Graph</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Task Dependency Graph</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph
     * @generated
     */
	EClass getTaskDependencyGraph();

	/**
     * Returns the meta object for the reference '{@link org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph#getResourceModel <em>Resource Model</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Resource Model</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph#getResourceModel()
     * @see #getTaskDependencyGraph()
     * @generated
     */
	EReference getTaskDependencyGraph_ResourceModel();

	/**
     * Returns the meta object for the containment reference list '{@link org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph#getConstraints <em>Constraints</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Constraints</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph#getConstraints()
     * @see #getTaskDependencyGraph()
     * @generated
     */
    EReference getTaskDependencyGraph_Constraints();

    /**
     * Returns the meta object for class '{@link org.eclipse.lsat.common.scheduler.graph.Task <em>Task</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Task</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.Task
     * @generated
     */
	EClass getTask();

	/**
     * Returns the meta object for the attribute '{@link org.eclipse.lsat.common.scheduler.graph.Task#getExecutionTime <em>Execution Time</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Execution Time</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.Task#getExecutionTime()
     * @see #getTask()
     * @generated
     */
	EAttribute getTask_ExecutionTime();

	/**
     * Returns the meta object for the map '{@link org.eclipse.lsat.common.scheduler.graph.Task#getExecutionData <em>Execution Data</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the map '<em>Execution Data</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.Task#getExecutionData()
     * @see #getTask()
     * @generated
     */
    EReference getTask_ExecutionData();

    /**
     * Returns the meta object for the attribute list '{@link org.eclipse.lsat.common.scheduler.graph.Task#getExecutionDataParameters <em>Execution Data Parameters</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute list '<em>Execution Data Parameters</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.Task#getExecutionDataParameters()
     * @see #getTask()
     * @generated
     */
    EAttribute getTask_ExecutionDataParameters();

    /**
     * Returns the meta object for the reference list '{@link org.eclipse.lsat.common.scheduler.graph.Task#getResources <em>Resources</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Resources</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.Task#getResources()
     * @see #getTask()
     * @generated
     */
	EReference getTask_Resources();

	/**
     * Returns the meta object for the '{@link org.eclipse.lsat.common.scheduler.graph.Task#addExecutionData(java.lang.String, org.eclipse.emf.common.util.EList) <em>Add Execution Data</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Add Execution Data</em>' operation.
     * @see org.eclipse.lsat.common.scheduler.graph.Task#addExecutionData(java.lang.String, org.eclipse.emf.common.util.EList)
     * @generated
     */
    EOperation getTask__AddExecutionData__String_EList();

    /**
     * Returns the meta object for class '{@link org.eclipse.lsat.common.scheduler.graph.Dependency <em>Dependency</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Dependency</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.Dependency
     * @generated
     */
	EClass getDependency();

	/**
     * Returns the meta object for class '{@link java.util.Map.Entry <em>Execution Data Entry</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Execution Data Entry</em>'.
     * @see java.util.Map.Entry
     * @model keyDataType="org.eclipse.emf.ecore.EString" keyRequired="true"
     *        valueType="org.eclipse.lsat.common.scheduler.graph.TimeStepData" valueContainment="true" valueMany="true"
     * @generated
     */
    EClass getExecutionDataEntry();

    /**
     * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Key</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Key</em>'.
     * @see java.util.Map.Entry
     * @see #getExecutionDataEntry()
     * @generated
     */
    EAttribute getExecutionDataEntry_Key();

    /**
     * Returns the meta object for the containment reference list '{@link java.util.Map.Entry <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Value</em>'.
     * @see java.util.Map.Entry
     * @see #getExecutionDataEntry()
     * @generated
     */
    EReference getExecutionDataEntry_Value();

    /**
     * Returns the meta object for class '{@link org.eclipse.lsat.common.scheduler.graph.TimeStepData <em>Time Step Data</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Time Step Data</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.TimeStepData
     * @generated
     */
    EClass getTimeStepData();

    /**
     * Returns the meta object for the attribute list '{@link org.eclipse.lsat.common.scheduler.graph.TimeStepData#getValues <em>Values</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute list '<em>Values</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.TimeStepData#getValues()
     * @see #getTimeStepData()
     * @generated
     */
    EAttribute getTimeStepData_Values();

    /**
     * Returns the meta object for the '{@link org.eclipse.lsat.common.scheduler.graph.TimeStepData#timeValue() <em>Time Value</em>}' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the '<em>Time Value</em>' operation.
     * @see org.eclipse.lsat.common.scheduler.graph.TimeStepData#timeValue()
     * @generated
     */
    EOperation getTimeStepData__TimeValue();

    /**
     * Returns the meta object for class '{@link org.eclipse.lsat.common.scheduler.graph.Constraint <em>Constraint</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Constraint</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.Constraint
     * @generated
     */
    EClass getConstraint();

    /**
     * Returns the meta object for the reference '{@link org.eclipse.lsat.common.scheduler.graph.Constraint#getSource <em>Source</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Source</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.Constraint#getSource()
     * @see #getConstraint()
     * @generated
     */
    EReference getConstraint_Source();

    /**
     * Returns the meta object for the reference '{@link org.eclipse.lsat.common.scheduler.graph.Constraint#getTarget <em>Target</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Target</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.Constraint#getTarget()
     * @see #getConstraint()
     * @generated
     */
    EReference getConstraint_Target();

    /**
     * Returns the meta object for class '{@link org.eclipse.lsat.common.scheduler.graph.JitConstraint <em>Jit Constraint</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Jit Constraint</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.JitConstraint
     * @generated
     */
    EClass getJitConstraint();

    /**
     * Returns the meta object for class '{@link org.eclipse.lsat.common.scheduler.graph.TimeConstraint <em>Time Constraint</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Time Constraint</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.TimeConstraint
     * @generated
     */
    EClass getTimeConstraint();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.lsat.common.scheduler.graph.TimeConstraint#getLowerBound <em>Lower Bound</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Lower Bound</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.TimeConstraint#getLowerBound()
     * @see #getTimeConstraint()
     * @generated
     */
    EAttribute getTimeConstraint_LowerBound();

    /**
     * Returns the meta object for the attribute '{@link org.eclipse.lsat.common.scheduler.graph.TimeConstraint#getUpperBound <em>Upper Bound</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Upper Bound</em>'.
     * @see org.eclipse.lsat.common.scheduler.graph.TimeConstraint#getUpperBound()
     * @see #getTimeConstraint()
     * @generated
     */
    EAttribute getTimeConstraint_UpperBound();

    /**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
	GraphFactory getGraphFactory();

	/**
     * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
     * @generated
     */
	interface Literals {
		/**
         * The meta object literal for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.TaskDependencyGraphImpl <em>Task Dependency Graph</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see org.eclipse.lsat.common.scheduler.graph.impl.TaskDependencyGraphImpl
         * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getTaskDependencyGraph()
         * @generated
         */
		EClass TASK_DEPENDENCY_GRAPH = eINSTANCE.getTaskDependencyGraph();

		/**
         * The meta object literal for the '<em><b>Resource Model</b></em>' reference feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference TASK_DEPENDENCY_GRAPH__RESOURCE_MODEL = eINSTANCE.getTaskDependencyGraph_ResourceModel();

		/**
         * The meta object literal for the '<em><b>Constraints</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference TASK_DEPENDENCY_GRAPH__CONSTRAINTS = eINSTANCE.getTaskDependencyGraph_Constraints();

        /**
         * The meta object literal for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.TaskImpl <em>Task</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see org.eclipse.lsat.common.scheduler.graph.impl.TaskImpl
         * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getTask()
         * @generated
         */
		EClass TASK = eINSTANCE.getTask();

		/**
         * The meta object literal for the '<em><b>Execution Time</b></em>' attribute feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EAttribute TASK__EXECUTION_TIME = eINSTANCE.getTask_ExecutionTime();

		/**
         * The meta object literal for the '<em><b>Execution Data</b></em>' map feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference TASK__EXECUTION_DATA = eINSTANCE.getTask_ExecutionData();

        /**
         * The meta object literal for the '<em><b>Execution Data Parameters</b></em>' attribute list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute TASK__EXECUTION_DATA_PARAMETERS = eINSTANCE.getTask_ExecutionDataParameters();

        /**
         * The meta object literal for the '<em><b>Resources</b></em>' reference list feature.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @generated
         */
		EReference TASK__RESOURCES = eINSTANCE.getTask_Resources();

		/**
         * The meta object literal for the '<em><b>Add Execution Data</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation TASK___ADD_EXECUTION_DATA__STRING_ELIST = eINSTANCE.getTask__AddExecutionData__String_EList();

        /**
         * The meta object literal for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.DependencyImpl <em>Dependency</em>}' class.
         * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
         * @see org.eclipse.lsat.common.scheduler.graph.impl.DependencyImpl
         * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getDependency()
         * @generated
         */
		EClass DEPENDENCY = eINSTANCE.getDependency();

        /**
         * The meta object literal for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.ExecutionDataEntryImpl <em>Execution Data Entry</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see org.eclipse.lsat.common.scheduler.graph.impl.ExecutionDataEntryImpl
         * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getExecutionDataEntry()
         * @generated
         */
        EClass EXECUTION_DATA_ENTRY = eINSTANCE.getExecutionDataEntry();

        /**
         * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute EXECUTION_DATA_ENTRY__KEY = eINSTANCE.getExecutionDataEntry_Key();

        /**
         * The meta object literal for the '<em><b>Value</b></em>' containment reference list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference EXECUTION_DATA_ENTRY__VALUE = eINSTANCE.getExecutionDataEntry_Value();

        /**
         * The meta object literal for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.TimeStepDataImpl <em>Time Step Data</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see org.eclipse.lsat.common.scheduler.graph.impl.TimeStepDataImpl
         * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getTimeStepData()
         * @generated
         */
        EClass TIME_STEP_DATA = eINSTANCE.getTimeStepData();

        /**
         * The meta object literal for the '<em><b>Values</b></em>' attribute list feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute TIME_STEP_DATA__VALUES = eINSTANCE.getTimeStepData_Values();

        /**
         * The meta object literal for the '<em><b>Time Value</b></em>' operation.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EOperation TIME_STEP_DATA___TIME_VALUE = eINSTANCE.getTimeStepData__TimeValue();

        /**
         * The meta object literal for the '{@link org.eclipse.lsat.common.scheduler.graph.Constraint <em>Constraint</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see org.eclipse.lsat.common.scheduler.graph.Constraint
         * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getConstraint()
         * @generated
         */
        EClass CONSTRAINT = eINSTANCE.getConstraint();

        /**
         * The meta object literal for the '<em><b>Source</b></em>' reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference CONSTRAINT__SOURCE = eINSTANCE.getConstraint_Source();

        /**
         * The meta object literal for the '<em><b>Target</b></em>' reference feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EReference CONSTRAINT__TARGET = eINSTANCE.getConstraint_Target();

        /**
         * The meta object literal for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.JitConstraintImpl <em>Jit Constraint</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see org.eclipse.lsat.common.scheduler.graph.impl.JitConstraintImpl
         * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getJitConstraint()
         * @generated
         */
        EClass JIT_CONSTRAINT = eINSTANCE.getJitConstraint();

        /**
         * The meta object literal for the '{@link org.eclipse.lsat.common.scheduler.graph.impl.TimeConstraintImpl <em>Time Constraint</em>}' class.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @see org.eclipse.lsat.common.scheduler.graph.impl.TimeConstraintImpl
         * @see org.eclipse.lsat.common.scheduler.graph.impl.GraphPackageImpl#getTimeConstraint()
         * @generated
         */
        EClass TIME_CONSTRAINT = eINSTANCE.getTimeConstraint();

        /**
         * The meta object literal for the '<em><b>Lower Bound</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute TIME_CONSTRAINT__LOWER_BOUND = eINSTANCE.getTimeConstraint_LowerBound();

        /**
         * The meta object literal for the '<em><b>Upper Bound</b></em>' attribute feature.
         * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
         * @generated
         */
        EAttribute TIME_CONSTRAINT__UPPER_BOUND = eINSTANCE.getTimeConstraint_UpperBound();

	}

} //GraphPackage
