/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTExtentMap;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationMessages;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.IntermediatePropertyModelAdapter;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.NumberConversions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTEvaluationOptions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTStackTraceElement;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtGenericVisitorDecorator;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtStackTraceBuilder;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ThisInstanceResolver;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.library.EObjectEStructuralFeaturePair;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.QVTUMLReflection;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceFactory;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.utilities.UMLReflection;

public class QvtOperationalEvaluationEnv
extends EcoreEvaluationEnvironment {
    private QvtOperationalEvaluationEnv myRootEnv;
    private Internal myInternal;
    private ImperativeOperation myOperation;
    private final List<Object> myOperationArgs;
    private Object myOperationSelf;
    private final Map<String, Object> myBindings;
    private final int myStackDepth;
    private final List<ModelParameterExtent> myExtents;
    private QVTUMLReflection fQVUMLReflection;

    protected QvtOperationalEvaluationEnv(IContext context, QvtOperationalEvaluationEnv parent) {
        super((EvaluationEnvironment)(parent == null ? new EcoreEvaluationEnvironment(null) : parent));
        if (parent == null) {
            this.myRootEnv = this;
            this.myInternal = new RootInternal(context);
            this.myStackDepth = 1;
        } else {
            this.myRootEnv = parent.myRootEnv;
            this.myInternal = new Internal();
            this.myStackDepth = parent.myStackDepth + 1;
        }
        this.myBindings = new HashMap<String, Object>();
        this.myOperationArgs = new ArrayList<Object>();
        this.myExtents = new ArrayList<ModelParameterExtent>();
    }

    public QvtOperationalEvaluationEnv getRoot() {
        return this.myRootEnv;
    }

    public int getDepth() {
        return this.myStackDepth;
    }

    public ModuleInstance getThisOfType(Module module) {
        ThisInstanceResolver thisResolver = this.internalEnv().getThisResolver();
        assert (thisResolver != null);
        return thisResolver.getThisInstanceOf(module);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (InternalEvaluationEnv.class == adapterType) {
            return adapterType.cast(this.internalEnv());
        }
        return (T)super.getAdapter(adapterType);
    }

    private Internal internalEnv() {
        return this.myInternal;
    }

    public Map<EClass, Set<EObject>> createExtentMap(Object object) {
        return new QVTExtentMap(this);
    }

    public List<Object> getOperationArgs() {
        return this.myOperationArgs;
    }

    public void setOperationSelf(Object source) {
        this.myOperationSelf = source;
    }

    public Object getOperationSelf() {
        return this.myOperationSelf;
    }

    public IContext getContext() {
        return this.internalEnv().getContext();
    }

    public void addModelExtent(ModelParameterExtent extent) {
        this.internalEnv().addModelExtent(extent);
    }

    public QVTUMLReflection getUMLReflection() {
        QvtOperationalEvaluationEnv parent = this.getParent();
        if (parent != null) {
            return parent.getUMLReflection();
        }
        if (this.fQVUMLReflection == null) {
            this.fQVUMLReflection = new QVTUMLReflection((UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)UMLReflectionImpl.INSTANCE);
        }
        return this.fQVUMLReflection;
    }

    public void cleanup() {
        this.internalEnv().cleanup();
        this.clear();
        if (this.getParent() == null) {
            if (this.fQVUMLReflection != null) {
                this.fQVUMLReflection.close();
            }
            QvtOperationalStdLibrary.INSTANCE.getEnvironment().close();
        }
    }

    public boolean overrides(EOperation operation, int opcode) {
        return CallHandler.Access.hasHandler(operation);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        CallHandler callHandler = CallHandler.Access.getHandler(operation);
        if (callHandler != null) {
            if (source == null || source == this.getInvalidResult()) {
                return this.getInvalidResult();
            }
            Module targetModule = QvtOperationalParserUtil.getOwningModule(operation);
            ModuleInstance targetModuleInstance = this.getThisOfType(targetModule);
            assert (targetModuleInstance != null);
            return callHandler.invoke(targetModuleInstance, source, args, this);
        }
        return super.callOperation(operation, opcode, source, args);
    }

    public Object navigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) throws IllegalArgumentException {
        if (target instanceof ModuleInstance) {
            ModuleInstance moduleTarget = (ModuleInstance)target;
            EClassifier owningClassifier = this.getUMLReflection().getOwningClassifier(property);
            target = owningClassifier instanceof Module ? moduleTarget.getThisInstanceOf((Module)owningClassifier) : moduleTarget.getThisInstanceOf(moduleTarget.getModule());
        }
        EStructuralFeature resolvedProperty = property;
        if (property instanceof ContextualProperty) {
            IntermediatePropertyModelAdapter.ShadowEntry shadow = IntermediatePropertyModelAdapter.getPropertyHolder((EObject)property.getEContainingClass(), (ContextualProperty)property, target);
            target = shadow.getPropertyRuntimeOwner(target, this);
            resolvedProperty = shadow.getProperty();
        }
        if (target instanceof Tuple) {
            if (target instanceof EObject) {
                EObject etarget = (EObject)target;
                resolvedProperty = etarget.eClass().getEStructuralFeature(property.getName());
                if (resolvedProperty == null) {
                    return null;
                }
            } else {
                resolvedProperty = null;
                for (EStructuralFeature feature : ((Tuple)target).getTupleType().oclProperties()) {
                    if (!property.getName().equals(feature.getName())) continue;
                    resolvedProperty = feature;
                    break;
                }
                if (resolvedProperty == null) {
                    return null;
                }
            }
        }
        try {
            return super.navigateProperty(resolvedProperty, qualifiers, target);
        }
        catch (IllegalArgumentException e) {
            this.internalEnv().throwQVTException(new QvtRuntimeException("Unknown property '" + property.getName() + "'", e));
            return this.getInvalidResult();
        }
    }

    public QvtOperationalEvaluationEnv getParent() {
        return super.getParent() instanceof QvtOperationalEvaluationEnv ? (QvtOperationalEvaluationEnv)super.getParent() : null;
    }

    public Object getValueOf(String name) {
        Object result = this.myBindings.get(name);
        if (result instanceof TypedBinding) {
            return ((TypedBinding)result).value;
        }
        return result;
    }

    public EClassifier getTypeOf(String name) {
        Object result = this.myBindings.get(name);
        if (result instanceof TypedBinding) {
            return ((TypedBinding)result).type;
        }
        return null;
    }

    public boolean isOclInvalid(Object value) {
        return this.getInvalidResult() == value;
    }

    public void copyVariableValueFrom(QvtOperationalEvaluationEnv fromEnv, String varName, String targetVarName) {
        Object sourceValue = fromEnv.getValueOf(varName);
        this.replace(targetVarName, sourceValue);
    }

    public void replace(String name, Object value) {
        this.myBindings.put(name, value);
    }

    public void replace(String name, Object value, EClassifier declaredType) {
        if (declaredType != null) {
            this.replace(name, new TypedBinding(value, declaredType));
        } else {
            this.replace(name, value);
        }
    }

    public void add(String name, Object value) {
        if ("this".equals(name)) {
            Object thisValue = value;
            if (thisValue != null && thisValue.getClass() == TypedBinding.class) {
                thisValue = ((TypedBinding)thisValue).value;
            }
            if (thisValue instanceof ModuleInstance) {
                this.internalEnv().setThisResolver((ModuleInstance)thisValue);
            }
        }
        if (this.myBindings.containsKey(name)) {
            String message = NLS.bind("The name: ({0})  already has a binding: ({1})", name, this.myBindings.get(name));
            throw new IllegalArgumentException(message);
        }
        this.myBindings.put(name, value);
    }

    public void add(String name, Object value, EClassifier declaredType) {
        if (declaredType != null) {
            this.add(name, new TypedBinding(value, declaredType));
        } else {
            this.add(name, value);
        }
    }

    public Object remove(String name) {
        Object result = this.myBindings.remove(name);
        if (result instanceof TypedBinding) {
            return ((TypedBinding)result).value;
        }
        return result;
    }

    public void clear() {
        this.myBindings.clear();
    }

    public String toString() {
        return this.myBindings.toString();
    }

    public Set<String> getNames() {
        return this.myBindings.keySet();
    }

    public boolean isKindOf(Object object, EClassifier classifier) {
        if (classifier instanceof AnyType) {
            return !(object instanceof Collection);
        }
        if (classifier == QvtOperationalStdLibrary.INSTANCE.getElementType()) {
            if (object instanceof EObject) {
                return QVTUMLReflection.isUserModelElement((EClassifier)((EObject)object).eClass());
            }
        } else if (object instanceof DynamicEObjectImpl) {
            for (EClass objType : ((EObject)object).eClass().getEAllSuperTypes()) {
                if (objType.getEPackage() != classifier.getEPackage() || objType.getClassifierID() != classifier.getClassifierID()) continue;
                return true;
            }
        }
        if (classifier instanceof org.eclipse.ocl.types.CollectionType && object instanceof Collection) {
            if (!(classifier.isInstance(object) || classifier.eClass().getEPackage() == EcorePackage.eINSTANCE && classifier.eClass().getClassifierID() == EcorePackage.eINSTANCE.getCollectionType().getClassifierID())) {
                return false;
            }
            if (((Collection)object).isEmpty()) {
                return true;
            }
            return this.isKindOf(((Collection)object).iterator().next(), (EClassifier)((CollectionType)classifier).getElementType());
        }
        return super.isKindOf(object, classifier);
    }

    public EClassifier getType(Object object) {
        if (object == null) {
            return (EClassifier)QvtOperationalStdLibrary.INSTANCE.getOCLStdLib().getOclVoid();
        }
        return super.getType(object);
    }

    protected Object coerceValue(ETypedElement element, Object value, boolean copy) {
        EClassifier oclType = this.getUMLReflection().getOCLType(element);
        if (value instanceof MutableList || value instanceof Dictionary) {
            return value;
        }
        if (oclType instanceof AnyType) {
            if (value instanceof Collection) {
                return copy ? CollectionUtil.createNewCollection((Collection)value) : value;
            }
        } else {
            if (oclType instanceof ListType) {
                if (value instanceof Collection) {
                    return copy ? Utils.createList(value) : value;
                }
                return copy ? Utils.createList(value != null ? Collections.singletonList(value) : Collections.emptyList()) : value;
            }
            if (oclType instanceof DictionaryType) {
                if (value instanceof Collection) {
                    return copy ? Utils.createDictionary(value) : value;
                }
                return copy ? Utils.createDictionary(value != null ? Collections.singletonList(value) : Collections.emptyList()) : value;
            }
            if (oclType instanceof org.eclipse.ocl.types.CollectionType) {
                org.eclipse.ocl.types.CollectionType collectionType = (org.eclipse.ocl.types.CollectionType)oclType;
                if (collectionType.getKind() == CollectionKind.COLLECTION_LITERAL) {
                    if (value instanceof Collection) {
                        return copy ? CollectionUtil.createNewCollection((Collection)value) : value;
                    }
                    return copy ? CollectionUtil.createNewSet(value != null ? Collections.singletonList(value) : Collections.emptyList()) : value;
                }
                if (value == null) {
                    return copy ? EvaluationUtil.createNewCollection((org.eclipse.ocl.types.CollectionType<EClassifier, EOperation>)collectionType) : value;
                }
            }
        }
        return super.coerceValue(element, (Object)value, copy);
    }

    public EObject createInstance(EClassifier type, ModelParameter extent) {
        EObject newObject;
        if (!QvtOperationalUtil.isInstantiable(type)) {
            this.internalEnv().throwQVTException(new QvtRuntimeException("Cannot instantiate type " + QvtOperationalParserUtil.safeGetQualifiedName(this.getUMLReflection(), type, "")));
        }
        if ((newObject = type.getEPackage().getEFactoryInstance().create((EClass)type)) == null) {
            return null;
        }
        this.putInstanceToExtent(newObject, extent);
        return newObject;
    }

    public void putInstanceToExtent(EObject eObj, ModelParameter extent) {
        ModelParameterExtent targetExtent;
        TransformationInstance mainTransfInstance = this.internalEnv().getCurrentTransformation();
        if (mainTransfInstance == null) {
            assert (extent == null);
            return;
        }
        if (extent == null) {
            targetExtent = this.getDefaultInstantiationExtent((EClassifier)eObj.eClass());
        } else {
            OperationalTransformation targetTransf = (OperationalTransformation)extent.eContainer();
            assert (targetTransf != null);
            TransformationInstance targetThis = mainTransfInstance;
            if (mainTransfInstance.getTransformation() != targetTransf) {
                targetThis = (TransformationInstance)mainTransfInstance.getThisInstanceOf(targetTransf);
            }
            ModelInstance model = targetThis.getModel(extent);
            assert (model != null);
            targetExtent = model.getExtent();
        }
        if (this.isReadonlyGuardEnabled() && targetExtent.isReadonly()) {
            this.internalEnv().throwQVTException(new QvtRuntimeException(NLS.bind(EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_ReadOnlyInputModel, String.valueOf(extent.getName()) + " : " + QvtOperationalTypesUtil.getTypeFullName(extent.getEType()))));
        }
        targetExtent.addObject(eObj);
    }

    public ModelParameterExtent getDefaultInstantiationExtent(EClassifier type) {
        TransformationInstance mainTransfInstance = this.internalEnv().getCurrentTransformation();
        if (mainTransfInstance != null) {
            EList<ModelParameter> modelParameters;
            ModelParameter modelParam;
            ModelInstance model;
            if (IntermediateClassFactory.isIntermediateClass(type)) {
                TransformationInstance.InternalTransformation internTransf = mainTransfInstance.getAdapter(TransformationInstance.InternalTransformation.class);
                ModelInstance intermExtent = internTransf.getIntermediateExtent();
                if (intermExtent != null) {
                    return intermExtent.getExtent();
                }
            } else if (QVTUMLReflection.isUserModelElement(type) && (model = mainTransfInstance.getModel(modelParam = QvtOperationalModuleEnv.findModelParameter(type, DirectionKind.OUT, modelParameters = mainTransfInstance.getTransformation().getModelParameter()))) != null) {
                return model.getExtent();
            }
        }
        return this.internalEnv().getUnboundExtent();
    }

    private Collection<Object> append(Collection<Object> collection, Object newContent, EClassifier classifier) {
        if (collection == null || this.isOclInvalid(newContent)) {
            throw new IllegalArgumentException();
        }
        Collection newCollection = collection instanceof MutableList || collection instanceof Dictionary ? collection : CollectionUtil.createNewCollection(collection);
        Object convertedContent = this.ensureTypeCompatibility(newContent, classifier.getInstanceClass());
        if (convertedContent == null || this.isKindOf(convertedContent, classifier)) {
            newCollection.add(convertedContent);
        } else if (newContent instanceof Collection) {
            for (Object element : (Collection)newContent) {
                newCollection.add(this.ensureTypeCompatibility(element, classifier.getInstanceClass()));
            }
        }
        return newCollection;
    }

    public Object assign(EClassifier classifier, Object oldValue, Object exprValue, boolean isReset) {
        Collection newValue;
        if (classifier instanceof org.eclipse.ocl.types.CollectionType && !this.isOclInvalid(exprValue)) {
            org.eclipse.ocl.types.CollectionType collectionType = (org.eclipse.ocl.types.CollectionType)classifier;
            Collection newCollection = null;
            if (isReset) {
                if (exprValue instanceof MutableList || exprValue instanceof Dictionary) {
                    newCollection = exprValue;
                } else {
                    newCollection = EvaluationUtil.createNewCollection((org.eclipse.ocl.types.CollectionType<EClassifier, EOperation>)collectionType);
                    if (newCollection == null) {
                        newCollection = exprValue instanceof Collection ? EvaluationUtil.createNewCollectionOfSameKind(exprValue) : CollectionUtil.createNewSet();
                    }
                    if (exprValue instanceof Collection) {
                        for (Object element : exprValue) {
                            newCollection.add(this.ensureTypeCompatibility(element, ((EClassifier)collectionType.getElementType()).getInstanceClass()));
                        }
                    } else if (exprValue != null) {
                        newCollection.add(this.ensureTypeCompatibility(exprValue, ((EClassifier)collectionType.getElementType()).getInstanceClass()));
                    }
                }
            } else {
                Set oldCollection;
                if (oldValue instanceof Collection) {
                    oldCollection = (Set)oldValue;
                } else {
                    oldCollection = EvaluationUtil.createNewCollection((org.eclipse.ocl.types.CollectionType<EClassifier, EOperation>)collectionType);
                    if (oldCollection == null) {
                        oldCollection = CollectionUtil.createNewSet();
                    }
                }
                newCollection = this.append(oldCollection, exprValue, (EClassifier)collectionType.getElementType());
            }
            newValue = newCollection;
        } else {
            newValue = exprValue;
        }
        return EvaluationUtil.doImplicitListCoercion(classifier, newValue);
    }

    public void callSetter(EObject target, EStructuralFeature eStructuralFeature, Object exprValue, boolean valueIsUndefined, boolean isReset) {
        if (this.getInvalidResult() == target) {
            return;
        }
        EObject owner = target;
        if (target instanceof ModuleInstance) {
            ModuleInstance moduleTarget = (ModuleInstance)target;
            owner = moduleTarget.getThisInstanceOf(moduleTarget.getModule());
        }
        if (eStructuralFeature instanceof ContextualProperty) {
            IntermediatePropertyModelAdapter.ShadowEntry shadow = IntermediatePropertyModelAdapter.getPropertyHolder((EObject)eStructuralFeature.getEContainingClass(), (ContextualProperty)eStructuralFeature, owner);
            owner = shadow.getPropertyRuntimeOwner(owner, this);
            eStructuralFeature = shadow.getProperty();
        }
        if (this.isReadonlyGuardEnabled()) {
            this.checkReadonlyGuard(eStructuralFeature, exprValue, owner);
        }
        final Object currentValue = owner.eGet(eStructuralFeature);
        EClassifier oclType = this.getUMLReflection().getOCLType(eStructuralFeature);
        Object newValue = this.assign(oclType, currentValue, exprValue, isReset);
        final Class expectedClass = eStructuralFeature.getEType().getInstanceClass();
        if (FeatureMapUtil.isMany((EObject)owner, (EStructuralFeature)eStructuralFeature)) {
            EList containerList = (EList)currentValue;
            if (valueIsUndefined) {
                if (isReset) {
                    containerList.clear();
                }
            } else {
                List newList;
                Collection coll = (Collection)newValue;
                if (!EvaluationUtil.canContainNull(containerList)) {
                    newList = new ArrayList(coll.size());
                    for (Object o : coll) {
                        if (o == null) continue;
                        newList.add(o);
                    }
                } else {
                    newList = newValue instanceof List ? (List)newValue : new ArrayList(coll);
                }
                DelegatingEList<Object> delegatingList = new DelegatingEList<Object>(){

                    protected List<Object> delegateList() {
                        return (List)currentValue;
                    }

                    public void add(int index, Object object) {
                        super.add(index, QvtOperationalEvaluationEnv.this.ensureTypeCompatibility(object, expectedClass));
                    }

                    public boolean add(Object object) {
                        return super.add(QvtOperationalEvaluationEnv.this.ensureTypeCompatibility(object, expectedClass));
                    }
                };
                try {
                    ECollections.setEList((EList)delegatingList, newList);
                }
                catch (RuntimeException e) {
                    QvtPlugin.warning(0, NLS.bind(EvaluationMessages.ContentMergeForMultivaluedFeatureFailed, eStructuralFeature.getName()), e);
                    containerList.clear();
                    containerList.addAll(newList);
                }
            }
        } else if (this.isOclInvalid(newValue) || newValue == null && !this.acceptsNullValue(expectedClass)) {
            if (isReset) {
                owner.eUnset(eStructuralFeature);
            }
        } else {
            if (newValue instanceof Collection && eStructuralFeature.getUpperBound() == -2) {
                for (Object element : (Collection)newValue) {
                    if (element == null) continue;
                    newValue = element;
                    break;
                }
            }
            owner.eSet(eStructuralFeature, this.ensureTypeCompatibility(newValue, expectedClass));
        }
    }

    private boolean isReadonlyGuardEnabled() {
        return this.getContext().getSessionData().getValue(QVTEvaluationOptions.FLAG_READONLY_GUARD_ENABLED) == Boolean.TRUE;
    }

    public int getMaxStackDepth() {
        return this.getContext().getSessionData().getValue(QVTEvaluationOptions.EVALUATION_MAX_STACK_DEPTH);
    }

    public List<Class<? extends QvtGenericVisitorDecorator>> getVisitorDecoratorClasses() {
        return this.getContext().getSessionData().getValue(QVTEvaluationOptions.VISITOR_DECORATORS);
    }

    private void checkReadonlyGuard(EStructuralFeature eStructuralFeature, Object exprValue, EObject owner) {
        EReference eReference;
        ModelParameter violatedReadonlyParam = ModelParameterExtent.getReadonlyModelParameter(owner);
        if (violatedReadonlyParam == null && eStructuralFeature instanceof EReference && (eReference = (EReference)eStructuralFeature).isContainment()) {
            if (exprValue instanceof EObject) {
                violatedReadonlyParam = ModelParameterExtent.getReadonlyModelParameter((EObject)exprValue);
            } else if (exprValue instanceof Collection) {
                for (Object element : (Collection)exprValue) {
                    if (element instanceof EObject && (violatedReadonlyParam = ModelParameterExtent.getReadonlyModelParameter((EObject)exprValue)) != null) break;
                }
            }
        }
        if (violatedReadonlyParam != null) {
            this.internalEnv().throwQVTException(new QvtRuntimeException(NLS.bind(EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_ReadOnlyInputModel, String.valueOf(violatedReadonlyParam.getName()) + " : " + QvtOperationalTypesUtil.getTypeFullName(violatedReadonlyParam.getEType()))));
        }
    }

    private Object ensureTypeCompatibility(Object value, Class<?> expectedType) {
        if (expectedType != null) {
            return NumberConversions.convertNumber(value, expectedType);
        }
        return value;
    }

    private boolean acceptsNullValue(Class<?> type) {
        if (type == null) {
            return true;
        }
        return !type.isPrimitive();
    }

    public QvtOperationalEvaluationEnv cloneEvaluationEnv() {
        QvtOperationalEvaluationEnv env = new QvtOperationalEvaluationEnv(this.getContext(), this.getParent());
        return this.copyEnv(env);
    }

    public QvtOperationalEvaluationEnv createDeferredExecutionEnvironment() {
        QvtOperationalEvaluationEnv parent;
        parent = this.getRoot() == this ? (parent = null) : this.getRoot();
        QvtOperationalEvaluationEnv result = new QvtOperationalEvaluationEnv(this.getContext(), parent);
        return this.copyEnv(result);
    }

    protected QvtOperationalEvaluationEnv copyEnv(QvtOperationalEvaluationEnv env) {
        env.myInternal = this.internalEnv().clone();
        env.myOperationArgs.addAll(this.myOperationArgs);
        env.myOperationSelf = this.myOperationSelf;
        env.myOperation = this.myOperation;
        env.myBindings.putAll(this.myBindings);
        return env;
    }

    public void setOperation(ImperativeOperation myOperation) {
        this.myOperation = myOperation;
    }

    public ImperativeOperation getOperation() {
        return this.myOperation;
    }

    private class Internal
    implements InternalEvaluationEnv {
        private ThisInstanceResolver myThisResolver;
        private EObject myCurrentIP;

        Internal() {
        }

        Internal(Internal another) {
            this.myThisResolver = another.myThisResolver;
            this.myCurrentIP = another.myCurrentIP;
        }

        IContext getContext() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getContext();
        }

        public Internal clone() {
            return new Internal(this);
        }

        @Override
        public TransformationInstance getCurrentTransformation() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getCurrentTransformation();
        }

        @Override
        public ModuleInstance getCurrentModule() {
            return this.myThisResolver instanceof ModuleInstance ? (ModuleInstance)this.myThisResolver : null;
        }

        @Override
        public ModelParameterExtent getUnboundExtent() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getUnboundExtent();
        }

        public void addModelExtent(ModelParameterExtent extent) {
            QvtOperationalEvaluationEnv.this.getRoot().myExtents.add(extent);
        }

        public void cleanup() {
            for (ModelParameterExtent extent : QvtOperationalEvaluationEnv.this.getRoot().myExtents) {
                extent.cleanup();
            }
        }

        @Override
        public void setThisResolver(ThisInstanceResolver thisResolver) {
            this.myThisResolver = thisResolver;
        }

        @Override
        public ThisInstanceResolver getThisResolver() {
            return this.myThisResolver;
        }

        @Override
        public Object getInvalid() {
            return QvtOperationalEvaluationEnv.this.getInvalidResult();
        }

        @Override
        public EObjectEStructuralFeaturePair getLastAssignmentLvalueEval() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getLastAssignmentLvalueEval();
        }

        @Override
        public void setLastAssignmentLvalueEval(EObjectEStructuralFeaturePair lvalue) {
            QvtOperationalEvaluationEnv.this.getRoot().internalEnv().setLastAssignmentLvalueEval(lvalue);
        }

        @Override
        public void processDeferredTasks() {
            QvtOperationalEvaluationEnv.this.getRoot().internalEnv().processDeferredTasks();
        }

        @Override
        public boolean isDeferredExecution() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().isDeferredExecution();
        }

        @Override
        public void addDeferredTask(Runnable task) {
            QvtOperationalEvaluationEnv.this.getRoot().internalEnv().addDeferredTask(task);
        }

        @Override
        public void setTraces(Trace trace) {
            QvtOperationalEvaluationEnv.this.getRoot().internalEnv().setTraces(trace);
        }

        @Override
        public Trace getTraces() {
            return QvtOperationalEvaluationEnv.this.getRoot().internalEnv().getTraces();
        }

        @Override
        public EObject setCurrentIP(EObject currentIPObject) {
            EObject prevValue = this.myCurrentIP;
            this.myCurrentIP = currentIPObject;
            return prevValue;
        }

        @Override
        public EObject getCurrentIP() {
            return this.myCurrentIP;
        }

        @Override
        public void throwQVTException(QvtRuntimeException exception) throws QvtRuntimeException {
            try {
                exception.setStackQvtTrace(this.getStackTraceElements());
            }
            catch (Exception e) {
                QvtPlugin.error("Failed to build QVT stack trace", e);
            }
            throw exception;
        }

        @Override
        public List<QVTStackTraceElement> getStackTraceElements() {
            return new QvtStackTraceBuilder(QvtOperationalEvaluationEnv.this).buildStackTrace();
        }
    }

    private class RootInternal
    extends Internal {
        private IContext myContext;
        private List<Runnable> myDeferredTasks;
        private EObjectEStructuralFeaturePair myLastAssignLvalue;
        private ModelParameterExtent myUnboundExtent;
        private TransformationInstance myThisTransformation;
        private boolean myIsDeferredExecution;
        private Trace myTraces;

        RootInternal(IContext context) {
            assert (context != null);
            this.myContext = context;
            this.myIsDeferredExecution = false;
            this.myTraces = TraceFactory.eINSTANCE.createTrace();
        }

        RootInternal(RootInternal another) {
            super(another);
            this.myLastAssignLvalue = another.myLastAssignLvalue;
            this.myDeferredTasks = another.myDeferredTasks;
            this.myContext = another.myContext;
            this.myUnboundExtent = another.myUnboundExtent;
            this.myThisTransformation = another.myThisTransformation;
            this.myIsDeferredExecution = another.myIsDeferredExecution;
        }

        @Override
        IContext getContext() {
            return this.myContext;
        }

        @Override
        public TransformationInstance getCurrentTransformation() {
            return this.myThisTransformation;
        }

        @Override
        public void setThisResolver(ThisInstanceResolver thisResolver) {
            if (thisResolver instanceof TransformationInstance) {
                this.myThisTransformation = (TransformationInstance)thisResolver;
            }
            super.setThisResolver(thisResolver);
        }

        @Override
        public Internal clone() {
            return new RootInternal(this);
        }

        @Override
        public ModelParameterExtent getUnboundExtent() {
            if (this.myUnboundExtent == null) {
                this.myUnboundExtent = new ModelParameterExtent();
            }
            return this.myUnboundExtent;
        }

        @Override
        public void addDeferredTask(Runnable task) {
            if (this.myDeferredTasks == null) {
                this.myDeferredTasks = new ArrayList<Runnable>();
            }
            this.myDeferredTasks.add(task);
        }

        @Override
        public EObjectEStructuralFeaturePair getLastAssignmentLvalueEval() {
            return this.myLastAssignLvalue;
        }

        @Override
        public void setLastAssignmentLvalueEval(EObjectEStructuralFeaturePair lvalue) {
            this.myLastAssignLvalue = lvalue;
        }

        @Override
        public void processDeferredTasks() {
            if (this.myDeferredTasks != null) {
                try {
                    this.myIsDeferredExecution = true;
                    ArrayList<Runnable> tasksCopy = new ArrayList<Runnable>(this.myDeferredTasks);
                    for (Runnable task : tasksCopy) {
                        task.run();
                    }
                }
                finally {
                    this.myIsDeferredExecution = false;
                }
            }
        }

        @Override
        public boolean isDeferredExecution() {
            return this.myIsDeferredExecution;
        }

        @Override
        public Trace getTraces() {
            return this.myTraces;
        }

        @Override
        public void setTraces(Trace trace) {
            this.myTraces = trace;
        }
    }

    private static class TypedBinding {
        final Object value;
        final EClassifier type;

        private TypedBinding(Object value, EClassifier type) {
            this.value = value;
            this.type = type;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.type != null) {
                buf.append(this.type).append(" : ");
            }
            buf.append(this.value);
            return buf.toString();
        }
    }
}

