/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.AbstractXYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.util.PublicCloneable;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class StandardIntervalXYToolTipGenerator
extends AbstractXYItemLabelGenerator
implements XYToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2173467562605711571L;
    public static final String DEFAULT_TOOL_TIP_FORMAT = "{0}: ({3} - {5}, {2})";

    public StandardIntervalXYToolTipGenerator() {
        this(DEFAULT_TOOL_TIP_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public StandardIntervalXYToolTipGenerator(String formatString, NumberFormat xFormat, NumberFormat yFormat) {
        super(formatString, xFormat, yFormat);
    }

    public StandardIntervalXYToolTipGenerator(String formatString, DateFormat xFormat, NumberFormat yFormat) {
        super(formatString, xFormat, yFormat);
    }

    public StandardIntervalXYToolTipGenerator(String formatString, NumberFormat xFormat, DateFormat yFormat) {
        super(formatString, xFormat, yFormat);
    }

    public StandardIntervalXYToolTipGenerator(String formatString, DateFormat xFormat, DateFormat yFormat) {
        super(formatString, xFormat, yFormat);
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        return this.generateLabelString(dataset, series, item);
    }

    protected Object[] createItemArray(XYDataset dataset, int series, int item) {
        if (dataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)dataset;
            Object[] result = new Object[]{String.valueOf(dataset.getSeriesKey(series)), this.formatXValue(intervalXYDataset.getX(series, item)), this.formatYValue(intervalXYDataset.getY(series, item)), this.formatXValue(intervalXYDataset.getStartX(series, item)), this.formatYValue(intervalXYDataset.getStartY(series, item)), this.formatXValue(intervalXYDataset.getEndX(series, item)), this.formatYValue(intervalXYDataset.getEndY(series, item))};
            return result;
        }
        return super.createItemArray(dataset, series, item);
    }

    protected String formatXValue(Number xValue) {
        if (this.getXDateFormat() != null) {
            return this.getXDateFormat().format(xValue);
        }
        return this.getXFormat().format(xValue);
    }

    protected String formatYValue(Number yValue) {
        if (yValue == null || Double.isNaN(yValue.doubleValue())) {
            return this.getNullYString();
        }
        if (this.getYDateFormat() != null) {
            return this.getYDateFormat().format(yValue);
        }
        return this.getYFormat().format(yValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardIntervalXYToolTipGenerator)) {
            return false;
        }
        return super.equals(obj);
    }
}

