/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFLabelDescription;
import org.eclipse.eef.EEFLabelStyle;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.common.ui.api.SWTUtils;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IEEFLabelController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.widgets.ActionButton;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EEFLabelLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int LABEL_WIDTH_HINT = 300;
    private EEFLabelDescription description;
    private StyledText body;
    private List<ActionButton> actionButtons = new ArrayList<ActionButton>();
    private IEEFLabelController controller;
    private EEFWidgetFactory widgetFactory;

    public EEFLabelLifecycleManager(EEFLabelDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        Composite labelComposite = this.widgetFactory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        labelComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        labelComposite.setLayoutData((Object)gridData);
        this.createLabel(labelComposite);
        this.createWidgetActionButtons(labelComposite);
        this.controller = new EEFControllersFactory().createLabelController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    private void createLabel(Composite parent) {
        this.body = this.widgetFactory.createStyledText(parent, 64);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = this.body.getLineHeight();
        gridData.widthHint = 300;
        gridData.horizontalIndent = 5;
        this.body.setLayoutData((Object)gridData);
        this.body.setEditable(false);
    }

    private void createWidgetActionButtons(Composite parent) {
        if (!this.description.getActions().isEmpty()) {
            Composite buttons = this.widgetFactory.createComposite(parent);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = false;
            buttons.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout(this.description.getActions().size(), true);
            layout.marginHeight = 0;
            buttons.setLayout((Layout)layout);
            for (EEFWidgetAction action : this.description.getActions()) {
                ActionButton actionButton = new ActionButton(action, buttons, this.widgetFactory, this.interpreter, this.variableManager);
                this.actionButtons.add(actionButton);
            }
        }
    }

    @Override
    protected int getLabelVerticalAlignment() {
        return 4;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.controller.onNewValue(value -> {
            if (!this.body.isDisposed()) {
                if (this.body.getText() == null || !this.body.getText().equals(value)) {
                    this.body.setText(Optional.ofNullable(value).orElse(""));
                }
                this.setStyle();
            }
        });
        this.actionButtons.forEach(actionButton -> {
            SelectionListener selectionListener = SWTUtils.widgetSelectedAdapter(event -> {
                if (!this.container.isRenderingInProgress()) {
                    IStatus result = this.controller.action(actionButton.getAction());
                    if (result != null && result.getSeverity() == 4) {
                        EEFIdeUiPlugin.INSTANCE.log(result);
                    } else {
                        this.refresh();
                    }
                }
            });
            actionButton.addSelectionListener(selectionListener);
        });
    }

    private void setStyle() {
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle style = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (style instanceof EEFLabelStyle) {
            EEFLabelStyle labelStyle = (EEFLabelStyle)style;
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.body);
            styleHelper.applyTextStyle(labelStyle.getFontNameExpression(), labelStyle.getFontSizeExpression(), labelStyle.getFontStyleExpression(), this.body.getFont(), labelStyle.getBackgroundColorExpression(), labelStyle.getForegroundColorExpression(), callback);
        }
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        if (!this.body.isDisposed()) {
            this.body.setEnabled(isEnabled);
        }
        this.actionButtons.stream().filter(actionButton -> !actionButton.getButton().isDisposed()).forEach(actionButton -> actionButton.setEnabled(isEnabled));
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        this.actionButtons.forEach(ActionButton::removeSelectionListener);
        this.controller.removeNewValueConsumer();
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    protected Control getValidationControl() {
        return this.body;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.actionButtons.clear();
    }
}

