/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algorithms;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.algorithms.CycleFoundException;
import org.eclipse.lsat.common.ludus.backend.graph.Graph;

public final class TopologicalSort {
    private TopologicalSort() {
    }

    public static <V, E> List<V> topologicalSort(Graph<V, E> graph) throws CycleFoundException {
        LinkedList l = new LinkedList();
        HashSet<V> unmarked = new HashSet<V>(graph.getVertices());
        HashSet tempMarked = new HashSet();
        while (!unmarked.isEmpty()) {
            Object v = unmarked.iterator().next();
            TopologicalSort.visit(graph, l, unmarked, tempMarked, v);
        }
        return l;
    }

    private static <V, E> void visit(Graph<V, E> graph, List<V> l, Set<V> unmarked, Set<V> tempMarked, V v) throws CycleFoundException {
        if (tempMarked.contains(v)) {
            throw new CycleFoundException();
        }
        if (unmarked.contains(v)) {
            tempMarked.add(v);
            for (E edge : graph.outgoingEdgesOf(v)) {
                TopologicalSort.visit(graph, l, unmarked, tempMarked, graph.getEdgeTarget(edge));
            }
            unmarked.remove(v);
            tempMarked.remove(v);
            l.add(0, v);
        }
    }
}

