/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ui.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.lsat.common.emf.ui.model.ModelWorkbenchLabelProvider;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class ModelWorkbenchContentProvider
extends BaseWorkbenchContentProvider {
    private final AdapterFactory adapterFactory;
    private final ResourceSet resourceSet;

    public ModelWorkbenchContentProvider(AdapterFactory ... adapterFactories) {
        this((ResourceSet)new ResourceSetImpl(), adapterFactories);
    }

    public ModelWorkbenchContentProvider(ResourceSet resourceSet, AdapterFactory ... adapterFactories) {
        this.resourceSet = resourceSet;
        this.adapterFactory = ModelWorkbenchLabelProvider.createAdapterFactory(adapterFactories);
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public Object[] getElements(Object element) {
        if (element instanceof Collection) {
            return ((Collection)element).toArray();
        }
        return super.getElements(element);
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return super.getParent(element);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IFile) {
            try {
                URI modelURI = URI.createPlatformResourceURI((String)((IFile)element).getFullPath().toString(), (boolean)true);
                Resource resource = this.resourceSet.getResource(modelURI, true);
                return (resource != null ? resource.getContents() : Collections.EMPTY_LIST).toArray();
            }
            catch (WrappedException e) {
                e.printStackTrace();
            }
        } else if (element instanceof EObject) {
            ITreeItemContentProvider adapter = (ITreeItemContentProvider)this.adapterFactory.adapt(element, ITreeItemContentProvider.class);
            return (adapter != null ? adapter.getChildren(element) : Collections.EMPTY_LIST).toArray();
        }
        return super.getChildren(element);
    }
}

