/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.teditor.formatting2;

import activity.Activity;
import activity.ActivityPackage;
import activity.ActivitySet;
import activity.Claim;
import activity.Event;
import activity.LocationPrerequisite;
import activity.Move;
import activity.RaiseEvent;
import activity.Release;
import activity.RequireEvent;
import activity.SimpleAction;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import machine.Import;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.graph.directed.editable.EdgeTarget;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.graph.directed.editable.SourceReference;
import org.eclipse.lsat.common.graph.directed.editable.TargetReference;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class ActivityFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private ActivityGrammarAccess _activityGrammarAccess;

    protected void _format(ActivitySet activityset, @Extension IFormattableDocument document) {
        EList _imports = activityset.getImports();
        for (Import imports : _imports) {
            Iterator _function = it -> it.noSpace();
            document.prepend((EObject)imports, (Procedures.Procedure1)_function);
        }
        EList _activities = activityset.getActivities();
        for (Activity activities : _activities) {
            if (activities == null) continue;
            document.format((Object)activities);
        }
        EList _events = activityset.getEvents();
        for (Event event : _events) {
            if (event == null) continue;
            document.format((Object)event);
        }
    }

    protected void _format(LocationPrerequisite prerequisite, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)prerequisite, _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)prerequisite).keyword(this._activityGrammarAccess.getLocationPrerequisiteAccess().getAtKeyword_3()), _function_1);
    }

    protected void _format(Activity activity, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.prepend((EObject)activity, _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getActivityKeyword_0()), _function_1);
        ISemanticRegion openActivity = this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_2());
        ISemanticRegion closeActivity = this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getRightCurlyBracketKeyword_12());
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.surround(openActivity, _function_2);
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(openActivity, closeActivity, _function_3);
        Procedures.Procedure1 _function_4 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getPrerequisitesKeyword_3_0()), _function_4);
        ISemanticRegion openPrerequisites = this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_3_1());
        ISemanticRegion closePrerequisites = this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getRightCurlyBracketKeyword_3_3());
        Procedures.Procedure1 _function_5 = it -> it.oneSpace();
        Procedures.Procedure1 _function_6 = it -> it.newLine();
        document.append(document.prepend(openPrerequisites, _function_5), _function_6);
        Procedures.Procedure1 _function_7 = it -> it.newLine();
        Procedures.Procedure1 _function_8 = it -> it.newLine();
        document.append(document.prepend(closePrerequisites, _function_7), _function_8);
        Procedures.Procedure1 _function_9 = it -> it.indent();
        document.interior(openPrerequisites, closePrerequisites, _function_9);
        EList _prerequisites = activity.getPrerequisites();
        for (LocationPrerequisite prerequisite : _prerequisites) {
            if (prerequisite == null) continue;
            document.format((Object)prerequisite);
        }
        Procedures.Procedure1 _function_10 = it -> it.newLine();
        document.prepend(this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getActionsKeyword_4()), _function_10);
        ISemanticRegion openActions = this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_5());
        ISemanticRegion closeActions = this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getRightCurlyBracketKeyword_7());
        Procedures.Procedure1 _function_11 = it -> it.oneSpace();
        Procedures.Procedure1 _function_12 = it -> it.newLine();
        document.append(document.prepend(openActions, _function_11), _function_12);
        Procedures.Procedure1 _function_13 = it -> it.newLine();
        Procedures.Procedure1 _function_14 = it -> it.newLine();
        document.append(document.prepend(closeActions, _function_13), _function_14);
        Procedures.Procedure1 _function_15 = it -> it.indent();
        document.interior(openActions, closeActions, _function_15);
        ISemanticRegion openActionFlow = this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_9());
        ISemanticRegion closeActionFlow = this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getRightCurlyBracketKeyword_11());
        Procedures.Procedure1 _function_16 = it -> it.oneSpace();
        Procedures.Procedure1 _function_17 = it -> it.newLine();
        document.append(document.prepend(openActionFlow, _function_16), _function_17);
        Procedures.Procedure1 _function_18 = it -> it.newLine();
        Procedures.Procedure1 _function_19 = it -> it.newLine();
        document.append(document.prepend(closeActionFlow, _function_18), _function_19);
        Procedures.Procedure1 _function_20 = it -> it.indent();
        document.interior(openActionFlow, closeActionFlow, _function_20);
        Procedures.Procedure1 _function_21 = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)activity).keyword(this._activityGrammarAccess.getActivityAccess().getActionsKeyword_4()), _function_21);
        EList _nodes = activity.getNodes();
        for (Node node : _nodes) {
            Procedures.Procedure1 _function_22 = it -> it.newLine();
            document.prepend((EObject)node, _function_22);
            if (node == null) continue;
            document.format((Object)node);
        }
        EList _edges = activity.getEdges();
        for (Edge edge : _edges) {
            Procedures.Procedure1 _function_22 = it -> it.newLine();
            document.prepend((EObject)edge, _function_22);
            if (edge == null) continue;
            document.format((Object)edge);
        }
    }

    protected void _format(Claim claim, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)claim).keyword(this._activityGrammarAccess.getClaimAccess().getColonKeyword_2()), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)claim).keyword(this._activityGrammarAccess.getClaimAccess().getClaimKeyword_5()), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)claim).keyword(this._activityGrammarAccess.getClaimAccess().getPassivePassiveKeyword_4_0()), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)claim).assignment(this._activityGrammarAccess.getClaimAccess().getResourceAssignment_6()), _function_4);
    }

    protected void _format(Release release, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)release).keyword(this._activityGrammarAccess.getReleaseAccess().getColonKeyword_2()), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)release).keyword(this._activityGrammarAccess.getReleaseAccess().getReleaseKeyword_4()), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)release).assignment(this._activityGrammarAccess.getReleaseAccess().getResourceAssignment_5()), _function_3);
    }

    protected void _format(RequireEvent require, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)require).keyword(this._activityGrammarAccess.getRequireEventAccess().getColonKeyword_2()), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)require).keyword(this._activityGrammarAccess.getRequireEventAccess().getRequireKeyword_3()), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)require).assignment(this._activityGrammarAccess.getRequireEventAccess().getResourceAssignment_4()), _function_3);
    }

    protected void _format(RaiseEvent raise, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)raise).keyword(this._activityGrammarAccess.getRaiseEventAccess().getColonKeyword_2()), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)raise).keyword(this._activityGrammarAccess.getRaiseEventAccess().getRaiseKeyword_3()), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)raise).assignment(this._activityGrammarAccess.getRaiseEventAccess().getResourceAssignment_4()), _function_3);
    }

    protected void _format(Event event, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.prepend((EObject)event, _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)event).keyword(this._activityGrammarAccess.getEventAccess().getEventKeyword_0()), _function_1), _function_2);
    }

    protected void _format(Move move, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)move).keyword(this._activityGrammarAccess.getMoveAccess().getColonKeyword_2()), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)move).keyword(this._activityGrammarAccess.getMoveAccess().getMoveKeyword_4()), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)move).keyword(this._activityGrammarAccess.getMoveAccess().getPassingPassingKeyword_8_0_0_0_0()), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)move).keyword(this._activityGrammarAccess.getMoveAccess().getContinuingContinuingKeyword_8_1_0_0_0()), _function_4);
        Procedures.Procedure1 _function_5 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)move).keyword(this._activityGrammarAccess.getMoveAccess().getToKeyword_8_0_0_1()), _function_5);
        Procedures.Procedure1 _function_6 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)move).keyword(this._activityGrammarAccess.getMoveAccess().getForKeyword_8_1_0_1()), _function_6);
        Procedures.Procedure1 _function_7 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)move).keyword(this._activityGrammarAccess.getMoveAccess().getWithSpeedProfileKeyword_9_0()), _function_7);
        Procedures.Procedure1 _function_8 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)move).ruleCall(this._activityGrammarAccess.getMoveAccess().getSchedulingTypeSchedulingEnumRuleCall_10_0()), _function_8);
        Procedures.Procedure1 _function_9 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)move).feature((EStructuralFeature)ActivityPackage.Literals.MOVE__PROFILE), _function_9);
    }

    protected void _format(SimpleAction simpleaction, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)simpleaction).keyword(this._activityGrammarAccess.getSimpleActionAccess().getColonKeyword_2()), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)simpleaction).feature((EStructuralFeature)ActivityPackage.Literals.SIMPLE_ACTION__TYPE), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)simpleaction).keyword(this._activityGrammarAccess.getSimpleActionAccess().getFullStopKeyword_5_0()), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)simpleaction).keyword(this._activityGrammarAccess.getSimpleActionAccess().getFullStopKeyword_5_2()), _function_4);
    }

    protected void _format(Edge edge, @Extension IFormattableDocument document) {
        EdgeTarget _target;
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)edge).keyword(this._activityGrammarAccess.getEdgeAccess().getHyphenMinusGreaterThanSignKeyword_2()), _function);
        SourceReference _source = edge.getSource();
        if (_source != null) {
            document.format((Object)_source);
        }
        if ((_target = edge.getTarget()) != null) {
            document.format((Object)_target);
        }
    }

    protected void _format(SourceReference sourceRef, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)sourceRef).keyword(this._activityGrammarAccess.getSourceReferenceAccess().getVerticalLineKeyword_1_1_0()), _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.oneSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)sourceRef).ruleCall(this._activityGrammarAccess.getSourceReferenceAccess().getNodeActionIIDParserRuleCall_1_0_0_1()), _function_2);
    }

    protected void _format(TargetReference targetRef, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.oneSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)targetRef).ruleCall(this._activityGrammarAccess.getTargetReferenceAccess().getNodeActionIIDParserRuleCall_1_0_0_1()), _function);
        Procedures.Procedure1 _function_1 = it -> it.oneSpace();
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)targetRef).keyword(this._activityGrammarAccess.getTargetReferenceAccess().getVerticalLineKeyword_1_1_0()), _function_1), _function_2);
    }

    @XbaseGenerated
    public void format(Object move, IFormattableDocument document) {
        if (move instanceof Move) {
            this._format((Move)move, document);
            return;
        }
        if (move instanceof RaiseEvent) {
            this._format((RaiseEvent)move, document);
            return;
        }
        if (move instanceof RequireEvent) {
            this._format((RequireEvent)move, document);
            return;
        }
        if (move instanceof SimpleAction) {
            this._format((SimpleAction)move, document);
            return;
        }
        if (move instanceof Claim) {
            this._format((Claim)move, document);
            return;
        }
        if (move instanceof Release) {
            this._format((Release)move, document);
            return;
        }
        if (move instanceof Event) {
            this._format((Event)move, document);
            return;
        }
        if (move instanceof XtextResource) {
            this._format((XtextResource)move, document);
            return;
        }
        if (move instanceof Activity) {
            this._format((Activity)move, document);
            return;
        }
        if (move instanceof ActivitySet) {
            this._format((ActivitySet)move, document);
            return;
        }
        if (move instanceof LocationPrerequisite) {
            this._format((LocationPrerequisite)move, document);
            return;
        }
        if (move instanceof Edge) {
            this._format((Edge)move, document);
            return;
        }
        if (move instanceof TargetReference) {
            this._format((TargetReference)move, document);
            return;
        }
        if (move instanceof SourceReference) {
            this._format((SourceReference)move, document);
            return;
        }
        if (move instanceof EObject) {
            this._format((EObject)move, document);
            return;
        }
        if (move == null) {
            this._format(null, document);
            return;
        }
        if (move != null) {
            this._format(move, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(move, document).toString());
    }
}

