/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SymbolsModel {
    private static final SymbolInformation ROOT_SYMBOL_INFORMATION = new SymbolInformation();
    private volatile Map<SymbolInformation, List<SymbolInformation>> childrenMap = Collections.emptyMap();
    private volatile List<DocumentSymbol> rootSymbols = Collections.emptyList();
    private @Nullable URI uri;

    public synchronized boolean update(@Nullable List<Either<SymbolInformation, DocumentSymbol>> response) {
        if (response == null || response.isEmpty()) {
            this.childrenMap = Collections.emptyMap();
            this.rootSymbols = Collections.emptyList();
        } else {
            HashMap<SymbolInformation, List<SymbolInformation>> newChildrenMap = new HashMap<SymbolInformation, List<SymbolInformation>>();
            ArrayList<DocumentSymbol> newRootSymbols = new ArrayList<DocumentSymbol>();
            ArrayDeque<SymbolInformation> parentStack = new ArrayDeque<SymbolInformation>();
            parentStack.push(ROOT_SYMBOL_INFORMATION);
            SymbolInformation[] previousSymbol = new SymbolInformation[1];
            response.stream().sorted(Comparator.comparing(either -> either.isLeft() ? ((SymbolInformation)either.getLeft()).getLocation().getRange().getStart() : ((DocumentSymbol)either.getRight()).getRange().getStart(), Comparator.comparingInt(pos -> ((Position)pos).getLine()).thenComparingInt(pos -> ((Position)pos).getCharacter()))).forEach(arg_0 -> this.lambda$3(previousSymbol, parentStack, newChildrenMap, newRootSymbols, arg_0));
            this.childrenMap = newChildrenMap;
            this.rootSymbols = newRootSymbols;
        }
        return true;
    }

    private boolean isIncluded(@Nullable SymbolInformation parent, @Nullable SymbolInformation symbol) {
        if (parent == null || symbol == null) {
            return false;
        }
        if (parent == ROOT_SYMBOL_INFORMATION) {
            return true;
        }
        return this.isIncluded(parent.getLocation(), symbol.getLocation());
    }

    private boolean isIncluded(Location reference, Location included) {
        return reference.getUri().equals(included.getUri()) && !reference.equals((Object)included) && this.isAfter(reference.getRange().getStart(), included.getRange().getStart()) && this.isAfter(included.getRange().getEnd(), reference.getRange().getEnd());
    }

    private boolean isAfter(Position reference, Position included) {
        return included.getLine() > reference.getLine() || included.getLine() == reference.getLine() && included.getCharacter() >= reference.getCharacter();
    }

    private void addChild(Map<SymbolInformation, List<SymbolInformation>> newChildrenMap, SymbolInformation parent, SymbolInformation child) {
        List children = newChildrenMap.computeIfAbsent(parent, key -> new ArrayList());
        children.add(child);
    }

    public Object[] getElements() {
        ArrayList<Object> res = ArrayUtil.asArrayList(this.getChildren(ROOT_SYMBOL_INFORMATION));
        URI current = this.uri;
        Function<DocumentSymbol, Object> mapper = current != null ? symbol -> new DocumentSymbolWithURI((DocumentSymbol)symbol, current) : symbol -> symbol;
        this.rootSymbols.stream().map(mapper).forEach(res::add);
        return res.toArray();
    }

    public Object[] getChildren(@Nullable Object parentElement) {
        if (parentElement != null) {
            if (parentElement instanceof SymbolInformation) {
                List<SymbolInformation> children = this.childrenMap.get(parentElement);
                if (children != null && !children.isEmpty()) {
                    return children.toArray();
                }
            } else if (parentElement instanceof DocumentSymbolWithURI) {
                DocumentSymbolWithURI element = (DocumentSymbolWithURI)parentElement;
                List children = element.symbol.getChildren();
                if (children != null && !children.isEmpty()) {
                    return element.symbol.getChildren().stream().map(symbol -> new DocumentSymbolWithURI((DocumentSymbol)symbol, documentSymbolWithURI.uri)).toArray();
                }
            }
        }
        return ArrayUtil.NO_OBJECTS;
    }

    public boolean hasChildren(@Nullable Object parentElement) {
        if (parentElement != null) {
            if (parentElement instanceof SymbolInformation) {
                List<SymbolInformation> children = this.childrenMap.get(parentElement);
                if (children != null) {
                    return !children.isEmpty();
                }
            } else if (parentElement instanceof DocumentSymbolWithURI) {
                DocumentSymbolWithURI element = (DocumentSymbolWithURI)parentElement;
                List children = element.symbol.getChildren();
                if (children != null) {
                    return !children.isEmpty();
                }
            }
        }
        return false;
    }

    public @Nullable Object getParent(@Nullable Object element) {
        if (element instanceof SymbolInformation) {
            for (Map.Entry<SymbolInformation, List<SymbolInformation>> entry : this.childrenMap.entrySet()) {
                if (!entry.getValue().contains(element)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void setUri(@Nullable URI uri) {
        this.uri = uri;
    }

    public @Nullable TreePath toUpdatedSymbol(TreePath initialSymbol) {
        ArrayList<Object> res = new ArrayList<Object>(initialSymbol.getSegmentCount());
        Object currentSymbol = null;
        int i = 0;
        while (i < initialSymbol.getSegmentCount()) {
            String name;
            Object[] currentChildren = currentSymbol == null ? this.getElements() : this.getChildren(currentSymbol);
            if ((currentSymbol = ArrayUtil.findFirstMatching(currentChildren, arg_0 -> this.lambda$9(name = this.getName(initialSymbol.getSegment(i)), arg_0))) == null) {
                return null;
            }
            res.add(currentSymbol);
            ++i;
        }
        return new TreePath(res.toArray());
    }

    private @Nullable String getName(Object segment) {
        if (segment instanceof DocumentSymbolWithURI) {
            DocumentSymbolWithURI symbolWithURI = (DocumentSymbolWithURI)segment;
            segment = symbolWithURI.symbol;
        }
        if (segment instanceof DocumentSymbol) {
            DocumentSymbol documentSymbol = (DocumentSymbol)segment;
            return documentSymbol.getName();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$3(SymbolInformation[] var1_1, ArrayDeque var2_2, HashMap var3_3, ArrayList var4_4, Either either) {
        block5: {
            block2: {
                block4: {
                    block3: {
                        if (!either.isLeft()) break block2;
                        symbol = (SymbolInformation)either.getLeft();
                        if (!this.isIncluded(var1_1[0], symbol)) break block3;
                        var2_2.push(NullSafetyHelper.castNonNull(var1_1[0]));
                        this.addChild(var3_3, NullSafetyHelper.castNonNull((SymbolInformation)var2_2.peek()), symbol);
                        break block4;
                    }
                    if (!this.isIncluded((SymbolInformation)var2_2.peek(), symbol)) ** GOTO lbl13
                    this.addChild(var3_3, NullSafetyHelper.castNonNull((SymbolInformation)var2_2.peek()), symbol);
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        var2_2.pop();
lbl13:
                        // 2 sources

                        ** while (!this.isIncluded((SymbolInformation)((SymbolInformation)var2_2.peek()), (SymbolInformation)symbol))
                    }
lbl14:
                    // 1 sources

                    this.addChild(var3_3, NullSafetyHelper.castNonNull((SymbolInformation)var2_2.peek()), symbol);
                    var2_2.push(symbol);
                }
                var1_1[0] = symbol;
                break block5;
            }
            if (either.isRight()) {
                var4_4.add((DocumentSymbol)either.getRight());
            }
        }
    }

    private /* synthetic */ boolean lambda$9(String string, Object child) throws RuntimeException {
        return Objects.equals(this.getName(child), string);
    }

    public static class DocumentSymbolWithURI {
        public final DocumentSymbol symbol;
        public final URI uri;

        public DocumentSymbolWithURI(DocumentSymbol symbol, URI uri) {
            this.symbol = symbol;
            this.uri = uri;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof DocumentSymbolWithURI) {
                DocumentSymbolWithURI other = (DocumentSymbolWithURI)obj;
                if (Objects.equals(this.symbol, other.symbol) && Objects.equals(this.uri, other.uri)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.symbol);
        }
    }
}

