/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;

public abstract class LanguageServers<E extends LanguageServers<E>> {
    private static final Predicate<ServerCapabilities> NO_FILTER = s -> true;
    private Predicate<ServerCapabilities> filter = NO_FILTER;
    protected  @Nullable LanguageServersRegistry.LanguageServerDefinition serverDefinition;

    private static void forwardCancellation(CompletableFuture<?> from, CompletableFuture<?> ... to) {
        from.exceptionally(t -> {
            if (t instanceof CancellationException) {
                ArrayUtil.forEach(to, f -> {
                    boolean bl = f.cancel(true);
                });
            }
            return null;
        });
    }

    private static <T> CompletableFuture<T> onCommonPool(CompletableFuture<T> source) {
        CompletionStage res = source.thenApplyAsync(Function.identity());
        LanguageServers.forwardCancellation(res, new CompletableFuture[]{source});
        return res;
    }

    public <T> CompletableFuture<List<T>> collectAll(Function<LanguageServer, ? extends CompletableFuture<T>> fn) {
        return this.collectAll((? super LanguageServerWrapper w, LanguageServer ls) -> (CompletableFuture)fn.apply((LanguageServer)ls));
    }

    public <T> CompletableFuture<List<T>> collectAll(BiFunction<? super LanguageServerWrapper, LanguageServer, ? extends CompletableFuture<T>> fn) {
        CompletableFuture init = CompletableFuture.completedFuture(new ArrayList());
        return LanguageServers.onCommonPool(this.executeOnServers(fn).reduce(init, LanguageServers::add, LanguageServers::addAll));
    }

    public <T> List<CompletableFuture<@Nullable T>> computeAll(Function<LanguageServer, ? extends CompletableFuture<T>> fn) {
        return this.computeAll((? super LanguageServerWrapper w, LanguageServer ls) -> (CompletableFuture)fn.apply((LanguageServer)ls));
    }

    public <T> List<CompletableFuture<@Nullable T>> computeAll(BiFunction<? super LanguageServerWrapper, LanguageServer, ? extends CompletableFuture<T>> fn) {
        return this.getServers().stream().map(serverFuture -> {
            CompletionStage requestFuture = serverFuture.thenApply(w -> w == null ? CompletableFuture.completedFuture(null) : w.executeImpl(ls -> (CompletableFuture)fn.apply((LanguageServerWrapper)w, (LanguageServer)ls)));
            CompletionStage res = ((CompletableFuture)requestFuture).thenCompose(Function.identity());
            ((CompletableFuture)requestFuture).thenAccept(arg_0 -> LanguageServers.lambda$10((CompletableFuture)res, arg_0));
            return res;
        }).toList();
    }

    public <T> CompletableFuture<Optional<T>> computeFirst(Function<LanguageServer, ? extends CompletableFuture<T>> queryLS) {
        return this.computeFirst((? super LanguageServerWrapper w, LanguageServer ls) -> (CompletableFuture)queryLS.apply((LanguageServer)ls));
    }

    public <T> CompletableFuture<Optional<T>> computeFirst(BiFunction<? super LanguageServerWrapper, LanguageServer, ? extends CompletableFuture<T>> queryLS) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture.allOf((CompletableFuture[])this.executeOnServers(queryLS).map(lsRequest -> {
            CompletionStage populateFuture = lsRequest.thenApply(t -> {
                if (t != null && !LanguageServers.isEmptyCollection(t)) {
                    result.complete(Optional.of(t));
                }
                return t;
            });
            result.whenComplete((v, t) -> {
                boolean bl = lsRequest.cancel(true);
            });
            return populateFuture;
        }).toArray(CompletableFuture[]::new)).whenComplete((v, t) -> this.completeEmptyOrWithException(result, (Throwable)t));
        return LanguageServers.onCommonPool(result);
    }

    public E withPreferredServer( @Nullable LanguageServersRegistry.LanguageServerDefinition serverDefinition) {
        Assert.isLegal((this.serverDefinition == null ? 1 : 0) != 0);
        this.serverDefinition = serverDefinition;
        return (E)this;
    }

    public E withFilter(Predicate<ServerCapabilities> filter) {
        Assert.isLegal((this.filter == NO_FILTER ? 1 : 0) != 0);
        this.filter = filter;
        return (E)this;
    }

    public E withCapability(Function<ServerCapabilities, Either<Boolean, ?>> serverCapabilities) {
        Assert.isLegal((this.filter == NO_FILTER ? 1 : 0) != 0);
        this.filter = f -> LSPEclipseUtils.hasCapability((Either)serverCapabilities.apply((ServerCapabilities)f));
        return (E)this;
    }

    public Predicate<ServerCapabilities> getFilter() {
        return this.filter;
    }

    protected Boolean matches(CompletableFuture<@Nullable LanguageServerWrapper> wrapperFuture) {
        try {
            return (Boolean)((CompletableFuture)wrapperFuture.thenApply(Objects::nonNull)).get(50L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not get language server due to timeout after 50 milliseconds", e);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean anyMatching() {
        return this.getServers().stream().anyMatch(this::matches);
    }

    private static boolean isEmptyCollection(Object obj) {
        Collection c;
        return obj instanceof Collection && (c = (Collection)obj).isEmpty();
    }

    protected List<CompletableFuture<@Nullable LanguageServerWrapper>> order(Map<LanguageServersRegistry.LanguageServerDefinition, CompletableFuture<@Nullable LanguageServerWrapper>> wrappers) {
        if (this.serverDefinition == null || wrappers.size() < 2) {
            return new ArrayList<CompletableFuture<LanguageServerWrapper>>(wrappers.values());
        }
        ArrayList<CompletableFuture<LanguageServerWrapper>> result = new ArrayList<CompletableFuture<LanguageServerWrapper>>(wrappers.size());
        for (Map.Entry<LanguageServersRegistry.LanguageServerDefinition, CompletableFuture<LanguageServerWrapper>> entry : wrappers.entrySet()) {
            if (Objects.equals(this.serverDefinition, entry.getKey())) {
                result.add(0, entry.getValue());
                continue;
            }
            result.add(entry.getValue());
        }
        return result;
    }

    protected Collection<LanguageServerWrapper> order(Collection<LanguageServerWrapper> wrappers) {
        if (this.serverDefinition != null && wrappers.size() > 1) {
            ArrayList<LanguageServerWrapper> temp = new ArrayList<LanguageServerWrapper>(wrappers);
            int i = 0;
            while (i < temp.size()) {
                LanguageServerWrapper wrapper = temp.get(i);
                if (Objects.equals(this.serverDefinition, wrapper.serverDefinition)) {
                    Collections.swap(temp, 0, i);
                    return temp;
                }
                ++i;
            }
        }
        return wrappers;
    }

    protected abstract List<CompletableFuture<@Nullable LanguageServerWrapper>> getServers();

    protected void computeVersion() {
    }

    public static <T> Stream<T> streamSafely(@Nullable Collection<T> col) {
        return col == null ? Stream.of(new Object[0]) : col.stream();
    }

    private static <T> CompletableFuture<List<T>> add(CompletableFuture<? extends List<T>> accumulator, CompletableFuture<@Nullable T> element) {
        CompletionStage res = accumulator.thenCombine(element, (a, b) -> {
            if (b != null) {
                a.add(b);
            }
            return a;
        });
        LanguageServers.forwardCancellation(res, new CompletableFuture[]{accumulator, element});
        return res;
    }

    public static <T> CompletableFuture<List<T>> addAll(CompletableFuture<List<T>> accumulator, CompletableFuture<List<T>> another) {
        CompletionStage res = accumulator.thenCombine(another, (a, b) -> {
            a.addAll(b);
            return a;
        });
        LanguageServers.forwardCancellation(res, new CompletableFuture[]{accumulator, another});
        return res;
    }

    private <T> Stream<CompletableFuture<T>> executeOnServers(BiFunction<? super LanguageServerWrapper, LanguageServer, ? extends CompletableFuture<T>> fn) {
        return this.getServers().stream().map(serverFuture -> {
            CompletionStage lsRequestFuture = serverFuture.thenApply(w -> w == null ? CompletableFuture.completedFuture(null) : w.executeImpl(ls -> (CompletableFuture)fn.apply((LanguageServerWrapper)w, (LanguageServer)ls)));
            CompletionStage res = ((CompletableFuture)lsRequestFuture).thenCompose(Function.identity());
            ((CompletableFuture)lsRequestFuture).thenAccept(arg_0 -> LanguageServers.lambda$25((CompletableFuture)res, arg_0));
            return res;
        });
    }

    private <T> void completeEmptyOrWithException(CompletableFuture<Optional<T>> completableFuture, @Nullable Throwable t) {
        if (t != null) {
            completableFuture.completeExceptionally(t);
        } else {
            completableFuture.complete(Optional.empty());
        }
    }

    public static LanguageServerDocumentExecutor forDocument(IDocument document) {
        return new LanguageServerDocumentExecutor(document);
    }

    public static LanguageServerProjectExecutor forProject(IProject project) {
        return new LanguageServerProjectExecutor(project);
    }

    private static /* synthetic */ void lambda$10(CompletableFuture completableFuture, CompletableFuture request) {
        LanguageServers.forwardCancellation(completableFuture, request);
    }

    private static /* synthetic */ void lambda$25(CompletableFuture completableFuture, CompletableFuture request) {
        LanguageServers.forwardCancellation(completableFuture, request);
    }

    public static class LanguageServerDocumentExecutor
    extends LanguageServers<LanguageServerDocumentExecutor> {
        private final IDocument document;

        protected LanguageServerDocumentExecutor(IDocument document) {
            this.document = document;
        }

        public IDocument getDocument() {
            return this.document;
        }

        CompletableFuture<@Nullable LanguageServerWrapper> connect(CompletableFuture<@Nullable LanguageServerWrapper> wrapperFuture) {
            return wrapperFuture.thenCompose(wrapper -> {
                CompletableFuture<LanguageServerWrapper> serverFuture;
                if (wrapper != null && (serverFuture = wrapper.connectDocument(this.document)) != null) {
                    return serverFuture;
                }
                return CompletableFuture.completedFuture(null);
            });
        }

        private CompletableFuture<@Nullable LanguageServerWrapper> filter(LanguageServerWrapper wrapper) {
            return wrapper.getServerCapabilitiesAsync().thenApply(sc -> this.getFilter().test((ServerCapabilities)sc) ? wrapper : null);
        }

        @Override
        protected List<CompletableFuture<@Nullable LanguageServerWrapper>> getServers() {
            Collection<LanguageServerWrapper> wrappers = LanguageServiceAccessor.getLSWrappers(this.document);
            return this.order(wrappers).stream().map(this::filter).map(this::connect).toList();
        }

        @Override
        public boolean anyMatching() {
            return LanguageServiceAccessor.getLSWrappers(this.document).stream().map(this::filter).anyMatch(this::matches);
        }
    }

    public static class LanguageServerProjectExecutor
    extends LanguageServers<LanguageServerProjectExecutor> {
        private final IProject project;
        private boolean restartStopped = true;

        LanguageServerProjectExecutor(IProject project) {
            this.project = project;
        }

        public LanguageServerProjectExecutor excludeInactive() {
            this.restartStopped = false;
            return this;
        }

        @Override
        protected List<CompletableFuture<@Nullable LanguageServerWrapper>> getServers() {
            return this.order(LanguageServiceAccessor.getStartedWrappersAsync(this.project, this.getFilter(), !this.restartStopped));
        }
    }
}

