Contributing to Linux Tools
===========================

Thanks for your interest in this project.

Project description:
--------------------

The Linux Tools project aims to bring a full-featured C and C++ IDE to Linux developers. We build on the source editing and debugging features of the CDT and integrate popular native development tools such as the SystemTap, GCov, GProf, LTTng, RPM .spec editor, a Valgrind heap usage analysis tool and Kernel Perf call profiling tools. The project also provides a place for Linux distributions to collaboratively overcome issues surrounding distribution packaging of Eclipse technology. The project produces both best practices and tools related to packaging. One of our features is a source archive of the Eclipse SDK that can be used by all Linux distributions building and distributing it.

- https://projects.eclipse.org/projects/tools.linuxtools

Developer resources:
--------------------

Information regarding source code management, builds, coding standards, and more.

- https://projects.eclipse.org/projects/tools.linuxtools/developer

Eclipse Contributor Agreement:
------------------------------

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

Contact:
--------

Contact the project developers via the project's "dev" list.

- https://dev.eclipse.org/mailman/listinfo/linuxtools-dev

Bugs/Issues:
----------------

This project uses Github Issues to track ongoing development and issues.

- https://github.com/eclipse-linuxtools/org.eclipse.linuxtools/issues
