/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants.diagnostics;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.xerces.AbstractLSPErrorReporter;
import org.eclipse.lemminx.extensions.xerces.LSPXMLEntityManager;
import org.eclipse.lemminx.extensions.xerces.ReferencedGrammarDiagnosticsInfo;
import org.eclipse.lemminx.extensions.xsd.participants.diagnostics.LSPErrorReporterForXSD;
import org.eclipse.lemminx.extensions.xsd.participants.diagnostics.LSPXMLGrammarPreparser;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XSDValidator {
    private static final Logger LOGGER = Logger.getLogger(XSDValidator.class.getName());
    private static boolean canCustomizeReporter = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDiagnostics(DOMDocument document, XMLEntityResolver entityResolver, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, ContentModelManager contentModelManager, CancelChecker monitor) {
        HashMap<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache = new HashMap<String, ReferencedGrammarDiagnosticsInfo>();
        LSPErrorReporterForXSD reporterForXSD = new LSPErrorReporterForXSD(document, diagnostics, contentModelManager, validationSettings != null ? validationSettings.isRelatedInformation() : false, referencedGrammarDiagnosticsInfoCache);
        try {
            LSPXMLEntityManager entityManager = new LSPXMLEntityManager(reporterForXSD, null);
            LSPXMLGrammarPreparser grammarPreparser = new LSPXMLGrammarPreparser();
            XMLSchemaLoader schemaLoader = XSDValidator.createSchemaLoader(reporterForXSD, entityManager);
            grammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", (XMLGrammarLoader)schemaLoader);
            grammarPreparser.setProperty("http://apache.org/xml/properties/internal/grammar-pool", new XMLGrammarPoolImpl());
            grammarPreparser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            grammarPreparser.setFeature("http://apache.org/xml/features/namespaces", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/namespace-prefixes", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation/schema", true);
            boolean resolveExternalEntities = validationSettings != null ? validationSettings.isResolveExternalEntities() : false;
            grammarPreparser.setFeature("http://apache.org/xml/features/external-general-entities", resolveExternalEntities);
            grammarPreparser.setFeature("http://apache.org/xml/features/external-parameter-entities", resolveExternalEntities);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
            grammarPreparser.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)reporterForXSD);
            schemaLoader.setProperty("http://apache.org/xml/properties/internal/entity-manager", (Object)entityManager);
            if (entityResolver != null) {
                grammarPreparser.setEntityResolver(entityResolver);
            }
            String content = document.getText();
            String uri = document.getDocumentURI();
            StringReader inputStream = new StringReader(content);
            XMLInputSource source = new XMLInputSource(null, uri, uri, (Reader)inputStream, null);
            grammarPreparser.getLoader("http://www.w3.org/2001/XMLSchema");
            grammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", source);
        }
        catch (IOException | CancellationException | XMLParseException entityManager) {
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected XSDValidator error", e);
        }
        finally {
            reporterForXSD.endReport();
        }
    }

    private static XMLSchemaLoader createSchemaLoader(XMLErrorReporter reporter, XMLEntityManager entityManager) {
        XMLSchemaLoader schemaLoader = new XMLSchemaLoader();
        if (canCustomizeReporter) {
            canCustomizeReporter = AbstractLSPErrorReporter.initializeReporter(schemaLoader, reporter, entityManager);
        }
        return schemaLoader;
    }
}

